/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.share.event.ListenerManager;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildObjectsTree;
import oracle.olap.util.ObjectSelection;

public class BuildObjectTreePicker
implements ItemPicker,
PropertyChangeListener {
    DataFlavor nodeFlavor = new DataFlavor(DefaultMutableTreeNode.class, "Tree Node");
    private final DataFlavor[] flavors = new DataFlavor[]{this.nodeFlavor};
    private ListenerManager m_manager = new ListenerManager();
    private BuildObjectsTree tree;
    private Component display;

    public BuildObjectTreePicker(BuildObjectsTree buildObjectsTree, Component component) {
        this.tree = buildObjectsTree;
        this.display = component;
        buildObjectsTree.addPropertyChangeListener(this);
        buildObjectsTree.addMouseListener(new DoubleClickHandler());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_manager.addListener((EventListener)propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_manager.removeListener((EventListener)propertyChangeListener);
    }

    public boolean isSelectableItemPresent() {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel == null) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        if (defaultMutableTreeNode.getChildCount() == 2) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
            return defaultMutableTreeNode2.getChildCount() > 0 || defaultMutableTreeNode3.getChildCount() > 0;
        }
        return false;
    }

    public boolean isItemSelected() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        if (this.tree.getSelectionCount() >= 1) {
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof BuildObject) && !(defaultMutableTreeNode.getUserObject() instanceof Measure)) continue;
                return true;
            }
        }
        return false;
    }

    public void deselectAll() {
        this.tree.clearSelection();
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        for (Transferable transferable : transferableArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            try {
                defaultMutableTreeNode = (DefaultMutableTreeNode)transferable.getTransferData(this.nodeFlavor);
                this.tree.addNode(defaultMutableTreeNode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.tree.updateUI();
        this.tree.expandTree();
        return true;
    }

    public void removeSelectedItems() {
        this.deselectAll();
        this.tree.updateUI();
    }

    public void removeAllSelectableItems() {
        this.tree.updateUI();
    }

    public Transferable[] getSelectedItems() {
        ArrayList<ObjectSelection> arrayList = new ArrayList<ObjectSelection>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode == null) continue;
                ObjectSelection objectSelection = new ObjectSelection(defaultMutableTreeNode);
                arrayList.add(objectSelection);
            }
        }
        return arrayList.toArray(new ObjectSelection[arrayList.size()]);
    }

    public Transferable[] getAllSelectableItems() {
        ArrayList<ObjectSelection> arrayList = new ArrayList<ObjectSelection>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (defaultMutableTreeNode != null) {
            this.visitAllNodes(defaultMutableTreeNode, arrayList);
        }
        return arrayList.toArray(new ObjectSelection[arrayList.size()]);
    }

    private void visitAllNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<ObjectSelection> list) {
        if (defaultMutableTreeNode.getUserObject() instanceof BuildObject || defaultMutableTreeNode.getUserObject() instanceof Measure) {
            ObjectSelection objectSelection = new ObjectSelection(defaultMutableTreeNode);
            list.add(objectSelection);
        }
        if (defaultMutableTreeNode.getChildCount() > 0) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                this.visitAllNodes(defaultMutableTreeNode2, list);
            }
        }
    }

    public DataFlavor[] getSelectionDataFlavors() {
        return this.flavors;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        return true;
    }

    public Component getComponent() {
        return this.display;
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_manager.addListener((EventListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_manager.removeListener((EventListener)actionListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Enumeration enumeration = this.m_manager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                EventListener eventListener = (EventListener)enumeration.nextElement();
                if (!(eventListener instanceof PropertyChangeListener)) continue;
                propertyChangeEvent = new PropertyChangeEvent(this, "selection", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)eventListener;
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        private DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Enumeration enumeration;
            if (mouseEvent.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && (enumeration = BuildObjectTreePicker.this.m_manager.getListeners()) != null) {
                while (enumeration.hasMoreElements()) {
                    EventListener eventListener = (EventListener)enumeration.nextElement();
                    if (!(eventListener instanceof ActionListener)) continue;
                    ActionListener actionListener = (ActionListener)eventListener;
                    actionListener.actionPerformed(new ActionEvent(BuildObjectTreePicker.this, mouseEvent.getID(), null, mouseEvent.getModifiers()));
                }
            }
        }
    }
}

