/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.table.Queries;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildObjectTreePicker;
import oracle.olap.build.wizard.BuildObjectsTree;
import oracle.olap.build.wizard.BuildObjectsTreeModel;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.stringexpr.ParamProperty;
import oracle.olap.stringexpr.ParamStringExpr;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.syntax.BuildSyntax;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.SyntaxObject;

public class BuildObjectShuttlePanel
extends DefaultTraversablePanel
implements ParamValue,
ParamProperty {
    BuildObjectsTreeModel fromTreeModel;
    BuildObjectsTreeModel toTreeModel;
    private ListSelectionListener toListListener;
    private BuildObjectsTree fromTree;
    private BuildObjectTreePicker fromTreePicker;
    private BuildObjectTreePicker toTreePicker;
    private BuildObjectsTree toTree;
    private TraversableContext m_ctx;
    private JCheckBox isAutoAddDimOn;
    private List<String> cubesInWrongBuildOrder = new ArrayList<String>();
    private List<String> unbuiltDims = new ArrayList<String>();
    private List<String> unSelectedDims = new ArrayList<String>();
    private Shuttle shuttleSelector;
    private boolean initialized;
    private Schema schema;
    private List<String> cubeNamesToBeBuilt;
    private JPanel dataTypeMismatchPanel;
    private static Queries queries;
    private static final String XMLFILE = "buildobjectqueries.xml";
    private static final Logger LOG;

    public BuildObjectShuttlePanel() {
        this.setLayout(new BorderLayout());
        this.add(this.createInstructions(), "North");
        this.shuttleSelector = this.createShuttle();
        this.add((Component)this.shuttleSelector, "Center");
        JPanel jPanel = this.createCheckBoxPanel();
        this.add(jPanel, "South");
    }

    private JCheckBox createAutoOrderCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_AUTOMATIC_ORDER_LABEL"));
        return jCheckBox;
    }

    private JCheckBox createAutoAddCubeDimCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_ADD_DIMENSIONS_LABEL"));
        return jCheckBox;
    }

    private JPanel createCheckBoxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.isAutoAddDimOn = this.createAutoAddCubeDimCheckBox();
        this.isAutoAddDimOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildObjectShuttlePanel.this.toTree.setAddCubeDimensionality(BuildObjectShuttlePanel.this.isAutoAddDimOn.isSelected());
                BuildObjectShuttlePanel.this.fromTree.setAddCubeDimensionality(BuildObjectShuttlePanel.this.isAutoAddDimOn.isSelected());
            }
        });
        jPanel.add(this.isAutoAddDimOn);
        return jPanel;
    }

    private JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(OLAPArb.get("BUILD_WIZARD_SEL_OBJ_INSTRUCTION_MSG"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    private Shuttle createShuttle() {
        Shuttle shuttle = new Shuttle();
        this.toTree = new BuildObjectsTree("SELECTED");
        this.fromTree = new BuildObjectsTree("AVAILABLE");
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.fromTreeModel = new BuildObjectsTreeModel(new DefaultMutableTreeNode("root"));
        this.toTreeModel = new BuildObjectsTreeModel(new DefaultMutableTreeNode("root"));
        this.toTree.setModel(this.fromTreeModel);
        this.fromTree.setModel(this.toTreeModel);
        this.toListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }
        };
        this.toTreePicker = new BuildObjectTreePicker(this.toTree, new JScrollPane(this.toTree));
        this.fromTreePicker = new BuildObjectTreePicker(this.fromTree, new JScrollPane(this.fromTree));
        shuttle.setToPicker((ItemPicker)this.toTreePicker);
        shuttle.setFromPicker((ItemPicker)this.fromTreePicker);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fromTree, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_AVAILABLE_OBJ_LABEL"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.toTree, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_SELECTED_OBJ_LABEL"));
        shuttle.addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }

            public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }

            public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }
        });
        shuttle.add((Component)jLabel, (Object)"FromHeader");
        shuttle.add((Component)jLabel2, (Object)"ToHeader");
        return shuttle;
    }

    private void fixButtons() {
        if (!this.toTreePicker.isSelectableItemPresent()) {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        } else {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        }
    }

    public void populateShuttle(List<BuildObject> list, List<BuildObject> list2, Schema schema) {
        this.toTreeModel.populate(list, schema);
        this.fromTreeModel.populate(list2, schema);
        this.toTree.setSchema(schema);
        this.fromTree.setSchema(schema);
        this.toTree.updateUI();
        this.fromTree.updateUI();
        this.expandRoot(this.toTree);
        this.expandRoot(this.fromTree);
        this.toTree.expandTree();
        this.shuttleSelector.updateUI();
    }

    private void expandRoot(JTree jTree) {
        jTree.expandRow(0);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
    }

    private void clearInlineCubeTypeBuildSpecs(List<BuildObject> list) {
        for (BuildObject buildObject : list) {
            if (!buildObject.getType().equals("CUBE")) continue;
            buildObject.setInlineBuildSpecification("");
        }
    }

    public List<BuildObject> getSelected() {
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.toTree.getModel().getRoot();
        this.getSelectedObjects(defaultMutableTreeNode, arrayList);
        return arrayList;
    }

    private void getSelectedObjects(DefaultMutableTreeNode defaultMutableTreeNode, List<BuildObject> list) {
        if (defaultMutableTreeNode.getUserObject() instanceof BuildObject) {
            BuildObject buildObject = (BuildObject)defaultMutableTreeNode.getUserObject();
            if (buildObject.getType().equalsIgnoreCase("CUBE")) {
                this.addInLineBuildSpecToObject(defaultMutableTreeNode, buildObject);
            }
            list.add(buildObject);
        }
        if (defaultMutableTreeNode.getChildCount() > 0) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.getSelectedObjects((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), list);
            }
        }
    }

    private void addInLineBuildSpecToObject(DefaultMutableTreeNode defaultMutableTreeNode, BuildObject buildObject) {
        if (buildObject.getInlineBuildSpecification() == null || buildObject.getInlineBuildSpecification().isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            int n = 0;
            Cube cube = this.schema.findCube(buildObject.getName());
            for (Measure measure : cube.getMeasures()) {
                if (measure.isDerived()) continue;
                ++n;
            }
            if (defaultMutableTreeNode2.getChildCount() > 0 && n != defaultMutableTreeNode2.getChildCount() && !buildObject.isMVRewriteEnabled()) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" FOR MEASURES ( ");
                for (n2 = 0; n2 < defaultMutableTreeNode2.getChildCount(); ++n2) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n2);
                    Measure measure = (Measure)defaultMutableTreeNode3.getUserObject();
                    stringBuilder.append(String.format("%s.%s.%s,", buildObject.getOwner(), buildObject.getName(), measure.getName()));
                }
                n2 = stringBuilder.lastIndexOf(",");
                stringBuilder.deleteCharAt(n2);
                stringBuilder.append(") BUILD ( LOAD,SOLVE)");
                buildObject.setInlineBuildSpecification(stringBuilder.toString());
            } else {
                buildObject.setInlineBuildSpecification("");
            }
        }
    }

    public List<BuildObject> getSelectableBuildObjects() {
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.fromTree.getModel().getRoot();
        this.getSelectedObjects(defaultMutableTreeNode, arrayList);
        return arrayList;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        List list = (List)traversableContext.get("AVAIL_BUILD_OBJECTS");
        List list2 = (List)traversableContext.get("BUILD_OBJECTS");
        this.clearInlineCubeTypeBuildSpecs(list);
        this.clearInlineCubeTypeBuildSpecs(list2);
        if (!this.initialized) {
            this.schema = (Schema)traversableContext.get("SCHEMA");
            this.populateShuttle(list, list2, this.schema);
            this.initialized = true;
        }
        boolean bl = (Boolean)traversableContext.get("ADDDIM");
        this.isAutoAddDimOn.setSelected(bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ArrayList<BuildObject> arrayList = new ArrayList();
        List<Object> list = new ArrayList();
        arrayList = this.getSelected();
        list = this.getSelectableBuildObjects();
        traversableContext.put("BUILD_OBJECTS", arrayList);
        traversableContext.put("AVAIL_BUILD_OBJECTS", list);
        traversableContext.put("ADDDIM", (Object)false);
        this.cubesInWrongBuildOrder = new ArrayList<String>();
        List<String> list2 = this.getCubesWithNoMeasures(arrayList);
        if (list2.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (String string : list2) {
                stringBuffer.append(string);
                if (n < list2.size()) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            String string = OLAPArb.format("BUILD_WIZARD_PAGE_SELECT_OBJECTS_CUBE_NO_MEASURE_ERROR", stringBuffer.toString());
            throw new TraversalException(string);
        }
        this.unbuiltDims = this.getUnbuiltDimsRequired(arrayList);
        if (!this.isAutoAddDimOn.isSelected() && this.unbuiltDims.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (String string : this.unbuiltDims) {
                stringBuffer.append(string);
                if (n < this.unbuiltDims.size()) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            String string = OLAPArb.format("BUILD_WIZARD_PAGE_SELECT_OBJECTS_DIM_REBUILD_REQUIRED_ERROR", stringBuffer.toString());
            throw new TraversalException(string);
        }
        List<String> list3 = this.getUnmapped(arrayList);
        if (list3.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (String string : list3) {
                stringBuffer.append(string);
                if (n < list3.size()) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            String string = OLAPArb.format("BUILD_WIZARD_MAPPINGERROR", stringBuffer.toString());
            throw new TraversalException(string);
        }
        List<String> list4 = this.getCubesWithBadMappings(arrayList);
        if (list4.size() > 0) {
            throw new TraversalException((Object)this.dataTypeMismatchPanel);
        }
        ArrayList<BuildObject> arrayList2 = new ArrayList<BuildObject>();
        arrayList2.addAll(arrayList);
        for (String string : this.unbuiltDims) {
            for (BuildObject buildObject : list) {
                if (!string.equalsIgnoreCase(buildObject.getName())) continue;
                arrayList2.add(buildObject);
            }
        }
        boolean bl = this.isAtomicRefreshEnabled(arrayList2);
        traversableContext.put("ENABLE_ATOMIC", (Object)new Boolean(bl));
        if (!bl) {
            traversableContext.put("ISATOMIC", (Object)new Boolean(false));
        }
    }

    private boolean isAtomicRefreshEnabled(List<BuildObject> list) {
        boolean bl = false;
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        ArrayList<BuildObject> arrayList2 = new ArrayList<BuildObject>();
        for (BuildObject buildObject : list) {
            if (buildObject.getType().equalsIgnoreCase("CUBE") && buildObject.isMVOn()) {
                arrayList2.add(buildObject);
            }
            if (!buildObject.getType().equalsIgnoreCase("CUBE DIMENSION") || !buildObject.isMVOn()) continue;
            arrayList.add(buildObject);
        }
        if (arrayList2.isEmpty() && arrayList.isEmpty()) {
            bl = true;
        }
        if (arrayList.size() == list.size() || arrayList2.size() == list.size() && list.size() == 1 && !this.isAutoAddDimOn.isSelected()) {
            bl = true;
        }
        if (arrayList2.size() == list.size() && list.size() > 1) {
            String string;
            Object object2 = "in (";
            int n = 1;
            Connection connection = null;
            HashMap<CallSite, String> hashMap = new HashMap<CallSite, String>();
            for (BuildObject object3 : arrayList2) {
                string = object3.getName();
                if (n == arrayList2.size()) {
                    object2 = (String)object2 + ":cubename" + n + ")";
                    connection = object3.getConnection();
                } else {
                    object2 = (String)object2 + ":cubename" + n + ",";
                }
                hashMap.put((CallSite)((Object)("cubename" + n)), string);
                ++n;
            }
            String string2 = "select name from user_dependencies where type = 'CUBE' and referenced_type = 'CUBE' and name " + (String)object2 + " and referenced_name not " + (String)object2;
            ArrayList<String> arrayList3 = new ArrayList<String>();
            string = "";
            DBUtil dBUtil = DBUtil.getInstance(connection);
            List list2 = dBUtil.executeReturnList(string2, hashMap);
            for (Map map : list2) {
                string = (String)map.get("NAME");
                string = string.toUpperCase();
                arrayList3.add(string);
            }
            if (arrayList3.isEmpty()) {
                bl = true;
            }
        }
        return bl;
    }

    private List<String> getUnmapped(List<BuildObject> list) throws TraversalException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        HashMap<List<String>, Integer> hashMap = new HashMap<List<String>, Integer>();
        Connection connection = null;
        String string = null;
        try {
            List<String> list2;
            HashMap<List<String>, BuildObject> hashMap2 = new HashMap<List<String>, BuildObject>();
            int n = 0;
            for (BuildObject list32 : list) {
                list2 = list32.getName();
                if (string == null) {
                    string = list32.getOwner();
                }
                if (connection == null) {
                    connection = list32.getConnection();
                }
                if (list32.getType().equalsIgnoreCase("CUBE")) {
                    arrayList2.add((String)((Object)list2));
                    hashMap2.put(list2, list32);
                }
                if (list32.getType().equalsIgnoreCase("CUBE DIMENSION")) {
                    arrayList3.add((String)((Object)list2));
                    hashMap2.put(list2, list32);
                }
                hashMap.put(list2, n);
                ++n;
            }
            DBUtil dBUtil = DBUtil.getInstance(connection);
            if (this.isAutoAddDimOn.isSelected()) {
                arrayList3.addAll(this.unSelectedDims);
            }
            ArrayList arrayList4 = new ArrayList();
            List<String> list3 = OLAPMetadataReader.getFullyMappedDimensions(dBUtil, string, arrayList3);
            list2 = new ArrayList();
            List<Object> list4 = new ArrayList();
            list2 = OLAPMetadataReader.getCubesWithMeasuresMapped(dBUtil, string, arrayList2);
            list4 = OLAPMetadataReader.getCubesWithDimensionalityMapped(dBUtil, string, arrayList2);
            for (String string2 : arrayList3) {
                if (list3.contains(string2) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            for (String string2 : arrayList2) {
                BuildObject buildObject = (BuildObject)hashMap2.get(string2);
                if (!list2.contains(string2) && buildObject.isMVOn() && !arrayList.contains(string2)) {
                    arrayList.add(string2);
                    continue;
                }
                if (!list4.contains(string2) && buildObject.isMVOn() && !arrayList.contains(string2)) {
                    arrayList.add(string2);
                    continue;
                }
                int n2 = 0;
                for (String string3 : list4) {
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    ++n2;
                }
                Cube cube = this.schema.findCube(string2);
                List<Dimension> list5 = cube.getDimensions();
                if (list5.size() == n2 || !buildObject.isMVOn() || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getMessage());
        }
        return arrayList;
    }

    private List<String> getUnbuiltDimsRequired(List<BuildObject> list) throws TraversalException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = null;
        Connection connection = null;
        try {
            int n = 0;
            for (BuildObject object : list) {
                String string2 = object.getName();
                if (string == null) {
                    string = object.getOwner();
                }
                if (connection == null) {
                    connection = object.getConnection();
                }
                if (object.getType().equalsIgnoreCase("CUBE")) {
                    arrayList2.add(string2);
                }
                if (object.getType().equalsIgnoreCase("CUBE DIMENSION")) {
                    arrayList3.add(string2);
                }
                hashMap.put(string2, n);
                ++n;
            }
            for (String string3 : arrayList2) {
                int n2 = (Integer)hashMap.get(string3);
                Cube cube = this.schema.findCube(string3);
                List<Dimension> list2 = cube.getDimensions();
                for (Dimension dimension : list2) {
                    String string4 = dimension.getName();
                    if (!arrayList3.contains(string4)) {
                        if (dimension.isEmpty() && !arrayList.contains(string4)) {
                            arrayList.add(string4);
                        }
                        if (this.unSelectedDims.contains(string4)) continue;
                        this.unSelectedDims.add(string4);
                        continue;
                    }
                    int n3 = (Integer)hashMap.get(string4);
                    if (n2 >= n3 || this.cubesInWrongBuildOrder.contains(string3)) continue;
                    this.cubesInWrongBuildOrder.add(string3);
                }
            }
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getMessage());
        }
        return arrayList;
    }

    private List<String> getCubesWithNoMeasures(List<BuildObject> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BuildObject buildObject : list) {
            if (!buildObject.getType().equalsIgnoreCase("CUBE")) continue;
            try {
                String string = buildObject.getBuildSpecification();
                String string2 = buildObject.getOwner();
                String string3 = buildObject.getName();
                Cube cube = this.schema.findCube(string3);
                Map<String, Object> map = BuildSyntax.getInstance().fromSyntax(string2, string);
                List list2 = (List)map.get("CUBE_BUILD_COMMANDS_KEY");
                for (CubeBuildCommand cubeBuildCommand : list2) {
                    String string4 = cubeBuildCommand.getType();
                    List<Measure> list3 = cube.getMeasures();
                    if (!string4.equalsIgnoreCase("LOAD") && !string4.equalsIgnoreCase("SOLVE") || list3.size() != 0 || arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getCubesWithBadMappings(List<BuildObject> list) throws TraversalException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        this.cubeNamesToBeBuilt = new ArrayList<String>();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(OLAPArb.get("BUILD_WIZARD_MAPPINGERROR3"));
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setEditable(false);
        jTextArea2.setText(OLAPArb.get("BUILD_WIZARD_MAPPINGERROR4"));
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        Object[] objectArray = new String[]{OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_CUBE_NAME"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_DIM_NAME"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_DIM_HIER"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_DIM_LVL"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_CUBE_SRC"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_CUBE_SRC_DATATYPE"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_DIM_SRC"), OLAPArb.get("BUILD_WIZARD_MAPPINGERROR_COLUMN_HDR_DIM_SRC_DATATYPE")};
        defaultTableModel.setColumnIdentifiers(objectArray);
        GenericTable genericTable = new GenericTable((TableModel)defaultTableModel);
        genericTable.setName("errorMsgTable");
        genericTable.setAutoResizeMode(0);
        genericTable.setColumnSelectorAvailable(false);
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(6);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(7);
        tableColumn.setPreferredWidth(100);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)genericTable);
        jScrollPane.setName("errorScrollPane");
        this.dataTypeMismatchPanel = new JPanel();
        this.dataTypeMismatchPanel.setName("dataTypeMismatchPanel");
        this.dataTypeMismatchPanel.setLayout(new GridBagLayout());
        int n2 = 0;
        this.dataTypeMismatchPanel.add((Component)jTextArea, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dataTypeMismatchPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dataTypeMismatchPanel.add((Component)jTextArea2, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        for (BuildObject object3 : list) {
            if (connection == null) {
                connection = object3.getConnection();
            }
            if (!object3.getType().equalsIgnoreCase("CUBE")) continue;
            object2 = object3.getName();
            this.cubeNamesToBeBuilt.add((String)object2);
            if (n == 0) {
                stringBuffer.append("'" + (String)object2 + "'");
            } else {
                stringBuffer.append(",'" + (String)object2 + "'");
            }
            ++n;
        }
        if (this.cubeNamesToBeBuilt.size() > 0) {
            object = this.getQuery("CUBE_DIMENSIONALITY_MAPPINGS");
            ParamStringExpr n3 = ParamStringExpr.getInstance();
            object2 = DBUtil.getInstance((Connection)connection);
            ArrayList arrayList2 = new ArrayList();
            List list2 = new ArrayList();
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            try {
                Object object3;
                Object object4;
                String string;
                Object object5;
                Object object6;
                String string2;
                Clob clob;
                String string3;
                Object object7;
                Object object82;
                String string4 = n3.getExpression((String)object, this, this, null, null, null);
                string4 = String.format(string4, stringBuffer.toString());
                List list3 = object2.executeReturnList(string4, null);
                StringBuffer stringBuffer2 = new StringBuffer();
                String string5 = null;
                for (Object object9 : list3) {
                    String string6;
                    String string7;
                    Object[] objectArray2;
                    String string8;
                    object82 = (String)object9.get("OWNER");
                    object7 = (Clob)object9.get("DIMENSIONALITY_EXPRESSION");
                    string3 = object7.getSubString(1L, (int)object7.length());
                    clob = (Clob)object9.get("KEY_EXPRESSION");
                    string2 = clob.getSubString(1L, (int)clob.length());
                    object6 = SyntaxObject.fromSyntax((String)string3, null, (String)this.schema.getName());
                    if (object6 instanceof ColumnExpression) {
                        object5 = (ColumnExpression)object6;
                        string = object5.getColumnName();
                        object4 = object5.getQuery();
                        object3 = object4.toSyntax();
                        if (object3.startsWith(string8 = this.schema.getName())) {
                            object3 = object3.substring(string8.length() + 1, object3.length());
                        }
                        objectArray2 = object3;
                        string5 = string5 == null ? " ( owner = '%s' and table_name = '%s' and column_name = '%s')" : "or (owner = '%s' and table_name = '%s' and column_name = '%s')";
                        string7 = String.format(string5, object82, objectArray2, string);
                        stringBuffer2.append(string7);
                        string6 = String.format("%s.%s.%s", object82, objectArray2, string);
                        hashMap2.put(string3, string6);
                    }
                    if (!((object6 = SyntaxObject.fromSyntax((String)string2, null, (String)this.schema.getName())) instanceof ColumnExpression)) continue;
                    object5 = (ColumnExpression)object6;
                    string = object5.getColumnName();
                    object4 = object5.getQuery();
                    object3 = object4.toSyntax();
                    if (object3.startsWith(string8 = this.schema.getName())) {
                        object3 = object3.substring(string8.length() + 1, object3.length());
                    }
                    objectArray2 = object3;
                    string5 = string5 == null ? " (owner = '%s' and table_name = '%s' and column_name = '%s')" : " or (owner = '%s' and table_name = '%s' and column_name = '%s')";
                    string7 = String.format(string5, object82, objectArray2, string);
                    stringBuffer2.append(string7);
                    string6 = String.format("%s.%s.%s", object82, objectArray2, string);
                    hashMap2.put(string2, string6);
                }
                if (stringBuffer2.length() > 0) {
                    Object object10 = this.getQuery("TABLE_COLUMN_DATA_TYPES");
                    object10 = String.format((String)object10, stringBuffer2.toString());
                    list2 = object2.executeReturnList((String)object10, null);
                    for (Object object82 : list2) {
                        object7 = (String)object82.get("TABCOLREF");
                        string3 = (String)object82.get("DATA_TYPE");
                        hashMap.put(object7, string3);
                    }
                }
                for (Object object9 : list3) {
                    object82 = (String)object9.get("CUBE_NAME");
                    object7 = (Clob)object9.get("DIMENSIONALITY_EXPRESSION");
                    string3 = object7.getSubString(1L, (int)object7.length());
                    clob = (Clob)object9.get("KEY_EXPRESSION");
                    string2 = clob.getSubString(1L, (int)clob.length());
                    object6 = (String)hashMap2.get(string3);
                    object5 = (String)hashMap.get(object6);
                    string = (String)hashMap2.get(string2);
                    object4 = (String)hashMap.get(string);
                    if (object5 == null || ((String)object5).equalsIgnoreCase((String)object4)) continue;
                    arrayList.add((String)object82);
                    object3 = new Object[defaultTableModel.getColumnCount()];
                    object3[0] = object82;
                    object3[1] = object9.get("MAPPED_DIMENSION_NAME");
                    object3[2] = object9.get("MAPPED_HIERARCHY_NAME");
                    object3[3] = object9.get("MAPPED_LEVEL_NAME");
                    object3[4] = string3;
                    object3[5] = object5;
                    object3[6] = string2;
                    object3[7] = object4;
                    defaultTableModel.addRow((Object[])object3);
                }
            }
            catch (Exception exception) {
                throw new TraversalException(exception.getMessage());
            }
        }
        if (arrayList.size() > 0) {
            object = new StringBuffer();
            boolean bl = true;
            for (String string : arrayList) {
                void var15_19;
                ((StringBuffer)object).append(string);
                if (var15_19 < arrayList.size()) {
                    ((StringBuffer)object).append(", ");
                }
                ++var15_19;
            }
            int n3 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), this.dataTypeMismatchPanel, OLAPArb.get("BUILD_ERROR_DLG_TITLE"), 0, 2);
            if (n3 == 0) {
                arrayList.clear();
            } else {
                jTextArea2.setVisible(false);
            }
        }
        return arrayList;
    }

    public Object getExitTransition() {
        return "METHODS";
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        BuildObjectShuttlePanel.queries = queries;
    }

    @Override
    public Object getValue(String string) throws SQLException, IOException {
        String string2 = null;
        if (string.equalsIgnoreCase("cubes_to_be_built")) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : this.cubeNamesToBeBuilt) {
                if (n == 0) {
                    stringBuffer.append("'" + string3 + "'");
                } else {
                    stringBuffer.append(",'" + string3 + "'");
                }
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    @Override
    public String getParamPropertyValue(String string, String string2, Measure measure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        Object object = this.getMetadataProperty(string, string2);
        String string3 = object != null ? object.toString() : null;
        return string3;
    }

    private Object getMetadataProperty(String string, String string2) {
        Object object = null;
        if (string.equalsIgnoreCase("schema")) {
            object = this.schema.getValue(string2);
        }
        return object;
    }

    static {
        LOG = Logger.getLogger(BuildObjectShuttlePanel.class.getName());
    }
}

