/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateExpression;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templatelist.TemplateNameFormat;
import oracle.olap.app.templates.templateview.BaseTemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamFactory;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.stringexpr.NameSyntaxParseException;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;
import oracle.olap.stringexpr.TokenMgrError;

public class TemplateHyperView
extends BaseTemplateHyperView {
    private static final Logger LOG = Logger.getLogger(TemplateHyperView.class.getName());
    private String desc;
    private String nameSuffix;
    private JCheckBox checkBox;
    private TemplateNameFormat templateNameFormat;
    private Measure baseMeasure;
    private DimensionHierarchy levelHier;

    public TemplateHyperView(TemplateGroupHyperView templateGroupHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, Template template, TemplateGroup templateGroup) {
        this(templateGroupHyperView, templateContext, templateHyperContext, template, templateGroup, null);
    }

    public TemplateHyperView(TemplateGroupHyperView templateGroupHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, Template template, TemplateGroup templateGroup, Map<String, String> map) {
        super(templateGroupHyperView, templateContext, templateHyperContext, template, templateGroup, map);
        if (template != null) {
            this.desc = template.getName();
            this.nameSuffix = "_" + template.getType();
            if (templateHyperContext.getResources() != null && template.getTemplateList() != null) {
                this.desc = templateHyperContext.getResources().getXLIFFResource(template.getTemplateList().getFileName(), this.desc);
            }
            this.checkBox = new JCheckBox(this.desc);
            this.checkBox.setSelected(template.isSelected());
        }
    }

    @Override
    public TemplateList getTemplateList() {
        return this.getTemplate().getTemplateList();
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getType() {
        return this.getTemplate().getType();
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDescSuffix() {
        return " " + this.desc;
    }

    @Override
    protected String getUi() {
        if (this.getTemplateGroup().getUi() == null && this.getTemplate() != null) {
            return this.getTemplate().getUi();
        }
        return null;
    }

    @Override
    public boolean setupTemplateHyperParamDependencies(List<TemplateHyperParam> list) {
        boolean bl = this.setupHyperParamDependencies(list);
        return bl;
    }

    public TemplateNameFormat getTemplateNameFormat() {
        return this.templateNameFormat;
    }

    public void setTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        this.templateNameFormat = templateNameFormat;
    }

    public void setNameSuffix(String string) {
        this.nameSuffix = string;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setEnabled(boolean bl) {
        this.checkBox.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    @Override
    public Param getParam(String string) {
        Template template = (Template)this.getTemplate();
        for (Param param : template.getParams()) {
            if (param.getName() == null || !param.getName().equals(string)) continue;
            return param;
        }
        return super.getParam(string);
    }

    public String generateName(String string, Measure measure, DimensionHierarchy dimensionHierarchy, String string2) throws NameSyntaxParseException, SQLException, IOException {
        if (string.equalsIgnoreCase("name")) {
            return this.generateName(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("description")) {
            return this.generateDescription(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("shortDescription")) {
            return this.generateShortDescription(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("longDescription")) {
            return this.generateLongDescription(measure, dimensionHierarchy, string2);
        }
        return "";
    }

    public String generateName(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        Object object = measure.getName() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getName() != null && (string2 = this.generateFromRule(this.templateNameFormat.getName(), measure, dimensionHierarchy)).trim().length() > 0) {
            object = string2;
        }
        if (((String)(object = ((String)object).replace(' ', '_'))).length() > 30) {
            object = ((String)object).substring(0, 30);
        }
        return object;
    }

    public String generateDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateShortDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getShortDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getShortDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getShortDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateLongDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getLongDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getLongDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateFromRule(String string, Measure measure, DimensionHierarchy dimensionHierarchy) throws NameSyntaxParseException, SQLException, IOException {
        try {
            this.baseMeasure = measure;
            this.levelHier = dimensionHierarchy;
            List<String> list = this.getVisibleParamNames();
            String string2 = StringExprParser.getParseTree(string, this, list);
            return string2;
        }
        catch (ParseException parseException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, parseException);
            throw nameSyntaxParseException;
        }
        catch (TokenMgrError tokenMgrError) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, tokenMgrError);
            throw nameSyntaxParseException;
        }
        catch (RuntimeException runtimeException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, runtimeException);
            throw nameSyntaxParseException;
        }
    }

    private String getObjectValue(String string, Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.startsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).toLowerCase().startsWith("measure")) {
            string = string.length() > "measure_".length() ? string.substring("measure_".length(), string.length()) : "name";
            return TemplateHyperView.getObjectDesc(measure, string);
        }
        if (string.toLowerCase().startsWith("hierarchy_level")) {
            Object object = this.getProperty("hierarchy_level");
            if (object instanceof NamedObjectWithDesc) {
                String string2 = "name";
                if (string.startsWith("hierarchy_level_")) {
                    string2 = string.substring("hierarchy_level_".length(), string.length());
                }
                NamedObjectWithDesc namedObjectWithDesc = (NamedObjectWithDesc)object;
                return TemplateHyperView.getObjectDesc(namedObjectWithDesc, string2);
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        if (string.toLowerCase().startsWith("hierarchy")) {
            string = string.substring("hierarchy_".length(), string.length());
            return TemplateHyperView.getObjectDesc(dimensionHierarchy, string);
        }
        if (string.toLowerCase().startsWith("level")) {
            DimensionHierarchyLevel dimensionHierarchyLevel;
            string = string.length() > "level_".length() ? string.substring("level_".length(), string.length()) : "name";
            Object object = this.getProperty("LEVEL");
            if (object instanceof DimensionHierarchyLevel && (dimensionHierarchyLevel = (DimensionHierarchyLevel)object) != null) {
                DimensionLevel dimensionLevel = dimensionHierarchyLevel.getDimensionLevel();
                return TemplateHyperView.getObjectDesc(dimensionLevel, string);
            }
        } else if (string.toLowerCase().startsWith("dimension")) {
            string = string.length() > "dimension_".length() ? string.substring("dimension_".length(), string.length()) : "name";
            Object object = this.getProperty("DIMENSION");
            if (object instanceof Dimension) {
                Dimension dimension = (Dimension)object;
                return TemplateHyperView.getObjectDesc(dimension, string);
            }
        } else {
            Object object = this.getProperty(string);
            if (object != null) {
                if (object instanceof String) {
                    return (String)object;
                }
                return object.toString();
            }
        }
        return "";
    }

    public static String getObjectDesc(NamedObjectWithDesc namedObjectWithDesc, String string) {
        String string2 = namedObjectWithDesc.getName();
        if (string.equalsIgnoreCase("name")) {
            return string2;
        }
        if (string.equalsIgnoreCase("description")) {
            string2 = namedObjectWithDesc.getDescription();
        }
        if (string.equalsIgnoreCase("short_description")) {
            string2 = namedObjectWithDesc.getShortDescription();
        }
        if (string.equalsIgnoreCase("long_description")) {
            return namedObjectWithDesc.getDescription();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = namedObjectWithDesc.getName();
        }
        return string2;
    }

    @Override
    public Object getValue(String string) {
        String string2 = null;
        try {
            if (string.equalsIgnoreCase("index$")) {
                int n = this.getParentTemplateHyperView().indexOf(this);
                return new Integer(n);
            }
            string2 = this.getObjectValue(string, this.baseMeasure, this.levelHier);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string2;
    }

    @Override
    public String getName() {
        if (this.getTemplate() != null) {
            return this.getTemplate().getName();
        }
        return null;
    }

    @Override
    public List<TemplateHyperParam> getHyperParams() {
        TemplateGroupHyperView templateGroupHyperView;
        BaseTemplateHyperView baseTemplateHyperView = this.getParentTemplateHyperView();
        if (baseTemplateHyperView instanceof TemplateGroupHyperView && (templateGroupHyperView = (TemplateGroupHyperView)baseTemplateHyperView) != null && templateGroupHyperView.getUi() != null) {
            return templateGroupHyperView.getHyperParams();
        }
        return super.getHyperParams();
    }

    @Override
    public String getExpression() throws SQLException, IOException {
        return this.getExpression(null);
    }

    public String getExpression(Measure measure) throws SQLException, IOException {
        if (this.getTemplate() == null) {
            return null;
        }
        String string = this.getTemplate().getExpression();
        return this.getExpression(string, measure);
    }

    public HashMap<String, String> getSQLExpressions(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        Template template = (Template)this.getTemplate();
        if (!template.getTemplateDependencies().isEmpty() && measure.getCube().isSQLExpressionsEnabled()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            List<TemplateExpression> list = template.getTemplateDependencies().get(0).getTemplateExpressions();
            for (TemplateExpression templateExpression : list) {
                hashMap.put(templateExpression.getType(), this.replaceExpressionTokens(measure, dimensionHierarchy, templateExpression.getExpression()));
            }
            return hashMap;
        }
        return null;
    }

    private String replaceExpressionTokens(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws SQLException, IOException {
        Object object = string;
        while (((String)object).indexOf("{") >= 0) {
            int n = ((String)object).indexOf("{");
            int n2 = ((String)object).indexOf("}");
            if (n2 < 0) continue;
            String string2 = ((String)object).substring(n + 1, n2);
            String[] stringArray = TemplateHyperParamFactory.splitDefinition(string2);
            String string3 = stringArray[3];
            String string4 = stringArray[2];
            TemplateHyperParam templateHyperParam = this.getHyperParamForName(string3);
            if (templateHyperParam == null) {
                templateHyperParam = this.getHyperParamForType(string3);
            }
            Object object2 = "{" + string3 + "}";
            object2 = string3;
            if (templateHyperParam != null) {
                object2 = templateHyperParam.getExpression(string4);
            } else if (string3.equalsIgnoreCase("measure")) {
                if (measure != null) {
                    object2 = measure.getID();
                }
            } else if (string3.equalsIgnoreCase("dependent")) {
                object2 = this.getDependentMeasureName(measure, dimensionHierarchy);
            } else if (string3.equalsIgnoreCase("measure_quoted")) {
                object2 = this.quoteExpression(measure.getID());
            } else if (string3.equalsIgnoreCase("measure_quoted_description")) {
                object2 = this.quoteMeasureDescriptionExpression(measure);
            } else if (string3.equalsIgnoreCase("dependent_quoted")) {
                object2 = this.quoteExpression(this.getDependentMeasureName(measure, dimensionHierarchy));
            } else if (string3.equalsIgnoreCase("dependent_quoted_description")) {
                object2 = this.quoteDependentDescriptionExpression(measure, this.getDependentMeasureDescription(measure, dimensionHierarchy));
            } else if (string3.equalsIgnoreCase("measure_column_name")) {
                object2 = this.getSQLName(measure);
            } else if (string3.equalsIgnoreCase("dependent_column_name")) {
                object2 = this.getSQLDependentName(measure, dimensionHierarchy);
            }
            String string5 = object;
            object = string5.substring(0, n);
            object = (String)object + (String)object2;
            object = (String)object + string5.substring(n2 + 1, string5.length());
        }
        return object;
    }

    private TemplateNameFormat getDependentTemplateNameFormat() {
        Template template = (Template)this.getTemplate();
        String string = template.getTemplateDependencies().get(0).getType();
        for (Template template2 : this.getTemplateList().getTemplatesOnly()) {
            if (template2.getType() == null || !template2.getType().equalsIgnoreCase(string)) continue;
            return template2.getTemplateNameFormat();
        }
        return null;
    }

    private String getDependentMeasureName(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        String string = "";
        Template template = (Template)this.getTemplate();
        String string2 = template.getTemplateDependencies().get(0).getType();
        TemplateNameFormat templateNameFormat = this.getDependentTemplateNameFormat();
        try {
            String string3 = templateNameFormat.getName();
            String string4 = this.getTemplateNameFormat().getName();
            this.getTemplateNameFormat().setName(string3);
            string = String.format("%s.%s", measure.getCube().getName(), this.generateName(measure, dimensionHierarchy, "_" + string2));
            this.getTemplateNameFormat().setName(string4);
        }
        catch (NameSyntaxParseException nameSyntaxParseException) {
            LOG.log(Level.SEVERE, nameSyntaxParseException.getMessage(), nameSyntaxParseException);
        }
        return string;
    }

    private String getDependentMeasureDescription(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        String string = "";
        TemplateNameFormat templateNameFormat = this.getDependentTemplateNameFormat();
        try {
            String string2 = templateNameFormat.getDescription();
            String string3 = this.getTemplateNameFormat().getDescription();
            this.getTemplateNameFormat().setDescription(string2);
            string = this.generateDescription(measure, dimensionHierarchy, "");
            this.getTemplateNameFormat().setDescription(string3);
        }
        catch (NameSyntaxParseException nameSyntaxParseException) {
            // empty catch block
        }
        return string;
    }

    private String getSQLName(Measure measure) {
        String string = measure.getID().substring(measure.getID().indexOf(".") + 1);
        return measure.getCube().getViewName() + "." + string;
    }

    private String getSQLDependentName(Measure measure, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        String string = "";
        Template template = (Template)this.getTemplate();
        String string2 = template.getTemplateDependencies().get(0).getType();
        TemplateNameFormat templateNameFormat = this.getDependentTemplateNameFormat();
        try {
            String string3 = templateNameFormat.getName();
            String string4 = this.getTemplateNameFormat().getName();
            this.getTemplateNameFormat().setName(string3);
            string = String.format("%s.%s", measure.getCube().getViewName(), this.generateName(measure, dimensionHierarchy, "_" + string2));
            this.getTemplateNameFormat().setName(string4);
        }
        catch (NameSyntaxParseException nameSyntaxParseException) {
            // empty catch block
        }
        return string;
    }

    private String quoteExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringBuffer.append("\"");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken() + "\".\"");
        }
        if (stringBuffer.toString().endsWith(".\"")) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    private String quoteMeasureDescriptionExpression(Measure measure) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string2 = measure.getCube().getDescription() != "" ? measure.getCube().getDescription() : measure.getCube().getName();
        if (string2 == null) {
            string2 = measure.getCube().getName();
        }
        String string4 = string = measure.getDescription() != "" ? measure.getDescription() : measure.getName();
        if (string == null) {
            string = measure.getName();
        }
        stringBuffer.append("\"" + string2 + "\".\"" + string + "\"");
        return stringBuffer.toString();
    }

    private String quoteDependentDescriptionExpression(Measure measure, String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string2 = measure.getCube().getDescription() != "" ? measure.getCube().getDescription() : measure.getCube().getName();
        if (string2 == null) {
            string2 = measure.getCube().getName();
        }
        stringBuffer.append("\"" + string2 + "\".\"" + string + "\"");
        return stringBuffer.toString();
    }

    public void checkDependentTemplateView(String string) {
    }

    public void checkReferencedTemplateView(String string) {
    }
}

