/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.templates.templateview.MeasureTreeNode;

public class MeasureSelector
extends JDialog
implements SearchListener {
    private static final String TITLE = "MEASURE_PICKER_TITLE";
    private static final String CANCEL_COMMAND = "CANCEL_ID";
    private static final String HELP_COMMAND = "HELP_ID";
    private static final String helpId = "olap_select_measures";
    private final String title;
    private final JComponent parentComponent;
    private JTree tree;
    private SearchField searchField;
    private JLabel filterLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private boolean measureSelected;
    private List<MeasureTreeNode> searchResults;
    private String previousSearch;
    private int searchIndex;

    public MeasureSelector(MeasureTreeNode measureTreeNode, Resources resources, JComponent jComponent) {
        super((Frame)Ide.getMainWindow());
        this.setLayout(new BorderLayout());
        this.parentComponent = jComponent;
        Dimension dimension = new Dimension(380, 350);
        this.setMinimumSize(dimension);
        this.setPreferredSize(this.getMinimumSize());
        HelpSystem.getHelpSystem().registerTopic(jComponent, helpId);
        this.searchResults = new ArrayList<MeasureTreeNode>();
        this.previousSearch = "";
        this.searchIndex = 0;
        this.tree = new JTree(measureTreeNode);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (component instanceof JLabel && object instanceof MeasureTreeNode) {
                    MeasureTreeNode measureTreeNode = (MeasureTreeNode)object;
                    ((JLabel)component).setIcon(measureTreeNode.getIcon());
                }
                return component;
            }
        });
        this.tree.setRootVisible(false);
        this.title = resources.getString(TITLE);
        super.setTitle(this.title);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MeasureSelector.this.measureSelected = MeasureSelector.this.isMeasureSelected();
                    MeasureSelector.this.setVisible(false);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)jPanel, "Center");
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setName("searchField");
        this.searchField.setAllowEmptySearch(true);
        this.searchField.setAutoFind(true);
        this.searchField.addSearchListener((SearchListener)this);
        this.searchField.setMinimumSize(new Dimension(50, 120));
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)resources.getString("MEASURE_SELECTOR_DIALOG_FILTER_LABEL"));
        this.okButton = new JButton(OLAPArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSelector.this.measureSelected = MeasureSelector.this.isMeasureSelected();
                MeasureSelector.this.setVisible(false);
            }
        });
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)OLAPArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSelector.this.showHelp();
            }
        });
        this.cancelButton = new JButton(OLAPArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSelector.this.measureSelected = false;
                MeasureSelector.this.setVisible(false);
            }
        });
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.filterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 19, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.searchField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 19, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add((Component)dialogButtonBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)jPanel2, "South");
        this.registerKeyboardActions();
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
    }

    private boolean isMeasureSelected() {
        MeasureTreeNode measureTreeNode = this.getValue();
        return measureTreeNode.getID() != null;
    }

    public MeasureTreeNode getValue() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            return (MeasureTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public MeasureTreeNode setNode(Object object) {
        if (this.tree != null) {
            MeasureTreeNode measureTreeNode = (MeasureTreeNode)this.tree.getModel().getRoot();
            MeasureTreeNode measureTreeNode2 = object instanceof MeasureTreeNode ? measureTreeNode.find(((MeasureTreeNode)object).getID()) : measureTreeNode.find(object.toString());
            if (measureTreeNode2 == null) {
                return null;
            }
            LinkedList<MeasureTreeNode> linkedList = new LinkedList<MeasureTreeNode>();
            for (TreeNode treeNode = measureTreeNode2; treeNode != null; treeNode = treeNode.getParent()) {
                linkedList.addFirst((MeasureTreeNode)treeNode);
            }
            TreePath treePath = new TreePath(linkedList.toArray());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
            this.tree.getExpandsSelectedPaths();
            return measureTreeNode2;
        }
        return null;
    }

    public boolean showPickerDialog() {
        this.setModal(true);
        this.setVisible(true);
        return this.measureSelected;
    }

    private void showHelp() {
        HelpSystem.getHelpSystem().showHelp(this.parentComponent);
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSelector.this.measureSelected = false;
                MeasureSelector.this.setVisible(false);
            }
        };
        jRootPane.registerKeyboardAction(actionListener, CANCEL_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp(MeasureSelector.this.parentComponent);
            }
        };
        jRootPane.registerKeyboardAction(actionListener2, HELP_COMMAND, KeyStroke.getKeyStroke(112, 0), 1);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this.findNode(searchEvent.getSearchText(), searchEvent.getDirection());
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    private void findNodes(String string, List<MeasureTreeNode> list) {
        MeasureTreeNode measureTreeNode = (MeasureTreeNode)this.tree.getModel().getRoot();
        this.findNodesDepthFirst(measureTreeNode, string, list);
    }

    private void findNode(String string, SearchEvent.Direction direction) {
        if (string.length() > 0) {
            if (this.searchResults.isEmpty()) {
                this.findNodes(string, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.setNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            } else if (this.previousSearch.equals(string)) {
                this.searchIndex = direction.equals((Object)SearchEvent.Direction.FORWARD) ? (this.searchIndex + 1 < this.searchResults.size() ? ++this.searchIndex : 0) : (this.searchIndex - 1 >= 0 ? --this.searchIndex : this.searchResults.size() - 1);
                if (!this.searchResults.isEmpty()) {
                    this.setNode(this.searchResults.get(this.searchIndex));
                }
            } else {
                this.searchResults.clear();
                this.searchIndex = 0;
                this.findNodes(string, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.setNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            }
        }
    }

    private void findNodesDepthFirst(MeasureTreeNode measureTreeNode, String string, List<MeasureTreeNode> list) {
        if (measureTreeNode.matches(string)) {
            list.add(measureTreeNode);
        }
        if (measureTreeNode.hasChildren()) {
            List<MeasureTreeNode> list2 = measureTreeNode.getChildren();
            for (MeasureTreeNode measureTreeNode2 : list2) {
                this.findNodesDepthFirst(measureTreeNode2, string, list);
            }
        }
    }

    public void clear() {
        this.searchField.clear();
    }
}

