/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.app.table.Column;
import oracle.olap.app.table.Format;
import oracle.olap.app.table.QueryPanel;
import oracle.olap.app.table.TextFormatter;
import oracle.olap.app.table.View;
import oracle.olap.util.SQLViewerDialogLauncher;

public class QueryTableCellViewer
extends AbstractCellEditor
implements TableCellEditor {
    private myTableCellEditorPanel component;
    private View view;
    private TextFieldFormat tfTemplate;
    private Map<String, TextFormatter> m_textFormatters;

    public QueryTableCellViewer(List<Format> list, View view) {
        this.view = view;
        this.m_textFormatters = new HashMap<String, TextFormatter>();
        this.component = new myTableCellEditorPanel(list);
    }

    @Override
    public Object getCellEditorValue() {
        return this.component.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        List<Column> list;
        Column column;
        this.component.setText((String)object);
        if (this.view != null && (column = (list = this.view.getColumnList()).get(n2)) != null) {
            if (column.getFormatting() != null) {
                this.component.setFormatting(column.getFormatting());
            } else {
                this.component.setFormatting("");
            }
        }
        return this.component;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }

    private class myTableCellEditorPanel
    extends JPanel {
        private List<Format> formats;

        private myTableCellEditorPanel(List<Format> list) {
            this.formats = list;
            this.jbInit();
        }

        private void jbInit() {
            this.setLayout(new BorderLayout());
            QueryTableCellViewer.this.tfTemplate = new TextFieldFormat();
            QueryTableCellViewer.this.tfTemplate.setEditable(false);
            Document document = QueryTableCellViewer.this.tfTemplate.getDocument();
            if (document != null) {
                document.putProperty("filterNewlines", Boolean.FALSE);
                QueryTableCellViewer.this.tfTemplate.setText("");
            }
            this.add((Component)QueryTableCellViewer.this.tfTemplate, "Center");
            JButton jButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
            jButton.setMargin(new Insets(2, 2, 2, 2));
            this.add((Component)jButton, "East");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = QueryTableCellViewer.this.tfTemplate.getText();
                    int n = 0;
                    Format format = QueryPanel.getFormat(myTableCellEditorPanel.this.formats, QueryTableCellViewer.this.tfTemplate.getFormatting());
                    if (format != null) {
                        try {
                            if (QueryTableCellViewer.this.m_textFormatters.get(QueryTableCellViewer.this.tfTemplate.getFormatting()) == null) {
                                QueryTableCellViewer.this.m_textFormatters.put(QueryTableCellViewer.this.tfTemplate.getFormatting(), (TextFormatter)format.getViewerFormat().getClassParam().newInstance());
                            }
                            TextFormatter textFormatter = QueryTableCellViewer.this.m_textFormatters.get(QueryTableCellViewer.this.tfTemplate.getFormatting());
                            string = textFormatter.getText(string);
                            if (textFormatter.getType().equalsIgnoreCase("SQL")) {
                                n = 1;
                            }
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                    SQLViewerDialogLauncher.launchDialog(QueryTableCellViewer.this.component, string, OLAPArb.getString("TEXTVIEWER_DIALOG_TITLE"), n);
                }
            });
        }

        public String getText() {
            return QueryTableCellViewer.this.tfTemplate.getText();
        }

        public void setText(String string) {
            QueryTableCellViewer.this.tfTemplate.setText(string);
            QueryTableCellViewer.this.tfTemplate.setToolTipText(string);
        }

        public void setFormatting(String string) {
            QueryTableCellViewer.this.tfTemplate.setFormatting(string);
        }
    }

    private class TextFieldFormat
    extends JTextField {
        private String formatting = "";

        public void setFormatting(String string) {
            this.formatting = string;
        }

        public String getFormatting() {
            return this.formatting;
        }
    }
}

