/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.olap.app.table.Column;
import oracle.olap.app.table.Format;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryComponent;
import oracle.olap.app.table.QueryTable;
import oracle.olap.app.table.QueryTableModel;
import oracle.olap.app.table.TextFormatter;
import oracle.olap.app.table.TooltipFormat;
import oracle.olap.app.table.View;

public class QueryPanel
extends JPanel
implements QueryComponent {
    private QueryTable m_queryTable;
    private QueryTableModel m_queryTableModel;
    private JScrollPane queryScrollPane;
    private GridBagConstraints queryConstraints;
    private JTableHeader m_tableHeader;
    private Connection m_conn;
    private Query m_query;
    private String m_querySQLText;
    private Map<String, Object> m_queryParams;
    private ComponentWithTitlebar titlebar;
    private List<Format> m_formats;
    private Map<String, TextFormatter> m_textFormatters;

    public QueryPanel(Connection connection, Query query, Map<String, Object> map, List<Format> list) {
        this.m_conn = connection;
        this.m_query = query;
        this.m_queryParams = map;
        this.m_formats = list;
        this.m_textFormatters = new HashMap<String, TextFormatter>();
        this.init();
    }

    private void init() {
        this.m_queryTableModel = new QueryTableModel(this.m_conn, this.m_query, this.m_queryParams);
        this.m_queryTable = new QueryTable(this.m_queryTableModel, this.m_formats){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    Format format;
                    List<Column> list;
                    Column column;
                    JComponent jComponent = (JComponent)component;
                    String string = (String)this.getValueAt(n, n2);
                    View view = QueryPanel.this.m_query.getView();
                    if (view != null && (column = (list = view.getColumnList()).get(n2)).getFormatting() != null && string != null && (format = QueryPanel.getFormat(QueryPanel.this.m_formats, column.getFormatting())) != null) {
                        TooltipFormat tooltipFormat = format.getTooltipFormat();
                        try {
                            if (QueryPanel.this.m_textFormatters.get(column.getFormatting()) == null) {
                                QueryPanel.this.m_textFormatters.put(column.getFormatting(), (TextFormatter)tooltipFormat.getClassParam().newInstance());
                            }
                            TextFormatter textFormatter = QueryPanel.this.m_textFormatters.get(column.getFormatting());
                            string = textFormatter.getText(string);
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                    jComponent.setToolTipText(string);
                }
                return component;
            }
        };
        this.m_queryTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.m_queryTable.setAutoResizeMode(0);
        this.setLayout(new GridBagLayout());
        this.queryConstraints = new GridBagConstraints();
        this.queryConstraints.gridx = 0;
        this.queryConstraints.gridy = 1;
        this.queryConstraints.fill = 1;
        this.queryConstraints.anchor = 10;
        this.queryConstraints.gridwidth = 5;
        this.queryConstraints.gridheight = 1;
        this.queryConstraints.weightx = 1.0;
        this.queryConstraints.weighty = 1.0;
        this.queryConstraints.insets = new Insets(10, 0, 0, 0);
        this.initTitlebar();
        this.add((Component)this.titlebar, this.queryConstraints);
    }

    private void initTitlebar() {
        this.titlebar = new ComponentWithTitlebar();
        this.queryScrollPane = new JScrollPane();
        this.queryScrollPane.getViewport().add((Component)((Object)this.m_queryTable), 32, 22);
        this.titlebar.setComponent((JComponent)this.queryScrollPane);
    }

    public void addTitleControlBar(ControlBar controlBar) {
        this.titlebar.setControlBar(controlBar);
    }

    public void setTitlebarLabel(JLabel jLabel) {
        this.titlebar.setLabel(jLabel);
    }

    @Override
    public synchronized void refresh() throws Exception {
        boolean bl = this.m_queryTableModel.populateQueryTableDataModel();
        int n = this.queryScrollPane.getVerticalScrollBar().getMaximum();
        this.m_tableHeader = this.m_queryTable.getTableHeader();
        this.queryScrollPane.getVerticalScrollBar().setValue(n);
    }

    public void resetColumnCount() {
        this.m_queryTableModel.resetColumnCount();
        this.m_queryTableModel.setColumnCount(0);
    }

    public QueryTable getQueryTable() {
        return this.m_queryTable;
    }

    public boolean isRecordsExist() throws Exception {
        boolean bl = false;
        this.refresh();
        if (this.m_queryTableModel.getNumOfRows() > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void cleanup() {
        this.m_queryTable = null;
        this.m_queryTableModel = null;
        this.queryScrollPane = null;
        this.queryConstraints = null;
        this.m_tableHeader = null;
        this.m_conn = null;
        this.m_query = null;
        this.m_queryParams = null;
    }

    public GridBagConstraints getUIConstraints() {
        return this.queryConstraints;
    }

    public Query getQuery() {
        return this.m_query;
    }

    public String getQuerySQL() {
        if (this.m_querySQLText == null) {
            String string = this.m_query.getText();
            Set<Map.Entry<String, Object>> set = this.m_queryParams.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                Object object = entry.getKey();
                Object object2 = entry.getValue();
                object = ":" + (String)object;
                Object object3 = "";
                if (object2 instanceof String) {
                    object3 = (String)object2;
                    object3 = "'" + (String)object3 + "'";
                } else if (object2 instanceof Integer) {
                    Integer n = (Integer)object2;
                    object3 = n.toString();
                }
                string = string.replaceAll((String)object, (String)object3);
            }
            this.m_querySQLText = string;
        }
        return this.m_querySQLText;
    }

    public TableModel getQueryTableModel() {
        return this.m_queryTableModel;
    }

    public static Format getFormat(List<Format> list, String string) {
        if (list != null) {
            for (Format format : list) {
                if (!format.getName().equals(string)) continue;
                return format;
            }
        }
        return null;
    }
}

