/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.util.Logger;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.Schema;

public class Cube
extends NamedObjectWithDesc {
    public static final String TYPE = "CUBE";
    private Schema schema;
    private String awName;
    private List<Dimension> dims;
    private List<Measure> measures;
    private String sparseType;
    private DimensionHierarchyLevel partitionHierarchyLevel;
    private String consistentSolveSpec;
    private String viewName;
    private boolean sqlExpressionsEnabled;
    private Map<String, String> dimensionKeyColMap;
    private Database database;

    public Cube(Schema schema, String string, String string2, String string3, String string4, boolean bl) {
        super(string2, string3);
        this.schema = schema;
        this.awName = string;
        this.viewName = string4;
        this.sqlExpressionsEnabled = bl;
        this.dims = new ArrayList<Dimension>();
        this.measures = new ArrayList<Measure>();
        this.dimensionKeyColMap = new HashMap<String, String>();
    }

    public Cube(Database database, Schema schema, String string, String string2, String string3, String string4, boolean bl) {
        this(schema, string, string2, string3, string4, bl);
        this.database = database;
    }

    public String getID() {
        if (this.schema != null) {
            return this.schema.getName() + "." + this.getName();
        }
        return this.getName();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getAWName() {
        return this.awName;
    }

    public String getConsistentSolveSpec() {
        return this.consistentSolveSpec;
    }

    public void setConsistentSolveSpec(String string) {
        this.consistentSolveSpec = string;
    }

    public void setPartition(DimensionHierarchyLevel dimensionHierarchyLevel) {
        this.partitionHierarchyLevel = dimensionHierarchyLevel;
    }

    public DimensionHierarchyLevel getHierarchyLevel() {
        return this.partitionHierarchyLevel;
    }

    public void addDimension(Dimension dimension) {
        this.dims.add(dimension);
    }

    public List<Dimension> getDimensions() {
        return this.dims;
    }

    public Dimension findDimension(String string) {
        for (Dimension dimension : this.dims) {
            if (!dimension.getName().equals(string)) continue;
            return dimension;
        }
        return null;
    }

    public Measure addMeasure(String string, String string2, String string3, String string4) {
        Measure measure = new Measure(this, string, string2, string3, string4);
        this.measures.add(measure);
        return measure;
    }

    public Measure findMeasure(String string) {
        for (Measure measure : this.measures) {
            String string2 = measure.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return measure;
        }
        return null;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public void setSQLExpressionsEnabled(boolean bl) {
        this.sqlExpressionsEnabled = bl;
    }

    public boolean isSQLExpressionsEnabled() {
        return this.sqlExpressionsEnabled;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public String getViewName() {
        if (this.database != null) {
            String string = null;
            try {
                string = this.database.getUser();
            }
            catch (Exception exception) {
                Logger.severe(Cube.class, (Throwable)exception);
            }
            if (string != null && !string.equalsIgnoreCase(this.schema.getName())) {
                return this.schema.getName() + "." + this.viewName;
            }
        }
        return this.viewName;
    }

    public void setDimensionColumn(String string, String string2) {
        this.dimensionKeyColMap.put(string, string2);
    }

    public String getDimensionColumn(String string) {
        return this.dimensionKeyColMap.get(string);
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        for (Measure measure : this.measures) {
            measure.setSelected(bl);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(" Dimensions [");
        for (Dimension dimension : this.dims) {
            stringBuffer.append(dimension.getName());
            stringBuffer.append(",");
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

