/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapixml;

import oracle.olap.app.cubeddl.model.CubeColumn;
import oracle.olap.app.cubeddl.model.CubeCreate;
import oracle.olap.app.cubeddl.model.Hierarchy;
import oracle.olap.app.olapixml.NamedObjectWithDescX;
import oracle.olap.app.olapmetadata.Cube;

public class CubeX
extends NamedObjectWithDescX {
    public CubeX(Cube cube) {
        super(cube);
    }

    public CubeX(CubeCreate cubeCreate) {
        super(cubeCreate);
    }

    private CubeCreate getCube() {
        return (CubeCreate)this.getNamedObject();
    }

    @Override
    public String getStartX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  <Cube\n");
        stringBuffer.append("    Name=\"" + this.getName().toUpperCase() + "\">\n");
        return stringBuffer.toString();
    }

    @Override
    public String getEndX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  </Cube>\n");
        return stringBuffer.toString();
    }

    public String drop() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer();
        stringBuffer.append("  <Cube\n");
        stringBuffer.append("    Action=\"REMOVE\"\n");
        stringBuffer.append("    Name=\"" + this.getName().toUpperCase() + "\">\n");
        stringBuffer.append(this.getEndX());
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartX());
        String string = "DEFAULTAW";
        if (this.getCube().getAWSpecification() != null) {
            string = this.getCube().getAWSpecification().getName();
        }
        string = string.toUpperCase();
        stringBuffer.append("    <Organization>\n");
        stringBuffer.append("      <AWCubeOrganization\n");
        stringBuffer.append("        AW=\"" + string + "\"\n");
        stringBuffer.append("        NullStorage=\"MV_READY\"\n");
        stringBuffer.append("        MVOption=\"NONE\"\n");
        if (this.getCube().getPrecomputePercent() != null) {
            stringBuffer.append("        PrecomputePercent=\"" + this.getCube().getPrecomputePercent() + "\"\n");
        }
        stringBuffer.append("        MeasureStorage=\"SHARED\"\n");
        stringBuffer.append("        CubeStorageType=\"NUMBER\">\n");
        if (this.getCube().getPartition() != null) {
            stringBuffer.append("        PartitionLevel=\"" + this.getCube().getPartition() + "\"\n");
        }
        stringBuffer.append("      </AWCubeOrganization>\n");
        stringBuffer.append("    </Organization>\n");
        for (CubeColumn cubeColumn : this.getCube().getDimensions()) {
            stringBuffer.append("   <Dimensionality\n");
            stringBuffer.append("      Action=\"ADD\"\n");
            stringBuffer.append("      Name=\"" + cubeColumn.getDimension() + "\"\n");
            stringBuffer.append("      Dimension=\"" + cubeColumn.getDimension() + "\">\n");
            stringBuffer.append("   </Dimensionality>\n");
        }
        if (this.getCube().getSolve() != null) {
            stringBuffer.append("   <ConsistentSolve>\n");
            stringBuffer.append("       " + this.getCube().getSolve() + "\n");
            stringBuffer.append("   </ConsistentSolve>\n");
        }
        if (this.getCube().getMeasures().size() > 0) {
            stringBuffer.append("   <Measure>\n");
        }
        for (CubeColumn cubeColumn : this.getCube().getMeasures()) {
            if (cubeColumn.getMeasureExpression() == null) {
                stringBuffer.append("     <BaseMeasure\n");
                stringBuffer.append("       Name=\"" + cubeColumn.getName() + "\"\n");
                stringBuffer.append("       SQLDataType=\"NUMBER\">\n");
                stringBuffer.append("     </BaseMeasure>\n");
                continue;
            }
            stringBuffer.append("     <DerivedMeasure\n");
            stringBuffer.append("       Name=\"" + cubeColumn.getName().toUpperCase() + "\"\n");
            stringBuffer.append("       MeasureExpression=\"" + cubeColumn.getMeasureExpression() + "\">\n");
            stringBuffer.append("     </DerivedMeasure>\n");
        }
        if (this.getCube().getMeasures().size() > 0) {
            stringBuffer.append("   </Measure>\n");
        }
        if (this.getCube().isMapped()) {
            String string2;
            stringBuffer.append("   <CubeMap\n");
            stringBuffer.append("      Name=\"MAP1\"\n");
            stringBuffer.append("      Query=\"" + this.getCube().getQuery() + "\">\n");
            for (CubeColumn cubeColumn : this.getCube().getMeasures()) {
                if (cubeColumn.getMeasureExpression() != null || (string2 = this.getCube().getMeasureMap(cubeColumn)) == null) continue;
                stringBuffer.append("       <MeasureMap\n");
                stringBuffer.append("         Action=\"ADD\"\n");
                stringBuffer.append("         Name=\"" + cubeColumn.getName() + "\"\n");
                stringBuffer.append("         Measure=\"" + cubeColumn.getName() + "\"\n");
                stringBuffer.append("         Expression=\"" + this.getCube().getMeasureMap(cubeColumn) + "\">\n");
                stringBuffer.append("       </MeasureMap>\n");
            }
            for (CubeColumn cubeColumn : this.getCube().getDimensions()) {
                string2 = this.getCube().getCubeDimMap(cubeColumn);
                if (string2 == null) continue;
                Hierarchy hierarchy = this.getCube().getHierarchy(cubeColumn);
                String string3 = "STANDARD";
                String string4 = null;
                if (hierarchy != null) {
                    string3 = hierarchy.getName();
                    string4 = hierarchy.getLeafLevel();
                }
                if (string4 == null) continue;
                stringBuffer.append("      <CubeDimensionalityMap\n");
                stringBuffer.append("         Action=\"ADD\"\n");
                stringBuffer.append("         Name=\"" + cubeColumn.getDimension() + "\"\n");
                stringBuffer.append("         Dimensionality=\"" + cubeColumn.getDimension() + "\"\n");
                stringBuffer.append("         Expression=\"" + string2 + "\"\n");
                stringBuffer.append("         MappedDimension=\"" + cubeColumn.getDimension() + "." + string3 + "." + string4 + "\">\n");
                stringBuffer.append("      </CubeDimensionalityMap>\n");
            }
            stringBuffer.append("   </CubeMap>\n");
        }
        stringBuffer.append(this.getEndX());
        return stringBuffer.toString();
    }
}

