/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.hyper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class HyperLinkLabel
extends JLabel {
    private boolean m_blnIsEnabled = true;
    protected JPopupMenu m_editMenu = null;
    private Color m_focusForeColor = UIManager.getColor("ComboBox.selectionForeground");
    private Color m_focusBackColor = UIManager.getColor("ComboBox.selectionBackground");
    private Color m_hyperForeColor = Color.blue;
    private Color m_lblBackColor1 = UIManager.getColor("Panel.background");
    private Color m_lblBackColor2 = UIManager.getColor("ComboBox.background");

    public HyperLinkLabel() {
        this.setOpaque(true);
        this.setBorder(null);
        this.setDoubleBuffered(true);
        this.setEnabled(true);
        this.setRequestFocusEnabled(true);
        this.m_editMenu = new JPopupMenu();
        this.m_editMenu.setDoubleBuffered(true);
        HyperMouseInputListener hyperMouseInputListener = new HyperMouseInputListener();
        this.addMouseListener(hyperMouseInputListener);
        this.addMouseMotionListener(hyperMouseInputListener);
        this.addFocusListener(new HyperFocusListener());
        this.registerKeyboardActions();
    }

    public HyperLinkLabel(String string) {
        this();
        super.setText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.m_blnIsEnabled != bl) {
            this.m_blnIsEnabled = bl;
            this.setRequestFocusEnabled(bl);
            this.resetKeyboardActions();
            if (bl) {
                this.registerKeyboardActions();
            }
            this.repaint();
        }
    }

    public void setContents(Component component) {
        this.m_editMenu.removeAll();
        this.m_editMenu.add(component);
    }

    @Override
    public void paint(Graphics graphics) {
        Color color = this.m_hyperForeColor;
        Color color2 = this.m_lblBackColor1 != null ? this.m_lblBackColor1 : this.m_lblBackColor2;
        Color color3 = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setFont(this.getFont());
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getText();
        if (this.m_blnIsEnabled) {
            if (this.hasFocus() && !this.m_editMenu.isVisible()) {
                color = this.m_focusForeColor;
                color2 = this.m_focusBackColor;
            }
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            int n3 = n / 2 - fontMetrics.stringWidth(string) / 2;
            int n4 = fontMetrics.getAscent();
            graphics.drawString(string, n3, n4);
            graphics.drawLine(n3, n4 + 1, n - n3, n4 + 1);
            graphics.setColor(color3);
            graphics.setFont(font);
        } else {
            super.paint(graphics);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return this.m_blnIsEnabled;
    }

    protected void registerKeyboardActions() {
        this.registerKeyboardAction(new MenuShowAction(), KeyStroke.getKeyStroke(32, 0), 1);
        this.registerKeyboardAction(new MenuShowAction(), KeyStroke.getKeyStroke(40, 8), 1);
        this.registerKeyboardAction(new MenuHideAction(), KeyStroke.getKeyStroke(27, 0), 1);
        this.registerKeyboardAction(new MenuHideAction(), KeyStroke.getKeyStroke(38, 8), 1);
    }

    protected void toggleDisplayEditMenu() {
        if (this.m_editMenu != null) {
            if (this.m_editMenu.isVisible()) {
                this.hideEditMenu();
            } else {
                this.showEditMenu();
            }
        }
    }

    protected void showEditMenu() {
        if (!this.m_editMenu.isVisible()) {
            this.m_editMenu.show(this, 0, this.getBounds().height);
        }
    }

    protected void hideEditMenu() {
        if (this.m_editMenu.isVisible()) {
            this.m_editMenu.setVisible(false);
            this.requestFocusInWindow();
        }
    }

    private class HyperMouseInputListener
    extends MouseInputAdapter {
        private HyperMouseInputListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (HyperLinkLabel.this.m_blnIsEnabled) {
                HyperLinkLabel.this.requestFocusInWindow();
                HyperLinkLabel.this.toggleDisplayEditMenu();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (HyperLinkLabel.this.m_blnIsEnabled) {
                HyperLinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                HyperLinkLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            HyperLinkLabel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class HyperFocusListener
    implements FocusListener {
        private HyperFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            HyperLinkLabel.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            HyperLinkLabel.this.repaint();
        }
    }

    private class MenuShowAction
    extends AbstractAction {
        private MenuShowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HyperLinkLabel.this.showEditMenu();
        }
    }

    private class MenuHideAction
    extends AbstractAction {
        private MenuHideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HyperLinkLabel.this.hideEditMenu();
        }
    }
}

