/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.db;

import java.util.StringTokenizer;

public class OracleSQLDataType {
    private String m_dataType;
    private String m_dataTypeSize;
    private String m_dataTypeScale;

    public OracleSQLDataType(String string) {
        StringTokenizer stringTokenizer;
        string = string.trim();
        if (string.endsWith(")")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((stringTokenizer = new StringTokenizer(string, "(")).hasMoreTokens()) {
            this.setDataType(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            if (stringTokenizer2.countTokens() == 2) {
                this.setDataTypeSize(stringTokenizer2.nextToken());
                this.setDataTypeScale(stringTokenizer2.nextToken());
            } else if (!string2.equals("0")) {
                this.setDataTypeSize(string2);
            }
        }
    }

    public String getSQLDataType() {
        Object object = this.m_dataType;
        if (this.getDataTypeSize() != null && this.getDataTypeScale() == null) {
            object = (String)object + "(" + this.getDataTypeSize() + ")";
        }
        if (this.getDataTypeSize() != null && this.getDataTypeScale() != null) {
            object = (String)object + "(" + this.getDataTypeSize() + "," + this.getDataTypeScale() + ")";
        }
        return object;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public void setDataType(String string) {
        this.m_dataType = string;
        if (string.equals("VARCHAR2") || string.equals("NVARCHAR2")) {
            this.m_dataTypeScale = null;
        }
        if (string.equals("DATE") || string.equals("INTEGER") || string.equals("DECIMAL") || string.equals("DATETIME")) {
            this.m_dataTypeSize = null;
            this.m_dataTypeScale = null;
        }
    }

    public String getDataTypeSize() {
        return this.m_dataTypeSize;
    }

    public long getDataTypeSizeLong() {
        String[] stringArray = this.m_dataTypeSize.split(" ");
        return Long.parseLong(stringArray[0]);
    }

    public void setDataTypeSize(String string) {
        this.m_dataTypeSize = string;
    }

    public String getDataTypeScale() {
        return this.m_dataTypeScale;
    }

    public int getDataTypeScaleInt() {
        return Integer.parseInt(this.m_dataTypeScale.trim());
    }

    public void setDataTypeScale(String string) {
        this.m_dataTypeScale = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_dataType);
        if (!(this.m_dataTypeSize == null || this.m_dataTypeSize.length() <= 0 || this.m_dataType.equals("DATE") || this.m_dataType.equals("INTEGER") || this.m_dataType.equals("DECIMAL") || this.m_dataType.equals("DATETIME"))) {
            stringBuffer.append("(" + this.m_dataTypeSize);
            if (!this.m_dataType.equals("VARCHAR2") && this.m_dataTypeScale != null && this.m_dataTypeScale.length() > 0) {
                stringBuffer.append("," + this.m_dataTypeScale);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean isSizeSmaller(OracleSQLDataType oracleSQLDataType) {
        if (this.getDataType().equals(oracleSQLDataType.getDataType()) && this.getDataTypeSize() != null && oracleSQLDataType.getDataTypeSize() != null) {
            if (this.getDataTypeSizeLong() < oracleSQLDataType.getDataTypeSizeLong()) {
                return true;
            }
            if (this.getDataTypeSizeLong() == oracleSQLDataType.getDataTypeSizeLong() && this.getDataTypeScale() != null && oracleSQLDataType.getDataTypeScale() != null && this.getDataTypeScaleInt() < oracleSQLDataType.getDataTypeScaleInt()) {
                return true;
            }
        }
        return false;
    }
}

