/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.ui.ComponentWithTitlebar;

public class BuildActionReportPanel
extends JPanel {
    private ResultSetTable resultSetTable;
    private String buildQuery;
    private OracleDatabaseImpl db;
    private String objName;
    private String reportTitle;
    private Logger Log = Logger.getLogger(BuildActionReportPanel.class.getName());

    public BuildActionReportPanel(String string, String string2, Database database, String string3) {
        this.objName = string;
        this.buildQuery = string2;
        this.db = (OracleDatabaseImpl)database;
        this.reportTitle = string3;
        this.setLayoutComponents();
        this.showBuildActionReport();
    }

    private void setLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.resultSetTable = new ResultSetTable();
        this.resultSetTable.setSelectionMode(0);
        this.resultSetTable.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this.resultSetTable);
        this.resultSetTable.setFillsViewportHeight(true);
        jScrollPane.setBackground(Color.WHITE);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(this.reportTitle));
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.add((Component)componentWithTitlebar, gridBagConstraints);
    }

    private void showBuildActionReport() {
        try {
            String string = this.db.getQualifiedName();
            this.resultSetTable.setQuery(string, this.buildQuery, null, null);
            this.resultSetTable.refresh();
            this.resultSetTable.allRowsFetched();
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, exception.getMessage());
        }
    }
}

