/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.QueryBase;
import com.adbs.utils.Str;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public final class UnionOperator
extends JLabel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private QueryBase queryBase;
    private String unionOperator;
    private boolean all;

    public UnionOperator(ControlOwner owner) {
        this.setPreferredSize(new Dimension(16, 16));
        this.setSize(16, 16);
        this.unionOperator = "union";
        this.all = false;
        this.queryBase = (QueryBase)owner;
        this.updateContent();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && e.getClickCount() == 1) {
                    UnionOperator.this.queryBase.getQueryBuilder().popupMenuPopup(UnionOperator.this.getPopupMenu(), UnionOperator.this, UnionOperator.this.queryBase, e.getPoint());
                }
                super.mouseClicked(e);
            }
        });
    }

    public String getOperator() {
        return this.unionOperator;
    }

    public void setUnionOperator(String value) {
        if (!this.unionOperator.equals(value)) {
            this.unionOperator = !Str.IsNullOrEmpty(value) ? value : "union";
        }
        this.updateContent();
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean value) {
        if (this.all != value) {
            this.all = value;
            this.updateContent();
        }
    }

    public void updateContent() {
        Icon img;
        String s = this.unionOperator.toLowerCase();
        if (this.all) {
            s = s + " all";
        }
        this.setToolTipText(s);
        if (this.queryBase.getQueryBuilder().getSyntaxProvider() != null) {
            String uo = this.queryBase.astQueryBase.getSimpleUnionOperator(this.queryBase.getSQLContext().getSQLBuilderExpression());
            img = this.queryBase.getQueryBuilder().getSyntaxProvider().getUnionOperatorImage(uo);
        } else {
            img = null;
        }
        this.setIcon(img);
    }

    protected JPopupMenu getPopupMenu() {
        String unionOp = this.queryBase.astQueryBase.getSimpleUnionOperator(this.queryBase.getSQLContext().getSQLBuilderExpression()).toUpperCase();
        ArrayList<String> sl = new ArrayList<String>();
        this.queryBase.getQueryBuilder().getSyntaxProvider().getUnionOperatorList(sl);
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < sl.size(); ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem((String)sl.get(i));
            item.setActionCommand("union operator selected");
            item.addActionListener(this);
            item.setSelected(unionOp.equalsIgnoreCase((String)sl.get(i)));
            menu.add(item);
        }
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("union operator selected")) {
            this.queryBase.setUnionOperatorByMenuItem(e.getSource());
        }
    }
}

