/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstIdentifierList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;

public class StatsObject
implements Disposable {
    private BaseSQLContext sqlContext;
    private MetadataObject metadataObject;
    private SQLQualifiedName name;
    private AstIdentifierList aliases;

    public StatsObject(BaseSQLContext sqlContext, MetadataObject metadataObject, SQLQualifiedName name) {
        assert (name != null);
        this.sqlContext = sqlContext;
        this.metadataObject = metadataObject;
        this.name = name.clone(sqlContext);
        this.aliases = new AstIdentifierList(sqlContext);
    }

    @Override
    public void dispose() {
        this.name.dispose();
        this.aliases.dispose();
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public MetadataObject getMetadataObject() {
        return this.metadataObject;
    }

    public SQLQualifiedName getName() {
        return this.name;
    }

    public AstIdentifierList getAliases() {
        return this.aliases;
    }

    public void assign(Object source) {
        if (source instanceof StatsObject) {
            this.metadataObject = ((StatsObject)source).getMetadataObject();
            this.name.assign(((StatsObject)source).getName());
            this.aliases.assign(((StatsObject)source).getAliases());
        }
    }
}

