/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNamesComparator;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SQLQualifiedNameList
implements Disposable {
    private ArrayList<SQLQualifiedName> items = new ArrayList();
    protected BaseSQLContext sqlContext;

    public SQLQualifiedNameList(BaseSQLContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    @Override
    public void dispose() {
        this.clear();
    }

    public SQLQualifiedName get(int index) {
        return this.items.get(index);
    }

    public void set(int index, SQLQualifiedName value) {
        this.items.set(index, value);
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public void assign(SQLQualifiedNameList source) {
        this.clear();
        for (int i = 0; i < source.getCount(); ++i) {
            this.add(source.get(i).clone(this.sqlContext));
        }
    }

    public void clear() {
        for (SQLQualifiedName qn : this.items) {
            qn.dispose();
        }
        this.items.clear();
    }

    public int add(SQLQualifiedName obj) {
        assert (obj.getSQLContext() == this.sqlContext);
        this.items.add(obj);
        return this.items.size() - 1;
    }

    public SQLQualifiedName extract(SQLQualifiedName item) {
        int x = this.indexOf(item);
        if (x != -1) {
            this.items.remove(x);
        }
        return item;
    }

    public int remove(SQLQualifiedName obj) {
        int x = this.items.indexOf(obj);
        if (x != -1) {
            this.remove(obj);
        }
        obj.dispose();
        return x;
    }

    public void remove(int index) {
        SQLQualifiedName obj = this.items.remove(index);
        obj.dispose();
    }

    public void insert(int index, SQLQualifiedName obj) {
        this.items.add(index, obj);
    }

    public SQLQualifiedName first() {
        if (this.items.size() > 0) {
            return this.items.get(0);
        }
        return null;
    }

    public SQLQualifiedName last() {
        if (this.items.size() > 0) {
            return this.items.get(this.items.size() - 1);
        }
        return null;
    }

    public int findByName(SQLQualifiedName obj) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.sqlContext.compareQualifiedNames(obj, this.get(i)) != 0) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findByName(String name) {
        SQLQualifiedName qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
        try {
            int n = this.findByName(qn);
            return n;
        }
        finally {
            qn.dispose();
        }
    }

    public void sortByNames() {
        assert (this.sqlContext.getSyntaxProvider() != null);
        this.sortItems(new SQLQualifiedNamesComparator());
    }

    protected void sortItems(Comparator<SQLQualifiedName> comparator) {
        Collections.sort(this.items, comparator);
    }

    public int add(String name) throws QueryBuilderException {
        assert (this.sqlContext.getSyntaxProvider() != null);
        SQLDatabaseObject qn = null;
        try {
            qn = this.sqlContext.parseObjectNameQuoteIfNeed(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (qn == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
        }
        return this.add(qn);
    }

    public int addIdentifier(String name, boolean caseSensitive) {
        SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
        int result = this.add(qn);
        qn.addName(name, caseSensitive);
        return result;
    }

    public int addIdentifier(String name) {
        return this.addIdentifier(name, false);
    }

    public int addBuiltin(String name) {
        SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
        int result = this.add(qn);
        qn.addBuiltin(name);
        return result;
    }

    public void move(int oldIndex, int newIndex) {
        Helpers.listMove(this.items, oldIndex, newIndex);
    }

    public String getXML(String rootElement, String itemsName) {
        String result = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.newDocument();
            doc.appendChild(this.getXMLNode(doc, rootElement, itemsName));
            DOMSource src = new DOMSource(doc.getDocumentElement());
            StringWriter sw = new StringWriter();
            TransformerFactory tranFact = TransformerFactory.newInstance();
            Transformer transformer = tranFact.newTransformer();
            StreamResult dest = new StreamResult(sw);
            transformer.transform(src, dest);
            return sw.toString();
        }
        catch (Exception exception) {
            return result;
        }
    }

    public void setXML(String itemsName, String xml) throws QueryBuilderException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            StringReader sr = new StringReader(xml);
            Document doc = parser.parse(new InputSource(sr));
            if (doc.getDocumentElement() != null) {
                this.loadFromXMLNode(doc.getDocumentElement(), itemsName);
            }
        }
        catch (Exception e) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorBadXML", "Error parsing XML:\n%1$s"), e.getMessage()), e);
        }
    }

    protected Element getXMLNode(Document doc, String nodeName, String itemsName) {
        Element result = doc.createElement(nodeName);
        for (int i = 0; i < this.getCount(); ++i) {
            result.appendChild(this.get(i).getXMLNode(doc, itemsName, "item"));
        }
        return result;
    }

    protected void loadFromXMLNode(Node node, String itemsName) {
        this.clear();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child == null || !child.getNodeName().equals(itemsName)) continue;
            SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
            qn.loadFromXMLNode(child, "item");
            this.add(qn);
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public int indexOf(SQLQualifiedName obj) {
        return this.items.indexOf(obj);
    }
}

