/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderItemListFormat;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLOrderByItem;

public class SQLOrderByClause
extends AstNodeWithList {
    public boolean siblings;

    public SQLOrderByClause(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public SQLOrderByItem get(int index) {
        return (SQLOrderByItem)super.get(index);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLOrderByClause) {
            this.siblings = ((SQLOrderByClause)source).siblings;
        }
    }

    public void set(int index, SQLOrderByItem value) {
        super.set(index, value);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildOrderByList(builder, format, null);
    }

    public void buildOrderByKeywords(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Order");
        if (this.siblings) {
            builder.space();
            builder.writeKeyword("Siblings");
        }
        builder.space();
        builder.writeKeyword("By");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildOrderByList(SQLBuilder builder, SQLBuilderSelectFormat format, SQLBuilderItemListFormat listFormat) {
        AstNodeWithList separator = new AstNodeWithList(this.sqlContext);
        try {
            if (listFormat != null && listFormat.getNewLineBeforeComma()) {
                separator.newLine();
            }
            separator.addSymbol(",");
            if (listFormat != null && listFormat.getNewLineAfterItem()) {
                separator.addNewLine();
            } else {
                separator.addSpace();
            }
            this.buildList(builder, format, separator);
        }
        finally {
            separator.dispose();
        }
    }
}

