/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ideimpl.palette2.DeclaredExtension;
import oracle.ideimpl.palette2.DeclaredGroup;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class DeclaredPage
extends HashStructureAdapter
implements DeclaredExtension {
    private DeclaredPage(HashStructure hash) {
        super(hash);
    }

    public static DeclaredPage getInstance(HashStructure hash) {
        return new DeclaredPage(hash);
    }

    public String getName() {
        return this._hash.getString("name/#text");
    }

    public String getDescription() {
        return this._hash.getString("description/#text");
    }

    public String getIcon() {
        return this._hash.getString("icon/#text");
    }

    public String getPageId() {
        return this._hash.getString("pageId/#text");
    }

    public String getPageEditor() {
        return this._hash.getString("pageEditor/#text");
    }

    public String getProjectConfiguration() {
        return this._hash.getString("projectConfiguration/#text");
    }

    public List<DefaultPalettePage.ShowForTypeRecord> getShowForTypes() {
        List data = this._hash.getAsList("showForTypes");
        if (data == null) {
            return null;
        }
        ArrayList<DefaultPalettePage.ShowForTypeRecord> types = new ArrayList<DefaultPalettePage.ShowForTypeRecord>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("type");
            for (HashStructure h2 : data2) {
                String type = h2.getString("#text");
                boolean preferred = h2.getBoolean("asPreferredPage");
                types.add(new DefaultPalettePage.ShowForTypeRecord(type, preferred));
            }
        }
        return Collections.unmodifiableList(types);
    }

    public List<String> getTechnologyScopes() {
        List data = this._hash.getAsList("technologyScopes");
        if (data == null) {
            return null;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("technologyScope");
            for (HashStructure h2 : data2) {
                scopes.add(h2.getString("#text"));
            }
        }
        return Collections.unmodifiableList(scopes);
    }

    public String getType() {
        return this._hash.getString("type/#text");
    }

    public String getPageContext() {
        return this._hash.getString("pageContextClassName/#text");
    }

    public Collection<DeclaredGroup> getGroups() {
        List data = this._hash.getAsList("group");
        if (data != null) {
            ArrayList<DeclaredGroup> groups = new ArrayList<DeclaredGroup>(data.size());
            for (HashStructure h : data) {
                groups.add(DeclaredGroup.getInstance(h));
            }
            return Collections.unmodifiableList(groups);
        }
        return null;
    }

    public String toString() {
        Object temp = String.format("DeclaredPage[ name=%s, description=%s, pageId=%s, ShowForTypes=%s, TechnologyScope=%s, Type=%s, PageContext=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getDescription()), String.valueOf(this.getPageId()), String.valueOf(this.getShowForTypes()), String.valueOf(this.getTechnologyScopes()), String.valueOf(this.getType()), String.valueOf(this.getPageContext()));
        Collection<DeclaredGroup> groups = this.getGroups();
        for (DeclaredGroup x : groups) {
            temp = (String)temp + x.toString();
        }
        return temp;
    }

    @Override
    public String getExtensionId() {
        return this._hash.getString("pageId/#__extension-id");
    }

    public static class PageBuilder
    extends DefaultPalettePage.Builder {
        public PageBuilder(DeclaredPage page) {
            super(page.getName(), page.getDescription());
            this.iconUrl(page.getIcon());
            this.pageId(page.getPageId());
            this.pageEditor(page.getPageEditor());
            this.projectConfiguration(page.getProjectConfiguration());
            this.showForTypes(page.getShowForTypes());
            this.technologyScopes(page.getTechnologyScopes());
            this.type(page.getType());
            this.pageContext(page.getPageContext());
            this.extensionId(page.getExtensionId());
        }
    }
}

