/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.docking.DockableView;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.InspectorPage;
import oracle.ide.inspector.InspectorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.ideimpl.inspector.InspectorGroup;
import oracle.javatools.icons.OracleIcons;

@Deprecated
public class PropertyInspector
extends oracle.bali.inspector.PropertyInspector
implements InspectorPage {
    public static final String PROPERTY_READ_ONLY = "readOnlyIncluded";
    public static final String PROPERTY_WRITE_ONLY = "writeOnlyIncluded";
    public static final String PROPERTY_TOOLBAR = "actionComponentVisible";
    public static final String PROPERTY_STATUS = "statusVisible";
    private static final HashMap ICONS = new HashMap(10);
    protected InternalAction readOnlyAction;
    protected InternalAction writeOnlyAction;
    protected InternalAction statusAction;
    protected InternalAction helpAction;
    protected InspectorWindow owner;
    protected JPopupMenu contextMenu;
    protected JMenuItem readOnlyItem;
    protected JMenuItem writeOnlyItem;
    protected JMenuItem statusItem;
    protected JSeparator helpSeparator;
    protected JMenuItem helpItem;

    private boolean updateBackground(Component comp) {
        Component[] children;
        if (comp instanceof JViewport) {
            comp.setBackground(IdeUIManager.getSelectedFocusedTabColor());
            return true;
        }
        Component[] componentArray = children = comp instanceof Container ? ((Container)comp).getComponents() : null;
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!this.updateBackground(children[i])) continue;
                return true;
            }
        }
        return false;
    }

    public PropertyInspector() {
        super((oracle.bali.inspector.InspectorGroup)new InspectorGroup());
        this.setColumnFilter(PropertyModel.COLUMN_IS_HIDDEN, Boolean.TRUE, Boolean.FALSE);
        this.setActionComponent(null);
        ((BorderLayout)this.getLayout()).setVgap(0);
        super.setStatusVisible(false);
        super.setFindVisible(false);
        this.updateBackground((Component)((Object)this));
        this.updateBorders();
        this.setCategorized(true);
        this.setIntersection(true);
        this.setReadOnlyIncluded(false);
        this.setWriteOnlyIncluded(false);
        this.setAlphabetizeGroupProperties(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (PropertyInspector.this.readOnlyAction == null) {
                    return;
                }
                String propName = e.getPropertyName();
                if (PropertyInspector.PROPERTY_READ_ONLY.equals(propName)) {
                    PropertyInspector.this.readOnlyAction.setState(PropertyInspector.this.isReadOnlyIncluded());
                } else if (PropertyInspector.PROPERTY_WRITE_ONLY.equals(propName)) {
                    PropertyInspector.this.writeOnlyAction.setState(PropertyInspector.this.isWriteOnlyIncluded());
                } else if (PropertyInspector.PROPERTY_STATUS.equals(propName)) {
                    PropertyInspector.this.statusAction.setState(PropertyInspector.this.isStatusVisible());
                }
            }
        });
        this.setColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME, new NameRenderer(this));
        this.setHelpAction(-1, null);
    }

    public void setUnderlyingPropertyModel(PropertyModel newModel) {
        final PropertyModel oldModel = this.getUnderlyingPropertyModel();
        super.setUnderlyingPropertyModel(newModel);
        if (oldModel != null && oldModel != this.getUnderlyingPropertyModel()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oldModel.dispose();
                }
            });
        }
    }

    public void setStatusVisible(boolean displayStatus) {
        if (this.owner != null) {
            this.owner.setStatusVisible(displayStatus);
        }
    }

    public boolean isStatusVisible() {
        return this.owner != null ? this.owner.isStatusVisible() : false;
    }

    public void setStatusText(String text) {
        if (this.owner != null) {
            this.owner.setStatus(text);
        }
    }

    protected synchronized JPopupMenu getMenuForRow(int row, PropertyModel model, Object col) {
        HelpInfo helpInfo;
        if (this.contextMenu == null) {
            if (this.readOnlyAction == null) {
                this.initActions();
            }
            this.readOnlyItem = new ToggleMenuItem((ToggleAction)this.readOnlyAction);
            this.writeOnlyItem = new ToggleMenuItem((ToggleAction)this.writeOnlyAction);
            this.statusItem = new ToggleMenuItem((ToggleAction)this.statusAction);
            this.helpItem = Ide.getMenubar().createMenuItem((ToggleAction)this.helpAction);
            this.contextMenu = new JPopupMenu();
            this.contextMenu.add(this.readOnlyItem);
            this.contextMenu.add(this.writeOnlyItem);
            this.contextMenu.add(new JSeparator());
            this.contextMenu.add(this.statusItem);
        }
        if ((helpInfo = this.setHelpAction(row, model)) != null) {
            if (this.helpItem.getParent() == null) {
                this.contextMenu.add(this.helpSeparator);
                this.contextMenu.add(this.helpItem);
            }
        } else if (this.helpItem.getParent() != null) {
            this.contextMenu.remove(this.helpSeparator);
            this.contextMenu.remove(this.helpItem);
        }
        this.statusAction.setState(this.owner != null ? this.owner.isStatusVisible() : false);
        return this.contextMenu;
    }

    protected Icon getIcon(String imageName) {
        Icon icon = (Icon)ICONS.get(imageName);
        if (icon == null) {
            icon = "categorized".equals(imageName) ? InspectorArb.getIcon(16) : ("find".equals(imageName) ? IdeArb.getIcon((int)111) : ("union".equals(imageName) ? InspectorArb.getIcon(15) : super.getIcon(imageName)));
            ICONS.put(imageName, icon);
        }
        return icon;
    }

    public String getShortLabel() {
        return InspectorArb.getString(21);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return InspectorArb.getIcon(27);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    @Override
    public void stateChanged(int state) {
        if (state == 2) {
            this.setUnderlyingPropertyModel(null);
            if (this.readOnlyAction != null) {
                this.readOnlyAction = null;
                this.writeOnlyAction = null;
                this.statusAction = null;
                this.helpAction = null;
            }
        } else {
            this.toolbarStateChanged(state);
        }
    }

    @Override
    public void toolbarStateChanged(int state) {
    }

    @Override
    public void setOwner(InspectorWindow owner) {
        this.owner = owner;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getPropertyTable();
    }

    protected void initActions() {
        this.readOnlyAction = new InternalAction(InspectorArb.getString(6), InspectorArb.getInteger(7), null, this.isReadOnlyIncluded());
        this.writeOnlyAction = new InternalAction(InspectorArb.getString(8), InspectorArb.getInteger(9), null, this.isWriteOnlyIncluded());
        this.statusAction = new InternalAction(InspectorArb.getString(13), InspectorArb.getInteger(14), null, this.isStatusVisible());
        this.helpSeparator = new JSeparator();
    }

    private void updateBorders() {
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (!(child instanceof JComponent)) continue;
            ((JComponent)child).setBorder(BorderFactory.createEmptyBorder());
            if (!(child instanceof JSplitPane)) continue;
            Component grandChild = ((JSplitPane)child).getTopComponent();
            if (grandChild instanceof JComponent) {
                ((JComponent)grandChild).setBorder(BorderFactory.createEmptyBorder());
            }
            if (!((grandChild = ((JSplitPane)child).getBottomComponent()) instanceof JComponent)) continue;
            ((JComponent)grandChild).setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private HelpInfo setHelpAction(int row, PropertyModel model) {
        int column;
        if (this.helpAction == null) {
            this.helpAction = new InternalAction(InspectorArb.getString(17), InspectorArb.getInteger(18), OracleIcons.getIcon((String)"help.png"), false);
            this.helpAction.putValue("Check", Boolean.FALSE);
            this.initActions();
        }
        HelpInfo helpInfo = null;
        int n = column = model != null ? model.getColumnIndex(IdePropertyModel.COLUMN_HELP) : -1;
        if (column != -1 && row >= 0) {
            Object value = model.getValueAt(row, column);
            if (value instanceof HelpInfo) {
                helpInfo = (HelpInfo)value;
            } else if (value instanceof Helpable) {
                helpInfo = ((Helpable)value).getHelpInfo();
            } else if (value instanceof String) {
                helpInfo = new HelpInfo((String)value);
            }
        }
        if (helpInfo != null) {
            DockableView last = InspectorManager.getInspectorManager().getLastView();
            helpInfo.setContext(last != null ? last.getContext() : null);
        }
        this.helpAction.setEnabled(helpInfo != null);
        this.helpAction.putValue("UserData", helpInfo);
        return helpInfo;
    }

    protected void updateRowActions(int row, PropertyModel model) {
        super.updateRowActions(row, model);
        this.setHelpAction(row, model);
    }

    static final class NameRenderer
    extends DefaultTableCellRenderer {
        private PropertyInspector pi;

        public NameRenderer(PropertyInspector pi) {
            this.pi = pi;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object val;
            PropertyModel model = this.pi != null ? this.pi.getPropertyModel() : null;
            int iconCol = model != null ? model.getColumnIndex(PropertyModel.COLUMN_ICON) : -1;
            Icon icon = null;
            if (iconCol != -1 && (val = model.getValueAt(row, iconCol)) instanceof Icon) {
                icon = (Icon)val;
            }
            this.setIcon(icon);
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JComponent)comp).setBorder(null);
            return comp;
        }
    }

    class InternalAction
    extends ToggleAction {
        InternalAction(String name, Integer mnemonic, Icon icon, boolean initialState) {
            super(name, icon);
            this.putValue("Check", Boolean.TRUE);
            this.putValue("State", initialState ? Boolean.TRUE : Boolean.FALSE);
            this.putValue("MnemonicKey", mnemonic);
            this.putValue("ActionCommandKey", name);
        }

        public void actionPerformed(ActionEvent e) {
            HelpInfo helpInfo;
            String cmd = e.getActionCommand();
            if (PropertyInspector.this.helpAction.getValue("Name").equals(cmd) && (helpInfo = (HelpInfo)this.getValue("UserData")) != null) {
                HelpSystem.getHelpSystem().showHelp(helpInfo);
            }
            if (PropertyInspector.this.readOnlyAction.getValue("Name").equals(cmd)) {
                PropertyInspector.this.setReadOnlyIncluded(!PropertyInspector.this.isReadOnlyIncluded());
            } else if (PropertyInspector.this.writeOnlyAction.getValue("Name").equals(cmd)) {
                PropertyInspector.this.setWriteOnlyIncluded(!PropertyInspector.this.isWriteOnlyIncluded());
            } else if (PropertyInspector.this.statusAction.getValue("Name").equals(cmd)) {
                PropertyInspector.this.setStatusVisible(!PropertyInspector.this.isStatusVisible());
            }
        }
    }
}

