/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.GridBagConstraints;
import java.util.LinkedList;
import javax.swing.JComponent;

final class RenderInfo {
    private final LinkedList<History> historyQueue = new LinkedList();
    private History current = new History();

    RenderInfo(GridBagConstraints constraints, JComponent parent) {
        this.current.constraints = constraints;
        this.current.parent = parent;
    }

    void update(JComponent parent, GridBagConstraints c) {
        this.addCopyOfCurrentToHistory();
        this.current.parent = parent;
        this.current.constraints = c;
    }

    void update(GridBagConstraints c) {
        this.addCopyOfCurrentToHistory();
        this.current.constraints = c;
    }

    void update(JComponent parent) {
        this.addCopyOfCurrentToHistory();
        this.current.parent = parent;
    }

    private void addCopyOfCurrentToHistory() {
        this.historyQueue.addLast(this.current.copy());
    }

    void restore() {
        this.current = this.historyQueue.removeLast();
    }

    GridBagConstraints copyConstraints() {
        if (this.current.constraints == null) {
            return null;
        }
        return (GridBagConstraints)this.current.constraints.clone();
    }

    JComponent parent() {
        return this.current.parent;
    }

    GridBagConstraints constraints() {
        return this.current.constraints;
    }

    private class History {
        JComponent parent;
        GridBagConstraints constraints;

        private History() {
        }

        private History copy() {
            History destination = new History();
            destination.parent = this.parent;
            destination.constraints = this.constraints;
            return destination;
        }
    }
}

