/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.awt.Font;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class TextStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 2449144528089711618L;
    public static final float MIN_HALO_SIZE = 1.5f;
    private static Font defaultFont = new Font("Serif", 0, 18);
    Font font = defaultFont;
    SizeDefinition2D fontSize = new SizeDefinition2D(12.0, -1.0, null);
    String embeddedTTFont = null;
    Color color = Color.black;
    Color background = null;
    Color haloColor = Color.white;
    SizeDefinition haloWidth = new SizeDefinition(-1.0, null);
    LabelingHints labelingHints = new LabelingHints(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER);
    boolean sticky = false;
    boolean honorNewline = false;
    boolean autoTextWrap = false;
    int wrappingWidth = 400;
    float letterSpacing = 0.0f;
    boolean smartPathFollowing = false;
    public static String TEXT_DECORATION_NONE = "NONE";
    public static String TEXT_DECORATION_UNDERLINE = "UNDERLINE";
    public static String TEXT_DECORATION_LINETHROUGH = "LINETHROUGH";
    public static String TEXT_DECORATION_OVERLINE = "OVERLINE";
    String textDecoration = TEXT_DECORATION_NONE;
    float multilineSpacing = 0.0f;
    float wordSpacing = 0.0f;
    Color strokeColor = null;
    boolean straightLineLabeling = false;
    boolean applyOHintTosimplepoints = false;

    public TextStyleModel() {
        this.type = 5;
        this.labelingHints.put(LabelingHints.KEY_OPOINT_HALIGN, LabelingHints.VALUE_OPOINT_HALIGN_CENTER);
        this.labelingHints.put(LabelingHints.KEY_LINE_VALIGN, LabelingHints.VALUE_LINE_VALIGN_BASELINE);
    }

    @Override
    public Object clone() {
        TextStyleModel textStyleModel = (TextStyleModel)super.clone();
        textStyleModel.setFontSizes(this.fontSize);
        textStyleModel.setHaloWidth(this.haloWidth);
        return textStyleModel;
    }

    @Override
    public String getTypeName() {
        return "TEXT";
    }

    public void setFont(Font font) {
        this.font = font == null ? defaultFont : font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setHalo(float f, Color color) {
        this.setHaloWidth(f);
        this.setHaloColor(color);
    }

    public void setHaloColor(Color color) {
        this.haloColor = color;
    }

    public Color getHaloColor() {
        return this.haloColor;
    }

    public SizeDefinition getHaloSize() {
        return this.haloWidth;
    }

    public void setHaloWidth(SizeDefinition sizeDefinition) {
        this.haloWidth = new SizeDefinition(-1.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.haloWidth.setValue(sizeDefinition.getValue());
        this.haloWidth.setUnit(sizeDefinition.getUnit());
    }

    public void setHaloWidth(float f) {
        this.haloWidth.setValue(f);
    }

    public float getHaloWidth() {
        return (float)this.haloWidth.getValue();
    }

    public void setHaloWidthUnit(String string) {
        this.haloWidth.setUnit(string);
    }

    public String getHaloWidthUnit() {
        return this.haloWidth.getUnit();
    }

    public float getFontSizeValue() {
        return (float)this.fontSize.getWidth();
    }

    public void setFontSizeValue(float f) {
        this.fontSize.setWidth(f);
    }

    public void setFontSizes(SizeDefinition2D sizeDefinition2D) {
        this.fontSize = new SizeDefinition2D(12.0, -1.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.fontSize.setWidth(sizeDefinition2D.getWidth());
        this.fontSize.setHeight(sizeDefinition2D.getHeight());
        this.fontSize.setUnit(sizeDefinition2D.getUnit());
    }

    public void setFontSize(float f, String string) {
        this.fontSize.setWidth(f);
        this.fontSize.setUnit(string);
    }

    public SizeDefinition2D getFontSizes() {
        return this.fontSize;
    }

    public void setFontSizeUnit(String string) {
        this.fontSize.setUnit(string);
    }

    public String getFontSizeUnit() {
        return this.fontSize.getUnit();
    }

    public float getMinFontSize() {
        return (float)this.fontSize.getHeight();
    }

    public void setMinFontSize(float f) {
        this.fontSize.setHeight(f);
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public static float getMinimumHaloSize() {
        return 1.5f;
    }

    public boolean haloEnabled() {
        if (this.haloWidth.isPixelUnit()) {
            return this.haloWidth.getValue() >= 1.5;
        }
        return this.haloWidth.getValue() > 0.0;
    }

    @Override
    public String toXMLString() {
        Font font = null;
        font = this.font == null ? defaultFont : this.font;
        int n = font.getStyle();
        String string = "plain";
        if (font.isItalic()) {
            string = "italic";
        }
        String string2 = null;
        String string3 = "";
        if (this.embeddedTTFont == null) {
            string2 = this.font.getFamily();
        } else {
            string2 = this.embeddedTTFont;
            string3 = " embedded-ttf=\"true\" ";
        }
        float f = this.getFontSizeValue();
        String string4 = String.valueOf(f);
        if (this.fontSize.isPixelUnit()) {
            string4 = String.valueOf((int)f);
        }
        String string5 = "";
        if (this.getMinFontSize() > 0.0f) {
            float f2 = this.getMinFontSize();
            string5 = ";min-font-size:" + String.valueOf(f2);
            if (this.fontSize.isPixelUnit()) {
                string5 = ";min-font-size:" + String.valueOf((int)f2);
            }
        }
        String string6 = "";
        if (this.fontSize.getUnit() != null && !this.fontSize.getUnit().equalsIgnoreCase("px")) {
            string6 = this.fontSize.getUnit();
            if (this.getMinFontSize() > 0.0f) {
                string5 = string5 + this.fontSize.getUnit();
            }
        }
        String string7 = "";
        if (font.isBold()) {
            string7 = "font-weight:bold;";
        }
        String string8 = "";
        String string9 = "";
        if (this.haloWidth.getUnit() != null && !this.haloWidth.getUnit().equalsIgnoreCase("px")) {
            string9 = this.haloWidth.getUnit();
        }
        String string10 = StyleUtils.getUSLocaleFormat(this.haloWidth.getValue());
        String string11 = StyleUtils.cleanDecimalZeros(string10, 1);
        if (this.haloWidth.isPixelUnit()) {
            string11 = StyleUtils.cleanDecimalZeros(string10, 0);
        }
        if (this.haloColor != null && (this.haloWidth.getValue() > 0.0 && !this.haloWidth.isPixelUnit() || this.haloWidth.getValue() >= 1.0 && this.haloWidth.isPixelUnit())) {
            string8 = " float-width=\"" + string11 + string9 + "\"";
            if (this.haloColor != Color.white) {
                string8 = string8 + " float-color=\"" + StyleUtils.getHexidecimalString(this.haloColor) + "\"";
                if (this.haloColor.getAlpha() != 255) {
                    string8 = string8 + " float-color-opacity=\"" + this.haloColor.getAlpha() + "\"";
                }
            }
        }
        String string12 = "";
        if (this.letterSpacing > 0.0f) {
            string12 = " letter-spacing=\"" + this.letterSpacing + "\"";
        }
        String string13 = this.sticky ? " sticky=\"true\" " : "";
        String string14 = this.autoTextWrap ? "\n        auto-wrap=\"true\" wrapping-width=\"" + this.wrappingWidth + "\" " : "";
        String string15 = this.honorNewline ? " honor-newline=\"true\" " : "";
        String string16 = this.multilineSpacing > 0.0f ? " multiline-spacing=\"" + this.multilineSpacing + "\"" : "";
        Object object = this.labelingHints.get(LabelingHints.KEY_MULTILINE_TEXT_ALIGN);
        String string17 = "text-align:" + (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER == object ? "center" : (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT == object ? "right" : "left")) + ";";
        String string18 = "";
        if (!this.textDecoration.equalsIgnoreCase(TEXT_DECORATION_NONE)) {
            string18 = "text-decoration:" + this.textDecoration.toLowerCase() + ";";
        }
        String string19 = "";
        if (this.color.getAlpha() != 255) {
            string19 = ";fill-opacity:" + this.color.getAlpha();
        }
        String string20 = "";
        String string21 = "";
        String string22 = "";
        if (this.background != null) {
            string21 = "background:" + StyleUtils.getHexidecimalString(this.background);
            if (this.background.getAlpha() != 255) {
                string22 = ";background-opacity: " + this.background.getAlpha();
            }
            string20 = "font-style:" + string + ";font-family:" + string2 + ";font-size:" + string4 + string6 + string5 + ";" + string7 + string17 + string18 + "fill:" + StyleUtils.getHexidecimalString(this.color) + string19 + ";" + string21 + string22 + "\"> Hello World!\n";
        } else {
            string20 = "font-style:" + string + ";font-family:" + string2 + ";font-size:" + string4 + string6 + string5 + ";" + string7 + string17 + string18 + "fill:" + StyleUtils.getHexidecimalString(this.color) + string19 + "\"> Hello World!\n";
        }
        String string23 = "<?xml version=\"1.0\" standalone=\"yes\"?>\n  <svg width=\"1in\" height=\"1in\" >\n  <desc></desc>\n";
        string23 = this.haloWidth.getValue() > 0.0 ? string23 + "    <g class=\"text\"" + string3 + string8 + string13 + string14 + string15 + string12 + string16 + " \n        style=\"" + string20 : string23 + "    <g class=\"text\"" + string3 + string13 + string14 + string15 + string12 + " \n        style=\"" + string20;
        string23 = string23 + this.getOrientedPointHintsXml();
        string23 = string23 + this.getPathTextHintsXml();
        string23 = string23 + "    </g>\n  </svg>\n";
        return string23;
    }

    private String getOrientedPointHintsXml() {
        String string;
        Object object = this.labelingHints.get(LabelingHints.KEY_OPOINT_HALIGN);
        Object object2 = this.labelingHints.get(LabelingHints.KEY_OPOINT_VALIGN);
        if (object == null && object2 == null) {
            return "";
        }
        if (object == null) {
            object = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
        }
        if (object2 == null) {
            object2 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        }
        String string2 = object == LabelingHints.VALUE_OPOINT_HALIGN_CENTER ? "center" : (string = object == LabelingHints.VALUE_OPOINT_HALIGN_START ? "start" : "end");
        String string3 = object2 == LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE ? "middle" : (object2 == LabelingHints.VALUE_OPOINT_VALIGN_TOP ? "top" : (object2 == LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM ? "bottom" : "baseline"));
        String string4 = "";
        if (this.applyOHintTosimplepoints) {
            string4 = " apply-to-simple-points=\"true\"";
        }
        String string5 = "        <opoint halign=\"" + string + "\" valign=\"" + string3 + "\"" + string4 + "/>\n";
        return string5;
    }

    private String getPathTextHintsXml() {
        String string = "";
        Object object = this.labelingHints.get(LabelingHints.KEY_LINE_VALIGN);
        if (object != null) {
            string = " valign=\"" + (object == LabelingHints.VALUE_LINE_VALIGN_MIDDLE ? "middle" : (object == LabelingHints.VALUE_LINE_VALIGN_TOP ? "top" : (object == LabelingHints.VALUE_LINE_VALIGN_BOTTOM ? "bottom" : "baseline"))) + "\"";
        }
        String string2 = "";
        Object object2 = this.labelingHints.get(LabelingHints.KEY_LINE_HALIGN);
        if (object2 != null) {
            string2 = " halign=\"" + (object2 == LabelingHints.VALUE_LINE_HALIGN_START ? "start" : (object2 == LabelingHints.VALUE_LINE_HALIGN_END ? "end" : "center")) + "\"";
        }
        String string3 = this.smartPathFollowing ? " smart-path-following=\"true\"" : "";
        String string4 = this.straightLineLabeling ? " straight-line-labeling=\"true\"" : "";
        String string5 = "        <text-along-path" + string2 + string + string3 + string4 + "/>\n";
        return string5;
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public void setHonorNewline(boolean bl) {
        this.honorNewline = bl;
    }

    public boolean isHonorNewline() {
        return this.honorNewline;
    }

    public void setAutoTextWrap(boolean bl) {
        this.autoTextWrap = bl;
    }

    public boolean isAutoTextWrap() {
        return this.autoTextWrap;
    }

    public void setWrappingWidth(int n) {
        this.wrappingWidth = n;
    }

    public int getWrappingWidth() {
        return this.wrappingWidth;
    }

    public void setLabelingHints(LabelingHints labelingHints) {
        this.labelingHints = labelingHints;
    }

    public LabelingHints getLabelingHints() {
        return this.labelingHints;
    }

    public Object getLabelingHint(LabelingHints.Key key) {
        return this.labelingHints.get(key);
    }

    public void setLabelingHint(LabelingHints.Key key, Object object) {
        this.labelingHints.put(key, object);
    }

    public void setLetterSpacing(float f) {
        this.letterSpacing = f;
    }

    public float getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setSmartPathFollowing(boolean bl) {
        this.smartPathFollowing = bl;
    }

    public boolean isSmartPathFollowing() {
        return this.smartPathFollowing;
    }

    public String getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(String string) {
        this.textDecoration = string == null || !string.equalsIgnoreCase(TEXT_DECORATION_UNDERLINE) && !string.equalsIgnoreCase(TEXT_DECORATION_LINETHROUGH) && !string.equalsIgnoreCase(TEXT_DECORATION_OVERLINE) ? TEXT_DECORATION_NONE : string.toUpperCase();
    }

    public float getMultilineSpacing() {
        return this.multilineSpacing;
    }

    public void setMultilineSpacing(float f) {
        this.multilineSpacing = f < 0.0f ? 0.0f : f;
    }

    public void setStraightLineLabeling(boolean bl) {
        this.straightLineLabeling = bl;
    }

    public boolean isStraightLineLabeling() {
        return this.straightLineLabeling;
    }

    public void setEmbeddedTTFont(String string) {
        this.embeddedTTFont = string != null && string.trim().length() == 0 ? null : string;
    }

    public String getEmbeddedTTFont() {
        return this.embeddedTTFont;
    }

    public Font deriveFont(float f) {
        if (f < 1.0f) {
            return this.getFont();
        }
        return this.getFont().deriveFont(f);
    }

    @Override
    public String[] getStyleDependency() {
        String[] stringArray = null;
        if (this.embeddedTTFont != null) {
            stringArray = new String[]{this.embeddedTTFont};
        }
        return stringArray;
    }

    public boolean getApplyOPointsHintsToSimplePoints() {
        return this.applyOHintTosimplepoints;
    }

    public void setApplyOPointsHintsToSimplePoints(boolean bl) {
        this.applyOHintTosimplepoints = bl;
    }
}

