/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapclient.taglib;

import java.awt.Color;
import java.awt.Dimension;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.lbs.mapclient.MapViewer;
import oracle.lbs.mapclient.taglib.MapViewerTagUtil;

public class MapViewerSetParamTag
extends BodyTagSupport {
    String basemap = null;
    String bgcolor = null;
    String bgimage = null;
    String width = null;
    String height = null;
    String title = null;
    String antialiasing = null;
    String centerX = null;
    String centerY = null;
    String size = null;
    String imagescaling = null;

    public void setBasemap(String string) {
        this.basemap = string;
    }

    public void setBgcolor(String string) {
        this.bgcolor = string;
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    public void setBgimage(String string) {
        this.bgimage = string;
    }

    public String getBgimage() {
        return this.bgimage;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getWidth() {
        return this.width;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public String getHeight() {
        return this.height;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAntialiasing(String string) {
        this.antialiasing = string;
    }

    public String getAntialiasing() {
        return this.antialiasing;
    }

    public void setImagescaling(String string) {
        this.imagescaling = string;
    }

    public String getImagescaling() {
        return this.imagescaling;
    }

    public void setCenterX(String string) {
        this.centerX = string;
    }

    public String getCenterX() {
        return this.centerX;
    }

    public void setCenterY(String string) {
        this.centerY = string;
    }

    public String getCenterY() {
        return this.centerY;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public String getSize() {
        return this.size;
    }

    public int doStartTag() throws JspException {
        Color color;
        MapViewer mapViewer = MapViewerTagUtil.getAHandle(this.pageContext);
        if (this.basemap != null) {
            mapViewer.setBaseMapName(this.basemap);
        }
        if (this.bgcolor != null && (color = Color.decode(this.bgcolor)) != null) {
            mapViewer.setBackgroundColor(color);
        }
        if (this.bgimage != null) {
            mapViewer.setBackgroundImageURL(this.bgimage);
        }
        if (this.width != null && this.height != null) {
            int n = -1;
            int n2 = -1;
            try {
                n = Integer.parseInt(this.width);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                n2 = Integer.parseInt(this.height);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n > 0 && n2 > 0) {
                mapViewer.setDeviceSize(new Dimension(n, n2));
            }
        }
        if (this.antialiasing != null) {
            boolean bl = Boolean.getBoolean(this.antialiasing);
            mapViewer.setAntiAliasing(bl);
        }
        if (this.imagescaling != null) {
            boolean bl = Boolean.getBoolean(this.imagescaling);
            mapViewer.setImageScaling(bl);
        }
        if (this.title != null) {
            mapViewer.setMapTitle(this.title);
        }
        if (this.centerX != null && this.centerY != null) {
            double d = Double.NaN;
            double d2 = Double.NaN;
            try {
                d = Double.parseDouble(this.centerX);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                d2 = Double.parseDouble(this.centerY);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                mapViewer.setCenter(d, d2);
            }
        }
        if (this.size != null) {
            double d = Double.NaN;
            try {
                d = Double.parseDouble(this.size);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!Double.isNaN(d)) {
                mapViewer.setSize(d);
            }
        }
        return 0;
    }
}

