/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapclient;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.lbs.mapclient.ThemeCache;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.lbs.mapclient.ThemeOrder;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.RenderingRule;

class MapDefinition
implements Serializable {
    static final long serialVersionUID = 451825724650160139L;
    public static final int MAX_THEMES = 256;
    private ThemeCache cache = new ThemeCache(256);
    private ThemeOrder order = new ThemeOrder(256);
    private String title = null;
    private String baseMap = null;
    private String mapDataSource = null;
    private boolean wrapAround = false;

    public void clearAll() {
        this.cache.clear();
        this.order.clear();
        this.title = null;
        this.baseMap = null;
        this.mapDataSource = null;
    }

    public void deleteAllThemes() {
        this.cache.clear();
        this.order.clear();
    }

    public ThemeDescriptor getThemeDescriptor(String string) {
        return (ThemeDescriptor)this.cache.get(string);
    }

    public int getThemePosition(String string) {
        return this.order.indexOf(string);
    }

    public int addPredefinedTheme(String string) {
        return this.addPredefinedTheme(this.cache.size(), string);
    }

    public int addLRSTheme(String string) {
        return this.addLRSTheme(this.cache.size(), string);
    }

    public int addPredefinedTheme(String string, String string2) {
        return this.addPredefinedTheme(this.cache.size(), string, string2);
    }

    public int addPredefinedTheme(String string, String string2, boolean bl) {
        return this.addPredefinedTheme(this.cache.size(), string, string2, bl);
    }

    public int addPredefinedTheme(String string, String string2, boolean bl, String string3, int n) {
        return this.addPredefinedTheme(this.cache.size(), string, string2, bl, string3, n);
    }

    public int addPredefinedTheme(String string, String string2, String string3) {
        return this.addPredefinedTheme(this.cache.size(), string, string2, string3);
    }

    public int addImageTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return this.addImageTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public int addImageTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 4;
        themeDescriptor.name = string7;
        themeDescriptor.host = string;
        themeDescriptor.sid = string2;
        themeDescriptor.port = string3;
        themeDescriptor.mode = string6;
        themeDescriptor.user = string4;
        themeDescriptor.passwd = string5;
        themeDescriptor.query = string8;
        themeDescriptor.imageColumn = string9;
        themeDescriptor.imageMBRColumn = string10;
        themeDescriptor.imageFormat = string11;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string12);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        if (this.cache.get(string7) != null) {
            System.err.println("Replacing theme with name " + string7 + ".");
            this.cache.put(string7, themeDescriptor);
            return -1;
        }
        this.cache.put(string7, themeDescriptor);
        this.order.add(n, string7);
        return n;
    }

    public int addImageTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.addImageTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, bl);
    }

    public int addImageTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 4;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = string3;
        themeDescriptor.imageColumn = string4;
        themeDescriptor.imageMBRColumn = string5;
        themeDescriptor.imageFormat = string6;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string7);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        if (this.cache.get(string2) != null) {
            System.err.println("Replacing theme with name " + string2 + ".");
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, boolean bl) {
        return this.addGeoRasterTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, bl);
    }

    public int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 5;
        themeDescriptor.name = string7;
        themeDescriptor.host = string;
        themeDescriptor.sid = string2;
        themeDescriptor.port = string3;
        themeDescriptor.mode = string6;
        themeDescriptor.user = string4;
        themeDescriptor.passwd = string5;
        themeDescriptor.query = string8;
        themeDescriptor.geoRasterTable = string9;
        themeDescriptor.geoRasterColumn = string10;
        themeDescriptor.rasterTable = string11;
        themeDescriptor.rasterID = string12;
        themeDescriptor.pyramidLevel = string14;
        themeDescriptor.bands = string15;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string13);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        if (this.cache.get(string7) != null) {
            System.err.println("Replacing theme with name " + string7 + ".");
            this.cache.put(string7, themeDescriptor);
            return -1;
        }
        this.cache.put(string7, themeDescriptor);
        this.order.add(n, string7);
        return n;
    }

    public int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        return this.addGeoRasterTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl);
    }

    public int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 5;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = string3;
        themeDescriptor.geoRasterTable = string4;
        themeDescriptor.geoRasterColumn = string5;
        themeDescriptor.rasterTable = string6;
        themeDescriptor.rasterID = string7;
        themeDescriptor.pyramidLevel = string9;
        themeDescriptor.bands = string10;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string8);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        if (this.cache.get(string2) != null) {
            System.err.println("Replacing theme with name " + string2 + ".");
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addTheme(ThemeDescriptor themeDescriptor) {
        int n = this.cache.size();
        if (this.cache.get(themeDescriptor.name) != null) {
            this.cache.put(themeDescriptor.name, themeDescriptor);
            return -1;
        }
        this.cache.put(themeDescriptor.name, themeDescriptor);
        this.order.add(n, themeDescriptor.name);
        return this.cache.size();
    }

    public int addPredefinedTheme(int n, String string) {
        return this.addPredefinedTheme(n, null, string, null);
    }

    public int addLRSTheme(int n, String string) {
        return this.addLRSTheme(n, null, string, null);
    }

    public int addPredefinedTheme(int n, String string, String string2) {
        return this.addPredefinedTheme(n, string, string2, null);
    }

    public int addPredefinedTheme(int n, String string, String string2, boolean bl) {
        return this.addPredefinedTheme(n, string, string2, null, bl);
    }

    public int addPredefinedTheme(int n, String string, String string2, boolean bl, String string3, int n2) {
        return this.addPredefinedTheme(n, string, string2, null, bl, string3, n2);
    }

    public int addPredefinedTheme(int n, String string, String string2, String string3, boolean bl) {
        if (this.cache.get(string2) != null) {
            return -1;
        }
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 1;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.templateTheme = string3;
        themeDescriptor.snapToTileScale = bl;
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addPredefinedTheme(int n, String string, String string2, String string3, boolean bl, String string4, int n2) {
        if (this.cache.get(string2) != null) {
            return -1;
        }
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 1;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.templateTheme = string3;
        themeDescriptor.snapToTileScale = bl;
        themeDescriptor.tileResizingOption = string4;
        themeDescriptor.currentThreads = n2;
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addPredefinedTheme(int n, String string, String string2, String string3) {
        if (this.cache.get(string2) != null) {
            return -1;
        }
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 1;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.templateTheme = string3;
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addLRSTheme(int n, String string, String string2, String string3) {
        if (this.cache.get(string2) != null) {
            return -1;
        }
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 15;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.templateTheme = string3;
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl) {
        return this.addJDBCTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, bl);
    }

    public int addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return this.addJDBCTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, bl);
    }

    public int addJDBCTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 2;
        themeDescriptor.name = string7;
        themeDescriptor.host = string;
        themeDescriptor.sid = string2;
        themeDescriptor.port = string3;
        themeDescriptor.mode = string6;
        themeDescriptor.user = string4;
        themeDescriptor.passwd = string5;
        themeDescriptor.query = string8;
        themeDescriptor.spatialColumn = string9;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string10);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.renderStyleName = string11;
        themeDescriptor.labelColumn = string12;
        themeDescriptor.labelStyleName = string13;
        if (this.cache.get(string7) != null) {
            this.cache.put(string7, themeDescriptor);
            return -1;
        }
        this.cache.put(string7, themeDescriptor);
        this.order.add(n, string7);
        return n;
    }

    public int addJDBCTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 2;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = string3;
        themeDescriptor.spatialColumn = string4;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.renderStyleName = string6;
        themeDescriptor.labelColumn = string7;
        themeDescriptor.labelStyleName = string8;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addTopologyTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 7;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = string3;
        themeDescriptor.topologyName = string4;
        themeDescriptor.featureTableName = string5;
        themeDescriptor.spatialColumn = string6;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string7);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.renderStyleName = string8;
        themeDescriptor.labelColumn = string9;
        themeDescriptor.labelStyleName = string10;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addTopologyTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        return this.addTopologyTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl);
    }

    public int addTopologyThemeFromView(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 7;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = string3;
        themeDescriptor.topologyName = string4;
        themeDescriptor.featureTableName = string5;
        themeDescriptor.spatialColumn = string6;
        themeDescriptor.passThrough = bl;
        themeDescriptor.topoView = string11;
        themeDescriptor.topoViewColumn = string12;
        try {
            themeDescriptor.SRID = Integer.parseInt(string7);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.renderStyleName = string8;
        themeDescriptor.labelColumn = string9;
        themeDescriptor.labelStyleName = string10;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addTopologyThemeFromView(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return this.addTopologyThemeFromView(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public int addTopologyDebugTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2, String string7, String string8, String string9, String string10, String string11, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 7;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = null;
        themeDescriptor.topologyName = string3;
        themeDescriptor.featureTableName = null;
        themeDescriptor.passThrough = bl;
        themeDescriptor.linkStyle = string5;
        themeDescriptor.nodeStyle = string8;
        themeDescriptor.faceStyle = string10;
        themeDescriptor.edgeLabelStyle = string7;
        themeDescriptor.directionStyle = string6;
        themeDescriptor.directionMarkerSize = n2;
        themeDescriptor.nodeLabelStyle = string9;
        themeDescriptor.faceLabelStyle = string11;
        themeDescriptor.isDebugTheme = true;
        try {
            themeDescriptor.SRID = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addTopologyDebugTheme(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, String string8, String string9, String string10, String string11, boolean bl) {
        return this.addTopologyDebugTheme(this.cache.size(), string, string2, string3, string4, string5, string6, n, string7, string8, string9, string10, string11, bl);
    }

    public int addNetworkTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, double d, int n2, String string7, int n3, String string8, String string9, int n4, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 6;
        themeDescriptor.name = string2;
        themeDescriptor.networkName = string3;
        themeDescriptor.dataSource = string;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.linkStyle = string5;
        themeDescriptor.directionStyle = string6;
        themeDescriptor.directionPosition = d;
        themeDescriptor.directionMarkerSize = n2;
        themeDescriptor.nodeStyle = string7;
        themeDescriptor.nodeMarkerSize = n3;
        themeDescriptor.pathIds = string8;
        themeDescriptor.pathStyles = string9;
        themeDescriptor.networkLevel = n4;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addNetworkTheme(String string, String string2, String string3, String string4, String string5, String string6, double d, int n, String string7, int n2, String string8, String string9, int n3, boolean bl) {
        return this.addNetworkTheme(this.cache.size(), string, string2, string3, string4, string5, string6, d, n, string7, n2, string8, string9, n3, bl);
    }

    public int addNetworkTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, double d, int n, String string12, int n2, String string13, String string14, int n3, boolean bl) {
        return this.addNetworkTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, d, n, string12, n2, string13, string14, n3, bl);
    }

    public int addNetworkTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, double d, int n2, String string12, int n3, String string13, String string14, int n4, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 6;
        themeDescriptor.name = string7;
        themeDescriptor.host = string;
        themeDescriptor.sid = string2;
        themeDescriptor.port = string3;
        themeDescriptor.mode = string6;
        themeDescriptor.user = string4;
        themeDescriptor.passwd = string5;
        themeDescriptor.networkName = string8;
        try {
            themeDescriptor.SRID = Integer.parseInt(string9);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.linkStyle = string10;
        themeDescriptor.directionStyle = string11;
        themeDescriptor.directionPosition = d;
        themeDescriptor.directionMarkerSize = n2;
        themeDescriptor.nodeStyle = string12;
        themeDescriptor.nodeMarkerSize = n3;
        themeDescriptor.pathIds = string13;
        themeDescriptor.pathStyles = string14;
        themeDescriptor.networkLevel = n4;
        if (this.cache.get(string7) != null) {
            this.cache.put(string7, themeDescriptor);
            return -1;
        }
        this.cache.put(string7, themeDescriptor);
        this.order.add(n, string7);
        return n;
    }

    public int addAnnotationTextTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.addAnnotationTextTheme(n, string, string2, string3, string4, string5, string6, string7, null, null, bl);
    }

    public int addAnnotationTextTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 12;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.query = string3;
        themeDescriptor.featureTableName = string4;
        themeDescriptor.spatialColumn = string5;
        themeDescriptor.passThrough = bl;
        themeDescriptor.highlightTextColor = string8;
        themeDescriptor.highlightLeaderLineColor = string9;
        try {
            themeDescriptor.SRID = Integer.parseInt(string6);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.renderStyleName = string7;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addAnnotationTextTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.addAnnotationTextTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, bl);
    }

    public int addAnnotationTextTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        return this.addAnnotationTextTheme(this.cache.size(), string, string2, string3, string4, string5, string6, string7, string8, string9, bl);
    }

    public int addCustomGeometryTheme(int n, String string, String string2, String string3, Properties properties, String string4, String string5, String string6, String string7, String[] stringArray, String string8, String string9, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 11;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.providerId = string3;
        themeDescriptor.providerRuntimeProperties = properties;
        try {
            themeDescriptor.SRID = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.renderStyleName = string5;
        themeDescriptor.labelColumn = string6;
        themeDescriptor.labelStyleName = string7;
        themeDescriptor.WFS_attributeList = stringArray;
        themeDescriptor.keyColumn = string8;
        themeDescriptor.WFS_queryCondition = string9;
        themeDescriptor.passThrough = bl;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addCustomGeometryTheme(String string, String string2, String string3, Properties properties, String string4, String string5, String string6, String string7, String[] stringArray, String string8, String string9, boolean bl) {
        return this.addCustomGeometryTheme(this.cache.size(), string, string2, string3, properties, string4, string5, string6, string7, stringArray, string8, string9, bl);
    }

    public int addShortestPath(int n, String string, String string2, String string3, String string4, int n2, int n3, String string5, String string6, String string7, String string8, int n4, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 6;
        themeDescriptor.name = string2;
        themeDescriptor.networkName = string3;
        themeDescriptor.dataSource = string;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string8);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.spStyle = string5;
        themeDescriptor.spAlgorithm = string4;
        themeDescriptor.spStartNode = n2;
        themeDescriptor.spEndNode = n3;
        themeDescriptor.spStartStyle = string6;
        themeDescriptor.spEndStyle = string7;
        themeDescriptor.networkLevel = n4;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addShortestPath(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7, String string8, int n3, boolean bl) {
        return this.addShortestPath(this.cache.size(), string, string2, string3, string4, n, n2, string5, string6, string7, string8, n3, bl);
    }

    public int addLinksWithinCost(int n, String string, String string2, String string3, int n2, String string4, String string5, double d, String string6, int n3, boolean bl) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 6;
        themeDescriptor.name = string2;
        themeDescriptor.networkName = string3;
        themeDescriptor.dataSource = string;
        themeDescriptor.passThrough = bl;
        try {
            themeDescriptor.SRID = Integer.parseInt(string6);
        }
        catch (Exception exception) {
            themeDescriptor.SRID = 0;
        }
        themeDescriptor.spStyle = string5;
        themeDescriptor.spAlgorithm = "WITHINCOST";
        themeDescriptor.spStartNode = n2;
        themeDescriptor.spCost = d;
        themeDescriptor.spStartStyle = string4;
        themeDescriptor.networkLevel = n3;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addLinksWithinCost(String string, String string2, String string3, int n, String string4, String string5, double d, String string6, int n2, boolean bl) {
        return this.addLinksWithinCost(this.cache.size(), string, string2, string3, n, string4, string5, d, string6, n2, bl);
    }

    public int addWMSMapTheme(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String string5, String string6, String string7, String string8, String string9, Object[] objectArray) {
        int n = this.cache.size();
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 8;
        themeDescriptor.name = string;
        themeDescriptor.WMS_ServiceURLPrefix = string2;
        themeDescriptor.WMS_IsBackgroundImage = "true".equalsIgnoreCase(string3);
        themeDescriptor.WMS_Version = "1.0.0".equalsIgnoreCase(string4) || "1.1.0".equalsIgnoreCase(string4) || "1.1.1".equalsIgnoreCase(string4) || "1.3.0".equalsIgnoreCase(string4) ? string4 : "1.1.1";
        themeDescriptor.WMS_Layers = stringArray;
        themeDescriptor.WMS_Styles = stringArray2;
        themeDescriptor.WMS_SRS = string5 == null || string5.length() < 1 ? "EPSG:4326" : string5;
        themeDescriptor.WMS_Format = string6 == null || string6.length() < 1 ? "image/png" : string6;
        themeDescriptor.WMS_Transparent = !"false".equalsIgnoreCase(string7);
        themeDescriptor.WMS_BgColor = string8 == null || !string8.startsWith("0x") || string8.length() != 8 ? "0xffffff" : string8;
        themeDescriptor.WMS_Exceptions = string9 == null ? ("1.3.0".equalsIgnoreCase(themeDescriptor.WMS_Version) ? "XML" : "application/vnd.ogc.se_xml") : string9;
        themeDescriptor.WMS_VendorSpecificParameters = objectArray;
        if (this.cache.get(string) != null) {
            this.cache.put(string, themeDescriptor);
            return -1;
        }
        this.cache.put(string, themeDescriptor);
        this.order.add(n, string);
        return n;
    }

    public int addMapCacheTheme(String string, String string2, String string3, boolean bl, String string4) {
        int n = this.cache.size();
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 9;
        themeDescriptor.name = string;
        themeDescriptor.dataSource = string2;
        themeDescriptor.cacheMapSource = string3;
        themeDescriptor.snapToCacheScale = bl;
        themeDescriptor.tileResizingOption = string4;
        if (this.cache.get(string) != null) {
            this.cache.put(string, themeDescriptor);
            return -1;
        }
        this.cache.put(string, themeDescriptor);
        this.order.add(n, string);
        return n;
    }

    public int addWFSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String string10) {
        int n = this.cache.size();
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 10;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.WMS_SRS = string4;
        themeDescriptor.WFS_url = string3;
        themeDescriptor.featureTableName = string5;
        themeDescriptor.spatialColumn = string6;
        themeDescriptor.renderStyleName = string7;
        themeDescriptor.labelColumn = string8;
        themeDescriptor.labelStyleName = string9;
        themeDescriptor.WFS_attributeList = stringArray;
        themeDescriptor.renderStyleAttributes = stringArray2;
        themeDescriptor.WFS_queryCondition = string10;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addWFSTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String string10) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 10;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.WMS_SRS = string4;
        themeDescriptor.WFS_url = string3;
        themeDescriptor.featureTableName = string5;
        themeDescriptor.spatialColumn = string6;
        themeDescriptor.renderStyleName = string7;
        themeDescriptor.labelColumn = string8;
        themeDescriptor.labelStyleName = string9;
        themeDescriptor.WFS_attributeList = stringArray;
        themeDescriptor.renderStyleAttributes = stringArray2;
        themeDescriptor.WFS_queryCondition = string10;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addWFSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n = this.cache.size();
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 10;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.WMS_SRS = string4;
        themeDescriptor.WFS_url = string3;
        themeDescriptor.featureTableName = string5;
        themeDescriptor.spatialColumn = string6;
        themeDescriptor.renderStyleName = string7;
        themeDescriptor.labelColumn = string8;
        themeDescriptor.labelStyleName = string9;
        themeDescriptor.WFS_attributeList = stringArray;
        themeDescriptor.renderStyleAttributes = stringArray2;
        themeDescriptor.WFS_featureIds = stringArray3;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addWFSTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 10;
        themeDescriptor.name = string2;
        themeDescriptor.dataSource = string;
        themeDescriptor.WMS_SRS = string4;
        themeDescriptor.WFS_url = string3;
        themeDescriptor.featureTableName = string5;
        themeDescriptor.spatialColumn = string6;
        themeDescriptor.renderStyleName = string7;
        themeDescriptor.labelColumn = string8;
        themeDescriptor.labelStyleName = string9;
        themeDescriptor.WFS_attributeList = stringArray;
        themeDescriptor.renderStyleAttributes = stringArray2;
        themeDescriptor.WFS_featureIds = stringArray3;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n, string2);
        return n;
    }

    public int addWMTSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, int n) {
        int n2 = this.cache.size();
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 14;
        themeDescriptor.dataSource = string;
        themeDescriptor.name = string2;
        themeDescriptor.WMTS_ServiceURLPrefix = string3;
        themeDescriptor.WMTS_Version = string4;
        themeDescriptor.WMTS_Format = string7;
        themeDescriptor.WMTS_Layer = string6;
        themeDescriptor.WMTS_MatrixSetID = string8;
        themeDescriptor.WMTS_Style = string5;
        themeDescriptor.snapToTileScale = bl;
        themeDescriptor.tileResizingOption = string9;
        themeDescriptor.currentThreads = n;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n2, string2);
        return n2;
    }

    public int addWMTSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, int n, double d, double d2) {
        int n2 = this.cache.size();
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        themeDescriptor.type = 14;
        themeDescriptor.dataSource = string;
        themeDescriptor.name = string2;
        themeDescriptor.WMTS_ServiceURLPrefix = string3;
        themeDescriptor.WMTS_Version = string4;
        themeDescriptor.WMTS_Format = string7;
        themeDescriptor.WMTS_Layer = string6;
        themeDescriptor.WMTS_MatrixSetID = string8;
        themeDescriptor.WMTS_Style = string5;
        themeDescriptor.WMTS_TopLeftCornerX = d;
        themeDescriptor.WMTS_TopLeftCornerY = d2;
        themeDescriptor.snapToTileScale = bl;
        themeDescriptor.tileResizingOption = string9;
        themeDescriptor.currentThreads = n;
        if (this.cache.get(string2) != null) {
            this.cache.put(string2, themeDescriptor);
            return -1;
        }
        this.cache.put(string2, themeDescriptor);
        this.order.add(n2, string2);
        return n2;
    }

    public void deleteTheme(String string) {
        int n = this.getThemePosition(string);
        if (n < 0) {
            return;
        }
        this.cache.remove(string);
        this.order.remove(n);
    }

    public boolean isEnabled(String string) {
        try {
            return ((ThemeDescriptor)this.cache.get((String)string)).enabled;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean isVisibleInSVG(String string) {
        try {
            return ((ThemeDescriptor)this.cache.get((String)string)).visibleInSVG;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public void setEnabled(boolean bl, String string) {
        try {
            ((ThemeDescriptor)this.cache.get((String)string)).enabled = bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setLabelAlwaysOn(boolean bl, String string) {
        try {
            ((ThemeDescriptor)this.cache.get((String)string)).labelAlwaysOn = bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setClickable(boolean bl, String string) {
        try {
            ((ThemeDescriptor)this.cache.get((String)string)).clickable = bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean isClickable(String string) {
        try {
            return ((ThemeDescriptor)this.cache.get((String)string)).clickable;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public void moveThemeUp(int n) {
        try {
            Object object = this.order.remove(n);
            if (object == null) {
                return;
            }
            this.order.add(n - 1, (String)object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveThemeDown(int n) {
        try {
            Object object = this.order.remove(n);
            this.order.add(n + 1, (String)object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public String getActiveTheme(double d) {
        for (int i = this.order.size() - 1; i >= 0; --i) {
            ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get((String)this.order.get(i));
            if (!(d >= themeDescriptor.maxScale) || !(d <= themeDescriptor.minScale)) continue;
            return themeDescriptor.name;
        }
        return null;
    }

    public void setThemeScale(String string, double d, double d2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.maxScale = d2;
        themeDescriptor.minScale = d;
    }

    public void setThemeLabelScale(String string, double d, double d2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.maxLabelScale = d2;
        themeDescriptor.minLabelScale = d;
    }

    public void setThemeScaleMode(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.scaleType = "MAPVIEWER_NATIVE";
        if (string2 != null && string2.equalsIgnoreCase("RATIO")) {
            themeDescriptor.scaleType = "RATIO";
        }
    }

    public void setThemeFastUnpickle(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.fastUnpickle = bl;
    }

    public void setThemeReorientLines(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.reorientLines = bl;
    }

    public void setThemeUpsideDownLabels(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.upsideDownLabels = bl;
    }

    public void setGeoRasterThemePolygonMask(String string, double[] dArray) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.polygonMask = dArray;
        themeDescriptor.pmaskTable = null;
        themeDescriptor.pmaskGeomColumn = null;
        themeDescriptor.pmaskQCondition = null;
        themeDescriptor.pmaskJoinColumn = null;
        themeDescriptor.pmaskJoinGeorColumn = null;
    }

    public void setGeoRasterThemePolygonMaskSRID(String string, int n) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.polygonMaskSRID = n;
    }

    public void setGeoRasterThemePolygonMask(String string, String string2, String string3, String string4, String string5, String string6) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.pmaskTable = string2;
        themeDescriptor.pmaskGeomColumn = string3;
        themeDescriptor.pmaskQCondition = string4;
        themeDescriptor.pmaskJoinColumn = string5;
        themeDescriptor.pmaskJoinGeorColumn = string6;
        themeDescriptor.polygonMask = null;
    }

    public void setGeoRasterThemeTransparentNODATA(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.transparentNodata = bl;
    }

    public void setGeoRasterThemeAlphaBand(String string, int n) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.alphaBand = n;
    }

    public void setGeoRasterThemeBitmapMasks(String string, GeoRasterBitmapMask[] geoRasterBitmapMaskArray) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.bitmapMasks = geoRasterBitmapMaskArray;
    }

    public void setGeoRasterThemeReprojectionMode(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.reprojMode = string2 == null || string2.equalsIgnoreCase("BILINEAR") ? "BILINEAR" : (string2.equalsIgnoreCase("NN") ? "NN" : (string2.equalsIgnoreCase("CUBIC") ? "CUBIC" : (string2.equalsIgnoreCase("AVERAGE4") ? "AVERAGE4" : (string2.equalsIgnoreCase("AVERAGE16") ? "AVERAGE16" : "BILINEAR"))));
    }

    public void setGeoRasterThemeRenderInterpolationHint(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.renderInterpolationHint = string2 == null || string2.equalsIgnoreCase("NEAREST_NEIGHBOR") ? "NEAREST_NEIGHBOR" : (string2 == null || string2.equalsIgnoreCase("BILINEAR") ? "BILINEAR" : (string2.equalsIgnoreCase("CUBIC") ? "CUBIC" : (string2.equalsIgnoreCase("CUBIC2") ? "CUBIC2" : "NEAREST_NEIGHBOR")));
    }

    public void setGeoRasterThemeFilterReprojectionResult(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.filterReprojResult = bl;
    }

    public void setAnnoTextThemeExpressionColumn(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        if (themeDescriptor.type != 12) {
            return;
        }
        themeDescriptor.labelColumn = string2;
    }

    public void setThemeSimplifyShapes(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.simplifiedShapes = bl;
    }

    public void setThemeMinDistForSVG(String string, double d) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.minDistBetweenPoints = d;
    }

    public void setThemeVisibleInSVG(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.visibleInSVG = bl;
    }

    public void setThemeFixedLabelInSVG(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.fixedSVGLabel = bl;
    }

    public void setThemeSelectableInSVG(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.selectableInSVG = bl;
    }

    public void setThemePartOfBaseMapInSVG(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.partOfBaseMap = bl;
    }

    public void setThemeOnClickInSVG(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.onClickInSVG = string2;
    }

    public void setThemeOnMouseMoveInSVG(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.onMouseMoveInSVG = string2;
    }

    public void setThemeOnMouseOverInSVG(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.onMouseOverInSVG = string2;
    }

    public void setThemeOnMouseOutInSVG(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.onMouseOutInSVG = string2;
    }

    public void setJDBCThemeKeyColumn(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.keyColumn = string2;
    }

    public void setJDBCThemeHiddenInfoDef(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.hiddenInfoDef = string2;
    }

    public void setThemeUnitAndResolution(String string, String string2, double d) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.imageResUnit = string2;
        themeDescriptor.imageResolution = d;
    }

    public void setThemeAlpha(String string, float f) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.imageAlpha = f;
    }

    public void setThemeTransparency(String string, float f) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.opacity = f;
    }

    public void setThemeRequestTimeout(String string, long l) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.requestTimeout = l > 0L ? l : 0L;
    }

    public void setSnapToTileScale(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.snapToTileScale = bl;
    }

    public void setTileResizingOption(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.tileResizingOption = string2;
    }

    public void setCurrentThreads(String string, int n) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.currentThreads = n;
    }

    public void setThemeWorkspace(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.workspaceName = string2;
    }

    public void setThemeWorkspaceSavedPoint(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.workspaceSavedPoint = string2;
    }

    public void setThemeWorkspaceDate(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.workspaceDate = string2;
    }

    public void setThemeWorkspaceDateFormat(String string, String string2, String string3, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.workspaceDateFormat = string2;
        themeDescriptor.workspaceDateNlsParam = string3;
        themeDescriptor.workspaceDateTsWtz = bl;
    }

    public void setThemePixelsForGeneralizedView(String string, int n) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        themeDescriptor.minimumFeatureSizePx = n;
    }

    public void setPredefinedThemeParameters(String string, Object[] objectArray) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        themeDescriptor.dynamicParameters = objectArray;
    }

    public void setThemeRuntimeParameters(String string, Properties properties) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        themeDescriptor.providerRuntimeProperties = properties;
    }

    public void setThemeRenderLabels(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        themeDescriptor.renderLabels = bl;
    }

    public void setThemeFetchSize(String string, int n) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        themeDescriptor.fetchSize = n;
    }

    public void setThemeRenderingRules(String string, RenderingRule[][] renderingRuleArray) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.renderRules = renderingRuleArray;
    }

    public void setThemeAuthentication(String string, String string2, String string3) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.authUser = string2;
        themeDescriptor.authPassword = string3;
    }

    public void setNoRepetitiveLabel(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.noRepetitiveLabel = bl;
    }

    public void setAllowNakedPoints(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.allowNakedPoints = bl;
    }

    public void addGeoRasterThemeOperation(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        if (themeDescriptor.operationNames == null) {
            themeDescriptor.operationNames = new String[1];
            themeDescriptor.operationNames[0] = string2;
        } else {
            int n = themeDescriptor.operationNames.length;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                vector.add(themeDescriptor.operationNames[i]);
            }
            if (vector.contains(string2)) {
                return;
            }
            vector.add(string2);
            themeDescriptor.operationNames = vector.toArray(new String[vector.size()]);
        }
    }

    public void addGeoRasterThemeOperation(String string, String string2, String string3, String string4) {
        Hashtable<String, String> hashtable;
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return;
        }
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        if (themeDescriptor.operationParameters == null) {
            themeDescriptor.operationParameters = new Hashtable();
        }
        if ((hashtable = (Hashtable<String, String>)themeDescriptor.operationParameters.get(string2)) == null) {
            hashtable = new Hashtable<String, String>();
            themeDescriptor.operationParameters.put(string2, hashtable);
        }
        hashtable.put(string3, string4);
        this.addGeoRasterThemeOperation(string, string2);
    }

    public void deleteAllGeoRasterThemeOperations(String string) {
        if (string == null) {
            return;
        }
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.operationNames = null;
        themeDescriptor.operationParameters = null;
    }

    public void removeGeoRasterThemeOperation(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        if (themeDescriptor.operationParameters != null) {
            themeDescriptor.operationParameters.remove(string2);
            if (themeDescriptor.operationParameters.size() == 0) {
                themeDescriptor.operationParameters = null;
            }
        }
        if (themeDescriptor.operationNames != null) {
            int n = themeDescriptor.operationNames.length;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                vector.add(themeDescriptor.operationNames[i]);
            }
            if (!vector.contains(string2)) {
                return;
            }
            vector.remove(string2);
            themeDescriptor.operationNames = vector.size() > 0 ? vector.toArray(new String[vector.size()]) : null;
        }
    }

    public String[] getGeoRasterThemeOperationNames(String string) {
        if (string == null) {
            return null;
        }
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return null;
        }
        return themeDescriptor.operationNames;
    }

    public Hashtable getGeoRasterThemeOperationParameters(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return null;
        }
        if (themeDescriptor.operationParameters != null) {
            return (Hashtable)themeDescriptor.operationParameters.get(string2);
        }
        return null;
    }

    public String[] getThemeNames() {
        if (this.order.size() == 0) {
            return null;
        }
        return (String[])this.order.toArray(new String[this.order.size()]);
    }

    public void setNetworkThemeMultipleDirectionMarker(String string, boolean bl) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.multipleMarker = bl;
    }

    public void setNetworkThemeBiDirectionMarker(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.bidirectionStyle = string2;
    }

    public void setNetworkThemeLabels(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.linksLabelStyle = string2;
        themeDescriptor.linksLabelColumn = string3;
        themeDescriptor.nodesLabelStyle = string4;
        themeDescriptor.nodesLabelColumn = string5;
        themeDescriptor.pathsLabelStyle = string6;
        themeDescriptor.pathsLabelColumn = string7;
    }

    public void setNetworkThemeDirectionMarkerSize(String string, double d, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.directionMarkerSize = d;
        themeDescriptor.directionMarkerSizeUnit = string2;
    }

    public void setNetworkThemeNodeMarkerSize(String string, double d, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.nodeMarkerSize = d;
        themeDescriptor.nodeMarkerSizeUnit = string2;
    }

    public void setWFSThemeVersion(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.WFS_version = string2;
    }

    public void setWFSThemeOutputFormat(String string, String string2) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.WFS_outputFormat = string2;
    }

    public void setJDBCThemePointColumns(String string, String string2, String string3) {
        ThemeDescriptor themeDescriptor = (ThemeDescriptor)this.cache.get(string);
        if (themeDescriptor == null) {
            return;
        }
        themeDescriptor.xColumn = string2;
        themeDescriptor.yColumn = string3;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBaseMap(String string) {
        this.baseMap = string;
    }

    public void setWrapAround(boolean bl) {
        this.wrapAround = bl;
    }

    public boolean getWrapAround() {
        return this.wrapAround;
    }

    public String getBaseMap() {
        return this.baseMap;
    }

    public void setMapDataSource(String string) {
        this.mapDataSource = string;
    }

    public String getMapDataSource() {
        return this.mapDataSource;
    }

    public boolean hasThemes() {
        return this.cache.size() > 0;
    }

    public ThemeDescriptor[] getThemes() {
        if (this.hasThemes()) {
            int n = 0;
            ThemeDescriptor[] themeDescriptorArray = new ThemeDescriptor[this.cache.size()];
            for (n = 0; n < this.order.size(); ++n) {
                themeDescriptorArray[n] = this.getThemeDescriptor((String)this.order.get(n));
            }
            return themeDescriptorArray;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.cache);
        objectOutputStream.writeObject(this.order);
        objectOutputStream.writeObject(this.title);
        objectOutputStream.writeObject(this.baseMap);
        objectOutputStream.writeObject(this.mapDataSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cache = (ThemeCache)objectInputStream.readObject();
        this.order = (ThemeOrder)objectInputStream.readObject();
        this.title = (String)objectInputStream.readObject();
        this.baseMap = (String)objectInputStream.readObject();
        this.mapDataSource = (String)objectInputStream.readObject();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(" MapDefinition=");
        stringBuffer.append("\n  baseMap=" + this.baseMap);
        stringBuffer.append("\n  mapDataSource=" + this.mapDataSource);
        stringBuffer.append("\n  title=" + this.title);
        if (this.hasThemes()) {
            ThemeDescriptor[] themeDescriptorArray = this.getThemes();
            for (int i = 0; i < themeDescriptorArray.length; ++i) {
                stringBuffer.append("\n  theme [" + i + "]=" + themeDescriptorArray[i]);
            }
        }
        return stringBuffer.toString();
    }
}

