/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.ESSReceipt;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.smime.BodyPartUpdater;
import oracle.security.crypto.smime.MailTrustPolicy;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.smime.SmimeCapabilities;
import oracle.security.crypto.smime.SmimeSignedObject;
import oracle.security.crypto.smime.SmimeUtils;
import oracle.security.crypto.smime.ess.ESSSecurityLabel;
import oracle.security.crypto.smime.ess.EquivalentLabels;
import oracle.security.crypto.smime.ess.MLExpansionHistory;
import oracle.security.crypto.smime.ess.ReceiptRequest;
import oracle.security.crypto.smime.ess.SigningCertificate;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public class SmimeSigned
implements SmimeSignedObject {
    private CMSSignedDataContentInfo sd;

    SmimeSigned(CMSSignedDataContentInfo sd) {
        this.sd = sd;
    }

    public SmimeSigned() {
        this.sd = new CMSSignedDataContentInfo((CMSContentInfo)new CMSDataContentInfo());
    }

    public SmimeSigned(MimeBodyPart content) throws MessagingException, IOException {
        this(content, false);
    }

    public SmimeSigned(MimeBodyPart content, boolean useCompression) throws MessagingException, IOException {
        if (content == null) {
            this.sd = new CMSSignedDataContentInfo((CMSContentInfo)new CMSDataContentInfo());
        } else {
            new BodyPartUpdater(content);
            byte[] dc = SmimeUtils.toBytes(content);
            if (dc == null || dc.length < 1) {
                throw new InvalidInputException("Message content is empty");
            }
            this.sd = new CMSSignedDataContentInfo((CMSContentInfo)new CMSDataContentInfo(dc));
        }
    }

    public SmimeSigned(InputStream is) throws IOException {
        this(new CMSSignedDataContentInfo(is));
    }

    public void addCertificate(X509Certificate cert) {
        this.sd.addCertificate(cert);
    }

    public void addCRL(CRL crl) {
        this.sd.addCRL(crl);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException, IOException {
        this.addSignature(signerKey, signerCert, digestAlgID, (AttributeSet)null);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, Date timeStamp) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException, IOException {
        this.addSignature(signerKey, signerCert, digestAlgID, timeStamp, null);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, SmimeCapabilities smimeCaps) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException, IOException {
        this.addSignature(signerKey, signerCert, digestAlgID, null, smimeCaps);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, Date timeStamp, SmimeCapabilities smimeCaps) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException, IOException {
        AttributeSet authAttribs = null;
        if (timeStamp != null || smimeCaps != null) {
            authAttribs = new AttributeSet();
            if (timeStamp != null) {
                authAttribs.addAttribute(CMS.id_signingTime, (ASN1Object)new ASN1Date(timeStamp));
            }
            if (smimeCaps != null) {
                authAttribs.addAttribute(Smime.smimeCapabilities, (ASN1Object)smimeCaps);
            }
        }
        this.addSignature(signerKey, signerCert, digestAlgID, authAttribs);
    }

    public void addSignature(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AttributeSet signedAttributes) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, IOException, CertificateEncodingException {
        AlgorithmIdentifier digestEncryptionAlgID = null;
        Signature signature = Signature.getInstance(CMSUtils.getSigAlgName((String)signerKey.getAlgorithm(), (String)CMSUtils.getAlgoName((AlgorithmIdentifier)digestAlgID)));
        signature.initSign(signerKey);
        digestEncryptionAlgID = CMSUtils.getAlgoID((String)signerKey.getAlgorithm());
        this.sd.addSignature(signedAttributes, signerKey, signerCert, digestAlgID, digestEncryptionAlgID, null);
    }

    CMSSignedDataContentInfo getSD() {
        return this.sd;
    }

    CMSContentInfo getCMSContentObject() {
        return this.sd.getEnclosed();
    }

    public ESSReceipt getReceipt() {
        if (this.isSignedReceipt()) {
            return (ESSReceipt)this.sd.getEnclosed();
        }
        return null;
    }

    @Override
    public MimeBodyPart getEnclosedBodyPart() throws InvalidInputException, MessagingException {
        CMSDataContentInfo data;
        try {
            data = (CMSDataContentInfo)this.sd.getEnclosed();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException("Content-type 'data' expected");
        }
        if (data.isDegenerate()) {
            return null;
        }
        return new MimeBodyPart((InputStream)new UnsyncByteArrayInputStream(data.getData()));
    }

    public boolean isSignedReceipt() {
        ASN1ObjectID oid = this.sd.getEnclosedContentType();
        return oid.equals((Object)CMS.id_ct_receipt);
    }

    @Override
    public Vector getCertificates() {
        return this.sd.getCertificates();
    }

    @Override
    public Vector getCRLs() {
        return this.sd.getCRLs();
    }

    @Override
    public Enumeration signers() {
        return this.sd.signers();
    }

    @Override
    public void verifySignature(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        try {
            this.sd.verifySignature(signerCert);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public void verifySignature(X509Certificate signerCert, Address[] senderAddresses) throws AuthenticationException, SignatureException {
        if (senderAddresses == null) {
            throw new AuthenticationException("No 'sender' or 'from' addresses found.");
        }
        SmimeUtils.checkEmailAddress(signerCert, senderAddresses);
        try {
            this.sd.verifySignature(signerCert);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public void verify(CertificateTrustPolicy trustPolicy) throws AuthenticationException {
        this.sd.verify(trustPolicy);
    }

    @Override
    public void verify(CertificateTrustPolicy trustPolicy, Address[] senderAddresses) throws AuthenticationException {
        this.sd.verify((CertificateTrustPolicy)new MailTrustPolicy(trustPolicy, senderAddresses));
    }

    @Override
    public ESSSecurityLabel getESSSecurityLabel(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        ESSSecurityLabel vsl = null;
        try {
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            this.sd.verifySignature(signerCert);
            vsl = new ESSSecurityLabel(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find ESSSecurityLabel with Verifiable Signature");
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                ESSSecurityLabel sl = new ESSSecurityLabel(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ESSSecurityLabel's MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public EquivalentLabels getEquivalentLabels(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        EquivalentLabels vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new EquivalentLabels(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find EquivalentLabels with Verifiable Signature" + ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                EquivalentLabels sl = new EquivalentLabels(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("EquivalentLabels MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public SigningCertificate getSigningCertificate(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            SigningCertificate vsl = new SigningCertificate(sigInfo);
            return vsl;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find SigningCertificate with Verifiable Signature " + ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public MLExpansionHistory getMLExpansionHistory(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        MLExpansionHistory vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new MLExpansionHistory(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find MLExpansionHistory with Verifiable Signature" + ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                MLExpansionHistory sl = new MLExpansionHistory(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ESSSecurityLabel's MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public ReceiptRequest getReceiptRequest(X509Certificate signerCert) throws AuthenticationException, SignatureException {
        ReceiptRequest vsl = null;
        try {
            this.sd.verifySignature(signerCert);
            CMSSignerInfo sigInfo = this.sd.getSignerInfo(signerCert);
            vsl = new ReceiptRequest(sigInfo);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidInputException ex) {
            throw new SignatureException("Could not find ReceiptRequest with Verifiable Signature " + ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (IOException ex) {
            throw new AuthenticationException(ex.toString());
        }
        Enumeration e = this.sd.signers();
        while (e.hasMoreElements()) {
            CMSSignerInfo sigInfo = (CMSSignerInfo)e.nextElement();
            try {
                ReceiptRequest sl = new ReceiptRequest(sigInfo);
                if (vsl.equals(sl)) continue;
                throw new AuthenticationException("ReceiptRequest's MUST be identical");
            }
            catch (InvalidInputException invalidInputException) {
            }
        }
        return vsl;
    }

    @Override
    public String generateContentType(boolean useStandardContentTypes) {
        if (((CMSDataContentInfo)this.sd.getEnclosed()).getData() != null) {
            return useStandardContentTypes ? "application/pkcs7-mime; smime-type=signed-data" : "application/x-pkcs7-mime; smime-type=signed-data";
        }
        Enumeration signers = this.sd.signers();
        if (signers != null && signers.hasMoreElements()) {
            return useStandardContentTypes ? "application/pkcs7-signature" : "application/x-pkcs7-signature";
        }
        return useStandardContentTypes ? "application/pkcs7-mime; smime-type=certs-only" : "application/x-pkcs7-mime; smime-type=certs-only";
    }

    @Override
    public String generateContentType() {
        return this.generateContentType(true);
    }

    @Override
    public void writeTo(OutputStream os, String mimeType) throws IOException, MessagingException {
        this.sd.output(os);
    }
}

