/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.mail.MessagingException;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cms.CMSCompressedDataContentInfo;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSEnvelopedDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.smime.SmimeCompressed;
import oracle.security.crypto.smime.SmimeEnveloped;
import oracle.security.crypto.smime.SmimeMultipartSigned;
import oracle.security.crypto.smime.SmimeObject;
import oracle.security.crypto.smime.SmimeSigned;
import oracle.security.crypto.smime.SmimeSignedReceipt;
import oracle.security.crypto.util.InvalidInputException;

public class SmimeDataContentHandler
implements DataContentHandler {
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[0];
    }

    public Object getTransferData(DataFlavor flavor, DataSource source) throws UnsupportedFlavorException {
        throw new UnsupportedFlavorException(flavor);
    }

    public Object getContent(DataSource ds) throws IOException {
        try {
            MimeType contentType = new MimeType(ds.getContentType());
            if (contentType.match("application/pkcs7-mime") || contentType.match("application/x-pkcs7-mime")) {
                String smimeTypeParam = contentType.getParameter("smime-type");
                CMSContentInfo ci = CMSContentInfo.inputInstance((InputStream)ds.getInputStream());
                if (ci instanceof CMSSignedDataContentInfo) {
                    if (smimeTypeParam != null && smimeTypeParam.equals("signed-receipt")) {
                        return new SmimeSignedReceipt((CMSSignedDataContentInfo)ci);
                    }
                    return new SmimeSigned((CMSSignedDataContentInfo)ci);
                }
                if (ci instanceof CMSEnvelopedDataContentInfo) {
                    return new SmimeEnveloped((CMSEnvelopedDataContentInfo)ci);
                }
                if (ci instanceof CMSCompressedDataContentInfo) {
                    return new SmimeCompressed((CMSCompressedDataContentInfo)ci);
                }
                throw new InvalidInputException("Illegal CMS content type in S/MIME.");
            }
            if (contentType.match("application/pkcs7-signature") || contentType.match("application/x-pkcs7-signature")) {
                return new SmimeSigned(new CMSSignedDataContentInfo(ds.getInputStream()));
            }
            if (contentType.match("application/pkcs10") || contentType.match("application/x-pkcs10")) {
                return new CertificateRequest(ds.getInputStream());
            }
            if (contentType.match("multipart/signed")) {
                return new SmimeMultipartSigned(ds);
            }
            throw new InvalidInputException("Unrecognized MIME content type (" + contentType + ").");
        }
        catch (MimeTypeParseException ex) {
            throw new InvalidInputException((Exception)((Object)ex));
        }
        catch (MessagingException ex) {
            throw new InvalidInputException((Exception)((Object)ex));
        }
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj instanceof SmimeObject) {
            try {
                ((SmimeObject)obj).writeTo(os, mimeType);
            }
            catch (MessagingException ex) {
                throw new IOException(ex.toString());
            }
        } else if (obj instanceof CertificateRequest) {
            ((CertificateRequest)obj).output(os);
        } else {
            throw new IOException("Object not supported by data content handler.");
        }
    }
}

