/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.File;
import javax.activation.FileDataSource;

class MultipartFileDataSource
extends FileDataSource {
    private final String contentTypeHeader;
    private static final String DEFAULT_CONTENT_TYPE_HEADER = "multipart/signed; protocol=\"application/pkcs7-signature\"; micalg=sha1; boundary=\"SMS:FZUGIiu8BpSU1eqjxkVdZeLSFJk=\"";

    public MultipartFileDataSource(File file) {
        this(file, DEFAULT_CONTENT_TYPE_HEADER);
    }

    public MultipartFileDataSource(File file, String contentTypeHeader) {
        super(file);
        this.contentTypeHeader = contentTypeHeader;
    }

    public MultipartFileDataSource(String name) {
        this(name, DEFAULT_CONTENT_TYPE_HEADER);
    }

    public MultipartFileDataSource(String name, String contentTypeHeader) {
        super(name);
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getContentType() {
        String s = super.getContentType();
        if (s.startsWith("multipart")) {
            return this.contentTypeHeader;
        }
        return s;
    }
}

