/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.util.Vector;
import javax.mail.Address;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.CertificateVerifier;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AuthenticationException;

public class MailTrustPolicy
implements CertificateTrustPolicy {
    private CertificateTrustPolicy trustPolicy;
    private Address[] addresses;

    public MailTrustPolicy(CertificateTrustPolicy trustPolicy, Address[] addresses) {
        this.trustPolicy = trustPolicy;
        this.addresses = addresses;
    }

    public CertificateVerifier makeCertificateVerifier(Vector certificates, Vector crls) {
        return new MailCertificateVerifier(this.trustPolicy.makeCertificateVerifier(certificates, crls), this.addresses);
    }

    private static class MailCertificateVerifier
    implements CertificateVerifier {
        CertificateVerifier cv;
        Address[] addresses;

        MailCertificateVerifier(CertificateVerifier cv, Address[] addresses) {
            this.cv = cv;
            this.addresses = addresses;
        }

        public X509 getValidCertificate(IssuerAndSerialNo iasn) throws AuthenticationException {
            if (this.addresses == null) {
                throw new AuthenticationException("No 'sender' or 'from' addresses found.");
            }
            X509 cert = this.cv.getValidCertificate(iasn);
            if (cert != null) {
                String email = cert.getSubject().getEmail();
                if (email == null) {
                    throw new AuthenticationException("Certificate does not contain email address");
                }
                boolean found = false;
                for (int i = 0; i < this.addresses.length; ++i) {
                    if (!email.equals(this.addresses[i].toString())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new AuthenticationException("E-mail address on certificate is not correct");
                }
            }
            return cert;
        }
    }
}

