/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.property.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.property.spi.PropertyPageInfo;
import javax.ide.util.MetaClass;

public final class PropertyHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-hook");
    private static final ElementName PROPERTY_PAGES = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-pages");
    private static final ElementName PROPERTY_PAGE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-page");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName OBJECT_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "object-class");
    private static final String KEY_INFO = "propertyInfo";
    private final ElementVisitor _propertyPagesVisitor = new PropertyPagesVisitor();
    private final ElementVisitor _propertyPageVisitor = new PropertyPageVisitor();
    private final ElementVisitor _labelVisitor = new LabelVisitor();
    private final ElementVisitor _objectClassVisitor = new ObjectClassVisitor();
    private Collection _propertyPageInfos = new ArrayList();

    public Collection getPropertyPageInfos() {
        return this._propertyPageInfos;
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(PROPERTY_PAGES, this._propertyPagesVisitor);
    }

    private PropertyPageInfo getInfo(ElementContext context) {
        return (PropertyPageInfo)context.getScopeData().get(KEY_INFO);
    }

    private class PropertyPagesVisitor
    extends ElementVisitor {
        private PropertyPagesVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(PROPERTY_PAGE, PropertyHook.this._propertyPageVisitor);
        }
    }

    private final class PropertyPageVisitor
    extends ElementVisitor {
        private PropertyPageVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String clz = context.getAttributeValue("property-page-class");
            if (clz != null) {
                clz = clz.trim();
            }
            if (clz == null || clz.length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'property-page-class'");
                return;
            }
            ClassLoader cl = ElementVisitor.getClassLoader(context);
            MetaClass pageClass = new MetaClass(cl, clz);
            PropertyPageInfo info = new PropertyPageInfo();
            info.setPageClass(pageClass);
            String parent = context.getAttributeValue("parent-page");
            info.setParentPage(parent);
            context.getScopeData().put(PropertyHook.KEY_INFO, info);
            context.registerChildVisitor(LABEL, PropertyHook.this._labelVisitor);
            context.registerChildVisitor(OBJECT_CLASS, PropertyHook.this._objectClassVisitor);
        }

        @Override
        public void end(ElementEndContext context) {
            PropertyPageInfo info = PropertyHook.this.getInfo(context);
            if (info.getLabel() == null) {
                this.log(context, Level.SEVERE, "Label required.");
                return;
            }
            if (info.getObjectClass() == null) {
                this.log(context, Level.SEVERE, "Object class required.");
                return;
            }
            PropertyHook.this._propertyPageInfos.add(info);
        }
    }

    private final class LabelVisitor
    extends I18NStringVisitor {
        private LabelVisitor() {
        }

        @Override
        public void string(ElementContext context, String value) {
            PropertyPageInfo info = PropertyHook.this.getInfo(context);
            info.setLabel(value);
        }
    }

    private final class ObjectClassVisitor
    extends ElementVisitor {
        private ObjectClassVisitor() {
        }

        @Override
        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text != null) {
                text = text.trim();
            }
            if (text != null && text.length() > 0) {
                if (!"javax.ide.IDE".equals(text) && !"javax.ide.model.Project".equals(text)) {
                    this.log(context, Level.SEVERE, "Must be either 'javax.ide.IDE' or 'javax.ide.model.Project'.");
                    return;
                }
                PropertyHook.this.getInfo(context).setObjectClass(text);
            }
        }
    }
}

