/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;

public final class VFSHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "vfs-hook");
    private static final ElementName SCHEME = new ElementName("http://jcp.org/jsr/198/extension-manifest", "scheme");
    private static final ElementName HELPER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "helper");
    private static final ElementName HELPER_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "helper-class");
    private static final String CURRENT_HOLDER = "currentHolder";
    private final ElementVisitor _helperVisitor = new HelperVisitor();
    private final ElementVisitor _schemeVisitor = new SchemeVisitor();
    private final ElementVisitor _helperClassVisitor = new HelperClassVisitor();
    private Map _helperMetaClassesByScheme = new HashMap();

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(HELPER, this._helperVisitor);
    }

    private final class HelperVisitor
    extends ElementVisitor {
        private HelperVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.getScopeData().put(VFSHook.CURRENT_HOLDER, new Holder());
            context.registerChildVisitor(SCHEME, VFSHook.this._schemeVisitor);
            context.registerChildVisitor(HELPER_CLASS, VFSHook.this._helperClassVisitor);
        }

        @Override
        public void end(ElementEndContext context) {
            Holder holder = (Holder)context.getScopeData().get(VFSHook.CURRENT_HOLDER);
            if (holder.scheme == null) {
                this.log(context, Level.SEVERE, "Missing required element 'scheme'.");
                return;
            }
            if (holder.metaClass == null) {
                this.log(context, Level.SEVERE, "Missing required element 'helper-class'.");
                return;
            }
            if (VFSHook.this._helperMetaClassesByScheme.containsKey(holder.scheme)) {
                this.log(context, Level.WARNING, "Multiple virtual file system helpers for scheme '" + holder.scheme + "'. " + holder.metaClass.getClassName() + " takes precedence.");
            }
            VFSHook.this._helperMetaClassesByScheme.put(holder.scheme, holder.metaClass);
        }
    }

    private final class SchemeVisitor
    extends ElementVisitor {
        private SchemeVisitor() {
        }

        @Override
        public void end(ElementEndContext context) {
            if (context.getText() != null) {
                String scheme = context.getText().trim();
                Holder holder = (Holder)context.getScopeData().get(VFSHook.CURRENT_HOLDER);
                holder.scheme = scheme;
            }
        }
    }

    private final class HelperClassVisitor
    extends MetaClassVisitor {
        private HelperClassVisitor() {
        }

        @Override
        protected void metaClass(ElementContext context, MetaClass clz) {
            Holder holder = (Holder)context.getScopeData().get(VFSHook.CURRENT_HOLDER);
            holder.metaClass = clz;
        }
    }

    private final class Holder {
        private String scheme;
        private MetaClass metaClass;

        private Holder() {
        }
    }
}

