/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;

public final class URIPath {
    private final ArrayList _entriesList;

    public URIPath() {
        this._entriesList = new ArrayList();
    }

    public URIPath(int initialCapacity) {
        this._entriesList = new ArrayList(initialCapacity);
    }

    public URIPath(URI entry) {
        this();
        this.add(entry);
    }

    public URIPath(URI[] entries) {
        this();
        this.add(entries);
    }

    public URIPath(URIPath uriPath) {
        this();
        if (uriPath != null) {
            this._entriesList.addAll(uriPath._entriesList);
        }
    }

    public URIPath(String entries) {
        this();
        StringTokenizer tokenizer = new StringTokenizer(entries, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            this._entriesList.add(this.pathToURI(path));
        }
    }

    public void add(URI entry) {
        if (entry != null && !this.contains(entry)) {
            this._entriesList.add(entry);
        }
    }

    public void add(URI[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            for (int i = 0; i < numEntries; ++i) {
                this.add(entries[i]);
            }
        }
    }

    public void add(URIPath uriPath) {
        if (uriPath != null) {
            this.add(uriPath.getEntries());
        }
    }

    public URI[] getEntries() {
        return this._entriesList.toArray(new URI[this._entriesList.size()]);
    }

    public boolean contains(URI entry) {
        return this.findEntry(entry) >= 0;
    }

    public void remove(URI entry) {
        int i;
        if (entry != null && (i = this.findEntry(entry)) >= 0) {
            this._entriesList.remove(i);
        }
    }

    public Iterator iterator() {
        return this._entriesList.iterator();
    }

    public String toRelativePath(URI uri) {
        if (uri != null) {
            for (URI pathElem : this.getEntries()) {
                String relativePath = VirtualFileSystem.getVirtualFileSystem().toRelativeSpec(uri, pathElem, true);
                if (relativePath == null) continue;
                return relativePath;
            }
        }
        return null;
    }

    public URI toQualifiedURI(String relativePath) {
        if (relativePath != null) {
            URI[] entries = this.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                URI pathElem = entries[i];
                URI fullURI = pathElem.getScheme().equals("jar") ? URIFactory.newJarURI(pathElem, relativePath) : URIFactory.newURI(pathElem, relativePath);
                if (!VirtualFileSystem.getVirtualFileSystem().exists(fullURI)) continue;
                return fullURI;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((URIPath)o);
    }

    protected final boolean equalsImpl(URIPath uriPath) {
        if (this == uriPath) {
            return true;
        }
        if (this._entriesList.size() != uriPath._entriesList.size()) {
            return false;
        }
        Iterator iter1 = this._entriesList.iterator();
        Iterator iter2 = uriPath._entriesList.iterator();
        while (iter1.hasNext()) {
            URI uri1 = (URI)iter1.next();
            URI uri2 = (URI)iter2.next();
            if (VirtualFileSystem.getVirtualFileSystem().equals(uri1, uri2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer uriPath = new StringBuffer();
        for (URI uri : this.getEntries()) {
            String path = VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(uri);
            uriPath.append(path).append(File.pathSeparatorChar);
        }
        int len = uriPath.length();
        if (len > 0) {
            uriPath.setLength(len - 1);
        }
        return uriPath.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private int findEntry(URI entry) {
        if (entry != null) {
            URI[] entries = this.getEntries();
            int n = entries.length;
            for (int i = 0; i < n; ++i) {
                if (!VirtualFileSystem.getVirtualFileSystem().equals(entry, entries[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private URI pathToURI(String pathname) {
        if (URIFactory.isArchive(pathname)) {
            URI uri = URIFactory.newFileURI(pathname);
            return URIFactory.newJarURI(uri, "");
        }
        File dir = new File(pathname);
        try {
            return URIFactory.newDirURI(dir.getCanonicalPath());
        }
        catch (IOException e) {
            return URIFactory.newDirURI(dir.getAbsolutePath());
        }
    }
}

