/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ListenerInfo;
import javax.ide.model.spi.SuffixRecognizer;
import javax.ide.model.spi.XMLDocType;
import javax.ide.model.spi.XMLDocTypeRecognizer;
import javax.ide.model.spi.XMLRootElementRecognizer;
import javax.ide.util.MetaClass;

public class DocumentHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "document-hook");
    private static final ElementName DOCUMENTS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "documents");
    private static final ElementName BY_SUFFIX = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-suffix");
    private static final ElementName SUFFIX = new ElementName("http://jcp.org/jsr/198/extension-manifest", "suffix");
    private static final ElementName BY_XML_ROOT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-xml-root");
    private static final ElementName BY_XML_DOCTYPE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-xml-doctype");
    private static final ElementName ROOT_ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "root-element");
    private static final ElementName DOCTYPE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "doctype");
    private static final ElementName BY_RECOGNIZER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-recognizer");
    private static final ElementName LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "listeners");
    private static final ElementName DOCUMENT_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "document-listener");
    private static final ElementName PROPERTY_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-listener");
    private final ElementVisitor _documentsVisitor = new DocumentsVisitor();
    private final ElementVisitor _bySuffixVisitor = new BySuffixVisitor();
    private final ElementVisitor _byXMLRootVisitor = new ByXMLRootVisitor();
    private final ElementVisitor _byXMLDocTypeVisitor = new ByXMLDocTypeVisitor();
    private final ElementVisitor _byRecognizerVisitor = new ByRecognizerVisitor();
    private final ElementVisitor _rootElementVisitor = new RootElementVisitor();
    private final ElementVisitor _docTypeVisitor = new DocTypeVisitor();
    private final ElementVisitor _suffixVisitor = new SuffixVisitor();
    private final ElementVisitor _listenersVisitor = new ListenersVisitor();
    private final List _documentListeners = new ArrayList();
    private final List _propertyListeners = new ArrayList();
    private final List _suffixRecognizers = new ArrayList();
    private final List _xmlRecognizers = new ArrayList();
    private final List _customRecognizers = new ArrayList();
    private static final String KEY_CURRENT_SUFFIX_RECOGNIZER = "currentSuffixRecognizer";

    public Collection getDocumentListeners() {
        return Collections.unmodifiableCollection(this._documentListeners);
    }

    public Collection getSuffixRecognizers() {
        return Collections.unmodifiableCollection(this._suffixRecognizers);
    }

    public Collection getXMLRecognizers() {
        return Collections.unmodifiableCollection(this._xmlRecognizers);
    }

    public Collection getCustomRecognizers() {
        return Collections.unmodifiableCollection(this._customRecognizers);
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(DOCUMENTS, this._documentsVisitor);
        context.registerChildVisitor(LISTENERS, this._listenersVisitor);
    }

    private final SuffixRecognizer getSuffixRecognizer(ElementContext context) {
        return (SuffixRecognizer)context.getScopeData().get(KEY_CURRENT_SUFFIX_RECOGNIZER);
    }

    private MetaClass createMetaClass(ElementContext context, String className) {
        ClassLoader classLoader = (ClassLoader)context.getScopeData().get("classLoader");
        return new MetaClass(classLoader, className);
    }

    private class DocumentsVisitor
    extends ElementVisitor {
        private DocumentsVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(BY_SUFFIX, DocumentHook.this._bySuffixVisitor);
            context.registerChildVisitor(BY_XML_ROOT, DocumentHook.this._byXMLRootVisitor);
            context.registerChildVisitor(BY_XML_DOCTYPE, DocumentHook.this._byXMLDocTypeVisitor);
            context.registerChildVisitor(BY_RECOGNIZER, DocumentHook.this._byRecognizerVisitor);
        }
    }

    private class BySuffixVisitor
    extends ElementVisitor {
        private BySuffixVisitor() {
        }

        @Override
        public final void start(ElementStartContext context) {
            String docClass = context.getAttributeValue("document-class");
            if ((docClass == null || (docClass = docClass.trim()).length() == 0) && (docClass = this.getDefaultDocumentClassType()) == null) {
                this.log(context, Level.SEVERE, "Missing attribute 'document-class'.");
                return;
            }
            MetaClass docMetaClass = DocumentHook.this.createMetaClass(context, docClass);
            SuffixRecognizer sr = this.createSuffixRecognizer(context, docMetaClass);
            context.getScopeData().put(DocumentHook.KEY_CURRENT_SUFFIX_RECOGNIZER, sr);
            context.registerChildVisitor(SUFFIX, DocumentHook.this._suffixVisitor);
        }

        protected String getDefaultDocumentClassType() {
            return null;
        }

        protected boolean isSuffixRequired() {
            return true;
        }

        @Override
        public final void end(ElementEndContext context) {
            SuffixRecognizer sr = DocumentHook.this.getSuffixRecognizer(context);
            if (this.isSuffixRequired() && sr.getSuffixes().isEmpty()) {
                this.log(context, Level.SEVERE, "Missing 'suffix' element.");
            } else {
                this.registerRecognizer(context, sr);
            }
        }

        protected void registerRecognizer(ElementContext context, SuffixRecognizer sr) {
            DocumentHook.this._suffixRecognizers.add(sr);
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext context, MetaClass docClass) {
            return new SuffixRecognizer(docClass);
        }
    }

    private final class ByXMLRootVisitor
    extends BySuffixVisitor {
        private ByXMLRootVisitor() {
        }

        @Override
        protected boolean isSuffixRequired() {
            return false;
        }

        @Override
        protected String getDefaultDocumentClassType() {
            return "javax.ide.model.xml.XMLDocument";
        }

        @Override
        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext context, MetaClass docClass) {
            XMLRootElementRecognizer xmlr = new XMLRootElementRecognizer(docClass);
            context.registerChildVisitor(ROOT_ELEMENT, DocumentHook.this._rootElementVisitor);
            return xmlr;
        }

        @Override
        protected void registerRecognizer(ElementContext context, SuffixRecognizer sr) {
            XMLRootElementRecognizer xmlr = (XMLRootElementRecognizer)sr;
            if (xmlr.getRootElements().isEmpty()) {
                this.log(context, Level.SEVERE, "Must specify 'root-element'.");
            } else {
                DocumentHook.this._xmlRecognizers.add(xmlr);
            }
        }
    }

    private final class ByXMLDocTypeVisitor
    extends BySuffixVisitor {
        private ByXMLDocTypeVisitor() {
        }

        @Override
        protected boolean isSuffixRequired() {
            return false;
        }

        @Override
        protected String getDefaultDocumentClassType() {
            return "javax.ide.model.xml.XMLDocument";
        }

        @Override
        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext context, MetaClass docClass) {
            XMLDocTypeRecognizer xmlr = new XMLDocTypeRecognizer(docClass);
            context.registerChildVisitor(DOCTYPE, DocumentHook.this._docTypeVisitor);
            return xmlr;
        }

        @Override
        protected void registerRecognizer(ElementContext context, SuffixRecognizer sr) {
            XMLDocTypeRecognizer xmlr = (XMLDocTypeRecognizer)sr;
            if (xmlr.getDocTypes().isEmpty()) {
                this.log(context, Level.SEVERE, "Must specify 'doctype'.");
            } else {
                DocumentHook.this._xmlRecognizers.add(xmlr);
            }
        }
    }

    private class ByRecognizerVisitor
    extends ElementVisitor {
        private ByRecognizerVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String recClass = context.getAttributeValue("recognizer-class");
            if (recClass == null || (recClass = recClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'recognizer-class'.");
                return;
            }
            MetaClass recMetaClass = DocumentHook.this.createMetaClass(context, recClass);
            DocumentHook.this._customRecognizers.add(recMetaClass);
        }
    }

    private class RootElementVisitor
    extends ElementVisitor {
        private RootElementVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String localName;
            XMLRootElementRecognizer rec = (XMLRootElementRecognizer)DocumentHook.this.getSuffixRecognizer(context);
            String ns = context.getAttributeValue("namespace");
            if (ns != null && ns.trim().length() == 0) {
                ns = null;
            }
            if ((localName = context.getAttributeValue("local-name")) == null || (localName = localName.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'local-name'.");
                return;
            }
            ElementName name = new ElementName(ns, localName);
            rec.addRootElement(name);
        }
    }

    private class DocTypeVisitor
    extends ElementVisitor {
        private DocTypeVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String systemId;
            XMLDocTypeRecognizer rec = (XMLDocTypeRecognizer)DocumentHook.this.getSuffixRecognizer(context);
            String publicId = context.getAttributeValue("public-id");
            if (publicId != null && publicId.trim().length() == 0) {
                publicId = null;
            }
            if ((systemId = context.getAttributeValue("system-id")) != null && systemId.trim().length() == 0) {
                systemId = null;
            }
            XMLDocType docType = new XMLDocType(publicId, systemId);
            rec.addDocType(docType);
        }
    }

    private final class SuffixVisitor
    extends ElementVisitor {
        private SuffixVisitor() {
        }

        @Override
        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text == null || (text = text.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Must provide text content for 'suffix'.");
                return;
            }
            SuffixRecognizer r = DocumentHook.this.getSuffixRecognizer(context);
            r.addSuffix(text);
        }
    }

    private final class ListenersVisitor
    extends ElementVisitor {
        private ListenersVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(DOCUMENT_LISTENER, new AbstractListenerVisitor(){

                @Override
                protected void listenerInfo(ElementContext context, ListenerInfo info) {
                    DocumentHook.this._documentListeners.add(info);
                }
            });
            context.registerChildVisitor(PROPERTY_LISTENER, new AbstractListenerVisitor(){

                @Override
                protected void listenerInfo(ElementContext context, ListenerInfo info) {
                    DocumentHook.this._propertyListeners.add(info);
                }
            });
        }
    }

    private abstract class AbstractListenerVisitor
    extends ElementVisitor {
        private AbstractListenerVisitor() {
        }

        @Override
        public final void start(ElementStartContext context) {
            String listenerClass = context.getAttributeValue("listener-class");
            if (listenerClass == null || (listenerClass = listenerClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'listener-class'.");
                return;
            }
            String sourceClass = context.getAttributeValue("source-class");
            ListenerInfo info = new ListenerInfo();
            info.setListenerClass(DocumentHook.this.createMetaClass(context, listenerClass));
            info.setSourceID(sourceClass);
            this.listenerInfo(context, info);
        }

        protected abstract void listenerInfo(ElementContext var1, ListenerInfo var2);
    }
}

