/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.OnDemandElementVisitor;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.MenuVisitor;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.SectionVisitor;

final class MenusVisitor
extends OnDemandElementVisitor {
    private static final ElementName MENUBAR = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menubar");
    private static final ElementName POPUP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "popup");
    static final String KEY_MENU_BAR = "menuBar";
    private ElementVisitor _menubarVisitor = new MenuBarVisitor();
    private ElementVisitor _menuVisitor = new MenuVisitor();
    private ElementVisitor _popupVisitor = new PopupVisitor();
    private ElementVisitor _sectionVisitor = new SectionVisitor();

    MenusVisitor() {
    }

    @Override
    protected void startImpl(ElementStartContext context) {
        context.registerChildVisitor(MENUBAR, this._menubarVisitor);
        context.registerChildVisitor(POPUP, this._popupVisitor);
    }

    private final class MenuBarVisitor
    extends ElementVisitor {
        private MenuBarVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()) == "") {
                this.log(context, Level.SEVERE, "Required attribute 'id' missing");
                return;
            }
            MenuModel model = (MenuModel)context.getScopeData().get("menuModel");
            MenuBar menuBar = model.findOrCreatePullDownMenu(id);
            context.getScopeData().put(MenusVisitor.KEY_MENU_BAR, menuBar);
            context.registerChildVisitor(MenuVisitor.MENU, MenusVisitor.this._menuVisitor);
        }
    }

    private final class PopupVisitor
    extends ElementVisitor {
        private PopupVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()) == "") {
                this.log(context, Level.SEVERE, "Required attribute 'id' missing");
                return;
            }
            MenuModel model = (MenuModel)context.getScopeData().get("menuModel");
            PopupMenu popup = model.findOrCreatePopupMenu(id);
            context.getScopeData().put("sectionContainer", popup);
            context.registerChildVisitor(SectionVisitor.SECTION, MenusVisitor.this._sectionVisitor);
        }
    }
}

