/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.LocationAdapterImpl;
import javax.ide.extension.spi.LocationImpl;
import javax.ide.extension.spi.LocatorWrapper;
import javax.ide.extension.spi.LocatorWrapperFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import oracle.ideimpl.xml.stream.XMLEventAllocatorImpl;

public class PullManifestParser {
    private static Logger LOG = Logger.getLogger("javax.ide.extension.spi");
    public static final String INTERRUPT_PARSE_CONTEXT_KEY = "oracle.ide.parse.interrupt";
    private final DefaultElementContext _context;
    private LocationAdapter _locator;
    private XMLEventAllocator _xmlEventAllocator;
    private static XMLInputFactory _xmlStreamInputFactory = null;
    private static LocatorWrapperFactory s_locatorWrapper = null;

    public PullManifestParser(DefaultElementContext initialContext) {
        this._context = initialContext;
    }

    public ElementContext getContext() {
        return this._context;
    }

    public void parse(InputStream inputSource, String source) throws ParserConfigurationException, XMLStreamException, IOException {
        this.parse(null, inputSource, source);
    }

    private static XMLInputFactory createXMLStreamInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        Object allocator = null;
        String xmlEventAllocatorFQN = System.getProperty("javax.xml.stream.util.XMLEventAllocator");
        if (xmlEventAllocatorFQN != null) {
            try {
                Class<?> clazz = Class.forName(xmlEventAllocatorFQN);
                allocator = (XMLEventAllocator)clazz.newInstance();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not instantiate " + xmlEventAllocatorFQN + ". Will use oracle.ideimpl.xml.stream.XMLEventAllocatorImpl", e);
            }
        }
        if (allocator == null) {
            allocator = new XMLEventAllocatorImpl();
        }
        factory.setEventAllocator((XMLEventAllocator)allocator);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XMLStreamReader reader, InputStream inputSource, String source) throws ParserConfigurationException, IOException, XMLStreamException {
        if (reader == null) {
            if (_xmlStreamInputFactory == null) {
                _xmlStreamInputFactory = PullManifestParser.createXMLStreamInputFactory();
            }
            this._xmlEventAllocator = _xmlStreamInputFactory.getEventAllocator();
            reader = _xmlStreamInputFactory.createXMLStreamReader(source, inputSource);
        }
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 1) {
                    this.setDocumentLocation(new LocationAdapterImpl(reader.getLocation()));
                    StartElement startElementEvent = this.getXMLEvent(reader).asStartElement();
                    boolean toContinue = this.startElement(reader.getNamespaceURI(), startElementEvent.getName().getLocalPart(), startElementEvent.getName().getLocalPart(), new StAXAttributesAdapter(startElementEvent));
                    if (toContinue) continue;
                    break;
                }
                if (event == 2) {
                    this.setDocumentLocation(new LocationAdapterImpl(reader.getLocation()));
                    EndElement endElementEvent = this.getXMLEvent(reader).asEndElement();
                    this.endElement(reader.getNamespaceURI(), endElementEvent.getName().getLocalPart(), endElementEvent.getName().getLocalPart());
                    continue;
                }
                if (event == 4) {
                    Characters chars = this.getXMLEvent(reader).asCharacters();
                    char[] charArray = chars.getData().toCharArray();
                    this.characters(charArray, 0, charArray.length);
                    continue;
                }
                if (event != 5) continue;
            }
        }
        finally {
            this._context.reset();
            reader.close();
        }
    }

    private XMLEvent getXMLEvent(XMLStreamReader reader) throws XMLStreamException {
        return this._xmlEventAllocator.allocate(reader);
    }

    private boolean startElement(String uri, String name, String qName, DefaultElementContext.Attributes attributes) {
        ElementVisitor visitor = this._context.getVisitorForStartElement(new ElementName(uri, name));
        this._context.beginElement(uri, name, attributes);
        if (visitor != null) {
            this.recordPosition(this._context);
            try {
                visitor.start(this._context);
            }
            catch (Throwable re) {
                if (re instanceof ThreadDeath) {
                    throw (ThreadDeath)re;
                }
                ExtensionLogRecord r = new ExtensionLogRecord(this._locator, Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                r.setThrown(re);
                this._context.getLogger().log(r);
            }
        }
        this._context.postBeginElement();
        if (Boolean.TRUE.equals(this._context.getScopeData().get(INTERRUPT_PARSE_CONTEXT_KEY))) {
            this.endElement(uri, name, qName);
            for (ElementName elementName : this._context.getElementPath()) {
                this.endElement(elementName.getNamespaceURI(), elementName.getLocalName(), elementName.getLocalName());
            }
            return false;
        }
        return true;
    }

    public void endElement(String uri, String name, String qName) {
        this._context.endElement(uri, name);
        ElementVisitor visitor = this._context.getVisitorForEndElement();
        if (visitor != null) {
            this.recordPosition(this._context);
            try {
                visitor.end(this._context);
            }
            catch (Throwable re) {
                if (re instanceof ThreadDeath) {
                    throw (ThreadDeath)re;
                }
                ExtensionLogRecord r = new ExtensionLogRecord(this._locator, Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                r.setThrown(re);
                this._context.getLogger().log(r);
            }
        }
        this._context.postEndElement();
    }

    public void characters(char[] ch, int start, int length) {
        this._context.appendCharacters(ch, start, length);
    }

    public void setDocumentLocation(LocationAdapter location) {
        this._locator = s_locatorWrapper != null ? s_locatorWrapper.wrapLocation(location) : location;
    }

    private void recordPosition(ElementContext context) {
        context.getScopeData().put("xml.locator", this._locator != null ? this._locator : null);
    }

    public static void setLocatorWrapperFactory(LocatorWrapperFactory factory) {
        s_locatorWrapper = factory;
    }

    public static Location copyLocator(Location location) {
        if (location == null) {
            return null;
        }
        if (location instanceof LocatorWrapper) {
            return ((LocatorWrapper)location).createSnapshotCopy();
        }
        return new LocationImpl(location.getPublicId(), location.getSystemId(), location.getColumnNumber(), location.getLineNumber(), location.getCharacterOffset());
    }

    private static class StAXAttributesAdapter
    implements DefaultElementContext.Attributes {
        private Collection<Attribute> m_attributes;
        private final StartElement m_startElement;

        StAXAttributesAdapter(StartElement startElement) {
            this.m_startElement = startElement;
            this.m_attributes = new ArrayList<Attribute>(1);
            Iterator<Attribute> attributeIterator = startElement.getAttributes();
            while (attributeIterator.hasNext()) {
                this.m_attributes.add(attributeIterator.next());
            }
        }

        @Override
        public String getValue(String key) {
            Attribute attribute = this.m_startElement.getAttributeByName(new QName(key));
            return attribute != null ? attribute.getValue() : null;
        }

        @Override
        public Iterator<Attribute> iterator() {
            return this.m_startElement.getAttributes();
        }
    }

    static class StAXAttribute
    implements Attribute {
        private final String m_name;
        private final QName m_qname;
        private final String m_value;
        private final String CDATA = "CDATA";

        StAXAttribute(String name, String value) {
            this.m_name = name;
            this.m_value = value;
            this.m_qname = new QName(this.m_name);
        }

        @Override
        public QName getName() {
            return this.m_qname;
        }

        @Override
        public String getValue() {
            return this.m_value;
        }

        @Override
        public String getDTDType() {
            return "CDATA";
        }

        @Override
        public boolean isSpecified() {
            return true;
        }

        @Override
        public int getEventType() {
            return 10;
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public boolean isStartElement() {
            return false;
        }

        @Override
        public boolean isAttribute() {
            return true;
        }

        @Override
        public boolean isNamespace() {
            return false;
        }

        @Override
        public boolean isEndElement() {
            return false;
        }

        @Override
        public boolean isEntityReference() {
            return false;
        }

        @Override
        public boolean isProcessingInstruction() {
            return false;
        }

        @Override
        public boolean isCharacters() {
            return false;
        }

        @Override
        public boolean isStartDocument() {
            return false;
        }

        @Override
        public boolean isEndDocument() {
            return false;
        }

        @Override
        public StartElement asStartElement() {
            return null;
        }

        @Override
        public EndElement asEndElement() {
            return null;
        }

        @Override
        public Characters asCharacters() {
            return null;
        }

        @Override
        public QName getSchemaType() {
            return null;
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) {
        }
    }
}

