/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.MacroExpander;
import javax.ide.util.MetaResourceString;

public class MinimalExtensionVisitor
extends BaseExtensionVisitor {
    private final Map<Extension, ExtensionSource> _sourcesByExtension = new LinkedHashMap<Extension, ExtensionSource>();
    private final Map<String, Extension> _idToMinimalExtensionMap = new HashMap<String, Extension>();

    public Map<Extension, ExtensionSource> getSourcesByExtension() {
        return this._sourcesByExtension;
    }

    public Map<String, Extension> getIdToMinimalExtensionMap() {
        return this._idToMinimalExtensionMap;
    }

    @Override
    public void start(ElementStartContext start) {
        MinimalExtension ext = (MinimalExtension)this.processExtension(start);
        if (ext != null) {
            start.registerChildVisitor(NAME_ELEMENT, ext.getNameVisitor());
        }
    }

    @Override
    public void extension(ElementContext context, Extension extension) {
        ExtensionSource source = (ExtensionSource)context.getScopeData().get("extSource");
        if (extension != null) {
            this._idToMinimalExtensionMap.put(extension.getID(), extension);
            this._sourcesByExtension.put(extension, source);
        }
    }

    @Override
    public void addToClasspath(ElementContext context, Extension extension, URI classpathEntry) {
    }

    @Override
    protected DefaultExtension createExtension(String id) {
        return new MinimalExtension(id);
    }

    protected class MinimalExtension
    extends DefaultExtension {
        private DeferredElementVisitorHook _nameVisitor;
        private MinimalNameVisitor _realNameVisitor;

        public MinimalExtension(String id) {
            super(id);
            this._nameVisitor = new DeferredElementVisitorHook();
            this._realNameVisitor = new MinimalNameVisitor();
        }

        public ElementVisitor getNameVisitor() {
            return this._nameVisitor;
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name == null) {
                this._nameVisitor.attachElementVisitor(this._realNameVisitor);
            }
            return super.getName();
        }
    }

    private class MinimalNameVisitor
    extends ElementVisitor {
        private MinimalNameVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String rsKey = this.getAttributeHelper(context, "rskey", true, false);
            context.getScopeData().put("rskey", rsKey);
        }

        @Override
        public void end(ElementEndContext context) {
            DefaultExtension extension = BaseExtensionVisitor.getExtension(context);
            DefaultElementContext dec = (DefaultElementContext)context;
            String rsKey = (String)context.getScopeData().get("rskey");
            Object rawName = null;
            rawName = rsKey != null ? "${" + rsKey + "}" : dec.getRawText();
            if (rawName != null) {
                extension.setRawName((String)rawName);
                extension.setName(dec.processText((String)rawName));
            }
            if (MacroExpander.containsMacro((String)rawName)) {
                extension.setName(new MetaResourceString(MinimalNameVisitor.getResourceBundle(context), MacroExpander.stripOffBrackets((String)rawName)));
            } else {
                extension.setName((String)rawName);
            }
        }
    }
}

