/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.LocationImpl;
import javax.ide.extension.spi.LocatorImpl;
import javax.xml.stream.Location;
import org.xml.sax.Locator;

public class LocationAdapterImpl
implements LocationAdapter {
    private final Location m_streamLocation;
    private final Locator m_saxLocator;

    public LocationAdapterImpl(Location loc) {
        if (loc == null) {
            throw new IllegalArgumentException("location passed in must not be null");
        }
        this.m_streamLocation = loc;
        this.m_saxLocator = null;
    }

    public LocationAdapterImpl(Locator loc) {
        if (loc == null) {
            throw new IllegalArgumentException("locator passed in must not be null");
        }
        this.m_saxLocator = loc;
        this.m_streamLocation = null;
    }

    @Override
    public int getLineNumber() {
        return this.m_streamLocation != null ? this.m_streamLocation.getLineNumber() : this.m_saxLocator.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.m_streamLocation != null ? this.m_streamLocation.getColumnNumber() : this.m_saxLocator.getColumnNumber();
    }

    @Override
    public int getCharacterOffset() {
        return this.m_streamLocation != null ? this.m_streamLocation.getCharacterOffset() : -1;
    }

    @Override
    public String getPublicId() {
        return this.m_streamLocation != null ? this.m_streamLocation.getPublicId() : this.m_saxLocator.getPublicId();
    }

    @Override
    public String getSystemId() {
        return this.m_streamLocation != null ? this.m_streamLocation.getSystemId() : this.m_saxLocator.getSystemId();
    }

    @Override
    public LocationAdapter copyMe() {
        if (this.m_streamLocation != null) {
            return new LocationAdapterImpl(new LocationImpl(this.m_streamLocation));
        }
        return new LocationAdapterImpl(new LocatorImpl(this.m_saxLocator));
    }
}

