/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.Stack;
import javax.ide.util.MetaClass;

public class DynamicHook
extends ExtensionHook {
    public final String sApplicationObjectKey = DynamicHook.class.getName() + ".appObjectKey";
    private static final boolean STRICT = Boolean.getBoolean("DynamicHook.strict");
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String ADD_METHOD_PREFIX = "add";
    private static final Class[] sObjectParamTypes = new Class[]{Object.class};
    private static final Class[] sStringParamTypes = new Class[]{String.class};
    private static final Class[] sClassParamTypes = new Class[]{MetaClass.class};
    private final Stack<StackObject> _applicationObjectStack = new Stack();
    private final Stack<boolean[]> _complexTypeIndicatorStack = new Stack();
    private ClassLoader _classLoader;
    private final List<ElementTypeResolver> _resolvers = new ArrayList<ElementTypeResolver>(5);
    private final ReentrantLock _handlerLock = new ReentrantLock();
    private DeferredContext _deferredContext = null;

    public DynamicHook(Object rootObject) {
        this._applicationObjectStack.push(new StackObject(rootObject));
    }

    public DynamicHook(Object rootObject, ClassLoader classLoader) {
        this(rootObject);
        this._classLoader = classLoader;
    }

    public DynamicHook(Object rootObject, ClassLoader classLoader, ElementTypeResolver resolver) {
        this(rootObject, classLoader);
        this._resolvers.add(resolver);
    }

    public void registerElementTypeResolver(ElementTypeResolver resolver) {
        this._resolvers.add(resolver);
    }

    protected ElementVisitorFactory createVisitorFactory() {
        final String hookNamespaceURI = this.getHookNamespaceURI();
        if (hookNamespaceURI == null) {
            return null;
        }
        return new ElementVisitorFactory(){

            @Override
            public ElementVisitor getVisitor(ElementName name) {
                String namespaceURI = name.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.equals(hookNamespaceURI)) {
                    return DynamicHook.this;
                }
                return null;
            }
        };
    }

    protected String getHookNamespaceURI() {
        return null;
    }

    private final boolean isProcessingDeferredTopLevel() {
        return this._deferredContext != null && this.peekParent() == this._deferredContext.getDynamicMetaClass().getParent();
    }

    @Override
    public void start(ElementStartContext context) {
        ElementVisitorFactory visitorFactory;
        this._handlerLock.lock();
        if ((this._deferredContext == null && this._complexTypeIndicatorStack.isEmpty() || this.isProcessingDeferredTopLevel()) && (visitorFactory = this.createVisitorFactory()) != null) {
            context.registerVisitorFactory(visitorFactory);
        }
        MetaClass strictRuntimeMetaType = this.getRuntimeMetaType(context, true);
        this._complexTypeIndicatorStack.push(new boolean[]{strictRuntimeMetaType != null});
        if (strictRuntimeMetaType != null) {
            boolean instantiate = true;
            if (!this.isProcessingDeferredTopLevel()) {
                if (STRICT) {
                    try {
                        strictRuntimeMetaType.toClass();
                        this.findMethodEx(this.peekParent(), context.getElementName().getLocalName(), sObjectParamTypes);
                    }
                    catch (ClassNotFoundException cnfe) {
                        instantiate = false;
                    }
                    catch (NoSuchMethodException nsme) {
                        instantiate = false;
                    }
                } else {
                    try {
                        this.findMethodEx(this.peekParent(), context.getElementName().getLocalName(), sClassParamTypes);
                        instantiate = false;
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
            }
            if (instantiate) {
                Object o = null;
                Exception e = null;
                try {
                    o = this.getApplicationObject(this.getRuntimeMetaType(context), context);
                    if (this._deferredContext != null && this.isProcessingDeferredTopLevel()) {
                        this._deferredContext.setApplicationObject(o);
                    }
                }
                catch (InstantiationException ie) {
                    if (this._deferredContext != null) {
                        this._deferredContext.setInstantiationException(ie);
                    }
                    e = ie;
                }
                catch (IllegalAccessException iae) {
                    if (this._deferredContext != null) {
                        this._deferredContext.setIllegalAccessException(iae);
                    }
                    e = iae;
                }
                catch (ClassNotFoundException cnfe) {
                    if (this._deferredContext != null) {
                        this._deferredContext.setClassNotFoundException(cnfe);
                    }
                    e = cnfe;
                }
                catch (Exception ex) {
                    e = ex;
                }
                if (e != null) {
                    this._applicationObjectStack.push(new StackObject((Object)null));
                    return;
                }
                this.invokePreInitialize(this.peekParent(), o);
                this._applicationObjectStack.push(new StackObject(o));
                context.getScopeData().put(this.sApplicationObjectKey, o);
                this.handleComplexElementStart(o, context);
            } else {
                DynamicMetaClass clazz = new DynamicMetaClass(this.getRuntimeMetaType(context), this._applicationObjectStack.peek().getObject());
                clazz.getDeferredHook().start(context);
                this._applicationObjectStack.push(new StackObject(clazz));
            }
        } else {
            this.handleSimpleElementStart(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(ElementEndContext context) {
        try {
            boolean isComplex = this._complexTypeIndicatorStack.pop()[0];
            if (isComplex) {
                StackObject stackObject = this._applicationObjectStack.pop();
                Object childObject = stackObject.getObject();
                DynamicMetaClass childClass = stackObject.getDynamicMetaClass();
                if (childObject == null && childClass == null) {
                    this.log(context, Level.SEVERE, "No application object or MetaClass");
                    return;
                }
                Object parent = this.peekParent();
                if (parent == null) {
                    this.log(context, Level.SEVERE, "No parent application object");
                    return;
                }
                if (childObject != null) {
                    this.invokePostInitialize(childObject);
                    if (!this.isProcessingDeferredTopLevel()) {
                        this.attachObject(parent, childObject, context);
                    }
                    this.handleComplexElementEnd(context);
                } else {
                    childClass.getDeferredHook().end(context);
                    if (!this.isProcessingDeferredTopLevel()) {
                        this.attachClass(parent, childClass, context);
                    }
                }
            } else {
                Object parent = this.peekParent();
                if (parent != null) {
                    this.attachData(parent, context.getText(), context);
                }
                this.handleSimpleElementEnd(context);
            }
        }
        finally {
            this._handlerLock.unlock();
        }
    }

    private final Object peekParent() {
        return this._applicationObjectStack.peek().getObject();
    }

    protected void handleComplexElementStart(Object applicationObject, ElementStartContext context) {
    }

    protected void handleComplexElementEnd(ElementEndContext context) {
    }

    protected void handleSimpleElementStart(ElementStartContext context) {
    }

    protected void handleSimpleElementEnd(ElementEndContext context) {
    }

    protected <T> MetaClass<T> getRuntimeMetaType(ElementStartContext context) {
        return this.getRuntimeMetaType(context, false);
    }

    private final <T> MetaClass<T> getRuntimeMetaType(ElementStartContext context, boolean strict) {
        Class type = this.getRuntimeType(context);
        String className = type != null ? type.getName() : context.getAttributeValue(ATTRIBUTE_CLASS);
        return className != null ? new MetaClass(this.getHandlerClassLoader(context, strict), className) : null;
    }

    @Deprecated
    protected Class getRuntimeType(ElementStartContext context) {
        Class type = null;
        String classAttribute = context.getAttributeValue(ATTRIBUTE_CLASS);
        if (classAttribute != null) {
            try {
                type = Class.forName(classAttribute, true, this.getHandlerClassLoader(context));
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        } else {
            ListIterator<ElementTypeResolver> it = this._resolvers.listIterator(this._resolvers.size());
            while (it.hasPrevious() && type == null) {
                type = it.previous().resolveType(context.getElementName());
            }
        }
        return type;
    }

    private final ClassLoader getHandlerClassLoader(ElementContext context) {
        return this.getHandlerClassLoader(context, STRICT);
    }

    private final ClassLoader getHandlerClassLoader(ElementContext context, boolean strict) {
        if (this._classLoader != null) {
            return this._classLoader;
        }
        return strict ? this.getClass().getClassLoader() : this.getMetaClassLoader(context);
    }

    protected <T> T getApplicationObject(MetaClass<T> runtimeMetaType, ElementStartContext context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            return runtimeMetaType.newInstance();
        }
        catch (InstantiationException ie) {
            this.log(context, Level.SEVERE, "Unable to instantiate class: " + runtimeMetaType.getClassName());
            throw ie;
        }
        catch (IllegalAccessException iae) {
            this.log(context, Level.SEVERE, "Unable to access class or constructor: " + runtimeMetaType.getClassName());
            throw iae;
        }
        catch (ClassNotFoundException cnfe) {
            this.log(context, Level.SEVERE, "Unable to load class: " + runtimeMetaType.getClassName());
            throw cnfe;
        }
    }

    @Deprecated
    protected Object getApplicationObject(Class runtimeType, ElementStartContext context) {
        try {
            return runtimeType.newInstance();
        }
        catch (Exception e) {
            this.log(context, Level.SEVERE, "Unable to instantiate class: " + runtimeType.getName());
            e.printStackTrace();
            return null;
        }
    }

    protected void attachClass(Object parent, MetaClass metaClass, ElementEndContext context) {
        Method m = this.findMethod(context, parent, context.getElementName().getLocalName(), sClassParamTypes);
        if (m == null) {
            return;
        }
        try {
            m.invoke(parent, metaClass);
        }
        catch (InvocationTargetException ite) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach class: ").append(metaClass.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(ite.getTargetException().getClass().getName()).append(": ");
            b.append(ite.getTargetException().getMessage());
            this.log(context, Level.SEVERE, b.toString());
        }
        catch (Exception e) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach class: ").append(metaClass.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(e.getClass().getName()).append(": ").append(e.getMessage());
            this.log(context, Level.SEVERE, b.toString());
        }
    }

    protected void attachObject(Object parent, Object child, ElementEndContext context) {
        Method m = this.findMethod(context, parent, context.getElementName().getLocalName(), sObjectParamTypes);
        if (m == null) {
            return;
        }
        try {
            m.invoke(parent, child);
        }
        catch (InvocationTargetException ite) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach child object: ").append(child.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(ite.getTargetException().getClass().getName()).append(": ");
            b.append(ite.getTargetException().getMessage());
            this.log(context, Level.SEVERE, b.toString());
        }
        catch (Exception e) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach child object: ").append(child.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(e.getClass().getName()).append(": ").append(e.getMessage());
            this.log(context, Level.SEVERE, b.toString());
        }
    }

    protected void attachData(Object parent, String data, ElementEndContext context) {
        Method m = this.findMethod(context, parent, context.getElementName().getLocalName(), sStringParamTypes);
        if (m == null) {
            return;
        }
        try {
            m.invoke(parent, data);
        }
        catch (InvocationTargetException ite) {
            this.log(context, Level.SEVERE, "Unable to attach data '" + data + "' for simple element " + context.getElementName().getLocalName());
            ite.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            this.log(context, Level.SEVERE, "Unable to attach data '" + data + "' for simple element " + context.getElementName().getLocalName());
            e.printStackTrace();
        }
    }

    protected void invokePreInitialize(Object parent, Object target) {
    }

    protected void invokePostInitialize(Object target) {
    }

    protected Method findMethod(ElementContext context, Object o, String elementName, Class[] paramTypes) {
        try {
            return this.findMethodEx(o, elementName, paramTypes);
        }
        catch (NoSuchMethodException nme) {
            StringBuilder sb = new StringBuilder("(");
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(paramTypes[i].getName());
            }
            sb.append(")");
            this.log(context, Level.SEVERE, "Class " + o.getClass().getName() + " has no set or add method for element named " + elementName + " matching signature " + this.getMethodName(SET_METHOD_PREFIX, elementName) + sb.toString() + " or " + this.getMethodName(ADD_METHOD_PREFIX, elementName) + sb.toString());
            nme.printStackTrace();
            return null;
        }
    }

    private final Method findMethodEx(Object o, String elementName, Class[] paramTypes) throws NoSuchMethodException {
        try {
            return o.getClass().getMethod(this.getMethodName(SET_METHOD_PREFIX, elementName), paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            return o.getClass().getMethod(this.getMethodName(ADD_METHOD_PREFIX, elementName), paramTypes);
        }
    }

    protected String getMethodName(String prefix, String elementName) {
        char[] name = new char[prefix.length() + elementName.length()];
        for (int i = 0; i < prefix.length(); ++i) {
            name[i] = prefix.charAt(i);
        }
        boolean nextUpper = true;
        int nameIndex = prefix.length();
        for (int i = 0; i < elementName.length(); ++i) {
            if (Character.isJavaIdentifierPart(elementName.charAt(i))) {
                if (nextUpper) {
                    name[nameIndex] = Character.toUpperCase(elementName.charAt(i));
                    nextUpper = false;
                } else {
                    name[nameIndex] = elementName.charAt(i);
                }
                ++nameIndex;
                continue;
            }
            nextUpper = true;
        }
        return new String(name).trim();
    }

    private static final class DeferredContext {
        private final DynamicMetaClass _dynamicMetaClass;
        private final ElementContext _context;
        private Object _applicationObject;
        private ExceptionWrapper _exceptionWrapper;

        DeferredContext(DynamicMetaClass dynamicMetaClass, ElementContext context) {
            this._dynamicMetaClass = dynamicMetaClass;
            this._context = context;
        }

        final DynamicMetaClass getDynamicMetaClass() {
            return this._dynamicMetaClass;
        }

        final void setApplicationObject(Object applicationObject) {
            this._applicationObject = applicationObject;
        }

        final Object getApplicationObject() {
            return this._applicationObject;
        }

        final void setInstantiationException(InstantiationException ie) {
            this.setFinalExceptionWrapper(new ExceptionWrapper(ie));
        }

        final void setIllegalAccessException(IllegalAccessException iae) {
            this.setFinalExceptionWrapper(new ExceptionWrapper(iae));
        }

        final void setClassNotFoundException(ClassNotFoundException cnfe) {
            this.setFinalExceptionWrapper(new ExceptionWrapper(cnfe));
        }

        final void setFinalExceptionWrapper(ExceptionWrapper exceptionWrapper) {
            if (this._exceptionWrapper == null) {
                this._exceptionWrapper = exceptionWrapper;
            }
        }

        final void rethrowExceptions() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            if (this._exceptionWrapper == null) {
                return;
            }
            if (this._exceptionWrapper._ie != null) {
                throw this._exceptionWrapper._ie;
            }
            if (this._exceptionWrapper._iae != null) {
                throw this._exceptionWrapper._iae;
            }
            if (this._exceptionWrapper._cnfe != null) {
                throw this._exceptionWrapper._cnfe;
            }
        }

        private class ExceptionWrapper {
            private InstantiationException _ie;
            private IllegalAccessException _iae;
            private ClassNotFoundException _cnfe;

            ExceptionWrapper(InstantiationException ie) {
                this._ie = ie;
            }

            ExceptionWrapper(IllegalAccessException iae) {
                this._iae = iae;
            }

            ExceptionWrapper(ClassNotFoundException cnfe) {
                this._cnfe = cnfe;
            }
        }
    }

    private static final class StackObject {
        private final Object _object;
        private final DynamicMetaClass _dynamicMetaClass;

        StackObject(Object object) {
            this(object, null);
        }

        StackObject(DynamicMetaClass dynamicMetaClass) {
            this(null, dynamicMetaClass);
        }

        private StackObject(Object object, DynamicMetaClass dynamicMetaClass) {
            this._object = object;
            this._dynamicMetaClass = dynamicMetaClass;
        }

        final Object getObject() {
            return this._object;
        }

        final DynamicMetaClass getDynamicMetaClass() {
            return this._dynamicMetaClass;
        }
    }

    private final class DynamicMetaClass<T>
    extends MetaClass<T> {
        private final DeferredElementVisitorHook _deferredHook;
        private final Object _parent;

        DynamicMetaClass(MetaClass<T> metaClass, Object parent) {
            super(metaClass.getClassLoader(), metaClass.getClassName());
            this._deferredHook = new DeferredElementVisitorHook();
            this._parent = parent;
        }

        final DeferredElementVisitorHook getDeferredHook() {
            return this._deferredHook;
        }

        final Object getParent() {
            return this._parent;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DynamicMetaClass)) {
                return false;
            }
            DynamicMetaClass dc = (DynamicMetaClass)object;
            return this.nullSafeEquals(dc.getClassLoader(), this.getClassLoader()) && this.nullSafeEquals(dc.getClassName(), this.getClassName()) && this.nullSafeEquals(dc._parent, this._parent);
        }

        private final boolean nullSafeEquals(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T newInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            DynamicHook.this._handlerLock.lock();
            try {
                DynamicHook.this._applicationObjectStack.push(new StackObject(this.getParent()));
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                DefaultElementContext context = (DefaultElementContext)extensionRegistry.createInitialContext();
                DynamicHook.this._deferredContext = new DeferredContext(this, context);
                this._deferredHook.attachElementVisitor(DynamicHook.this);
                DynamicHook.this._deferredContext.rethrowExceptions();
                Object object = DynamicHook.this._deferredContext.getApplicationObject();
                return (T)object;
            }
            finally {
                DynamicHook.this._applicationObjectStack.pop();
                DynamicHook.this._deferredContext = null;
                DynamicHook.this._handlerLock.unlock();
            }
        }

        @Override
        public Class toClass() {
            throw new UnsupportedOperationException("Access to Class of dynamic MetaClass illegal");
        }
    }

    public static interface ElementTypeResolver {
        public Class resolveType(ElementName var1);
    }
}

