/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.editor.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.editor.spi.DisplayInfo;
import javax.ide.editor.spi.MappingInfo;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.util.MetaClass;

public final class EditorHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-hook");
    private static final ElementName EDITORS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editors");
    private static final ElementName EDITOR = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor");
    private static final ElementName NAME = new ElementName("http://jcp.org/jsr/198/extension-manifest", "name");
    private static final ElementName MAPPINGS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mappings");
    private static final ElementName MAPPING = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mapping");
    private static final ElementName OPEN_WITH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "open-with");
    private static final ElementName LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-listeners");
    private static final ElementName EDITOR_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-listener");
    private ElementVisitor _editorsVisitor = new EditorsVisitor();
    private ElementVisitor _editorVisitor = new EditorVisitor();
    private ElementVisitor _mappingsVisitor = new MappingsVisitor();
    private ElementVisitor _mappingVisitor = new MappingVisitor();
    private ElementVisitor _openWithVisitor = new OpenWithVisitor();
    private ElementVisitor _listenersVisitor = new ListenersVisitor();
    private ElementVisitor _listenerVisitor = new ListenerVisitor();
    private static final String KEY_DOCUMENT_CLASS = "documentClass";
    private static final String KEY_OPEN_WITH_COLL = "openWithColl";
    public static final String ANY_EDITOR_CLASS = "_anyListener";
    private Map _editorsByClassName = new HashMap();
    private Map _mappings = new HashMap();
    private Map _listeners = new HashMap();
    private Map _editorDisplayInfo = new HashMap();

    public DisplayInfo getDisplayInfo(MetaClass editorClass) {
        return (DisplayInfo)this._editorDisplayInfo.get(editorClass);
    }

    public Collection getEditors() {
        return this._editorsByClassName.values();
    }

    public MetaClass getEditorClass(String className) {
        return (MetaClass)this._editorsByClassName.get(className);
    }

    public Collection getMappedDocumentClasses() {
        return this._mappings.keySet();
    }

    public Collection getEditorsForDocClass(Class documentClass) {
        return (Collection)this._mappings.get(documentClass.getName());
    }

    public Map getListeners() {
        return this._listeners;
    }

    @Override
    public void start(ElementStartContext context) {
        context.registerChildVisitor(EDITORS, this._editorsVisitor);
        context.registerChildVisitor(MAPPINGS, this._mappingsVisitor);
        context.registerChildVisitor(LISTENERS, this._listenersVisitor);
    }

    private class EditorsVisitor
    extends ElementVisitor {
        private EditorsVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(EDITOR, EditorHook.this._editorVisitor);
        }
    }

    private class EditorVisitor
    extends ElementVisitor {
        private EditorVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String editorClass = context.getAttributeValue("editor-class");
            if (editorClass == null || (editorClass = editorClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'editor-class' attribute.");
                return;
            }
            ClassLoader cl = ElementVisitor.getClassLoader(context);
            final MetaClass editorMetaClass = new MetaClass(cl, editorClass);
            EditorHook.this._editorsByClassName.put(editorClass, editorMetaClass);
            context.registerChildVisitor(NAME, new I18NStringVisitor(){

                @Override
                protected void string(ElementContext context, String text) {
                    EditorHook.this._editorDisplayInfo.put(editorMetaClass, new DisplayInfo(text));
                }
            });
        }
    }

    private class MappingsVisitor
    extends ElementVisitor {
        private MappingsVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(MAPPING, EditorHook.this._mappingVisitor);
        }
    }

    private class MappingVisitor
    extends ElementVisitor {
        private MappingVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String docClass = context.getAttributeValue("document-class");
            if (docClass == null || (docClass = docClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'document-class' attribute.");
            } else {
                context.getScopeData().put(EditorHook.KEY_DOCUMENT_CLASS, docClass);
                ArrayList mappings = (ArrayList)EditorHook.this._mappings.get(docClass);
                if (mappings == null) {
                    mappings = new ArrayList();
                    EditorHook.this._mappings.put(docClass, mappings);
                }
                context.getScopeData().put(EditorHook.KEY_OPEN_WITH_COLL, mappings);
                context.registerChildVisitor(OPEN_WITH, EditorHook.this._openWithVisitor);
            }
        }
    }

    private class OpenWithVisitor
    extends ElementVisitor {
        private OpenWithVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            String editorClass = context.getAttributeValue("editor-class");
            if (editorClass == null || (editorClass = editorClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'editor-class'");
                return;
            }
            String isPreferred = context.getAttributeValue("preferred");
            boolean preferred = isPreferred == null ? false : Boolean.valueOf(isPreferred);
            MappingInfo mi = new MappingInfo(editorClass, preferred);
            List mappings = (List)context.getScopeData().get(EditorHook.KEY_OPEN_WITH_COLL);
            mappings.add(mi);
        }
    }

    private class ListenersVisitor
    extends ElementVisitor {
        private ListenersVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(EDITOR_LISTENER, EditorHook.this._listenerVisitor);
        }
    }

    private class ListenerVisitor
    extends ElementVisitor {
        private ListenerVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            ArrayList listeners;
            String sourceClass = context.getAttributeValue("source-class");
            String listenerClass = context.getAttributeValue("listener-class");
            if (listenerClass == null) {
                this.log(context, Level.SEVERE, "Required attribute 'listener-class' missing.");
                return;
            }
            ClassLoader cl = ElementVisitor.getClassLoader(context);
            MetaClass mc = new MetaClass(cl, listenerClass);
            if (sourceClass == null) {
                sourceClass = EditorHook.ANY_EDITOR_CLASS;
            }
            if ((listeners = (ArrayList)EditorHook.this._listeners.get(sourceClass)) == null) {
                listeners = new ArrayList();
                EditorHook.this._listeners.put(sourceClass, listeners);
            }
            listeners.add(mc);
        }
    }
}

