/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BICStubs;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleType;
import oracle.sql.NUMBER;

public class ImmutableProcessor {
    public static void delExpRows(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        String query = BICStubs.getQuery("DELETE_EXPIRED_ROWS", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/immutableQueries.xml");
        String[] queryType = model.getCommand().getSql().toUpperCase().split(" ");
        String type = null;
        Id tableNameID = null;
        if (queryType[0].equalsIgnoreCase("immutable_table") || queryType[0].equalsIgnoreCase("im")) {
            type = "IMMUTABLE";
            tableNameID = BICOptions.tableName_immutable_req.getId();
        } else if (queryType[0].equalsIgnoreCase("blockchain_table") || queryType[0].equalsIgnoreCase("bl")) {
            type = "BLOCKCHAIN";
            tableNameID = BICOptions.tableName_blockchain_req.getId();
        }
        if (query != null) {
            query = String.format(query, type);
        }
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        InVar.add(tableNameID);
        InVar.add(BICOptions.beforeTimestamp.getId());
        OutBinds.add(BICOptions.deleted_rows_count.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, null);
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.NUMBER);
                returnStatement.executeUpdate();
                NUMBER num_of_rows_deleted = returnStatement.getNUMBER(binds.size() + 1);
                if (binds.get(BICOptions.beforeTimestamp.getId()).equals("")) {
                    binds.put(BICOptions.beforeTimestamp.getId(), OffsetDateTime.now());
                }
                model.getContext().writeln("Command executed successfully.");
                model.getContext().writeln("Deleted " + num_of_rows_deleted.stringValue() + " expired rows from '" + binds.get(BICOptions.schema.getId()) + "." + binds.get(tableNameID) + "' " + (type != null ? type.toLowerCase() : null) + " table before '" + binds.get(BICOptions.beforeTimestamp.getId()).toString() + "' timestamp.");
                BICStubs.populateBindVariableStringValue(model, BICOptions.deleted_rows_count, num_of_rows_deleted.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    public static void addIntPartitioning(BICModel model, ParsedCommand parsedCommand) throws BICException {
        String query = BICStubs.getQuery("ADD_INTERVAL_PARTITIONING", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/immutableQueries.xml");
        if (query == null) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), "ADD_INTERVAL_PARTITIONING' or 'addIntPartition", model.getDbVersion())});
        }
        String[] queryType = model.getCommand().getSql().toUpperCase().split(" ");
        String type = null;
        Id tableNameID = null;
        if (queryType[0].equalsIgnoreCase("immutable_table") || queryType[0].equalsIgnoreCase("im")) {
            type = "IMMUTABLE";
            tableNameID = BICOptions.tableName_immutable_req.getId();
        } else if (queryType[0].equalsIgnoreCase("blockchain_table") || queryType[0].equalsIgnoreCase("bl")) {
            type = "BLOCKCHAIN";
            tableNameID = BICOptions.tableName_blockchain_req.getId();
        }
        query = String.format(query, type);
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        InVar.add(tableNameID);
        InVar.add(BICOptions.interval_number.getId());
        InVar.add(BICOptions.interval_frequency.getId());
        InVar.add(BICOptions.first_high_timestamp_immutable.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, null, null);
        DBUtil dBUtil = DBUtil.getInstance((Connection)model.getConnection());
        dBUtil.execute(query, new ArrayList<Object>(binds.values()));
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        model.getContext().writeln("Command executed successfully.");
        model.getContext().writeln("Table '" + binds.get(tableNameID) + "' partitioned successfully.");
    }
}

