/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.JavaFormat;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.RepeatComboBoxModel;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleRepeatPanel;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class ScheduleDialog
extends DialogDisplayer<AbstractNode> {
    private Logger theLogger = Logger.getLogger(this.getClass().getName());
    private JDialog dialog;
    private ScheduleWorkflowDialog parent;
    private boolean isEdit;
    private DateTimeEditor startTimeEditor;
    private DateTimeEditor endTimeEditor;
    private JSpinner spinner;
    private JMultiLineLabel repeatTextArea;
    private String curRepeatSel;
    private SchedulerModel model;
    private boolean isUIRendering = false;
    private static String SCHEDULER_END_REPEAT_OPTION_NEVER = DialogsLrb.get("SCHEDULER_END_REPEAT_OPTION_NEVER");
    private static String SCHEDULER_END_REPEAT_OPTION_ON_DATE = DialogsLrb.get("SCHEDULER_END_REPEAT_OPTION_ON_DATE");
    private CalendarPopupButton EndRepeatCalendarButton;
    private CalendarPopupButton StartDateCalendarButton;
    private JPanel jCustomRepeatPanel;
    private JComboBox jEndRepeatComboBox;
    private JLabel jEndRepeatLabel;
    private JPanel jEndRepeatPanel;
    private JLabel jNameLabel;
    private JTextField jNameTextField;
    private JComboBox jRepeatComboBox;
    private JLabel jRepeatLabel;
    private JLabel jStartDateLabel;
    private JPanel jStartDatePanel;

    public ScheduleDialog(ScheduleWorkflowDialog scheduleWorkflowDialog, Context context, SchedulerModel schedulerModel, boolean bl) {
        super(context, null);
        this.parent = scheduleWorkflowDialog;
        this.isEdit = bl;
        this.model = schedulerModel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jNameLabel = new JLabel();
        this.jNameTextField = new JTextField();
        this.jStartDateLabel = new JLabel();
        this.jStartDatePanel = new JPanel();
        this.StartDateCalendarButton = new CalendarPopupButton();
        this.jRepeatLabel = new JLabel();
        this.jRepeatComboBox = new JComboBox();
        this.jCustomRepeatPanel = new JPanel();
        this.jEndRepeatLabel = new JLabel();
        this.jEndRepeatComboBox = new JComboBox();
        this.jEndRepeatPanel = new JPanel();
        this.EndRepeatCalendarButton = new CalendarPopupButton();
        this.setPreferredSize(new Dimension(400, 200));
        this.jNameLabel.setLabelFor(this.jNameTextField);
        this.jNameLabel.setText("Name:");
        this.jStartDateLabel.setLabelFor(this.jStartDatePanel);
        this.jStartDateLabel.setText("Start Date:");
        this.jStartDatePanel.setPreferredSize(new Dimension(60, 20));
        this.jStartDatePanel.setLayout(new BorderLayout());
        this.StartDateCalendarButton.setBorder(null);
        this.StartDateCalendarButton.setBorderPainted(false);
        this.StartDateCalendarButton.setContentAreaFilled(false);
        this.jRepeatLabel.setLabelFor(this.jRepeatComboBox);
        this.jRepeatLabel.setText("Repeat:");
        this.jRepeatLabel.setMaximumSize(new Dimension(54, 14));
        this.jRepeatLabel.setMinimumSize(new Dimension(54, 14));
        this.jRepeatLabel.setPreferredSize(new Dimension(54, 14));
        this.jRepeatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Every Day", "Every Week", "Custom"}));
        this.jRepeatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleDialog.this.jRepeatComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jCustomRepeatPanel);
        this.jCustomRepeatPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        this.jEndRepeatLabel.setLabelFor(this.jEndRepeatComboBox);
        this.jEndRepeatLabel.setText("End Repeat:");
        this.jEndRepeatLabel.setMaximumSize(new Dimension(54, 14));
        this.jEndRepeatLabel.setMinimumSize(new Dimension(54, 14));
        this.jEndRepeatLabel.setPreferredSize(new Dimension(54, 14));
        this.jEndRepeatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Never", "After", "On Date"}));
        this.jEndRepeatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleDialog.this.jEndRepeatComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEndRepeatPanel.setPreferredSize(new Dimension(60, 20));
        this.jEndRepeatPanel.setLayout(new BorderLayout());
        this.EndRepeatCalendarButton.setBorder(null);
        this.EndRepeatCalendarButton.setBorderPainted(false);
        this.EndRepeatCalendarButton.setContentAreaFilled(false);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jStartDateLabel, GroupLayout.Alignment.LEADING, -1, 68, Short.MAX_VALUE).addComponent(this.jRepeatLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCustomRepeatPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jRepeatComboBox, GroupLayout.Alignment.LEADING, 0, 150, Short.MAX_VALUE).addComponent(this.jStartDatePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.StartDateCalendarButton, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jNameLabel, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNameTextField, -2, 150, -2)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jEndRepeatLabel, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEndRepeatComboBox, -2, 97, -2).addGap(8, 8, 8).addComponent(this.jEndRepeatPanel, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.EndRepeatCalendarButton, -2, -1, -2))).addGap(0, 28, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jStartDateLabel, -2, 21, -2).addComponent(this.jStartDatePanel, -2, -1, -2).addComponent((Component)this.StartDateCalendarButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRepeatLabel, -2, -1, -2).addComponent(this.jRepeatComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCustomRepeatPanel, -2, -1, -2).addGap(8, 8, 8).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.EndRepeatCalendarButton, -2, -1, -2).addComponent(this.jEndRepeatComboBox, -2, -1, -2).addComponent(this.jEndRepeatLabel, -2, -1, -2).addComponent(this.jEndRepeatPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jRepeatComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isUIRendering) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        SchedulerModel.Repeat repeat = null;
        if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_NONE)) {
            this.model.setRepeat(repeat);
        } else if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_DAY)) {
            repeat = new SchedulerModel.RepeatDailyBasic();
            this.model.setRepeat(repeat);
        } else if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_WEEK)) {
            repeat = new SchedulerModel.RepeatWeeklyBasic();
            this.model.setRepeat(repeat);
        } else if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM)) {
            ScheduleRepeatPanel scheduleRepeatPanel = new ScheduleRepeatPanel(this.getContext(), this.dialog, this.model);
            scheduleRepeatPanel.showAsDialog(this);
        }
        this.updateRepeatOption();
    }

    private void jEndRepeatComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isUIRendering) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        if (string.equals(SCHEDULER_END_REPEAT_OPTION_NEVER)) {
            this.model.setEndRepeat(null);
        } else if (string.equals(SCHEDULER_END_REPEAT_OPTION_ON_DATE)) {
            this.model.setEndRepeat(this.endTimeEditor.getCalendar());
        }
        this.updateEndRepeatDateOption(this.model.getEndRepeat());
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        jEWTDialog.setResizable(true);
        this.dialog = jEWTDialog;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_SCHEDULE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "define_schedule_dialog";
    }

    @Override
    public void initUI() {
        this.isUIRendering = true;
        String string = this.model.getScheduleName();
        this.jNameTextField.setText(string);
        if (!this.isEdit) {
            this.jNameTextField.setEditable(true);
        } else {
            this.jNameTextField.setEditable(false);
        }
        Locale locale = this.model.getLocale();
        GregorianCalendar gregorianCalendar = this.model.getStartDate();
        this.startTimeEditor = new DateTimeEditor(gregorianCalendar.getTime(), (Calendar)gregorianCalendar, JavaFormat.getDateFormat((OraTemporalDatum.Precision)OraTemporalDatum.Precision.MINUTE, (Locale)locale));
        this.startTimeEditor.setEnabled(true);
        this.startTimeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Date) {
                    GregorianCalendar gregorianCalendar = ScheduleDialog.this.model.getStartDate();
                    gregorianCalendar.setTime((Date)object);
                }
            }
        });
        this.jStartDatePanel.add((Component)this.startTimeEditor);
        this.StartDateCalendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel calendarPanel = ScheduleDialog.this.StartDateCalendarButton.getCalendarPanel();
                calendarPanel.setMultiSelect(false);
                calendarPanel.setShowTime(false);
                calendarPanel.setShowTimeZone(false);
                GregorianCalendar gregorianCalendar = ScheduleDialog.this.model.getStartDate();
                calendarPanel.setSelectedDate(gregorianCalendar.getTime());
                calendarPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if ("DOUBLE_CLICK_COMMAND".equals(actionEvent.getActionCommand())) {
                            Date[] dateArray = ScheduleDialog.this.StartDateCalendarButton.getSelectedDates();
                            for (int i = 0; i < dateArray.length; ++i) {
                                Date date = dateArray[i];
                                GregorianCalendar gregorianCalendar = ScheduleDialog.this.model.getStartDate();
                                gregorianCalendar.setTime(date);
                                ScheduleDialog.this.startTimeEditor.setCalendar((Calendar)gregorianCalendar);
                            }
                        }
                    }
                });
                Container container = calendarPanel.getParent();
                do {
                    if (container == null || !(container instanceof JDialog)) continue;
                    ((JDialog)container).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    break;
                } while ((container = container.getParent()) != null);
            }
        });
        this.spinner = new JSpinner(new SpinnerNumberModel(this.model.getMaxRuns(), 1, 1000, 1));
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                Integer n = (Integer)jSpinner.getValue();
                ScheduleDialog.this.model.setMaxRuns(n);
            }
        });
        gregorianCalendar = this.model.getEndDate();
        this.endTimeEditor = new DateTimeEditor(gregorianCalendar.getTime(), (Calendar)gregorianCalendar, JavaFormat.getDateFormat((OraTemporalDatum.Precision)OraTemporalDatum.Precision.MINUTE, (Locale)locale));
        this.endTimeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Date) {
                    GregorianCalendar gregorianCalendar = ScheduleDialog.this.model.getEndDate();
                    gregorianCalendar.setTime((Date)object);
                }
            }
        });
        this.EndRepeatCalendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel calendarPanel = ScheduleDialog.this.EndRepeatCalendarButton.getCalendarPanel();
                calendarPanel.setMultiSelect(false);
                calendarPanel.setShowTime(false);
                calendarPanel.setShowTimeZone(false);
                GregorianCalendar gregorianCalendar = ScheduleDialog.this.model.getEndDate();
                calendarPanel.setSelectedDate(gregorianCalendar.getTime());
                calendarPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if ("DOUBLE_CLICK_COMMAND".equals(actionEvent.getActionCommand())) {
                            Date[] dateArray = ScheduleDialog.this.EndRepeatCalendarButton.getSelectedDates();
                            for (int i = 0; i < dateArray.length; ++i) {
                                Date date = dateArray[i];
                                GregorianCalendar gregorianCalendar = ScheduleDialog.this.model.getEndDate();
                                gregorianCalendar.setTime(date);
                                ScheduleDialog.this.endTimeEditor.setCalendar((Calendar)gregorianCalendar);
                            }
                        }
                    }
                });
                Container container = calendarPanel.getParent();
                do {
                    if (container == null || !(container instanceof JDialog)) continue;
                    ((JDialog)container).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    break;
                } while ((container = container.getParent()) != null);
            }
        });
        this.jRepeatComboBox.setModel(new RepeatComboBoxModel<String>(new String[]{RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_NONE, RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_DAY, RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_WEEK, RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM}));
        this.jEndRepeatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_END_REPEAT_OPTION_NEVER, SCHEDULER_END_REPEAT_OPTION_ON_DATE}));
        this.repeatTextArea = new JMultiLineLabel("");
        this.jCustomRepeatPanel.setLayout(new BorderLayout());
        this.jCustomRepeatPanel.add((Component)this.repeatTextArea);
        this.updateRepeatOption();
        this.enableControls();
        this.isUIRendering = false;
    }

    private void updateRepeatOption() {
        Object object;
        SchedulerModel.Repeat repeat = this.model.getRepeat();
        this.curRepeatSel = repeat == null ? RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_NONE : (repeat instanceof SchedulerModel.RepeatDailyBasic ? RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_DAY : (repeat instanceof SchedulerModel.RepeatWeeklyBasic ? RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_WEEK : RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM));
        this.jRepeatComboBox.setSelectedItem(this.curRepeatSel);
        if (this.curRepeatSel.equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM)) {
            object = (SchedulerModel.RepeatInterval)repeat;
            this.repeatTextArea.setText(((SchedulerModel.Repeat)object).displaySchedule());
            this.jCustomRepeatPanel.setVisible(true);
        } else {
            this.jCustomRepeatPanel.setVisible(false);
        }
        this.jEndRepeatLabel.setVisible(false);
        this.jEndRepeatComboBox.setVisible(false);
        this.jEndRepeatPanel.setVisible(false);
        this.EndRepeatCalendarButton.setVisible(false);
        if (repeat != null) {
            this.jEndRepeatLabel.setVisible(true);
            this.jEndRepeatComboBox.setVisible(true);
            object = this.model.getEndRepeat();
            if (object == null) {
                this.jEndRepeatComboBox.setSelectedItem(SCHEDULER_END_REPEAT_OPTION_NEVER);
            } else {
                this.jEndRepeatComboBox.setSelectedItem(SCHEDULER_END_REPEAT_OPTION_ON_DATE);
            }
            this.jEndRepeatPanel.setVisible(true);
            this.updateEndRepeatDateOption(object);
        }
    }

    private void updateEndRepeatDateOption(Object object) {
        this.jEndRepeatPanel.removeAll();
        this.jEndRepeatPanel.setVisible(false);
        if (object == null) {
            this.EndRepeatCalendarButton.setVisible(false);
        } else if (object instanceof Integer) {
            this.jEndRepeatPanel.add(this.spinner);
            this.spinner.setValue(object);
            this.jEndRepeatPanel.setVisible(true);
            this.EndRepeatCalendarButton.setVisible(false);
        } else if (object instanceof Calendar) {
            GregorianCalendar gregorianCalendar = this.model.getEndDate();
            this.endTimeEditor.setCalendar((Calendar)gregorianCalendar);
            this.jEndRepeatPanel.add((Component)this.endTimeEditor);
            this.jEndRepeatPanel.setVisible(true);
            this.EndRepeatCalendarButton.setVisible(true);
        }
    }

    @Override
    public void initRes() {
        this.jNameLabel.setText(DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_LBL"));
        this.jStartDateLabel.setText(DialogsLrb.get("SCHEDULER_START_DATE_LBL"));
        this.StartDateCalendarButton.setToolTipText(DialogsLrb.get("SCHEDULER_START_DATE_BTN_TOOLTIP"));
        this.jEndRepeatLabel.setText(DialogsLrb.get("SCHEDULER_END_REPEAT_LBL"));
        this.EndRepeatCalendarButton.setToolTipText(DialogsLrb.get("SCHEDULER_END_DATE_BTN_TOOLTIP"));
        ResourceUtils.resLabel((JLabel)this.jRepeatLabel, (Component)this.jRepeatComboBox, (String)DialogsLrb.get("SCHEDULER_REPEAT_LBL"));
        this.jRepeatComboBox.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SCHEDULER_REPEAT_ADA"));
        this.jRepeatComboBox.setToolTipText(DialogsLrb.get("SCHEDULER_REPEAT_ADA"));
        this.jEndRepeatComboBox.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SCHEDULER_END_REPEAT_ADA"));
        this.jEndRepeatComboBox.setToolTipText(DialogsLrb.get("SCHEDULER_END_REPEAT_ADA"));
    }

    private void enableControls() {
    }

    @Override
    protected boolean doWork() {
        boolean bl = true;
        if (!this.isEdit) {
            String string = this.model.getScheduleName();
            JTextField jTextField = this.jNameTextField;
            String string2 = jTextField.getText().trim();
            if (string2.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_MISSING"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                bl = false;
            }
            if (StringUtils.isDoubleQuotedString(string2)) {
                string = StringUtils.addDoubleQuotes(string);
            }
            if (bl && !StringUtils.isDoubleQuotedString(string2)) {
                string2 = string2.toUpperCase();
            }
            try {
                if (string != null && string.compareTo(string2) != 0) {
                    if (bl && this.isDuplicateName(StringUtils.trimDoubleQuotes(string2))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_NOT_UNIQUE_MSG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                        bl = false;
                    }
                    if (bl && !TableNameValidator.validateTableName(string2, null, this.getContext(), false)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_INVALID_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                        bl = false;
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_VALIDATION_SYSTEM_ERROR"), null);
                bl = false;
            }
            if (bl) {
                String string3 = StringUtils.trimDoubleQuotes(string2);
                this.model.setScheduleName(string3);
            }
        }
        return bl;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    private boolean isDuplicateName(String string) {
        return this.parent.doesScheduleNameExist(string);
    }
}

