/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.Context;

public class NotificationPanel
extends JPanel {
    private Logger theLogger = Logger.getLogger(this.getClass().getName());
    private Context context;
    private ScheduleWorkflowDialog parent;
    private SchedulerModel model;
    private JLabel jCommentLabel;
    private JTextArea jCommentTextArea;
    private JCheckBox jEmailNotificationCheckBox;
    private JLabel jEventsLabel;
    private JCheckBox jFailedCheckBox;
    private JLabel jRecipientsLabel;
    private JTextField jRecipientsTextField;
    private JScrollPane jScrollPane;
    private JCheckBox jStartedCheckBox;
    private JCheckBox jStoppedCheckBox;
    private JLabel jSubjectLabel;
    private JTextField jSubjectTextField;
    private JCheckBox jSucceededCheckBox;

    public NotificationPanel(Context context, ScheduleWorkflowDialog scheduleWorkflowDialog) {
        this.context = context;
        this.parent = scheduleWorkflowDialog;
        this.model = scheduleWorkflowDialog.getModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        this.jEmailNotificationCheckBox.setText(DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_EMAIL_LBL"));
        this.jRecipientsLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_RECIPIENTS_LBL"));
        this.jRecipientsTextField.setToolTipText(DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_RECIPIENTS_TOOLIP"));
        this.jSubjectLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_SUBJECT_LBL"));
        this.jCommentLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_COMMENT_LBL"));
        this.jEventsLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_EVENTS_LBL"));
        this.jStartedCheckBox.setText(DialogsLrb.get("SCHEDULER_RAISED_EVENT_STARTED"));
        this.jSucceededCheckBox.setText(DialogsLrb.get("SCHEDULER_RAISED_EVENT_SUCCEEDED"));
        this.jFailedCheckBox.setText(DialogsLrb.get("SCHEDULER_RAISED_EVENT_FAILED"));
        this.jStoppedCheckBox.setText(DialogsLrb.get("SCHEDULER_RAISED_EVENT_STOPPED"));
    }

    public void initUI() {
        this.jEmailNotificationCheckBox.setSelected(this.model.isUseNotification());
        this.jEmailNotificationCheckBox.setEnabled(this.model.emailServerExist());
        this.jRecipientsTextField.setText(this.model.getEmailRecipients());
        this.jSubjectTextField.setText(this.model.getEmailSubject());
        this.jCommentTextArea.setText(this.model.getEmailComment());
        this.jStartedCheckBox.setSelected(this.model.isUseEventStarted());
        this.jSucceededCheckBox.setSelected(this.model.isUseEventSucceeded());
        this.jFailedCheckBox.setSelected(this.model.isUseEventFailed());
        this.jStoppedCheckBox.setSelected(this.model.isUseEventStopped());
        this.enableControls();
    }

    private void enableControls() {
        this.jRecipientsLabel.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jRecipientsTextField.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jSubjectLabel.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jSubjectTextField.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jCommentLabel.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jCommentTextArea.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jEventsLabel.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jStartedCheckBox.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jSucceededCheckBox.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jFailedCheckBox.setEnabled(this.jEmailNotificationCheckBox.isSelected());
        this.jStoppedCheckBox.setEnabled(this.jEmailNotificationCheckBox.isSelected());
    }

    public boolean isUseNotification() {
        return this.jEmailNotificationCheckBox.isSelected();
    }

    public String getRecipients() {
        return this.jRecipientsTextField.getText();
    }

    public String getSubject() {
        return this.jSubjectTextField.getText();
    }

    public String getComment() {
        return this.jCommentTextArea.getText();
    }

    public boolean isUseEventStarted() {
        return this.jStartedCheckBox.isSelected();
    }

    public boolean isUseEventSucceeded() {
        return this.jSucceededCheckBox.isSelected();
    }

    public boolean isUseEventFailed() {
        return this.jFailedCheckBox.isSelected();
    }

    public boolean isUseEventStopped() {
        return this.jStoppedCheckBox.isSelected();
    }

    private void initComponents() {
        this.jEmailNotificationCheckBox = new JCheckBox();
        this.jRecipientsLabel = new JLabel();
        this.jRecipientsTextField = new JTextField();
        this.jSubjectLabel = new JLabel();
        this.jSubjectTextField = new JTextField();
        this.jCommentLabel = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jCommentTextArea = new JTextArea();
        this.jEventsLabel = new JLabel();
        this.jStartedCheckBox = new JCheckBox();
        this.jSucceededCheckBox = new JCheckBox();
        this.jFailedCheckBox = new JCheckBox();
        this.jStoppedCheckBox = new JCheckBox();
        this.jEmailNotificationCheckBox.setText("Enable Email Notification");
        this.jEmailNotificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotificationPanel.this.jEmailNotificationCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jRecipientsLabel.setLabelFor(this.jRecipientsTextField);
        this.jRecipientsLabel.setText("Recipients");
        this.jSubjectLabel.setLabelFor(this.jSubjectTextField);
        this.jSubjectLabel.setText("Subject");
        this.jCommentLabel.setLabelFor(this.jCommentTextArea);
        this.jCommentLabel.setText("Comment");
        this.jCommentTextArea.setLineWrap(true);
        this.jCommentTextArea.setRows(5);
        this.jScrollPane.setViewportView(this.jCommentTextArea);
        this.jEventsLabel.setText("Events");
        this.jStartedCheckBox.setText("Started");
        this.jSucceededCheckBox.setText("Succeeded");
        this.jFailedCheckBox.setText("Failed");
        this.jStoppedCheckBox.setText("Stopped");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jEmailNotificationCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jEventsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jCommentLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jSubjectLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jRecipientsLabel, -1, 63, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRecipientsTextField).addComponent(this.jSubjectTextField).addComponent(this.jScrollPane).addGroup(groupLayout.createSequentialGroup().addComponent(this.jStartedCheckBox, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jSucceededCheckBox, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jFailedCheckBox, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jStoppedCheckBox, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jEmailNotificationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRecipientsLabel).addComponent(this.jRecipientsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSubjectLabel).addComponent(this.jSubjectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCommentLabel).addComponent(this.jScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jEventsLabel).addComponent(this.jStartedCheckBox).addComponent(this.jSucceededCheckBox).addComponent(this.jFailedCheckBox).addComponent(this.jStoppedCheckBox)).addGap(95, 95, 95)));
    }

    private void jEmailNotificationCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }
}

