/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public class MonthPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(MonthPanel.class.getName());
    private boolean _isSelectionAdjusting = false;
    private SpreadTable _dayTable;
    private ArrayTwoDModel _tableModel = new ArrayTwoDModel(7, 5);
    private ArrayOneDModel _headerModel = new ArrayOneDModel(7);
    private static final int _DAYS_IN_WEEK = 7;
    private static final int _WEEKS_IN_MONTH = 5;
    private DateFormatSymbols _dfSymbols;
    private boolean _isMultiSelect;
    private Font _boldFont;
    private ImmInsets _cellInsets = new ImmInsets(0, 0, 0, 0);
    private ArrayList<String> _selectedDays;

    public MonthPanel(Locale locale, String[] stringArray) {
        this._dfSymbols = new DateFormatSymbols(locale);
        this._isMultiSelect = true;
        this._selectedDays = new ArrayList();
        this._buildTableModel();
        this._dayTable = new CustomSpreadTable((TwoDModel)this._tableModel, null, null);
        this._customizeDayTable();
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this._dayTable);
        this.setSelectedDays(stringArray);
    }

    public void setSelectedDays(String[] stringArray) {
        if (stringArray != null) {
            this._selectedDays.clear();
            for (String string : stringArray) {
                this._selectedDays.add(string);
            }
        }
        if (this._selectedDays.isEmpty()) {
            this._selectedDays.add("1");
        }
        this._updateSelection();
    }

    public String[] getSelectedDays() {
        return this._selectedDays.toArray(new String[this._selectedDays.size()]);
    }

    public void rebuild() {
        this._buildTableModel();
        this._dayTable.setModels((TwoDModel)this._tableModel, null, null);
        this._updateSelection();
        this._updateAppearance();
    }

    private void _updateSelection() {
        this._isSelectionAdjusting = true;
        TwoDSelection twoDSelection = new TwoDSelection();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                String string = (String)this._tableModel.getData(j, i);
                if (string == null || !this._selectedDays.contains(string)) continue;
                TwoDSelection twoDSelection2 = new TwoDSelection(j, i);
                twoDSelection = twoDSelection.add(twoDSelection2);
            }
        }
        try {
            this._dayTable.getGrid().setSelection(twoDSelection);
            this._dayTable.getGrid().repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            theLogger.log(Level.FINEST, "ui.calendar.DayPanel._updateSelection: VetoExeception");
        }
        this._isSelectionAdjusting = false;
    }

    private void _updateAppearance() {
        ComplexAppearanceManager complexAppearanceManager = (ComplexAppearanceManager)this._dayTable.getGrid().getAppearanceManager();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                Appearance appearance = complexAppearanceManager.getCellAppearance(j, i);
                String string = (String)this._tableModel.getData(j, i);
                if (string == null) {
                    appearance.setBackground(UIManager.getColor("TextArea.background"));
                    appearance.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    appearance.setFont(this._boldFont);
                    appearance.setInsets(this._cellInsets);
                } else {
                    appearance.setBackground(UIManager.getColor("Table.background"));
                    appearance.setForeground(UIManager.getColor("TextArea.foreground"));
                    appearance.setFont(this._boldFont);
                    appearance.setInsets(this._cellInsets);
                }
                complexAppearanceManager.setCellAppearance(j, i, appearance);
            }
        }
    }

    public SpreadTable getTable() {
        return this._dayTable;
    }

    private void _buildTableModel() {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (++n > 31) continue;
                this._tableModel.setData(j, i, (Object)("" + n));
            }
        }
    }

    private void _customizeDayTable() {
        Font font = UIManager.getFont("Label.font");
        this._boldFont = font.deriveFont(1).deriveFont((float)font.getSize() - 1.0f);
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        this._dayTable.getGrid().setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setVerticalJustify(1);
        complexAppearanceManager.setAppearance(appearance);
        if (this._isMultiSelect) {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 2));
        } else {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 1));
        }
        this._dayTable.setHorizontalSeparatorsVisible(true);
        this._dayTable.setVerticalSeparatorsVisible(true);
        this._autoSetWidth();
    }

    private void _autoSetWidth() {
        int n = this._getMinColSize();
        this._dayTable.getGrid().setColumnWidth(0, n);
        this._dayTable.getGrid().setColumnWidth(1, n);
        this._dayTable.getGrid().setColumnWidth(2, n);
        this._dayTable.getGrid().setColumnWidth(3, n);
        this._dayTable.getGrid().setColumnWidth(4, n);
        this._dayTable.getGrid().setColumnWidth(5, n);
        this._dayTable.getGrid().setColumnWidth(6, n);
    }

    private int _getMinColSize() {
        int n;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this._boldFont);
        for (String string : this._dfSymbols.getShortWeekdays()) {
            int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
            n2 = Math.max(n2, n3 += this._cellInsets.left + this._cellInsets.right);
        }
        for (n = 1; n <= 31; ++n) {
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, Integer.toString(n));
            n2 = Math.max(n2, n4);
        }
        n = this._dayTable.getColumnGeometryManager().getSeparatorSize();
        return n2 += n;
    }

    void cleanUp() {
        this._dayTable = null;
        this._tableModel = null;
        this._headerModel = null;
        if (this._selectedDays != null) {
            this._selectedDays.clear();
        }
        this._selectedDays = null;
    }

    private class CustomSpreadTable
    extends SpreadTable {
        public CustomSpreadTable(TwoDModel twoDModel, OneDModel oneDModel, OneDModel oneDModel2) {
            super(twoDModel, oneDModel, oneDModel2);
            this.setBorder(null);
        }

        protected Grid createGrid(TwoDModel twoDModel) {
            return new CustomGrid(twoDModel);
        }

        private class CustomGrid
        extends Grid {
            public CustomGrid(TwoDModel twoDModel) {
                super(twoDModel);
                this.setGridKeyHandler((GridKeyHandler)new CustomKeyHandler());
            }
        }

        private class CustomKeyHandler
        extends StandardGridKeyHandler {
            private CustomKeyHandler() {
            }

            protected Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
                return cell;
            }
        }
    }

    private class DayGridSelectionManager
    extends GeneralGridSelectionManager {
        public DayGridSelectionManager(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public TwoDSelection modifySelection(TwoDSelection twoDSelection, TwoDSelection twoDSelection2, int n) {
            if (!MonthPanel.this._isSelectionAdjusting) {
                switch (n) {
                    case 0: {
                        MonthPanel.this._selectedDays.clear();
                        this._addSingleSelection(twoDSelection2);
                        break;
                    }
                    case 2: {
                        twoDSelection2 = !MonthPanel.this._isMultiSelect ? this._addSingleSelection(twoDSelection2) : this._addMultiSelection(twoDSelection2);
                        break;
                    }
                    case 1: {
                        this._removeSelection(twoDSelection2);
                        break;
                    }
                    default: {
                        assert (false) : "Invalid option";
                        break;
                    }
                }
            }
            if (twoDSelection2 == null) {
                MonthPanel.this._updateSelection();
                twoDSelection2 = this.getSelection();
                n = 0;
            }
            return super.modifySelection(twoDSelection, twoDSelection2, n);
        }

        private TwoDSelection _addSingleSelection(TwoDSelection twoDSelection) {
            MonthPanel.this._selectedDays.clear();
            CellRange[] cellRangeArray = twoDSelection.getCellRanges();
            if (cellRangeArray != null) {
                String string = (String)MonthPanel.this._tableModel.getData(twoDSelection.getSingleCell().column, twoDSelection.getSingleCell().row);
                if (string != null) {
                    MonthPanel.this._selectedDays.add(string);
                } else {
                    twoDSelection = twoDSelection.subtract(twoDSelection);
                }
            }
            return twoDSelection;
        }

        private TwoDSelection _addMultiSelection(TwoDSelection twoDSelection) {
            CellRange[] cellRangeArray = twoDSelection.getCellRanges();
            if (cellRangeArray != null) {
                for (int i = 0; i < cellRangeArray.length; ++i) {
                    CellRange cellRange = cellRangeArray[i];
                    for (int j = cellRange.getLowerLimit().column; j <= cellRange.getUpperLimit().column; ++j) {
                        for (int k = cellRange.getLowerLimit().row; k <= cellRange.getUpperLimit().row; ++k) {
                            String string = (String)MonthPanel.this._tableModel.getData(j, k);
                            if (string != null) {
                                MonthPanel.this._selectedDays.add(string);
                                continue;
                            }
                            TwoDSelection twoDSelection2 = new TwoDSelection(new Cell(j, k));
                            twoDSelection = twoDSelection.subtract(twoDSelection2);
                        }
                    }
                }
            }
            return twoDSelection;
        }

        private void _removeSelection(TwoDSelection twoDSelection) {
            CellRange[] cellRangeArray = twoDSelection.getCellRanges();
            if (cellRangeArray != null) {
                for (int i = 0; i < cellRangeArray.length; ++i) {
                    CellRange cellRange = cellRangeArray[i];
                    for (int j = cellRange.getLowerLimit().column; j <= cellRange.getUpperLimit().column; ++j) {
                        for (int k = cellRange.getLowerLimit().row; k <= cellRange.getUpperLimit().row; ++k) {
                            String string = (String)MonthPanel.this._tableModel.getData(j, k);
                            if (string == null) continue;
                            MonthPanel.this._selectedDays.remove(string);
                        }
                    }
                }
            }
        }
    }
}

