/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class TransformNodeSettings
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JLabel _descriptionLabel;
    private JCheckBox _jGenerateCacheCheckBox;
    private JLabel jLabel1;

    public TransformNodeSettings() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this._descriptionLabel = new JLabel();
        this._jGenerateCacheCheckBox = new JCheckBox();
        this.jLabel1.setText("jLabel1");
        this._jGenerateCacheCheckBox.setText("Generate Cache Sample Table to Optimize Viewing");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jGenerateCacheCheckBox, GroupLayout.Alignment.LEADING, -1, 364, Short.MAX_VALUE).addComponent(this._descriptionLabel, GroupLayout.Alignment.LEADING, -1, 364, Short.MAX_VALUE)).addGap(26, 26, 26)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._descriptionLabel, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jGenerateCacheCheckBox).addContainerGap(238, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        this._descriptionLabel.setText(PreferencesLrb.get("TRANSFORM_NODE_PREFERENCES"));
        String string = StringUtils.stripMnemonic((String)PreferencesLrb.get("TRANSFORM_NODE_GEN_CACHE"));
        ResourceUtils.resButton((AbstractButton)this._jGenerateCacheCheckBox, (String)PreferencesLrb.get("TRANSFORM_NODE_GEN_CACHE"));
        this._jGenerateCacheCheckBox.getAccessibleContext().setAccessibleName(string);
        this._jGenerateCacheCheckBox.getAccessibleContext().setAccessibleDescription(string);
        this.setHelpID("data_miner_prefs_nodes_transforms");
    }

    @Override
    public void initUI() {
    }

    public void onEntry(TraversableContext traversableContext) {
        TransformPreferenceSettings transformPreferenceSettings = TransformNodeSettings.getCoolFeaturePrefs(traversableContext);
        this._jGenerateCacheCheckBox.setSelected(transformPreferenceSettings.getGenerateCache());
    }

    private static TransformPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return TransformPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public void onExit(TraversableContext traversableContext) {
        TransformPreferenceSettings transformPreferenceSettings = TransformNodeSettings.getCoolFeaturePrefs(traversableContext);
        transformPreferenceSettings.setGenerateCache(this._jGenerateCacheCheckBox.isSelected());
    }

    public static class TransformPreferenceSettings
    extends DataMinerPreferenceSettings {
        protected static final String DATA_KEY = "oracle.dmt.dataminer.workflow.TransformPreferenceSettings";

        public static TransformPreferenceSettings getInstance() {
            return TransformPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private TransformPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static TransformPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new TransformPreferenceSettings(TransformPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setGenerateCache(boolean bl) {
            this._hash.putBoolean("generate_cache", bl);
        }

        public boolean getGenerateCache() {
            return this._hash.getBoolean("generate_cache", false);
        }
    }
}

