/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.dialog.tests.TestPreferencesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public final class TestNode
extends AbstractNode
implements ModelConsumer,
DataConsumer {
    private static final Logger theLogger = Logger.getLogger(AbstractBuildNode.class.getName());
    public static final String TARGET_ATTRIBUTE = "TargetAttribute";
    public static final String CASE_ATTRIBUTES = "CaseAttributes";
    public static final String TEST_MODELS = "TestModels";
    public static final String AUTO_SETTING = "AutoSetting";
    public static final String TEST_RESULTS = "testResults";
    public static final String GEN_ACCURACY_METRICS = "genAccuracyMetrics";
    public static final String GEN_CONFUSION_MATRIX = "genConfusionMatrix";
    public static final String GEN_ROC_CURVE = "genROC";
    public static final String GEN_LIFT_AND_PROFIT = "genLiftProfit";
    public static final String GEN_RESIDUALS = "genResiduals";
    public static final String TEST_SETTINGS_CHANGED = "testSettingsChanged";
    private Map<String, String> _nodesLookupMap = new HashMap<String, String>();
    private Map<String, MiningResultType> _resultLookupMap = new HashMap<String, MiningResultType>();
    private static final String MODEL_STATUS = "modelStatus";

    public TestNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        TestPreferencesPanel.TestPreferenceSettings testPreferenceSettings = TestPreferencesPanel.TestPreferenceSettings.getInstance();
        boolean bl = testPreferenceSettings.getAutomaticSetting();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        TestModelType testModelType = new TestModelType();
        testModelType.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
        testModelType.setArchive("No");
        testNodeType.setTestModels(testModelType);
        ClassificationTestSettingsType classificationTestSettingsType = new ClassificationTestSettingsType();
        ClassificationTestSettingsType.TopNTargets topNTargets = new ClassificationTestSettingsType.TopNTargets();
        topNTargets.setValue(BigInteger.valueOf(100L));
        classificationTestSettingsType.setTopNTargets(topNTargets);
        testNodeType.setTestSettings(classificationTestSettingsType);
        CaseAttributes caseAttributes = new CaseAttributes();
        testNodeType.setCaseAttributes(caseAttributes);
        TestNodeType.Results results = new TestNodeType.Results();
        testNodeType.setResults(results);
        testNodeType.setStatus(NodeStatusType.INVALID);
    }

    private void initModelNodeLookup() {
        this._nodesLookupMap.clear();
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode abstractNode : list) {
            this._nodesLookupMap.put(abstractNode.getMetadataId(), abstractNode.getData().getName());
        }
    }

    private void initResultLookup() {
        this._resultLookupMap.clear();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        for (ClassificationResultType classificationResultType : testNodeType.getResults().getClassificationResult()) {
            this._resultLookupMap.put(classificationResultType.getModelId(), (MiningResultType)classificationResultType);
        }
        for (ClassificationResultType classificationResultType : testNodeType.getResults().getRegressionResult()) {
            this._resultLookupMap.put(classificationResultType.getModelId(), (MiningResultType)classificationResultType);
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TEST_NODE_NAME");
    }

    public boolean areNodesCompatible(Node node) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        boolean bl = false;
        ModelProvider modelProvider = (ModelProvider)((Object)node);
        bl = testNodeType.getTestModels().getModel().size() == 0 ? true : testNodeType.getTestModels().getMiningFunction().equals((Object)modelProvider.getMiningFunctionTypeSupported()) && testNodeType.getTargetAttribute().getName().equals(modelProvider.getTargetAttribute().getName()) && testNodeType.getTargetAttribute().getDataType().equals(modelProvider.getTargetAttribute().getDataType());
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (node instanceof BuildTextNodeRef) {
            return false;
        }
        if (node instanceof DataProvider) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof DataProvider)) continue;
                bl = false;
                break;
            }
        } else {
            ModelProvider modelProvider;
            bl = node instanceof ModelProvider ? ((modelProvider = (ModelProvider)((Object)node)).getMiningFunctionTypeSupported().equals((Object)MiningFunctionType.CLASSIFICATION) || modelProvider.getMiningFunctionTypeSupported().equals((Object)MiningFunctionType.REGRESSION) ? this.areNodesCompatible(node) : false) : false;
        }
        return bl;
    }

    @Override
    public void refactorModelReferences(Node node, Map<String, RefModelType> map, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        TestModelType testModelType = testNodeType.getTestModels();
        TestModelType testModelType2 = (TestModelType)MetaDataHelper.copyMetadataObject(testModelType);
        List list = testModelType2.getModel();
        for (TestModelType.Model model : list) {
            if (!map.containsKey(model.getName())) continue;
            RefModelType refModelType = map.get(model.getName());
            model.setName(refModelType.getName());
            model.setModelId(refModelType.getModelId());
            model.setTestStatus(ModelStatusType.READY);
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_MODELS, testModelType2);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        Object object;
        AttributeType attributeType;
        AttributeType attributeType2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        AttributeType attributeType3 = null;
        if (!(testNodeType.getCaseAttributes().getAttribute().isEmpty() || (attributeType2 = map.get((attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0)).getName())) == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType()))) {
            object = attributeType.getName();
            attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            attributeType3.setName(attributeType2.getName());
            attributeType3.setDataType(attributeType2.getDataType());
            hashMap.put((String)object, attributeType3);
        }
        attributeType = null;
        attributeType2 = testNodeType.getTargetAttribute();
        if (!(attributeType2 == null || (object = map.get(attributeType2.getName())) == null || attributeType2.getName().equals(object.getName()) && attributeType2.getDataType().equals(object.getDataType()))) {
            String string = attributeType2.getName();
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType2);
            attributeType.setName(object.getName());
            attributeType.setDataType(object.getDataType());
            hashMap.put(string, attributeType);
        }
        if (!hashMap.isEmpty()) {
            object = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (attributeType3 != null) {
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), CASE_ATTRIBUTES, attributeType3);
            }
            if (attributeType != null) {
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), TARGET_ATTRIBUTE, attributeType);
            }
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public void refactor(Node node, boolean bl) {
        ++this.refactorInvokeCount;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            TestNodeType testNodeType = (TestNodeType)this.getData();
            TestNodeType.Results results = new TestNodeType.Results();
            results.setGenAccuracyMetrics(testNodeType.getResults().isGenAccuracyMetrics());
            results.setGenConfusionMatrix(testNodeType.getResults().isGenConfusionMatrix());
            results.setGenLift(testNodeType.getResults().isGenLift());
            results.setGenROC(testNodeType.getResults().isGenROC());
            results.setGenResiduals(testNodeType.getResults().isGenResiduals());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, results);
            this.setNodeReady();
            this.validate(false);
            List<AbstractNode> list2 = this.findChildNodes();
            for (AbstractNode abstractNode : list2) {
                abstractNode.refactor(this, bl);
            }
        }
    }

    @Override
    public void parentNodeNameChanged(Node node, String string) {
        this._nodesLookupMap.clear();
    }

    @Override
    public boolean validate(boolean bl) {
        List<PartitionExpressionType> list;
        Object object;
        Object object2;
        Object object32;
        Iterator<Object> iterator;
        Object object42;
        boolean bl2 = super.validate(bl);
        this._nodesLookupMap.clear();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        boolean bl3 = AutoSpecType.YES.equals((Object)testNodeType.getTestModels().getAutoSpec());
        boolean bl4 = false;
        boolean bl5 = false;
        TestModelType testModelType = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        TestNodeType.Results results = null;
        boolean bl6 = false;
        AttributeType attributeType = null;
        List<AbstractNode> list2 = this.findTestModelNodes();
        for (AbstractNode model : list2) {
            ModelProvider modelProvider = (ModelProvider)((Object)model);
            object42 = modelProvider.getOutputModels();
            iterator = object42.iterator();
            while (iterator.hasNext()) {
                object32 = iterator.next();
                object2 = testModelType.getModel().iterator();
                while (object2.hasNext()) {
                    object = (TestModelType.Model)object2.next();
                    list = object.getModelId();
                    if (list == null || !object32.getModelId().equals(list) || object.getName().compareTo(object32.getName()) == 0) continue;
                    object.setName(object32.getName());
                    bl5 = true;
                }
            }
        }
        if (bl3) {
            testModelType.getModel().clear();
            testModelType.setMiningFunction(null);
            var12_12 = testModelType.getMiningFunction();
            for (AbstractNode abstractNode : list2) {
                object42 = (ModelProvider)((Object)abstractNode);
                if (attributeType == null) {
                    attributeType = object42.getTargetAttribute();
                    bl6 = true;
                }
                iterator = object42.getOutputModels();
                object32 = iterator.iterator();
                while (object32.hasNext()) {
                    object2 = (RefModelType)object32.next();
                    if (!object2.isUseForOutput()) continue;
                    if (var12_12 == null) {
                        testModelType.setMiningFunction(object2.getMiningFunction());
                        var12_12 = testModelType.getMiningFunction();
                    }
                    if (!var12_12.equals(object2.getMiningFunction()) || !attributeType.getName().equals(object42.getTargetAttribute().getName()) || !attributeType.getDataType().equals(object42.getTargetAttribute().getDataType())) continue;
                    object = new TestModelType.Model();
                    list = object42.getPartitionAttributes((RefModelType)object2);
                    if (list != null && list.size() > 0) {
                        var21_38 = new PartitionExpressions();
                        var21_38.getPartitionExpression().addAll(list);
                        TestNode.setPartitionExpressions((TestModelType.Model)object, (PartitionExpressions)var21_38);
                    }
                    object.setMiningAlgorithm(object2.getMiningAlgorithm());
                    object.setMiningFunction(object2.getMiningFunction());
                    object.setModelId(object2.getModelId());
                    object.setName(object2.getName());
                    object.setNodeId(object2.getNodeId());
                    object.setSchema(object2.getSchema());
                    object.setStatus(object2.getStatus());
                    object.setTestStatus(ModelStatusType.READY);
                    object.setUseForOutput(object2.isUseForOutput());
                    object.setIsModelBuilt(object2.isIsModelBuilt());
                    testModelType.getModel().add(object);
                }
            }
            bl = true;
            bl5 = true;
            bl6 = true;
        } else {
            var12_12 = this.findTestModelNodes();
            HashMap hashMap = new HashMap();
            HashMap<CallSite, RefModelType> hashMap2 = new HashMap<CallSite, RefModelType>();
            object42 = var12_12.iterator();
            while (object42.hasNext()) {
                iterator = (AbstractNode)object42.next();
                object32 = (ModelProvider)((Object)iterator);
                object2 = object32.getTargetAttribute();
                hashMap.put(((AbstractNode)((Object)iterator)).getMetadataId(), iterator);
                object = object32.getOutputModels();
                list = object.iterator();
                while (list.hasNext()) {
                    var21_38 = (RefModelType)list.next();
                    if (!var21_38.isUseForOutput()) continue;
                    String string = ((AbstractNode)((Object)iterator)).getMetadataId() + "." + var21_38.getSchema() + "." + var21_38.getName() + "." + var21_38.getMiningAlgorithm() + "." + object2.getName() + "." + object2.getDataType();
                    hashMap2.put((CallSite)((Object)string), (RefModelType)var21_38);
                }
            }
            object42 = new ArrayList();
            attributeType = testNodeType.getTargetAttribute();
            for (Object object32 : testModelType.getModel()) {
                if (object32.getStatus() != RefModelStatusType.VALID || (object = (RefModelType)hashMap2.get(object2 = object32.getNodeId() + "." + object32.getSchema() + "." + object32.getName() + "." + object32.getMiningAlgorithm() + "." + attributeType.getName() + "." + attributeType.getDataType())) != null) continue;
                if (hashMap.get(object32.getNodeId()) != null) {
                    object42.add(object32);
                    bl5 = true;
                    bl = true;
                    continue;
                }
                object32.setStatus(RefModelStatusType.INVALID);
                object32.setNodeId(null);
                object32.setModelId(null);
                if (!bl4) {
                    this.addMessage("TEST_INVAL_MODEL", MessageEnumType.WARNING, new String[0]);
                    bl4 = true;
                }
                bl2 = false;
                bl5 = true;
            }
            if (object42.size() > 0) {
                testModelType.getModel().removeAll((Collection<?>)object42);
                if (testModelType.getModel().size() == 0) {
                    testModelType.setMiningFunction(null);
                    attributeType = null;
                    bl5 = true;
                    bl6 = true;
                }
            }
            for (Object object32 : testModelType.getModel()) {
                if (object32.getNodeId() == null || hashMap.get(object2 = object32.getNodeId()) == null) continue;
                hashMap.remove(object2);
            }
            if (hashMap.size() > 0) {
                hashMap2.clear();
                for (Object object32 : hashMap.values()) {
                    object2 = (ModelProvider)object32;
                    object = object2.getTargetAttribute();
                    list = object2.getOutputModels();
                    for (RefModelType refModelType : list) {
                        if (!refModelType.isUseForOutput()) continue;
                        String string = refModelType.getSchema() + "." + refModelType.getName() + "." + refModelType.getMiningAlgorithm() + "." + object.getName() + "." + object.getDataType();
                        hashMap2.put((CallSite)((Object)string), refModelType);
                    }
                }
                for (Object object32 : testModelType.getModel()) {
                    if (object32.getStatus() != RefModelStatusType.INVALID || attributeType == null || (object = (RefModelType)hashMap2.get(object2 = object32.getSchema() + "." + object32.getName() + "." + object32.getMiningAlgorithm() + "." + attributeType.getName() + "." + attributeType.getDataType())) == null) continue;
                    object32.setStatus(RefModelStatusType.VALID);
                    object32.setNodeId(object.getNodeId());
                    object32.setModelId(object.getModelId());
                    bl5 = true;
                }
            }
        }
        results = new TestNodeType.Results();
        results.setGenAccuracyMetrics(testNodeType.getResults().isGenAccuracyMetrics());
        results.setGenConfusionMatrix(testNodeType.getResults().isGenConfusionMatrix());
        results.setGenLift(testNodeType.getResults().isGenLift());
        results.setGenROC(testNodeType.getResults().isGenROC());
        results.setGenResiduals(testNodeType.getResults().isGenResiduals());
        for (TestModelType.Model model : testModelType.getModel()) {
            if (model.getModelId() == null) continue;
            for (Object object42 : testNodeType.getResults().getClassificationResult()) {
                if (!object42.getModelId().equals(model.getModelId())) continue;
                results.getClassificationResult().add(object42);
            }
            for (Object object42 : testNodeType.getResults().getRegressionResult()) {
                if (!object42.getModelId().equals(model.getModelId())) continue;
                results.getRegressionResult().add(object42);
            }
        }
        boolean bl7 = results.getClassificationResult().size() != testNodeType.getResults().getClassificationResult().size();
        boolean bl8 = results.getRegressionResult().size() != testNodeType.getResults().getRegressionResult().size();
        boolean bl9 = testModelType.isGeneratePartitions();
        boolean bl10 = false;
        for (Object object32 : testModelType.getModel()) {
            if (object32.getPartitionExpressions() == null || object32.getPartitionExpressions().getPartitionExpression().isEmpty() || null == object32.getPartitionExpressions().getPartitionExpression().get(0) || null == ((PartitionExpressionType)object32.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute() || ((PartitionExpressionType)object32.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute().getName().trim().isEmpty()) continue;
            bl10 = true;
            break;
        }
        boolean bl11 = false;
        if (bl10 && TestNode.matchModelPartitions(testModelType, testModelType.getModel())) {
            bl11 = true;
        }
        if (bl9 != bl11) {
            testModelType.setGeneratePartitions(Boolean.valueOf(bl11));
            bl5 = true;
        }
        object32 = new ArrayList();
        object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            object = new ComplexProperty(TARGET_ATTRIBUTE, attributeType);
            ((ComplexProperty)object).setOldData(testNodeType.getTargetAttribute());
            object32.add(object);
        }
        if (bl5) {
            object = new ComplexProperty(TEST_MODELS, testModelType);
            ((ComplexProperty)object).setOldData(testNodeType.getTestModels());
            object32.add(object);
        }
        if (bl7 || bl8) {
            object = new ComplexProperty(TEST_RESULTS, results);
            ((ComplexProperty)object).setOldData(testNodeType.getResults());
            object32.add(object);
        }
        ((OdmrSDMUndoFilter)((Object)object2)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object32);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public static void setPartitionExpressions(TestModelType.Model model, PartitionExpressions partitionExpressions) {
        if (!partitionExpressions.getPartitionExpression().isEmpty() && null != partitionExpressions.getPartitionExpression().get(0) && null != ((PartitionExpressionType)partitionExpressions.getPartitionExpression().get(0)).getPartitionAttribute() && !((PartitionExpressionType)partitionExpressions.getPartitionExpression().get(0)).getPartitionAttribute().getName().trim().isEmpty()) {
            model.setPartitionExpressions(partitionExpressions);
        }
    }

    public boolean validateNode() {
        boolean bl = true;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        AbstractDataNode abstractDataNode = this.findTestDataNode();
        if (abstractDataNode == null) {
            this.addMessage("TEST_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (testNodeType.getTestModels().getModel().size() == 0) {
            this.addMessage("TEST_NO_MODEL", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            if (modelProvider.getTargetAttribute() != null) continue;
            this.addMessage("TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void setProperty(String string, Object object) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        if (string.equals(TARGET_ATTRIBUTE)) {
            AttributeType attributeType = (AttributeType)object;
            testNodeType.setTargetAttribute(attributeType);
        } else if (string.equals(CASE_ATTRIBUTES)) {
            AttributeType attributeType = (AttributeType)object;
            testNodeType.getCaseAttributes().getAttribute().clear();
            testNodeType.getCaseAttributes().getAttribute().add(attributeType);
        } else if (string.equals(TEST_MODELS)) {
            TestModelType testModelType = (TestModelType)object;
            testNodeType.setTestModels(testModelType);
            this._nodesLookupMap.clear();
        } else if (string.equals(AUTO_SETTING)) {
            testNodeType.getTestModels().setAutoSpec((AutoSpecType)object);
        } else if (string.equals(MODEL_STATUS)) {
            this.setModelStatus(object);
        } else if (string.equals(TEST_RESULTS)) {
            testNodeType.setResults((TestNodeType.Results)object);
        } else if (string.equals(GEN_ACCURACY_METRICS)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenAccuracyMetrics())) {
                results.setGenAccuracyMetrics(bl);
            }
        } else if (string.equals(GEN_CONFUSION_MATRIX)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenConfusionMatrix())) {
                results.setGenConfusionMatrix(bl);
            }
        } else if (string.equals(GEN_ROC_CURVE)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenROC())) {
                results.setGenROC(bl);
            }
        } else if (string.equals(GEN_LIFT_AND_PROFIT)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenLift())) {
                results.setGenLift(bl);
            }
        } else if (string.equals(GEN_RESIDUALS)) {
            Boolean bl = (Boolean)object;
            TestNodeType.Results results = testNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenResiduals())) {
                results.setGenResiduals(bl);
            }
        } else if (string.equals(TEST_SETTINGS_CHANGED)) {
            if (object == null || !(object instanceof ClassificationTestSettingsType)) {
                return;
            }
            ClassificationTestSettingsType classificationTestSettingsType = (ClassificationTestSettingsType)object;
            testNodeType.setTestSettings(classificationTestSettingsType);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(MODEL_STATUS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AUTO_SETTING)) {
            TestNodeType testNodeType = (TestNodeType)this.getData();
            return testNodeType.getTestModels().getAutoSpec();
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        Object object = null;
        if (string.equals(TARGET_ATTRIBUTE)) {
            object = testNodeType.getTargetAttribute();
        } else if (string.equals(CASE_ATTRIBUTES)) {
            if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
                object = testNodeType.getCaseAttributes().getAttribute().get(0);
            }
        } else if (string.equals(TEST_MODELS)) {
            object = testNodeType.getTestModels();
        } else if (string.equals(AUTO_SETTING)) {
            object = testNodeType.getTestModels().getAutoSpec();
        } else if (string.equals(TEST_RESULTS)) {
            object = testNodeType.getResults();
        } else if (string.equals(GEN_ACCURACY_METRICS)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenAccuracyMetrics();
        } else if (string.equals(GEN_CONFUSION_MATRIX)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenConfusionMatrix();
        } else if (string.equals(GEN_ROC_CURVE)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenROC();
        } else if (string.equals(GEN_LIFT_AND_PROFIT)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenLift();
        } else if (string.equals(GEN_RESIDUALS)) {
            TestNodeType.Results results = testNodeType.getResults();
            object = results.isGenLift();
        } else if (string.equals(TEST_SETTINGS_CHANGED)) {
            object = testNodeType.getTestSettings();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TEST_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TEST_ICON"));
    }

    public AbstractDataNode findTestDataNode() {
        AbstractDataNode abstractDataNode = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            abstractDataNode = (AbstractDataNode)abstractNode;
            break;
        }
        return abstractDataNode;
    }

    public List<AttributeType> findCaseIds() {
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                arrayList.add(attributeType);
            }
        }
        return arrayList;
    }

    public String getModelNodeName(String string) {
        if (this._nodesLookupMap.size() == 0) {
            this.initModelNodeLookup();
        }
        return this._nodesLookupMap.get(string);
    }

    public MiningResultType getModelResult(String string) {
        if (this._resultLookupMap.size() == 0) {
            this.initResultLookup();
        }
        return this._resultLookupMap.get(string);
    }

    public List<AbstractNode> findTestModelNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof ModelProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public static void removeModel(TestModelType testModelType, List<TestModelType.Model> list) {
        if (list.size() > 0) {
            testModelType.getModel().removeAll(list);
            if (testModelType.getModel().size() == 0) {
                testModelType.setMiningFunction(null);
            }
        }
    }

    public static boolean addModels2(TestModelType testModelType, List<TestModelType.Model> list) {
        boolean bl = true;
        if (list.size() > 0) {
            if (testModelType.getModel().size() == 0) {
                testModelType.setMiningFunction(list.get(0).getMiningFunction());
            }
            HashMap<CallSite, Boolean> hashMap = new HashMap<CallSite, Boolean>();
            for (TestModelType.Model model : testModelType.getModel()) {
                String string = model.getSchema() + "." + model.getName();
                hashMap.put((CallSite)((Object)string), Boolean.TRUE);
            }
            for (TestModelType.Model model : list) {
                if (hashMap.get(model.getSchema() + "." + model.getName()) != null) {
                    model.setStatus(RefModelStatusType.INVALID);
                    bl = false;
                }
                testModelType.getModel().add(model);
            }
        }
        return bl;
    }

    public static boolean doesModelExist(TestModelType testModelType, RefModelType refModelType) {
        boolean bl = false;
        for (TestModelType.Model model : testModelType.getModel()) {
            String string;
            String string2 = model.getSchema() + "." + model.getName();
            if (!string2.equals(string = refModelType.getSchema() + "." + refModelType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean matchModelPartitions(TestModelType testModelType, List<TestModelType.Model> list) {
        boolean bl = true;
        if (list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (TestModelType.Model model : list) {
                if (model.getPartitionExpressions() == null) continue;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (PartitionExpressionType partitionExpressionType : model.getPartitionExpressions().getPartitionExpression()) {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append("|");
                    }
                    stringBuffer2.append(partitionExpressionType.getPartitionAttribute().getName() + "." + partitionExpressionType.getPartitionAttribute().getDataType());
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(stringBuffer2);
                    continue;
                }
                if (stringBuffer.toString().equals(stringBuffer2.toString())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void setModelStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (!subNodeProperty.getId().equals(model.getName())) continue;
            model.setTestStatus((ModelStatusType)subNodeProperty.getValue());
            break;
        }
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (!model.getTestStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(MODEL_STATUS, new SubNodeProperty(model.getName(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(model.getName(), model.getTestStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public String getHelpTopic() {
        return "test_node";
    }

    private String generateClassTestCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, TestModelType.Model model) throws Exception {
        CharSequence charSequence;
        Object object;
        Object object2;
        String string;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        Object object3 = null;
        String string2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string3 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string4 = ConnectionFolder.getUserAccountName(this.getContext());
        String string5 = model.getName();
        String string6 = parameterizedSourceDefinitions.getParmNameWithAmpersand(model.getNodeId(), string4, string5, DatabaseObjectType.MODEL);
        boolean bl = DbVersionHelper.isDB122Up((Version)version) && testNodeType.getTestModels().isGeneratePartitions();
        String string7 = "";
        string7 = bl ? CodeTemplate.getInstance().getTemplate("workflow_class_test_part_model.sql") : CodeTemplate.getInstance().getTemplate("workflow_class_test_model.sql");
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        Model model2 = new Model(connectionFolder, string4, string5);
        boolean bl2 = model2.modelCostMatrixExists();
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl2) {
            bl3 = true;
            bl4 = true;
        }
        String string8 = null;
        if (bl3) {
            string = "COST MODEL AUTO USING *";
            string8 = "COST";
        } else {
            string = "USING *";
            string8 = "PROBABILITY";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl3 && bl4) {
            object3 = bl ? "  v_sql := \n    'SELECT DISTINCT PARTITION_NAME FROM '||v_confusion_matrix_part||' WHERE PARTITION_NAME IS NOT NULL'; \n  EXECUTE IMMEDIATE v_sql BULK COLLECT INTO v_partitions; \n  FOR i IN 1..v_partitions.COUNT LOOP \n    v_sql := \n      'INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE) \n      WITH \n      tr_cost AS \n        ( \n          select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n          from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(model_name => :1, partition_name => :2)) \n        ), \n      c_m AS \n        ( \n          select * from '||v_confusion_matrix_part||' where partition_name = :3 \n        ), \n      total_actuals AS \n        ( \n          SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n            SUM(a.VALUE * b.cost) actuals_cost, \n            SUM(a.VALUE) total_actuals \n          FROM c_m a, tr_cost b \n          WHERE a.actual_target_value(+) = b.actual_target_value \n          AND a.predicted_target_value(+) = b.predicted_target_value \n          GROUP BY nvl(a.actual_target_value, b.actual_target_value) \n        ), \n      total_predicted AS \n        ( \n          SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n            SUM(a.VALUE * b.cost) predicted_cost, \n            SUM(a.VALUE) total_predicted \n          FROM c_m a, tr_cost b \n          WHERE a.actual_target_value(+) = b.actual_target_value \n          AND a.predicted_target_value(+) = b.predicted_target_value \n          GROUP BY nvl(a.predicted_target_value, b.predicted_target_value) \n        ), \n      right_predictions AS \n        ( \n          SELECT actual_target_value, \n            VALUE AS correct \n          FROM c_m a \n          WHERE actual_target_value = predicted_target_value \n        ), \n      actuals_total_cost as \n        ( \n          SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n          FROM c_m a, tr_cost b \n          WHERE a.actual_target_value = b.actual_target_value \n          AND a.predicted_target_value = b.predicted_target_value \n        ) \n      SELECT ''COST'', '''||v_partitions(i)||''', NVL(SUM(actuals_cost), 0) \n      FROM total_actuals a, total_predicted p, right_predictions c, actuals_total_cost tc \n      WHERE a.actual_target_value(+) = p.predicted_target_value \n      AND p.predicted_target_value = c.actual_target_value(+)'; \n    EXECUTE IMMEDIATE v_sql USING '<MODEL_NAME_PARAM>', '\"'||v_partitions(i)||'\"', v_partitions(i); \n  END LOOP; \n  v_sql := \n    'INSERT INTO '||v_test_metric||' (METRIC_NAME, PARTITION_NAME, METRIC_NUM_VALUE) \n    SELECT ''COST'', NULL, SUM(METRIC_NUM_VALUE) FROM '||v_test_metric||' \n    WHERE METRIC_NAME = ''COST'' AND PARTITION_NAME IS NOT NULL'; \n  execSQL(v_sql); \n" : "  v_sql := \n    'INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) \n    WITH \n    tr_cost AS \n      ( \n        select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n        from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(:1)) \n      ), \n    total_actuals AS \n      (SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n         SUM(a.VALUE * b.cost) actuals_cost, \n         SUM(a.VALUE) total_actuals \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value(+) = b.actual_target_value \n       AND a.predicted_target_value(+) = b.predicted_target_value \n       GROUP BY nvl(a.actual_target_value, b.actual_target_value)), \n    total_predicted AS \n      (SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n         SUM(a.VALUE * b.cost) predicted_cost, \n         SUM(a.VALUE) total_predicted \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value(+) = b.actual_target_value \n       AND a.predicted_target_value(+) = b.predicted_target_value \n       GROUP BY nvl(a.predicted_target_value, b.predicted_target_value)), \n    right_predictions AS \n      (SELECT actual_target_value, \n         VALUE AS correct \n       FROM '||v_confusion_matrix||' \n       WHERE actual_target_value = predicted_target_value), \n    actuals_total_cost as \n      (SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n       FROM '||v_confusion_matrix||' a, \n         tr_cost b \n       WHERE a.actual_target_value = b.actual_target_value \n       AND a.predicted_target_value = b.predicted_target_value) \n    SELECT ''COST'', NVL(SUM(actuals_cost), 0) \n    FROM total_actuals a, \n      total_predicted p, \n      right_predictions c, \n      actuals_total_cost tc \n    WHERE a.actual_target_value(+) = p.predicted_target_value \n      AND p.predicted_target_value = c.actual_target_value(+)'; \n  EXECUTE IMMEDIATE v_sql USING '<MODEL_NAME_PARAM>'; \n";
            stringBuffer.append((String)object3);
        }
        boolean bl5 = testNodeType.getResults().isGenLift() == null ? true : testNodeType.getResults().isGenLift();
        boolean bl6 = testNodeType.getResults().isGenROC() == null ? true : testNodeType.getResults().isGenROC();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        StringBuffer stringBuffer4 = new StringBuffer("");
        if (bl5 || bl6) {
            object2 = testNodeType.getTestSettings().getTopNTargets();
            object = testNodeType.getTestSettings().getBottomNTargets();
            String string9 = "DESC";
            int n = 5;
            if (object2 != null || object != null) {
                if (object != null) {
                    string9 = "ASC";
                    n = object.getValue().intValue();
                } else {
                    n = object2.getValue().intValue();
                }
                object3 = "  -- targets for test results \n  v_sql := \n    'SELECT <PARALLEL_HINT> \"'||v_target||'\" as prediction FROM \n    ( \n      SELECT \"'||v_target||'\", \n      RANK() OVER (ORDER BY count(\"'||v_target||'\") " + string9 + ") \"Rank\" \n      FROM '||v_test_data||'  \n      GROUP BY \"'||v_target||'\" \n    ) \n    WHERE rownum <= " + n + "'; \n  EXECUTE IMMEDIATE v_sql BULK COLLECT INTO v_targets; \n";
                object3 = StringUtils.getReplacedString((String)object3, "<PARALLEL_HINT>", string3);
            } else {
                charSequence = new StringBuffer();
                int n2 = 0;
                for (ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue : testNodeType.getTestSettings().getSpecificTargets().getTargetValue()) {
                    if (n2 > 0) {
                        ((StringBuffer)charSequence).append(", ");
                    }
                    ((StringBuffer)charSequence).append("'" + StringUtils.escapeSingleQuotesForSQL(targetValue.getValue()) + "'");
                    ++n2;
                }
                object3 = "  -- targets for test results \n  v_targets := ODMR_OBJECT_VALUES(" + ((StringBuffer)charSequence).toString() + "); \n";
            }
            stringBuffer4.append((String)object3);
            if (bl5) {
                object3 = "  FOR i IN 1..v_targets.COUNT LOOP \n    -- lift for each target \n    v_lift := generateUniqueName; \n    DBMS_DATA_MINING.COMPUTE_LIFT ( \n      apply_result_table_name   => v_apply_data, \n      target_table_name         => v_test_data, \n      case_id_column_name       => v_caseid, \n      target_column_name        => '\"'||v_target||'\"', \n      lift_table_name           => v_lift, \n      positive_target_value     => v_targets(i), \n      score_column_name         => 'PREDICTION', \n      score_criterion_column_name => '<SCORE_CRITERION>', \n      num_quantiles             => 100, \n      score_criterion_type      => '<SCORE_CRITERION>'); \n";
                if (bl) {
                    object3 = (String)object3 + "    -- partition lift for each target \n    v_lift_part := generateUniqueName; \n    DBMS_DATA_MINING.COMPUTE_LIFT_PART ( \n      apply_result_table_name     => v_apply_data, \n      target_table_name           => v_test_data, \n      case_id_column_name         => v_caseid, \n      target_column_name          => '\"'||v_target||'\"', \n      lift_table_name             => v_lift_part, \n      positive_target_value       => v_targets(i), \n      score_column_name           => 'PREDICTION', \n      score_criterion_column_name => '<SCORE_CRITERION>', \n      num_quantiles               => 100, \n      score_criterion_type        => '<SCORE_CRITERION>', \n      score_partition_column_name => 'PARTITION_NAME'); \n    execSQL('ALTER TABLE '||v_lift_part||' <TABLE_PARALLEL_HINT>'); \n";
                    object3 = bl3 ? (String)object3 + "    execSQL('INSERT INTO '||v_lift_part||' (QUANTILE_NUMBER, COST_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, PARTITION_NAME) \n            SELECT QUANTILE_NUMBER, COST_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, NULL FROM '||v_lift); \n" : (String)object3 + "    execSQL('INSERT INTO '||v_lift_part||' (QUANTILE_NUMBER, PROBABILITY_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, PARTITION_NAME) \n            SELECT QUANTILE_NUMBER, PROBABILITY_THRESHOLD, GAIN_CUMULATIVE, QUANTILE_TOTAL_COUNT, QUANTILE_TARGET_COUNT, PERCENTAGE_RECORDS_CUMULATIVE, LIFT_CUMULATIVE, TARGET_DENSITY_CUMULATIVE, TARGETS_CUMULATIVE, NON_TARGETS_CUMULATIVE, LIFT_QUANTILE, TARGET_DENSITY, NULL FROM '||v_lift); \n";
                    object3 = (String)object3 + "    execSQL('DROP TABLE '||v_lift||' PURGE'); \n    recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_lift_part, 'TABLE', v_target||'='||v_targets(i), 'Lift Result'); \n";
                } else {
                    object3 = (String)object3 + "    recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_lift, 'TABLE', v_target||'='||v_targets(i), 'Lift Result'); \n";
                }
                object3 = (String)object3 + "  END LOOP; \n";
                stringBuffer2.append((String)object3);
            }
            if (bl6) {
                object3 = "  -- roc for each target (only binary target support) \n  IF (v_targets.COUNT <= 2) THEN \n    FOR i IN 1..v_targets.COUNT LOOP \n      v_roc := generateUniqueName; \n      DBMS_DATA_MINING.COMPUTE_ROC ( \n        roc_area_under_curve        => v_area_under_curve, \n        apply_result_table_name     => v_apply_data, \n        target_table_name           => v_test_data, \n        case_id_column_name         => v_caseid, \n        target_column_name          => '\"'||v_target||'\"', \n        roc_table_name              => v_roc, \n        positive_target_value       => v_targets(i), \n        score_column_name           => 'PREDICTION', \n        score_criterion_column_name => 'PROBABILITY'); \n";
                object3 = bl ? (String)object3 + "    -- partition lift for each target \n      v_roc_part := generateUniqueName; \n      DBMS_DATA_MINING.COMPUTE_ROC_PART ( \n        roc_area_under_curve        => v_area_under_curve_nested, \n        apply_result_table_name     => v_apply_data, \n        target_table_name           => v_test_data, \n        case_id_column_name         => v_caseid, \n        target_column_name          => '\"'||v_target||'\"', \n        roc_table_name              => v_roc_part, \n        positive_target_value       => v_targets(i), \n        score_column_name           => 'PREDICTION', \n        score_criterion_column_name => 'PROBABILITY', \n        score_partition_column_name => 'PARTITION_NAME'); \n      execSQL('ALTER TABLE '||v_lift_part||' <TABLE_PARALLEL_HINT>'); \n      execSQL('INSERT INTO '||v_roc_part||' (PROBABILITY, TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES, TRUE_POSITIVE_FRACTION, FALSE_POSITIVE_FRACTION, PARTITION_NAME) \n              SELECT PROBABILITY, TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES, TRUE_POSITIVE_FRACTION, FALSE_POSITIVE_FRACTION, NULL FROM '||v_roc); \n      execSQL('DROP TABLE '||v_roc||' PURGE'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_roc_part, 'TABLE', v_target||'='||v_targets(i), 'ROC Result'); \n      v_area_under_curve_result := generateUniqueName; \n      execSQL('CREATE TABLE '||v_area_under_curve_result||' (PARTITION_NAME VARCHAR2(128), AREA NUMBER) <TABLE_PARALLEL_HINT>'); \n      EXECUTE IMMEDIATE 'INSERT INTO '||v_area_under_curve_result||' (PARTITION_NAME, AREA) \n                        SELECT t.attribute_name, NVL(t.value, 0) FROM TABLE(:1) t' USING v_area_under_curve_nested; \n      EXECUTE IMMEDIATE 'INSERT INTO '||v_area_under_curve_result||' (PARTITION_NAME, AREA) \n                        SELECT NULL, NVL(:1, 0) FROM DUAL' USING v_area_under_curve; \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_area_under_curve_result, 'TABLE', v_target||'='||v_targets(i), 'ROC Area Under Curve'); \n" : (String)object3 + "      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_roc, 'TABLE', v_target||'='||v_targets(i), 'ROC Result'); \n      recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_area_under_curve, 'SCALAR', v_target||'='||v_targets(i), 'ROC Area Under Curve'); \n";
                object3 = (String)object3 + "    END LOOP; \n  END IF; \n";
                stringBuffer3.append((String)object3);
            }
        }
        object2 = this.getInMemorySettings(context);
        object = (String)object2.get("IN_MEMORY_ON");
        boolean bl7 = false;
        bl7 = object == null || ((String)object).isEmpty() ? false : Boolean.parseBoolean((String)object);
        String string10 = (String)object2.get("COMPRESSION_METHOD");
        charSequence = (String)object2.get("PRIORITY_LEVEL");
        if (bl7) {
            string7 = CodeTemplate.updateBodyTemplate(string7, "<COMPRESSION_METHOD>", string10);
            string7 = CodeTemplate.updateBodyTemplate(string7, "<PRIORITY_LEVEL>", (String)charSequence);
        } else {
            string7 = CodeTemplate.updateBodyTemplate(string7, "<COMPRESSION_METHOD>", "");
            string7 = CodeTemplate.updateBodyTemplate(string7, "<PRIORITY_LEVEL>", "");
        }
        string7 = CodeTemplate.updateBodyTemplate(string7, "<TEST_APPLY_COST_OPTION>", string);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<COST_SETTING>", "");
        string7 = CodeTemplate.updateBodyTemplate(string7, "<TEST_TARGET_VALUES>", stringBuffer4.toString());
        string7 = CodeTemplate.updateBodyTemplate(string7, "<GEN_LIFT_RESULT>", stringBuffer2.toString());
        string7 = CodeTemplate.updateBodyTemplate(string7, "<GEN_ROC_RESULT>", stringBuffer3.toString());
        string7 = CodeTemplate.updateBodyTemplate(string7, "<COMPUTE_TOTAL_COST>", stringBuffer.toString());
        string7 = CodeTemplate.updateBodyTemplate(string7, "<SCORE_CRITERION>", string8);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<TABLE_PARALLEL_HINT>", string2);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<PARALLEL_HINT>", string3);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<MODEL_NAME_PARAM>", string6);
        string7 = CodeTemplate.updateBodyTemplate(string7, "<BUILD_MODEL_ID>", model.getModelId());
        String string11 = null;
        if (model.getMiningAlgorithm() == MiningAlgorithmType.DECISION_TREE) {
            string11 = MiningAlgorithms.DECISION_TREE.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.NAIVE_BAYES) {
            string11 = MiningAlgorithms.NAIVE_BAYES.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            string11 = MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            string11 = MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString();
        }
        string7 = CodeTemplate.updateBodyTemplate(string7, "<BUILD_MODEL_TYPE>", string11);
        return string7;
    }

    private String generateRegressTestCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, TestModelType.Model model) throws Exception {
        Object object;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = model.getSchema();
        String string2 = model.getName();
        String string3 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        boolean bl = DbVersionHelper.isDB122Up((Version)version) && testNodeType.getTestModels().isGeneratePartitions();
        String string5 = parameterizedSourceDefinitions.getParmNameWithAmpersand(model.getNodeId(), string, string2, DatabaseObjectType.MODEL);
        String string6 = "";
        string6 = bl ? CodeTemplate.getInstance().getTemplate("workflow_regress_test_part_model.sql") : CodeTemplate.getInstance().getTemplate("workflow_regress_test_model.sql");
        StringBuffer stringBuffer = new StringBuffer("");
        if (testNodeType.getResults().isGenResiduals() == null || testNodeType.getResults().isGenResiduals().booleanValue()) {
            object = "  -- Residual plot \n  v_residual_plot := generateUniqueName; \n  v_sql :=  'CREATE TABLE '||v_residual_plot||' <TABLE_PARALLEL_HINT> AS \n    SELECT <PARALLEL_HINT> * \n      FROM (SELECT \n            A.'||v_caseid||' CASEID, \n            B.\"'||v_target||'\" TARGET, \n            A.pred PREDICTION, \n            (B.\"'||v_target||'\" - A.pred) RESIDUAL \n              FROM '||v_apply_data||' A, \n                   '||v_test_data||' B \n             WHERE A.'||v_caseid||' = B.'||v_caseid||' \n            ORDER BY A.pred ASC) WHERE RESIDUAL IS NOT NULL'; \n  execSQL(v_sql); \n";
            object = bl ? (String)object + "  \n  -- Partition Residual plot \n  v_residual_plot_part := generateUniqueName; \n  v_sql :=  'CREATE TABLE '||v_residual_plot_part||' <TABLE_PARALLEL_HINT> AS \n    SELECT <PARALLEL_HINT> * \n      FROM (SELECT A.PARTITION_NAME PARTITION_NAME, \n            A.'||v_caseid||' CASEID, \n            B.\"'||v_target||'\" TARGET, \n            A.PRED PREDICTION, \n            (B.\"'||v_target||'\" - A.pred) RESIDUAL \n              FROM '||v_apply_data||' A, \n                   '||v_test_data||' B \n             WHERE A.'||v_caseid||' = B.'||v_caseid||' \n            ORDER BY A.PARTITION_NAME, A.PRED ASC) WHERE RESIDUAL IS NOT NULL'; \n  execSQL(v_sql); \n  v_index := generateUniqueName; \n  execSQL('CREATE INDEX '||v_index||' ON '||v_residual_plot_part||' (PARTITION_NAME) <TABLE_PARALLEL_HINT>'); \n  execSQL('INSERT INTO '||v_residual_plot_part||' (PARTITION_NAME, CASEID, TARGET, PREDICTION, RESIDUAL) \n          SELECT NULL, CASEID, TARGET, PREDICTION, RESIDUAL FROM '||v_residual_plot); \n  execSQL('DROP TABLE '||v_residual_plot||' PURGE'); \n  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_residual_plot_part, 'TABLE', NULL, 'Residual Plot'); \n" : (String)object + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_residual_plot, 'TABLE', NULL, 'Residual Plot'); \n";
            stringBuffer.append((String)object);
        }
        object = this.getInMemorySettings(context);
        String string7 = object.get("IN_MEMORY_ON");
        boolean bl2 = false;
        bl2 = string7 == null || string7.isEmpty() ? false : Boolean.parseBoolean(string7);
        String string8 = object.get("COMPRESSION_METHOD");
        String string9 = object.get("PRIORITY_LEVEL");
        if (bl2) {
            string6 = CodeTemplate.updateBodyTemplate(string6, "<COMPRESSION_METHOD>", string8);
            string6 = CodeTemplate.updateBodyTemplate(string6, "<PRIORITY_LEVEL>", string9);
        } else {
            string6 = CodeTemplate.updateBodyTemplate(string6, "<COMPRESSION_METHOD>", "");
            string6 = CodeTemplate.updateBodyTemplate(string6, "<PRIORITY_LEVEL>", "");
        }
        string6 = CodeTemplate.updateBodyTemplate(string6, "<RESIDUAL_PLOT>", stringBuffer.toString());
        string6 = CodeTemplate.updateBodyTemplate(string6, "<TABLE_PARALLEL_HINT>", string3);
        string6 = CodeTemplate.updateBodyTemplate(string6, "<PARALLEL_HINT>", string4);
        string6 = CodeTemplate.updateBodyTemplate(string6, "<MODEL_NAME_PARAM>", string5);
        string6 = CodeTemplate.updateBodyTemplate(string6, "<BUILD_MODEL_ID>", model.getModelId());
        String string10 = null;
        if (model.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            string10 = MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString();
        } else if (model.getMiningAlgorithm() == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            string10 = MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString();
        }
        string6 = CodeTemplate.updateBodyTemplate(string6, "<BUILD_MODEL_TYPE>", string10);
        return string6;
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            TestNodeType testNodeType = (TestNodeType)this.getData();
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            if (!DbVersionHelper.isDB121Up((Version)version)) {
                for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
                    ConnectionFolder connectionFolder;
                    Model model2;
                    List<MiningModelSettings> list;
                    if (model.getMiningAlgorithm() != MiningAlgorithmType.GENERALIZED_LINEAR_MODEL || MiningModelSettings.findSetting((String)"GLMS_FTR_SEL_CRIT", list = (model2 = new Model(connectionFolder = ConnectionFolder.getConnectionFolder(context), model.getSchema(), model.getName())).getModelSettings()) == null && MiningModelSettings.findSetting((String)"GLMS_MAX_FEATURES", list) == null && MiningModelSettings.findSetting((String)"GLMS_SELECT_BLOCK", list) == null && MiningModelSettings.findSetting((String)"GLMS_FTR_IDENTIFICATION", list) == null && MiningModelSettings.findSetting((String)"GLMS_PRUNE_MODEL", list) == null && MiningModelSettings.findSetting((String)"GLMS_FTR_ACCEPTANCE", list) == null && MiningModelSettings.findSetting((String)"GLMS_FTR_IDENTIFICATION", list) == null && MiningModelSettings.findSetting((String)"GLMS_FTR_GENERATION", list) == null) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_GLM_BUILD_SETTING_NOT_SUPPORTED"));
                    return false;
                }
            }
            if (!DbVersionHelper.isDB122Up((Version)version) && testNodeType.getTestModels().isGeneratePartitions()) {
                Object[] objectArray = new Object[]{testNodeType.getName()};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_PARTITION_MODELS_NOT_SUPPORTED"), objectArray));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private String generateCaseIdColumn(Context context) {
        String string = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            string = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        Object object;
        Object object2;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        String string2 = this.findTestDataNode().getMetadataId();
        String string3 = testNodeType.getTargetAttribute().getName();
        StringBuffer stringBuffer = new StringBuffer();
        Object object3 = null;
        String string4 = null;
        boolean bl = true;
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string6 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        if (testNodeType.getCaseAttributes() != null && !testNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            string4 = ((AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0)).getName();
            object3 = "  v_sql := \n    'CREATE VIEW '||v_input_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT t.* \n      FROM '||getInputSource('" + string2 + "')||' t \n    )'; \n  execSQL(v_sql); \n";
            object3 = StringUtils.getReplacedString((String)object3, "<PARALLEL_HINT>", string6);
            bl = true;
        } else {
            Object object4;
            Object object5;
            string4 = this.generateCaseIdColumn(context);
            stringBuffer.setLength(0);
            object2 = new ArrayList();
            object2 = this.getModel().findLinksToNode((IlvSDMNode)this);
            object = object2.iterator();
            Object object6 = null;
            while (object.hasNext()) {
                object5 = (GeneralLink)object.next();
                object4 = (AbstractNode)((GeneralLink)object5).getFrom();
                if (!(object4 instanceof AbstractDataNode)) continue;
                object6 = (AbstractDataNode)object4;
                break;
            }
            object5 = ((AbstractDataNode)object6).getInputSQL();
            object4 = null;
            String string7 = null;
            StringBuffer stringBuffer2 = new StringBuffer("");
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            try {
                object4 = ConnectionFolder.getUserAccountName(context);
                string7 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", connectionFolder);
                object5 = "SELECT * FROM (" + (String)object5 + ")";
                DatabaseMetadataUtils.createViewAs(connectionFolder, (String)object5, (String)object4, string7);
                Map<String, DatabaseMetadataUtils.ColumnInfo> map = DatabaseMetadataUtils.getColumnInfo(context, string7);
                for (DatabaseMetadataUtils.ColumnInfo columnInfo : map.values()) {
                    if (columnInfo.getDataType().compareToIgnoreCase("CLOB") == 0 || columnInfo.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(",\n        ");
                        }
                        stringBuffer2.append("LOB(" + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + ") STORE AS BASICFILE");
                        continue;
                    }
                    if (columnInfo.getDataType().contains("NESTED")) {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(",\n        ");
                        }
                        stringBuffer2.append("NESTED TABLE " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS '||generateUniqueName||'");
                        continue;
                    }
                    if (columnInfo.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(",\n        ");
                    }
                    stringBuffer2.append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS BASICFILE CLOB");
                }
            }
            finally {
                try {
                    DatabaseMetadataUtils.dropView(connectionFolder, (String)object4, string7);
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            object3 = "  \n  v_sql := \n    'CREATE TABLE '||v_input_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM '||v_caseid||', t.*  \n      FROM '||getInputSource('" + string2 + "')||' t \n    )'; \n  execSQL(v_sql); \n";
            object3 = StringUtils.getReplacedString((String)object3, "<STORAGE_CLAUSE>", stringBuffer2.toString());
            object3 = StringUtils.getReplacedString((String)object3, "<TABLE_PARALLEL_HINT>", string5);
            object3 = StringUtils.getReplacedString((String)object3, "<PARALLEL_HINT>", string6);
        }
        object3 = (String)object3 + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_input_data, '" + (bl ? "VIEW" : "TABLE") + "', NULL, 'Input Data'); \n";
        object2 = CodeTemplate.updateBodyTemplate(string, "<CASEID>", string4);
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<INPUT_DATA>", (String)object3);
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<SOURCE_NODE_ID>", string2);
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<TARGET>", string3);
        object = new StringBuffer();
        for (Object object5 : testNodeType.getTestModels().getModel()) {
            if (object5.getMiningFunction() == MiningFunctionType.REGRESSION) {
                ((StringBuffer)object).append(this.generateRegressTestCode(context, parameterizedSourceDefinitions, (TestModelType.Model)object5) + "\n");
                continue;
            }
            ((StringBuffer)object).append(this.generateClassTestCode(context, parameterizedSourceDefinitions, (TestModelType.Model)object5));
        }
        object2 = CodeTemplate.updateBodyTemplate((String)object2, "<TEST_MODELS>", ((StringBuffer)object).toString());
        return object2;
    }
}

