/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.partition.ModelPartitions;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureCompareNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSignatureType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;

public class FeatureCompareNode
extends AbstractTransformNode {
    public static final String FEATURE_COMPARE_MODEL_SIGNATURE = "featureCompareModelSignature";
    public static final String FEATURE_COMPARE_DATA_INPUT_1 = "featureCompareDataInput1";
    public static final String FEATURE_COMPARE_DATA_INPUT_2 = "featureCompareDataInput2";
    public static final String FEATURE_COMPARE_OUTPUT_COLUMN = "featureCompareOutputColumns";
    public static final String FEATURE_COMPARE_SUPPLEMENTAL_ATTRIBUTES = "featureCompareSupplementalAttributes";

    public FeatureCompareNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ModelInfoType modelInfoType = new ModelInfoType();
        modelInfoType.setSchema("");
        modelInfoType.setName("");
        modelInfoType.setMiningFunction(MiningFunctionType.FEATURE_EXTRACTION);
        modelInfoType.setStatus(RefModelStatusType.INVALID);
        modelInfoType.setMiningAlgorithm(MiningAlgorithmType.ALL);
        modelInfoType.setUseForOutput(false);
        modelInfoType.setModelId("");
        ModelSignatureType modelSignatureType = new ModelSignatureType();
        modelSignatureType.setModel(modelInfoType);
        modelSignatureType.setAttributes(new Attributes());
        FeatureCompareNodeType.OutputColumn outputColumn = new FeatureCompareNodeType.OutputColumn();
        outputColumn.setAutoSpec(AutoSpecType.YES);
        outputColumn.setName("");
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        supplementalAttributesType.setAutoSpec(AutoSpecType.YES);
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.getData();
        featureCompareNodeType.setModelSignature(modelSignatureType);
        featureCompareNodeType.setDataInput1(new InputSourceType());
        featureCompareNodeType.setDataInput2(new InputSourceType());
        featureCompareNodeType.getDataInput1().setDataSource(null);
        featureCompareNodeType.getDataInput2().setDataSource(null);
        InputSourceType.Custom custom = new InputSourceType.Custom();
        custom.setAttributes(new InputSourceType.Custom.Attributes());
        featureCompareNodeType.getDataInput1().setCustom(custom);
        featureCompareNodeType.getDataInput2().setCustom(custom);
        featureCompareNodeType.setOutputColumn(outputColumn);
        featureCompareNodeType.setSupplementalAttributes(supplementalAttributesType);
        featureCompareNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_FEATURE_COMPARE_NODE_NAME");
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        bl = node instanceof DataProvider && this.findDataSourceNodes().size() < 2 ? true : (node instanceof FeatureExtractionBuildNode || node instanceof ExplicitFeatureExtractionBuildNode ? this.findBuildNode() == null : (node instanceof ModelNode ? this.findBuildNode() == null && ((ModelNodeType)node.getData()).getMiningFunction().equals((Object)MiningFunctionType.FEATURE_EXTRACTION) : false));
        return bl;
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public String getHelpTopic() {
        return "featurecompare_node";
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_FEATURE_COMPARE_ICON"));
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_FEATURE_COMPARE_ICON"));
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.getData();
        if (node instanceof DataProvider) {
            InputSourceType.DataSource dataSource = featureCompareNodeType.getDataInput1().getDataSource();
            InputSourceType.DataSource dataSource2 = featureCompareNodeType.getDataInput2().getDataSource();
            boolean bl = dataSource != null;
            boolean bl2 = dataSource2 != null;
            NodeType nodeType = node.getData();
            if (bl && bl2) {
                if (this.idsDoesNotMatch(dataSource, nodeType) && this.idsDoesNotMatch(dataSource2, nodeType)) {
                    if (this.hasInvalidState(dataSource)) {
                        this.copyNodeMetaDataToInput(node, DataInput.INPUT_1);
                    } else if (this.hasInvalidState(dataSource2)) {
                        this.copyNodeMetaDataToInput(node, DataInput.INPUT_2);
                    }
                }
            } else if (bl) {
                if (this.idsDoesNotMatch(dataSource, nodeType) && this.hasInvalidState(dataSource)) {
                    this.copyNodeMetaDataToInput(node, DataInput.INPUT_1);
                }
            } else if (bl2 && this.idsDoesNotMatch(dataSource2, nodeType) && this.hasInvalidState(dataSource)) {
                this.copyNodeMetaDataToInput(node, DataInput.INPUT_2);
            }
        }
        this.validate(true);
    }

    private boolean idsDoesNotMatch(InputSourceType.DataSource dataSource, NodeType nodeType) {
        return !dataSource.getId().equals(nodeType.getId());
    }

    private boolean hasInvalidState(InputSourceType.DataSource dataSource) {
        return NodeStatusType.INVALID.equals((Object)dataSource.getStatus());
    }

    private void copyNodeMetaDataToInput(Node node, DataInput dataInput) {
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.getData();
        InputSourceType inputSourceType = DataInput.INPUT_1.equals((Object)dataInput) ? featureCompareNodeType.getDataInput1() : featureCompareNodeType.getDataInput2();
        InputSourceType.DataSource dataSource = inputSourceType.getDataSource();
        NodeType nodeType = node.getData();
        dataSource.setId(nodeType.getId());
        dataSource.setName(nodeType.getName());
        dataSource.setStatus(nodeType.getStatus());
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(true);
    }

    private InputSourceType.DataSource.Attributes.Attribute getEmptyAttrDataSource() {
        InputSourceType.DataSource.Attributes.Attribute attribute = new InputSourceType.DataSource.Attributes.Attribute();
        attribute.setName(DialogsLrb.get("EMPTY_COMBO"));
        attribute.setDataType("");
        attribute.setAlias("");
        attribute.setAnnotation("");
        attribute.setDataTypeQualifier("");
        attribute.setStatus(AttributeStatus.INVALID);
        attribute.setSource("DATA_SOURCE");
        return attribute;
    }

    private InputSourceType.Custom.Attributes.Attribute getEmptyAttrCustom() {
        InputSourceType.Custom.Attributes.Attribute attribute = new InputSourceType.Custom.Attributes.Attribute();
        attribute.setValue(DialogsLrb.get("EMPTY_COMBO"));
        attribute.setSource("CUSTOM");
        return attribute;
    }

    @Override
    public boolean validate(boolean bl) {
        Iterator<MiningAttributeType> iterator;
        boolean bl2 = super.validate(bl);
        boolean bl3 = true;
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.getData();
        if (bl) {
            this.validateChildren();
        }
        if (featureCompareNodeType.getModelSignature() == null || StringUtils.areEqual((String)featureCompareNodeType.getModelSignature().getModel().getName(), (String)DialogsLrb.get("EMPTY_COMBO")) || StringUtils.areEqual((String)featureCompareNodeType.getModelSignature().getModel().getName(), (String)"")) {
            bl2 = false;
            this.addMessage("FEATURE_COMPARE_NO_MODEL", MessageEnumType.WARNING, new String[0]);
        } else {
            Object object;
            Object object22;
            Object object32;
            Object object4;
            iterator = new ArrayList<AttributeType>();
            if (this.findBuildNode() instanceof AbstractBuildNode && this.getAvailableModels().containsKey(featureCompareNodeType.getModelSignature().getModel().getModelId())) {
                iterator.addAll(((AbstractBuildNode)this.findBuildNode()).getModelInputAttributes());
            } else if (this.findBuildNode() instanceof AbstractModelNode && this.getAvailableModels().containsKey(featureCompareNodeType.getModelSignature().getModel().getModelId())) {
                object4 = new Model(ConnectionFolder.getConnectionFolder(this.getContext()), featureCompareNodeType.getModelSignature().getModel().getSchema(), featureCompareNodeType.getModelSignature().getModel().getName());
                try {
                    object32 = ((Model)object4).getMiningAttributeTypes();
                    object22 = object32.iterator();
                    while (object22.hasNext()) {
                        object = object22.next();
                        object.setAnnotation("");
                        object.setAutoPrep("Yes");
                        object.setStatus(AttributeStatus.VALID);
                        object.setDataTypeQualifier("");
                        object.setMiningType(DatabaseMetadataUtils.getDefaultMiningType(object.getDataType()));
                        object.setAlias("");
                        iterator.add((MiningAttributeType)object);
                    }
                }
                catch (ODMrDAOException oDMrDAOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, oDMrDAOException.getStackTrace()[0].toString(), oDMrDAOException);
                }
            } else {
                bl2 = false;
                this.addMessage("FEATURE_COMPARE_MISSING_MODEL", MessageEnumType.WARNING, featureCompareNodeType.getModelSignature().getModel().getName());
                bl3 = false;
                for (Object object32 : featureCompareNodeType.getModelSignature().getAttributes().getAttribute()) {
                    object32.setStatus(AttributeStatus.INVALID);
                }
            }
            if (iterator.size() > featureCompareNodeType.getModelSignature().getAttributes().getAttribute().size() && bl3) {
                object4 = new HashMap();
                for (Object object22 : featureCompareNodeType.getModelSignature().getAttributes().getAttribute()) {
                    object4.put(object22.getName(), object22);
                    object22.setStatus(AttributeStatus.VALID);
                }
                int n = 0;
                object22 = iterator.iterator();
                while (object22.hasNext()) {
                    object = (AttributeType)object22.next();
                    if (!object4.containsKey(object.getName())) {
                        InputSourceType.DataSource.Attributes.Attribute attribute;
                        var10_18 = new AttributeType();
                        var10_18.setAlias(object.getAlias());
                        var10_18.setAnnotation(object.getAnnotation());
                        var10_18.setDataType(object.getDataType());
                        var10_18.setDataTypeQualifier(object.getDataTypeQualifier());
                        var10_18.setName(object.getName());
                        var10_18.setStatus(object.getStatus());
                        featureCompareNodeType.getModelSignature().getAttributes().getAttribute().add(n, var10_18);
                        if (featureCompareNodeType.getDataInput1().getCustom() != null) {
                            featureCompareNodeType.getDataInput1().getCustom().getAttributes().getAttribute().add(n, this.getEmptyAttrCustom());
                        } else {
                            attribute = this.getEmptyAttrDataSource();
                            if (this.getDataSourcesMap().containsKey(featureCompareNodeType.getDataInput1().getDataSource().getId())) {
                                for (AttributeType attributeType : this.getDataSourcesMap().get(featureCompareNodeType.getDataInput1().getDataSource().getId()).getAttributes().getAttribute()) {
                                    if (!attributeType.getName().equals(var10_18.getName()) || !attributeType.getDataType().equals(var10_18.getDataType())) continue;
                                    attribute.setAlias(attributeType.getAlias());
                                    attribute.setAnnotation(attributeType.getAnnotation());
                                    attribute.setDataType(attributeType.getDataType());
                                    attribute.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                                    attribute.setName(attributeType.getName());
                                    attribute.setSource("DATA_SOURCE");
                                    attribute.setStatus(attributeType.getStatus());
                                }
                            }
                            featureCompareNodeType.getDataInput1().getDataSource().getAttributes().getAttribute().add(n, attribute);
                        }
                        if (featureCompareNodeType.getDataInput2().getCustom() != null) {
                            featureCompareNodeType.getDataInput2().getCustom().getAttributes().getAttribute().add(n, this.getEmptyAttrCustom());
                        } else {
                            attribute = this.getEmptyAttrDataSource();
                            if (this.getDataSourcesMap().containsKey(featureCompareNodeType.getDataInput2().getDataSource().getId())) {
                                for (AttributeType attributeType : this.getDataSourcesMap().get(featureCompareNodeType.getDataInput2().getDataSource().getId()).getAttributes().getAttribute()) {
                                    if (!attributeType.getName().equals(var10_18.getName()) || !attributeType.getDataType().equals(var10_18.getDataType())) continue;
                                    attribute.setAlias(attributeType.getAlias());
                                    attribute.setAnnotation(attributeType.getAnnotation());
                                    attribute.setDataType(attributeType.getDataType());
                                    attribute.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                                    attribute.setName(attributeType.getName());
                                    attribute.setSource("DATA_SOURCE");
                                    attribute.setStatus(attributeType.getStatus());
                                }
                            }
                            featureCompareNodeType.getDataInput2().getDataSource().getAttributes().getAttribute().add(n, attribute);
                        }
                    }
                    ++n;
                }
            } else if (iterator.size() < featureCompareNodeType.getModelSignature().getAttributes().getAttribute().size() && bl3) {
                object4 = new HashMap();
                object32 = iterator.iterator();
                while (object32.hasNext()) {
                    object22 = (AttributeType)object32.next();
                    object4.put(object22.getName(), object22);
                    object22.setStatus(AttributeStatus.VALID);
                }
                object32 = null;
                object32 = featureCompareNodeType.getDataInput1().getCustom() != null ? featureCompareNodeType.getDataInput1().getCustom().getAttributes().getAttribute().iterator() : featureCompareNodeType.getDataInput1().getDataSource().getAttributes().getAttribute().iterator();
                object22 = null;
                object22 = featureCompareNodeType.getDataInput2().getCustom() != null ? featureCompareNodeType.getDataInput2().getCustom().getAttributes().getAttribute().iterator() : featureCompareNodeType.getDataInput2().getDataSource().getAttributes().getAttribute().iterator();
                object = featureCompareNodeType.getModelSignature().getAttributes().getAttribute().iterator();
                while (object.hasNext()) {
                    var10_18 = (AttributeType)object.next();
                    object32.next();
                    object22.next();
                    if (object4.containsKey(var10_18.getName())) continue;
                    object.remove();
                    object32.remove();
                    object22.remove();
                }
            } else if (bl3) {
                for (Object object32 : featureCompareNodeType.getModelSignature().getAttributes().getAttribute()) {
                    object32.setStatus(AttributeStatus.VALID);
                }
            }
        }
        if (featureCompareNodeType.getDataInput1().getDataSource() != null) {
            if (featureCompareNodeType.getDataInput1().getDataSource() != null && !this.getDataSourcesMap().containsKey(featureCompareNodeType.getDataInput1().getDataSource().getId())) {
                bl2 = false;
                this.addMessage("FEATURE_COMPARE_MISSING_DATA_SOURCE", MessageEnumType.WARNING, featureCompareNodeType.getDataInput1().getDataSource().getName());
                for (Object object4 : featureCompareNodeType.getDataInput1().getDataSource().getAttributes().getAttribute()) {
                    object4.setStatus(AttributeStatus.INVALID);
                }
                for (Object object4 : featureCompareNodeType.getSupplementalAttributes().getAttribute()) {
                    if (!object4.getName().startsWith("A.")) continue;
                    object4.setStatus(AttributeStatus.INVALID);
                }
                if (featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute() != null) {
                    featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().setStatus(AttributeStatus.INVALID);
                }
                featureCompareNodeType.getDataInput1().getDataSource().setStatus(NodeStatusType.INVALID);
            } else {
                boolean bl4;
                featureCompareNodeType.getDataInput1().getDataSource().setStatus(NodeStatusType.READY);
                iterator = this.getDataSourceAttributes(this.getDataSourcesMap().get(featureCompareNodeType.getDataInput1().getDataSource().getId()));
                boolean bl5 = !this.areMappedAttributesValid(featureCompareNodeType.getDataInput1().getDataSource().getAttributes(), (Map<String, AttributeType>)((Object)iterator));
                boolean bl6 = bl4 = !this.areSupplementalAttributesValid(featureCompareNodeType.getSupplementalAttributes().getAttribute(), (Map<String, AttributeType>)((Object)iterator), "A.");
                if (bl5 || bl4) {
                    bl2 = false;
                    this.addMessage("FEATURE_COMPARE_NO_AVAILABLE_ATTRIBUTES", MessageEnumType.WARNING, new String[0]);
                }
                if (featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute() == null) {
                    bl2 = false;
                    this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_CASE_ATTR", MessageEnumType.WARNING, new String[0]);
                } else if (!iterator.containsKey(featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().getName())) {
                    bl2 = false;
                    this.addMessage("SAMPLE_INVAL_CASEID", MessageEnumType.WARNING, new String[0]);
                    featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().setStatus(AttributeStatus.INVALID);
                } else {
                    featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().setStatus(AttributeStatus.VALID);
                }
            }
        }
        if (featureCompareNodeType.getDataInput2().getDataSource() != null) {
            if (!this.getDataSourcesMap().containsKey(featureCompareNodeType.getDataInput2().getDataSource().getId())) {
                bl2 = false;
                this.addMessage("FEATURE_COMPARE_MISSING_DATA_SOURCE", MessageEnumType.WARNING, featureCompareNodeType.getDataInput2().getDataSource().getName());
                for (InputSourceType.DataSource.Attributes.Attribute attribute : featureCompareNodeType.getDataInput2().getDataSource().getAttributes().getAttribute()) {
                    attribute.setStatus(AttributeStatus.INVALID);
                }
                for (AttributeType attributeType : featureCompareNodeType.getSupplementalAttributes().getAttribute()) {
                    if (!attributeType.getName().startsWith("B.")) continue;
                    attributeType.setStatus(AttributeStatus.INVALID);
                }
                if (featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute() != null) {
                    featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().setStatus(AttributeStatus.INVALID);
                }
                featureCompareNodeType.getDataInput2().getDataSource().setStatus(NodeStatusType.INVALID);
            } else {
                boolean bl7;
                featureCompareNodeType.getDataInput2().getDataSource().setStatus(NodeStatusType.READY);
                iterator = this.getDataSourceAttributes(this.getDataSourcesMap().get(featureCompareNodeType.getDataInput2().getDataSource().getId()));
                boolean bl8 = !this.areMappedAttributesValid(featureCompareNodeType.getDataInput2().getDataSource().getAttributes(), (Map<String, AttributeType>)((Object)iterator));
                boolean bl9 = bl7 = !this.areSupplementalAttributesValid(featureCompareNodeType.getSupplementalAttributes().getAttribute(), (Map<String, AttributeType>)((Object)iterator), "B.");
                if (bl8 || bl7) {
                    bl2 = false;
                    this.addMessage("FEATURE_COMPARE_NO_AVAILABLE_ATTRIBUTES", MessageEnumType.WARNING, new String[0]);
                }
                if (featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute() == null) {
                    bl2 = false;
                    this.addMessage("DYNAMIC_PREDICTION_NODE_INVALID_CASE_ATTR", MessageEnumType.WARNING, new String[0]);
                } else if (!iterator.containsKey(featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().getName())) {
                    bl2 = false;
                    this.addMessage("SAMPLE_INVAL_CASEID", MessageEnumType.WARNING, new String[0]);
                    featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().setStatus(AttributeStatus.INVALID);
                } else {
                    featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().setStatus(AttributeStatus.VALID);
                }
            }
        }
        if (!this.hasValidMappedAttributes(featureCompareNodeType.getDataInput1().getDataSource() != null ? featureCompareNodeType.getDataInput1().getDataSource().getAttributes().getAttribute() : featureCompareNodeType.getDataInput1().getCustom().getAttributes().getAttribute(), featureCompareNodeType.getDataInput2().getDataSource() != null ? featureCompareNodeType.getDataInput2().getDataSource().getAttributes().getAttribute() : featureCompareNodeType.getDataInput2().getCustom().getAttributes().getAttribute())) {
            bl2 = false;
            this.addMessage("FEATURE_COMPARE_NO_MAPPED_ATTRIBUTES", MessageEnumType.WARNING, new String[0]);
        }
        if (bl2) {
            featureCompareNodeType.setStatus(NodeStatusType.READY);
            featureCompareNodeType.setSQLExpression(this.generateSQLExpression());
        } else {
            featureCompareNodeType.setStatus(NodeStatusType.INVALID);
        }
        this.setState(bl2);
        return bl2;
    }

    private boolean areMappedAttributesValid(InputSourceType.DataSource.Attributes attributes, Map<String, AttributeType> map) {
        int n = 0;
        for (InputSourceType.DataSource.Attributes.Attribute attribute : attributes.getAttribute()) {
            attribute.setStatus(AttributeStatus.VALID);
            if (!(attribute.getName().equals(DialogsLrb.get("EMPTY_COMBO")) || map.containsKey(attribute.getName()) && map.get(attribute.getName()).getDataType().equals(attribute.getDataType()))) {
                attribute.setStatus(AttributeStatus.INVALID);
                continue;
            }
            if (attribute.getName().equals(DialogsLrb.get("EMPTY_COMBO")) || !AttributeStatus.VALID.equals((Object)attribute.getStatus())) continue;
            ++n;
        }
        return n > 0;
    }

    private boolean areSupplementalAttributesValid(List<AttributeType> list, Map<String, AttributeType> map, String string) {
        boolean bl = true;
        for (AttributeType attributeType : list) {
            if (!attributeType.getName().startsWith(string)) continue;
            attributeType.setStatus(AttributeStatus.VALID);
            if (map.containsKey(attributeType.getName().substring(2))) continue;
            bl = false;
            attributeType.setStatus(AttributeStatus.INVALID);
        }
        return bl;
    }

    private Map<String, AttributeType> getDataSourceAttributes(AbstractDataNode abstractDataNode) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : abstractDataNode.getAttributes().getAttribute()) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        return hashMap;
    }

    private boolean hasValidMappedAttributes(List<? extends Object> list, List<? extends Object> list2) {
        for (int i = 0; i < list.size(); ++i) {
            AttributeStatus attributeStatus;
            String string = list.get(i) instanceof InputSourceType.DataSource.Attributes.Attribute ? ((InputSourceType.DataSource.Attributes.Attribute)list.get(i)).getName() : ((InputSourceType.Custom.Attributes.Attribute)list.get(i)).getValue();
            String string2 = list2.get(i) instanceof InputSourceType.DataSource.Attributes.Attribute ? ((InputSourceType.DataSource.Attributes.Attribute)list2.get(i)).getName() : ((InputSourceType.Custom.Attributes.Attribute)list2.get(i)).getValue();
            AttributeStatus attributeStatus2 = list.get(i) instanceof InputSourceType.Custom.Attributes.Attribute ? AttributeStatus.VALID : ((InputSourceType.DataSource.Attributes.Attribute)list.get(i)).getStatus();
            AttributeStatus attributeStatus3 = attributeStatus = list2.get(i) instanceof InputSourceType.Custom.Attributes.Attribute ? AttributeStatus.VALID : ((InputSourceType.DataSource.Attributes.Attribute)list2.get(i)).getStatus();
            if (string.equals(DialogsLrb.get("EMPTY_COMBO")) || string2.equals(DialogsLrb.get("EMPTY_COMBO")) || !attributeStatus2.equals((Object)AttributeStatus.VALID) || !attributeStatus.equals((Object)AttributeStatus.VALID)) continue;
            return true;
        }
        return false;
    }

    public List<String> getPartitionAttributes(ModelSignatureType modelSignatureType) {
        ArrayList<String> arrayList;
        block4: {
            block3: {
                arrayList = new ArrayList<String>();
                if (!(this.findBuildNode() instanceof AbstractBuildNode)) break block3;
                PartitionExpressions partitionExpressions = ((BuildNodeType)this.findBuildNode().getData()).getPartitionExpressions();
                if (partitionExpressions == null) break block4;
                for (PartitionExpressionType partitionExpressionType : partitionExpressions.getPartitionExpression()) {
                    arrayList.add(partitionExpressionType.getPartitionAttribute().getName());
                }
                break block4;
            }
            if (!(this.findBuildNode() instanceof AbstractModelNode)) break block4;
            try {
                ModelPartitions modelPartitions = Model.getModelPartitions(ConnectionFolder.getConnectionFolder(this.getContext()), modelSignatureType.getModel().getSchema(), modelSignatureType.getModel().getName());
                arrayList.addAll(modelPartitions.getColumnNames());
            }
            catch (ODMrDAOException oDMrDAOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, oDMrDAOException.getStackTrace()[0].toString(), oDMrDAOException);
            }
        }
        return arrayList;
    }

    private List<Integer> getMappedIndexes(InputSourceType inputSourceType, InputSourceType inputSourceType2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = inputSourceType.getDataSource() != null ? inputSourceType.getDataSource().getAttributes().getAttribute().size() : inputSourceType.getCustom().getAttributes().getAttribute().size();
        boolean bl = inputSourceType.getCustom() != null;
        boolean bl2 = inputSourceType2.getCustom() != null;
        for (int i = 0; i < n; ++i) {
            AttributeStatus attributeStatus;
            String string = bl ? ((InputSourceType.Custom.Attributes.Attribute)inputSourceType.getCustom().getAttributes().getAttribute().get(i)).getValue() : ((InputSourceType.DataSource.Attributes.Attribute)inputSourceType.getDataSource().getAttributes().getAttribute().get(i)).getName();
            String string2 = bl2 ? ((InputSourceType.Custom.Attributes.Attribute)inputSourceType2.getCustom().getAttributes().getAttribute().get(i)).getValue() : ((InputSourceType.DataSource.Attributes.Attribute)inputSourceType2.getDataSource().getAttributes().getAttribute().get(i)).getName();
            AttributeStatus attributeStatus2 = bl ? AttributeStatus.VALID : ((InputSourceType.DataSource.Attributes.Attribute)inputSourceType.getDataSource().getAttributes().getAttribute().get(i)).getStatus();
            AttributeStatus attributeStatus3 = attributeStatus = bl2 ? AttributeStatus.VALID : ((InputSourceType.DataSource.Attributes.Attribute)inputSourceType2.getDataSource().getAttributes().getAttribute().get(i)).getStatus();
            if (string.equals(DialogsLrb.get("EMPTY_COMBO")) || string2.equals(DialogsLrb.get("EMPTY_COMBO")) || !attributeStatus2.equals((Object)AttributeStatus.VALID) || !attributeStatus.equals((Object)AttributeStatus.VALID)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    @Override
    public String generateSQLExpression() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(1024);
        StringBuilder stringBuilder2 = new StringBuilder(1024);
        StringBuilder stringBuilder3 = new StringBuilder(1024);
        StringBuilder stringBuilder4 = new StringBuilder(1024);
        StringBuilder stringBuilder5 = new StringBuilder(512);
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.getData();
        int n = 1;
        boolean bl = featureCompareNodeType.getDataInput1().getCustom() != null;
        boolean bl2 = featureCompareNodeType.getDataInput2().getCustom() != null;
        List<Integer> list = this.getMappedIndexes(featureCompareNodeType.getDataInput1(), featureCompareNodeType.getDataInput2());
        if (bl && bl2) {
            n = this.setBuffersForCustom(stringBuilder2, stringBuilder3, featureCompareNodeType.getDataInput1().getCustom().getAttributes().getAttribute(), n, featureCompareNodeType.getModelSignature().getAttributes().getAttribute(), list);
            n = this.setBuffersForCustom(stringBuilder2, stringBuilder3, featureCompareNodeType.getDataInput2().getCustom().getAttributes().getAttribute(), n, featureCompareNodeType.getModelSignature().getAttributes().getAttribute(), list);
            stringBuilder5.append("(SELECT * FROM \n (SELECT ");
            stringBuilder5.append((CharSequence)stringBuilder2);
            stringBuilder5.append(" FROM DUAL)) \"USER_DEFINED\"");
        } else {
            String string;
            if (bl) {
                n = this.setBuffersForCustom(stringBuilder2, stringBuilder3, featureCompareNodeType.getDataInput1().getCustom().getAttributes().getAttribute(), n, featureCompareNodeType.getModelSignature().getAttributes().getAttribute(), list);
                stringBuilder5.append("(SELECT * FROM \n (SELECT ");
                stringBuilder5.append((CharSequence)stringBuilder2);
                stringBuilder5.append(" FROM DUAL)) \"USER_DEFINED\"");
            } else {
                object = StringUtils.addDoubleQuotes((String)"A");
                stringBuilder4.append(String.join((CharSequence)".", new CharSequence[]{object, StringUtils.addDoubleQuotes((String)featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().getName())}));
                string = featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().getAlias();
                if (string != null && !string.isEmpty()) {
                    stringBuilder4.append(" AS ");
                    stringBuilder4.append(StringUtils.addDoubleQuotes((String)string));
                }
                this.setBuffersForSource(stringBuilder3, featureCompareNodeType.getDataInput1().getDataSource().getAttributes().getAttribute(), (String)object, featureCompareNodeType.getModelSignature().getAttributes().getAttribute(), list);
                stringBuilder5.append(String.join((CharSequence)" ", new CharSequence[]{this.getNodeNameForSQLExpressionInternal(true, featureCompareNodeType.getDataInput1().getDataSource().getId()), object}));
            }
            if (bl2) {
                n = this.setBuffersForCustom(stringBuilder2, stringBuilder3, featureCompareNodeType.getDataInput2().getCustom().getAttributes().getAttribute(), n, featureCompareNodeType.getModelSignature().getAttributes().getAttribute(), list);
                if (!bl) {
                    stringBuilder5.append(", ");
                    stringBuilder5.append("(SELECT * FROM \n (SELECT ");
                    stringBuilder5.append((CharSequence)stringBuilder2);
                    stringBuilder5.append(" FROM DUAL)) \"USER_DEFINED\"");
                }
            } else {
                object = StringUtils.addDoubleQuotes((String)"B");
                if (stringBuilder4.length() > 0) {
                    stringBuilder4.append(", ");
                }
                stringBuilder4.append(String.join((CharSequence)".", new CharSequence[]{object, StringUtils.addDoubleQuotes((String)featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().getName())}));
                string = featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().getAlias();
                if (string != null && !string.isEmpty()) {
                    stringBuilder4.append(" AS ");
                    stringBuilder4.append(StringUtils.addDoubleQuotes((String)string));
                }
                this.setBuffersForSource(stringBuilder3, featureCompareNodeType.getDataInput2().getDataSource().getAttributes().getAttribute(), (String)object, featureCompareNodeType.getModelSignature().getAttributes().getAttribute(), list);
                stringBuilder5.append(", ");
                stringBuilder5.append(String.join((CharSequence)" ", new CharSequence[]{this.getNodeNameForSQLExpressionInternal(true, featureCompareNodeType.getDataInput2().getDataSource().getId()), object}));
            }
        }
        if (stringBuilder4.length() > 0) {
            stringBuilder4.append(", ");
        }
        for (String string : featureCompareNodeType.getSupplementalAttributes().getAttribute()) {
            stringBuilder4.append(StringUtils.addDoubleQuotes((String)string.getName().split("\\.")[0]));
            stringBuilder4.append(".");
            stringBuilder4.append(StringUtils.addDoubleQuotes((String)string.getName().split("\\.")[1]));
            if (!StringUtils.isEmpty((String)string.getAlias())) {
                stringBuilder4.append(" AS ");
                stringBuilder4.append(StringUtils.addDoubleQuotes((String)string.getAlias()));
            }
            stringBuilder4.append(", ");
        }
        stringBuilder4.append("FEATURE_COMPARE(");
        if (!featureCompareNodeType.getModelSignature().getModel().getSchema().isEmpty()) {
            stringBuilder4.append(StringUtils.addDoubleQuotes((String)featureCompareNodeType.getModelSignature().getModel().getSchema()));
            stringBuilder4.append(".");
        }
        stringBuilder4.append(StringUtils.addDoubleQuotes((String)featureCompareNodeType.getModelSignature().getModel().getName()));
        stringBuilder4.append((CharSequence)stringBuilder3);
        stringBuilder4.append(") ");
        stringBuilder4.append(StringUtils.addDoubleQuotes((String)featureCompareNodeType.getOutputColumn().getName()));
        stringBuilder.append("SELECT ");
        stringBuilder.append((CharSequence)stringBuilder4);
        stringBuilder.append(" \n");
        stringBuilder.append("FROM ");
        stringBuilder.append((CharSequence)stringBuilder5);
        stringBuilder.append(" \n");
        if (!bl && !bl2) {
            stringBuilder.append("WHERE ");
            stringBuilder.append(String.join((CharSequence)".", StringUtils.addDoubleQuotes((String)"A"), StringUtils.addDoubleQuotes((String)featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute().getName())));
            stringBuilder.append(" = ");
            stringBuilder.append(String.join((CharSequence)".", StringUtils.addDoubleQuotes((String)"B"), StringUtils.addDoubleQuotes((String)featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute().getName())));
        }
        object = new StringBuilder(2048);
        if (!bl) {
            ((StringBuilder)object).append(this.getDataSourcesMap().get(featureCompareNodeType.getDataInput1().getDataSource().getId()).getInputSQL(true, false));
            ((StringBuilder)object).append(", \n");
        }
        if (!bl2) {
            ((StringBuilder)object).append(this.getDataSourcesMap().get(featureCompareNodeType.getDataInput2().getDataSource().getId()).getInputSQL(true, false));
            ((StringBuilder)object).append(", \n");
        }
        ((StringBuilder)object).append(this.wrapExpressionInWithClause(stringBuilder.toString()));
        return ((StringBuilder)object).toString();
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.getData();
        if (featureCompareNodeType.getDataInput1().getDataSource() != null) {
            attributes.getAttribute().add(featureCompareNodeType.getDataInput1().getDataSource().getCaseAttribute());
        }
        if (featureCompareNodeType.getDataInput2().getDataSource() != null) {
            attributes.getAttribute().add(featureCompareNodeType.getDataInput2().getDataSource().getCaseAttribute());
        }
        for (AttributeType attributeType : featureCompareNodeType.getSupplementalAttributes().getAttribute()) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            attributeType2.setAlias(null);
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attributeType2.setStatus(attributeType.getStatus());
            attributes.getAttribute().add(attributeType2);
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setName(featureCompareNodeType.getOutputColumn().getName());
        attributeType.setAlias(null);
        attributeType.setDataType("NUMBER");
        attributeType.setDataTypeQualifier(null);
        attributeType.setStatus(AttributeStatus.VALID);
        attributes.getAttribute().add(attributeType);
        return attributes;
    }

    public List<AbstractDataNode> findDataSourceNodes() {
        ArrayList<AbstractDataNode> arrayList = new ArrayList<AbstractDataNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof AbstractDataNode)) continue;
            arrayList.add((AbstractDataNode)abstractNode);
        }
        return arrayList;
    }

    public Map<String, AbstractDataNode> getDataSourcesMap() {
        HashMap<String, AbstractDataNode> hashMap = new HashMap<String, AbstractDataNode>();
        for (AbstractNode abstractNode : this.findParentNodes()) {
            if (!(abstractNode instanceof AbstractDataNode)) continue;
            hashMap.put(abstractNode.getData().getId(), (AbstractDataNode)abstractNode);
        }
        return hashMap;
    }

    public AbstractNode findBuildNode() {
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof ModelNode) && !(abstractNode instanceof FeatureExtractionBuildNode) && !(abstractNode instanceof ExplicitFeatureExtractionBuildNode)) continue;
            return abstractNode;
        }
        return null;
    }

    public Map<String, ModelSignatureType> getAvailableModels() {
        HashMap<String, ModelSignatureType> hashMap = new HashMap<String, ModelSignatureType>();
        if (this.findBuildNode() == null) {
            return hashMap;
        }
        AbstractNode abstractNode = this.findBuildNode();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        if (abstractNode instanceof AbstractBuildNode) {
            arrayList.addAll(((AbstractBuildNode)abstractNode).getOutputModels());
        } else if (abstractNode instanceof AbstractModelNode) {
            arrayList.addAll(((AbstractModelNode)abstractNode).getOutputModels());
        }
        for (RefModelType refModelType : arrayList) {
            if (!refModelType.isUseForOutput()) continue;
            hashMap.put(refModelType.getModelId(), this.modelTypeToModelSignature(abstractNode, refModelType));
        }
        return hashMap;
    }

    private int setBuffersForCustom(StringBuilder stringBuilder, StringBuilder stringBuilder2, List<InputSourceType.Custom.Attributes.Attribute> list, int n, List<AttributeType> list2, List<Integer> list3) {
        if (stringBuilder2.length() > 0) {
            stringBuilder2.append(" AND USING\n ");
        } else {
            stringBuilder2.append(" USING\n ");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        for (int n2 : list3) {
            if ("NUMBER".equals(list2.get(n2).getDataType())) {
                stringBuilder.append(list.get(n2).getValue());
            } else {
                stringBuilder.append("'" + list.get(n2).getValue() + "'");
            }
            stringBuilder.append(" \"ATTR" + n + "\"");
            stringBuilder.append(",");
            stringBuilder.append("\n");
            stringBuilder2.append("\"USER_DEFINED\".\"ATTR" + n++ + "\"");
            stringBuilder2.append(" ");
            stringBuilder2.append(StringUtils.addDoubleQuotes((String)list2.get(n2).getName()));
            stringBuilder2.append(",");
            stringBuilder2.append("\n");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length() - 1);
        stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder2.length() - 1);
        return n;
    }

    private void setBuffersForSource(StringBuilder stringBuilder, List<InputSourceType.DataSource.Attributes.Attribute> list, String string, List<AttributeType> list2, List<Integer> list3) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" AND USING\n");
        } else {
            stringBuilder.append(" USING\n");
        }
        for (int n : list3) {
            AttributeType attributeType = (AttributeType)list.get(n);
            if (attributeType.getStatus() != AttributeStatus.VALID) continue;
            stringBuilder.append(String.join((CharSequence)".", string, StringUtils.addDoubleQuotes((String)attributeType.getName())));
            stringBuilder.append(" ");
            stringBuilder.append(StringUtils.addDoubleQuotes((String)list2.get(n).getName()));
            stringBuilder.append(",");
            stringBuilder.append("\n");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length() - 1);
    }

    private ModelSignatureType modelTypeToModelSignature(AbstractNode abstractNode, RefModelType refModelType) {
        ModelSignatureType modelSignatureType = new ModelSignatureType();
        ModelInfoType modelInfoType = new ModelInfoType();
        modelInfoType.setName(refModelType.getName());
        modelInfoType.setModelId(refModelType.getModelId());
        modelInfoType.setStatus(refModelType.getStatus());
        modelInfoType.setSchema(refModelType.getSchema());
        modelInfoType.setMiningFunction(refModelType.getMiningFunction());
        modelInfoType.setMiningAlgorithm(refModelType.getMiningAlgorithm());
        Attributes attributes = new Attributes();
        if (abstractNode instanceof AbstractBuildNode) {
            for (AttributeType attributeType : ((AbstractBuildNode)abstractNode).getModelInputAttributes()) {
                AttributeType attributeType2 = new AttributeType();
                attributeType2.setAlias(attributeType.getAlias());
                attributeType2.setAnnotation(attributeType.getAnnotation());
                attributeType2.setDataType(attributeType.getDataType());
                attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                attributeType2.setName(attributeType.getName());
                attributeType2.setStatus(attributeType.getStatus());
                attributes.getAttribute().add(attributeType2);
            }
        } else if (abstractNode instanceof AbstractModelNode) {
            Model model = new Model(ConnectionFolder.getConnectionFolder(this.getContext()), refModelType.getSchema(), refModelType.getName());
            try {
                List<MiningAttributeType> list = model.getMiningAttributeTypes();
                for (MiningAttributeType miningAttributeType : list) {
                    miningAttributeType.setAnnotation("");
                    miningAttributeType.setAutoPrep("Yes");
                    miningAttributeType.setStatus(AttributeStatus.VALID);
                    miningAttributeType.setDataTypeQualifier(null);
                    miningAttributeType.setMiningType(DatabaseMetadataUtils.getDefaultMiningType(miningAttributeType.getDataType()));
                    miningAttributeType.setAlias(null);
                    attributes.getAttribute().add(miningAttributeType);
                }
            }
            catch (ODMrDAOException oDMrDAOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, oDMrDAOException.getStackTrace()[0].toString(), oDMrDAOException);
            }
        }
        modelSignatureType.setModel(modelInfoType);
        modelSignatureType.setAttributes(attributes);
        return modelSignatureType;
    }

    public static enum DataInput {
        INPUT_1,
        INPUT_2;

    }
}

