/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.cluster.ColumnGeneratorHelper;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DynamicHelper;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterIdType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;

public class DynamicClusterNode
extends DynamicNode {
    private String CLUSTER_TEMPLATE = null;
    public static final String CLUSTER_NODE_INPUT_COLUMNS = "CLUSTER_NODE_INPUT_COLUMNS";
    public static final String NUMBER_OF_CLUSTERS = "NUMBER_OF_CLUSTERS";
    public static final int INITIAL_CLUSTERS = 10;

    public DynamicClusterNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.CLUSTER_TEMPLATE = "SELECT " + (SQLHelper.generateSQLInlineHint(context) ? "/*+ inline */" : "") + "<SUPPLEMENTAL_DATA>\n<DYNAMIC_CLUSTER_CODE>FROM {INPUT_SOURCE}\n";
    }

    @Override
    public DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType() {
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        return dynamicClusterNodeType.getDynamicNodeBaseSettings();
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_DYNAMIC_CLUSTER_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_DYNAMIC_CLUSTER_NODE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_CLUSTER_NODE_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.initDynamicNodeBaseSettingsType();
        dynamicClusterNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
        dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns().getDynamicApplyOutputColumn().addAll(this.generateDefaultPredictionOutputs());
        ClusterIdType clusterIdType = new ClusterIdType();
        ClusterIdType.Column column = new ClusterIdType.Column();
        column.setName(String.valueOf(10));
        clusterIdType.setColumn(column);
        dynamicClusterNodeType.setClusterId(clusterIdType);
        dynamicClusterNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        dynamicClusterNodeType.setStatus(NodeStatusType.INVALID);
    }

    private List<DynamicApplyOutputColumnType> generateDefaultPredictionOutputs() {
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        arrayList.add(ColumnGeneratorHelper.generateDefaultClusterIdOutput(this.getNameGenerator(), true));
        arrayList.add(ColumnGeneratorHelper.generateDefaultClusterProbabilityOutput(this.getNameGenerator(), null, true));
        arrayList.add(ColumnGeneratorHelper.generateDefaultClusterDetailsOutput(this.getNameGenerator(), true));
        arrayList.add(ColumnGeneratorHelper.generateDefaultClusterDistanceOutput(this.getNameGenerator(), null, true));
        return arrayList;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list = attributes.getAttribute();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        MiningAttributes miningAttributes = dynamicNodeBaseSettingsType.getMiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        SupplementalAttributesType supplementalAttributesType = dynamicNodeBaseSettingsType.getSupplementalAttributes();
        supplementalAttributesType.getAttribute();
        CaseAttributes caseAttributes = dynamicNodeBaseSettingsType.getCaseAttributes();
        caseAttributes.getAttribute();
        PartitionExpressions partitionExpressions = dynamicNodeBaseSettingsType.getPartitionExpressions();
        partitionExpressions.getPartitionExpression();
        if (list2.isEmpty()) {
            miningAttributes.setAutoSpec(AutoSpecType.YES);
            this.copyAttributes(list2, list);
            DynamicClusterHelper dynamicClusterHelper = new DynamicClusterHelper(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions, dynamicClusterNodeType.getClusterId());
            this.updateAllColumnsTxn(dynamicClusterHelper, new DynamicClusterHelper());
            this.validate(true);
        } else {
            DynamicClusterHelper dynamicClusterHelper = new DynamicClusterHelper(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions, dynamicClusterNodeType.getClusterId());
            DynamicClusterHelper dynamicClusterHelper2 = this.copyPreviousState(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions, dynamicClusterNodeType.getClusterId());
            this.updateStatusFromDataProvider();
            this.updateAllColumnsTxn(dynamicClusterHelper, dynamicClusterHelper2);
            this.validateSimple(true);
        }
    }

    private DynamicClusterHelper copyPreviousState(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions, ClusterIdType clusterIdType) {
        DynamicHelper dynamicHelper = this.copyPreviousStateCommon(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
        return new DynamicClusterHelper(dynamicHelper.newInputAttributes, dynamicHelper.newSupplAttributes, dynamicHelper.newCaseAttributes, dynamicHelper.newPartExpressions, clusterIdType);
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        boolean bl3 = SQLHelper.isExtendedTypeEnabled(this.getContext());
        this.convertNestedVarcharTypes(bl3);
        bl2 = this.performValidation();
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        DynamicClusterHelper dynamicClusterHelper = this.copyPreviousState(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions(), dynamicClusterNodeType.getClusterId());
        this.updateStatusFromDataProvider();
        DynamicClusterHelper dynamicClusterHelper2 = new DynamicClusterHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions(), dynamicClusterNodeType.getClusterId());
        this.updateAllColumnsTxn(dynamicClusterHelper2, dynamicClusterHelper);
        bl2 = this.performValidation();
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    public void setSQLPredictionExpression(String string) {
        ((DynamicClusterNodeType)this.getData()).getDynamicNodeBaseSettings().setSQLPredictionExpression(string);
    }

    @Override
    public String getHelpTopic() {
        return "dynamic_cluster_node";
    }

    @Override
    public Attributes getAttributes() {
        if (this._isEnableLegacyApplyOutputTypes == null) {
            this.detectDBVersion();
        }
        Attributes attributes = new Attributes();
        if (null != this.getDynamicNodeBaseSettingsType().getSupplementalAttributes() && !this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute().isEmpty()) {
            attributes.getAttribute().addAll(this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute());
        }
        if (null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns() && null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
            for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
                String string = null;
                String string2 = null;
                if (null != dynamicApplyOutputColumnType.getClusterId()) {
                    string2 = dynamicApplyOutputColumnType.getClusterId().getColumn().getName();
                    string = "NUMBER";
                } else if (null != dynamicApplyOutputColumnType.getClusterProbability()) {
                    string2 = dynamicApplyOutputColumnType.getClusterProbability().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "NUMBER" : "BINARY_DOUBLE";
                } else if (null != dynamicApplyOutputColumnType.getClusterDetails()) {
                    string2 = dynamicApplyOutputColumnType.getClusterDetails().getColumn().getName();
                    string = "XMLTYPE";
                } else if (null != dynamicApplyOutputColumnType.getClusterDistance()) {
                    string2 = dynamicApplyOutputColumnType.getClusterDistance().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "NUMBER" : "BINARY_DOUBLE";
                } else if (null != dynamicApplyOutputColumnType.getClusterSet()) {
                    string2 = dynamicApplyOutputColumnType.getClusterSet().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "ODMR_CLUSTER_SET_NUM" : "ODMR_CLUSTER_SET_NUMPD";
                }
                AttributeType attributeType = new AttributeType();
                attributeType.setName(string2);
                attributeType.setDataType(string != null ? string : "UNKNOWN");
                attributeType.setStatus(AttributeStatus.VALID);
                attributes.getAttribute().add(attributeType);
            }
        }
        return attributes;
    }

    @Override
    public String generateSQLExpression() {
        Map<String, String> map = this.generateSQLExpressions();
        return map.get("CLIENT_SQL_EXPRESSION");
    }

    @Override
    public Map<String, String> generateSQLExpressions() {
        Object object2;
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        StringBuilder stringBuilder = new StringBuilder();
        List list = dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute();
        List list2 = dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute();
        List list3 = dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression();
        boolean bl = false;
        int n = 1;
        for (Object object2 : list) {
            bl = this.isCaseIdAttribute((AttributeType)object2, list2) ? false : (this.isPartitionAttribute((MiningAttributeType)object2, list3) ? false : "Yes".equals(object2.getInput()));
            if (!bl) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"");
            stringBuilder.append(object2.getName());
            stringBuilder.append("\"");
            if (stringBuilder.length() <= n * 500) continue;
            stringBuilder.append("\n");
            ++n;
        }
        stringBuilder.append("\n");
        Object object3 = this.generateSupplementalCode(this.CLUSTER_TEMPLATE);
        object2 = object3;
        Map<String, StringBuilder> map = this.generateClusterSQL(dynamicClusterNodeType.getClusterId());
        object3 = StringUtils.getReplacedString((String)object3, "<DYNAMIC_CLUSTER_CODE>", map.get("CLIENT_SQL_EXPRESSION").toString());
        object3 = StringUtils.getReplacedString((String)object3, "<INPUT_LIST>", stringBuilder.toString());
        object2 = StringUtils.getReplacedString((String)object2, "<DYNAMIC_CLUSTER_CODE>", map.get("SERVER_SQL_EXPRESSION").toString());
        object2 = StringUtils.getReplacedString((String)object2, "<INPUT_LIST>", stringBuilder.toString());
        String string = this.wrapExpressionInWithClause((String)object3);
        String string2 = this.wrapExpressionInWithClause((String)object2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CLIENT_SQL_EXPRESSION", string);
        hashMap.put("SERVER_SQL_EXPRESSION", string2);
        return hashMap;
    }

    private Map<String, StringBuilder> generateClusterSQL(ClusterIdType clusterIdType) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        List list = this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn();
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : list) {
            String string;
            PredictionFunctionsHelper.Parameters parameters = DynamicApplyHelper.getPredictionFunctionParameters(dynamicApplyOutputColumnType, null, null, null);
            String string2 = string = parameters.generateCode(this);
            if (parameters instanceof PredictionFunctionsHelper.ClusterId && clusterIdType != null) {
                string = StringUtils.getReplacedString(string, "<CLUSTERS_NUMBER>", clusterIdType.getColumn().getName());
                string2 = StringUtils.getReplacedString(string2, "<CLUSTERS_NUMBER>", clusterIdType.getColumn().getName());
            } else if (parameters instanceof PredictionFunctionsHelper.ClusterProbability) {
                var10_10 = this.generateClusterProbability((PredictionFunctionsHelper.ClusterProbability)parameters, clusterIdType);
                string = StringUtils.getReplacedString(string, "<CLUSTERS_PROBABILITY>", var10_10);
                string2 = StringUtils.getReplacedString(string2, "<CLUSTERS_PROBABILITY>", var10_10);
            } else if (parameters instanceof PredictionFunctionsHelper.ClusterSet) {
                var10_10 = this.generateClusterSet((PredictionFunctionsHelper.ClusterSet)parameters, clusterIdType);
                string = StringUtils.getReplacedString(string, "<CLUSTER_SET>", var10_10);
                string2 = StringUtils.getReplacedString(string2, "<CLUSTER_SET>", var10_10);
            } else if (parameters instanceof PredictionFunctionsHelper.ClusterDistance) {
                var10_10 = this.generateClusterDistance((PredictionFunctionsHelper.ClusterDistance)parameters, clusterIdType);
                string = StringUtils.getReplacedString(string, "<CLUSTERS_DISTANCE>", var10_10);
                string2 = StringUtils.getReplacedString(string2, "<CLUSTERS_DISTANCE>", var10_10);
            } else if (parameters instanceof PredictionFunctionsHelper.ClusterDetails) {
                var10_10 = this.generateClusterDetails((PredictionFunctionsHelper.ClusterDetails)parameters, clusterIdType);
                string = StringUtils.getReplacedString(string, "<CLUSTERS_DETAILS>", var10_10);
                string2 = StringUtils.getReplacedString(string2, "<CLUSTERS_DETAILS>", var10_10);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder.append(string);
            stringBuilder2.append(string2);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("CLIENT_SQL_EXPRESSION", stringBuilder);
        hashMap.put("SERVER_SQL_EXPRESSION", stringBuilder2);
        return hashMap;
    }

    private String generateClusterDetails(PredictionFunctionsHelper.ClusterDetails clusterDetails, ClusterIdType clusterIdType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clusterIdType.getColumn().getName());
        if (clusterDetails != null) {
            Object object = clusterDetails.getSelectedTarget();
            if (null != object) {
                Integer n;
                if (object instanceof Number && (n = (Integer)object) <= Integer.parseInt(clusterIdType.getColumn().getName())) {
                    stringBuilder.append(", " + object.toString());
                }
                if (clusterDetails.isUseTopN()) {
                    stringBuilder.append(", " + clusterDetails.getTopN().toString());
                }
            } else if (clusterDetails.isUseTopN()) {
                stringBuilder.append("NULL, " + clusterDetails.getTopN().toString());
            }
        }
        if (null != clusterDetails.getSort()) {
            stringBuilder.append(" " + ServerConstants.ApplyPredictionDetailsSort.toAlgorithm((String)clusterDetails.getSort()));
        }
        return stringBuilder.toString();
    }

    private String generateClusterDistance(PredictionFunctionsHelper.ClusterDistance clusterDistance, ClusterIdType clusterIdType) {
        Integer n;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clusterIdType.getColumn().getName());
        if (clusterDistance != null && null != (object = clusterDistance.getClusterId()) && object instanceof Number && (n = (Integer)object) <= Integer.parseInt(clusterIdType.getColumn().getName())) {
            stringBuilder.append(", " + object.toString());
        }
        return stringBuilder.toString();
    }

    private String generateClusterSet(PredictionFunctionsHelper.ClusterSet clusterSet, ClusterIdType clusterIdType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clusterIdType.getColumn().getName());
        if (clusterSet != null) {
            if (clusterSet.isUseTopN()) {
                BigInteger bigInteger = clusterSet.getTopN();
                if (!bigInteger.equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                    stringBuilder.append(", " + bigInteger.toString());
                }
                if (clusterSet.isUseCutOff()) {
                    if (bigInteger.equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                        stringBuilder.append(", null");
                    }
                    Double d = clusterSet.getCutOff();
                    stringBuilder.append(", " + d.toString());
                }
            } else if (clusterSet.isUseCutOff()) {
                Double d = clusterSet.getCutOff();
                stringBuilder.append(", null, " + d.toString());
            }
        }
        return stringBuilder.toString();
    }

    private String generateClusterProbability(PredictionFunctionsHelper.ClusterProbability clusterProbability, ClusterIdType clusterIdType) {
        Integer n;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clusterIdType.getColumn().getName());
        if (clusterProbability != null && null != (object = clusterProbability.getClusterId()) && object instanceof Number && (n = (Integer)object) <= Integer.parseInt(clusterIdType.getColumn().getName())) {
            stringBuilder.append(", " + object.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(CLUSTER_NODE_INPUT_COLUMNS) || complexProperty.getPropertyName().equals(ALL_COLUMNS)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        if (string.equals(CLUSTER_NODE_INPUT_COLUMNS)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("DynamicNodeBaseSettingsType", dynamicClusterNodeType.getDynamicNodeBaseSettings());
            hashMap.put("ClusterIdType", dynamicClusterNodeType.getClusterId());
            object = hashMap;
        } else {
            if (string.equals(NUMBER_OF_CLUSTERS)) {
                return dynamicClusterNodeType.getClusterId();
            }
            if (string.equals(ALL_COLUMNS)) {
                DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicClusterNodeType.getDynamicNodeBaseSettings();
                object = new DynamicClusterHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions(), dynamicClusterNodeType.getClusterId());
            } else {
                return super.getProperty(string);
            }
        }
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        DynamicClusterNodeType dynamicClusterNodeType = (DynamicClusterNodeType)this.getData();
        if (string.equals(CLUSTER_NODE_INPUT_COLUMNS)) {
            Map map = (Map)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)map.get("DynamicNodeBaseSettingsType");
            ClusterIdType clusterIdType = (ClusterIdType)map.get("ClusterIdType");
            dynamicClusterNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
            dynamicClusterNodeType.setClusterId(clusterIdType);
        } else if (string.equals(ALL_COLUMNS)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicClusterNodeType.getDynamicNodeBaseSettings();
            DynamicClusterHelper dynamicClusterHelper = (DynamicClusterHelper)object;
            dynamicNodeBaseSettingsType.setMiningAttributes(dynamicClusterHelper.newInputAttributes);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(dynamicClusterHelper.newSupplAttributes);
            dynamicNodeBaseSettingsType.setCaseAttributes(dynamicClusterHelper.newCaseAttributes);
            dynamicNodeBaseSettingsType.setPartitionExpressions(dynamicClusterHelper.newPartExpressions);
            dynamicClusterNodeType.setClusterId(dynamicClusterHelper.clusterId);
        } else if (string.equals(NUMBER_OF_CLUSTERS)) {
            ClusterIdType clusterIdType = (ClusterIdType)object;
            dynamicClusterNodeType.setClusterId(clusterIdType);
        } else {
            super.setProperty(string, object);
        }
    }

    private static class DynamicClusterHelper
    extends DynamicHelper {
        ClusterIdType clusterId;

        DynamicClusterHelper() {
            this.clusterId = new ClusterIdType();
        }

        DynamicClusterHelper(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions, ClusterIdType clusterIdType) {
            super(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
            this.clusterId = clusterIdType;
        }
    }
}

