/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.table;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableEditAttributesDialog;
import oracle.dmt.dataminer.workflow.inspect.DataSourceNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.table.UpdateTableNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.table.WorkflowUpdateTableNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class UpdateTableNodeColumnsGroupPIComponentPanel
extends PIComponentPanel {
    private static final String[] COLUMN_NAMES = new String[]{TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_UPDATE_WITH_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_UPDATE_WITH_TYPE_COLUMN")};
    private static final int NAME = 1;
    private static final int DATA_TYPE = 2;
    private static final int UPDATE_WITH = 0;
    private static final int UPDATE_WITH_DATA_TYPE = 3;
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private List<MapTargetSourceType> _targetColumns = new ArrayList<MapTargetSourceType>();
    private Map<String, String> requiredColumns = new HashMap<String, String>();
    private AbstractDataNode _targetNode;
    private JButton _refreshBtn;
    private static Icon _refreshIcon;
    private JButton _editBtn;
    private static Icon _editIcon;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JCheckBox jChkBoxAuto;

    public UpdateTableNodeColumnsGroupPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jChkBoxAuto = new JCheckBox();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jChkBoxAuto.setText("Auto specification");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChkBoxAuto, -2, 300, -2).addGap(0, 68, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -1, 270, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jChkBoxAuto.setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
            _refreshIcon = OracleIcons.getIcon((String)"refresh.png");
        }
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        AttributeType attributeType2;
        Object object2;
        this._model = (WorkflowUpdateTableNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        assert (nodeType instanceof UpdateTableNodeType);
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)nodeType;
        boolean bl = UpdateTableNode.isAutoSpec(updateTableNodeType);
        this.jChkBoxAuto.setSelected(bl);
        boolean bl2 = this.isWritable();
        this.jChkBoxAuto.setEnabled(bl2);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = UpdateTableNodeColumnsGroupPIComponentPanel.this.jChkBoxAuto.isSelected();
                if (bl && !MessageDialog.confirm((Component)UpdateTableNodeColumnsGroupPIComponentPanel.this, (Object)DataDialogsLrb.get("DATA_PROFILE_ALL_COLUMNS_SELECTED"), (String)DataDialogsLrb.get("DATA_PROFILE_ALL_COLUMNS_SELECTED_CONFIRM"), null)) {
                    UpdateTableNodeColumnsGroupPIComponentPanel.this.jChkBoxAuto.setSelected(false);
                    return;
                }
                ComplexProperty complexProperty = new ComplexProperty("autoSpec", bl ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
                String string = TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_AUTO");
                ArrayList<Property> arrayList = new ArrayList<Property>();
                arrayList.add(new Property(String.valueOf(UpdateTableNodePropertyModel.AUTO_SPEC.index), null, complexProperty, null, null));
                ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                AbstractDataNode abstractDataNode = (AbstractDataNode)UpdateTableNodeColumnsGroupPIComponentPanel.this.getTargetNode((PropertyModel)UpdateTableNodeColumnsGroupPIComponentPanel.this._model);
                complexProperty2.setOldData(abstractDataNode.getSQLExpression());
                arrayList.add(new Property(String.valueOf(UpdateTableNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
                UpdateTableNodeColumnsGroupPIComponentPanel.this._model.setValueAt(string, abstractDataNode, arrayList);
            }
        });
        UpdateTableAttributes updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        if (list != null && !list.isEmpty()) {
            UpdateTableNode.copyAttributes(this._targetColumns, list);
        }
        if (updateTableNodeType != null && updateTableNodeType.getUpdateTargetTable() != null && updateTableNodeType.getUpdateTargetTable().getSchema() != null && updateTableNodeType.getUpdateTargetTable().getName() != null) {
            this.requiredColumns = UpdateTableNode.getRequiredColumns(this.getContext((PropertyModel)this._model), StringUtils.escapeSingleQuotesForSQL(updateTableNodeType.getUpdateTargetTable().getSchema()), StringUtils.escapeSingleQuotesForSQL(updateTableNodeType.getUpdateTargetTable().getName()));
        }
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(this._targetColumns);
        generalAttributesTableModel.setWritable(bl2);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        arrayList.add(UpdateTableNode.getEmptyAttributeType());
        AbstractNode abstractNode = this._targetNode.findParentNode();
        if (abstractNode != null) {
            assert (abstractNode instanceof DataProvider);
            object2 = (DataProvider)((Object)abstractNode);
            arrayList.addAll(object2.getAttributes().getAttribute());
        }
        object2 = new HashMap();
        for (AttributeType attributeType2 : arrayList) {
            object2.put(attributeType2.getName(), attributeType2);
        }
        for (AttributeType attributeType2 : list) {
            object = attributeType2.getValue();
            String string = object.getName();
            if (string == null || null != object2.get(string)) continue;
            arrayList.add((AttributeType)object);
        }
        this.setupItemsTable(generalAttributesTableModel, arrayList);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        this._jAttributesTable.setFillsViewportHeight(true);
        attributeType2 = new ControlBar();
        this._refreshBtn = new JButton(_refreshIcon);
        object = RunManagerLrb.get("REFRESH_TIP");
        this._refreshBtn.setToolTipText((String)object);
        this._refreshBtn.getAccessibleContext().setAccessibleName((String)object);
        this._refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object22;
                NodeType nodeType = UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode.getData();
                assert (nodeType instanceof UpdateTableNodeType);
                UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)nodeType;
                UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
                List list = updateTableAttributes.getUpdateTableItemType();
                UpdateTableNode.copyAttributes(list, UpdateTableNodeColumnsGroupPIComponentPanel.this._targetColumns);
                UpdateTableAttributes updateTableAttributes2 = new UpdateTableAttributes();
                List list2 = updateTableAttributes2.getUpdateTableItemType();
                UpdateTableNode.copyAttributes(list2, UpdateTableNodeColumnsGroupPIComponentPanel.this._targetColumns);
                Map<String, AttributeType> map = UpdateTableNodeColumnsGroupPIComponentPanel.this.getTargetAttributes(updateTableNodeType);
                if (map == null || map.isEmpty()) {
                    for (Object object22 : list2) {
                        object22.getKey().setStatus(AttributeStatus.MISSING);
                    }
                } else {
                    for (Object object22 : list2) {
                        object = object22.getKey().getName();
                        AttributeType attributeType = map.get(object);
                        if (null == attributeType) {
                            object22.getKey().setStatus(AttributeStatus.MISSING);
                            continue;
                        }
                        object22.getKey().setStatus(attributeType.getStatus());
                    }
                }
                ArrayList arrayList = new ArrayList();
                object22 = new ComplexProperty("targetColumns", updateTableAttributes2);
                ((ComplexProperty)object22).setOldData(updateTableAttributes);
                arrayList.add(new Property(String.valueOf(DataSourceNodePropertyModel.DATA_SOURCE_TABLE_CONTENTS.index), null, object22, null, null));
                object = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                ((ComplexProperty)object).setOldData(UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode.getSQLExpression());
                arrayList.add(new Property(String.valueOf(DataSourceNodePropertyModel.SQL_EXPRESSION.index), null, object, null, null));
                UpdateTableNodeColumnsGroupPIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_DATA_SOURCE_NODE_ATTRIBUTES_REFRESHED"), UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode, arrayList);
            }
        });
        attributeType2.add((Component)this._refreshBtn);
        this._editBtn = new JButton(_editIcon);
        object = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText((String)object);
        this._editBtn.setEnabled(bl2 && !list.isEmpty());
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateTableNodeColumnsGroupPIComponentPanel.this.updateTableEditAttributes();
            }
        });
        attributeType2.add((Component)this._editBtn);
        this.jAttributesComponent.setControlBar((ControlBar)attributeType2);
        this._jAttributesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    UpdateTableNodeColumnsGroupPIComponentPanel.this.updateTableEditAttributes();
                }
            }
        });
    }

    private void updateTableEditAttributes() {
        UpdateTableNode updateTableNode = (UpdateTableNode)this._targetNode;
        UpdateTableEditAttributesDialog updateTableEditAttributesDialog = new UpdateTableEditAttributesDialog(this.getContext((PropertyModel)this._model), updateTableNode);
        DialogHelper dialogHelper = new DialogHelper(updateTableEditAttributesDialog);
        boolean bl = dialogHelper.showAsDialog(this);
        if (bl) {
            UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)this._targetNode.getData();
            UpdateTableAttributes updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
            List list = updateTableAttributes.getUpdateTableItemType();
            UpdateTableAttributes updateTableAttributes2 = new UpdateTableAttributes();
            List list2 = updateTableAttributes2.getUpdateTableItemType();
            UpdateTableNode.copyAttributes(list2, list);
            UpdateTableAttributes updateTableAttributes3 = new UpdateTableAttributes();
            List<MapTargetSourceType> list3 = updateTableEditAttributesDialog.getResultTargetSourceType();
            for (MapTargetSourceType object2 : list3) {
                if (null == this.requiredColumns.get(object2.getKey().getName())) continue;
                object2.getKey().setRequiredColumn(true);
            }
            UpdateTableNode.copyAttributes(updateTableAttributes3.getUpdateTableItemType(), list3);
            ComplexProperty complexProperty = new ComplexProperty("targetColumns", updateTableAttributes3);
            complexProperty.setOldData(updateTableAttributes2);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(UpdateTableNodePropertyModel.TARGET_COLUMNS.index), null, complexProperty, null, null));
            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            AbstractDataNode abstractDataNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
            complexProperty2.setOldData(abstractDataNode.getSQLExpression());
            arrayList.add(new Property(String.valueOf(UpdateTableNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
            this._model.setValueAt(UpdateTableNode.UPDATE_TABLE_INPUT, abstractDataNode, arrayList);
        }
    }

    protected Map<String, AttributeType> getTargetAttributes(UpdateTableNodeType updateTableNodeType) {
        Table table = new Table(updateTableNodeType.getUpdateTargetTable());
        return this.getAvailableAttributes(table);
    }

    /*
     * WARNING - void declaration
     */
    public void updateUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        TableColumnModel tableColumnModel;
        Object object3;
        if (!(propertyModel instanceof WorkflowUpdateTableNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowUpdateTableNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        assert (nodeType instanceof UpdateTableNodeType);
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)nodeType;
        boolean bl = UpdateTableNode.isAutoSpec(updateTableNodeType);
        this.jChkBoxAuto.setSelected(bl);
        this._targetColumns.clear();
        UpdateTableAttributes updateTableAttributes = updateTableNodeType.getUpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        if (list != null && !list.isEmpty()) {
            UpdateTableNode.copyAttributes(this._targetColumns, list);
        }
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        HashMap<String, TableColumnModel> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            object3 = (GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel());
            hashMap = new HashMap<String, TableColumnModel>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel = (MapTargetSourceType)((ODMrTableModel)((Object)object3)).getSrcData().get(nArray[i]);
                hashMap.put(tableColumnModel.getKey().getName(), tableColumnModel);
            }
        }
        object3 = this._jAttributesTable.getVisibleRect();
        TableColumn tableColumn = null;
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            nArray2[i] = tableColumn.getPreferredWidth();
        }
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(this._targetColumns);
        generalAttributesTableModel.setWritable(this.isWritable());
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        arrayList.add(UpdateTableNode.getEmptyAttributeType());
        AbstractNode abstractNode = this._targetNode.findParentNode();
        if (abstractNode != null) {
            assert (abstractNode instanceof DataProvider);
            object2 = (DataProvider)((Object)abstractNode);
            arrayList.addAll(object2.getAttributes().getAttribute());
        }
        object2 = new HashMap();
        for (AttributeType object4 : arrayList) {
            object2.put(object4.getName(), object4);
        }
        for (MapTargetSourceType mapTargetSourceType : list) {
            AttributeType attributeType = mapTargetSourceType.getValue();
            object = attributeType.getName();
            if (object == null || null != object2.get(object)) continue;
            arrayList.add(attributeType);
        }
        this.setupItemsTable(generalAttributesTableModel, arrayList);
        if (hashMap != null) {
            Vector vector = new Vector();
            List list2 = generalAttributesTableModel.getSrcData();
            for (int i = 0; i < list2.size(); ++i) {
                object = (MapTargetSourceType)list2.get(i);
                if (null == hashMap.get(object.getKey().getName())) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = integerArray[i];
                }
                this._jAttributesTable.setSelectedRowsInModel((int[])object);
            }
        }
        this._jAttributesTable.scrollRectToVisible((Rectangle)object3);
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        if (n == n2) {
            void var19_28;
            boolean bl2 = false;
            while (var19_28 < n2) {
                tableColumn = tableColumnModel.getColumn((int)var19_28);
                tableColumn.setPreferredWidth(nArray2[var19_28]);
                ++var19_28;
            }
        }
        this._editBtn.setEnabled(this.isWritable() && !list.isEmpty());
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel, List<AttributeType> list) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(1, true);
        this._jAttributesTable.setAutoResizeMode(4);
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        JComboBox jComboBox = new JComboBox();
        Vector<String> vector = new Vector<String>(list.size());
        for (AttributeType attributeType : list) {
            vector.add(attributeType.getName());
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(vector));
        jComboBox.setModel(defaultComboBoxModel);
        tableColumn.setCellEditor(new CustomComboCellEditor(jComboBox));
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    private class GeneralAttributesTableModel
    extends ODMrTableModel<MapTargetSourceType> {
        private boolean _writable;

        private GeneralAttributesTableModel(List<MapTargetSourceType> list) {
            super(COLUMN_NAMES, new ArrayList<MapTargetSourceType>(list));
            this._writable = true;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            AbstractDataNode abstractDataNode;
            if (UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode == null || n2 != 0) {
                return;
            }
            NodeType nodeType = UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode.getData();
            assert (nodeType instanceof UpdateTableNodeType);
            UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)nodeType;
            if (UpdateTableNode.isAutoSpec(updateTableNodeType)) {
                return;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ArrayList arrayList = new ArrayList();
            AbstractNode abstractNode = UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode.findParentNode();
            if (abstractNode != null) {
                assert (abstractNode instanceof AbstractDataNode);
                abstractDataNode = (AbstractDataNode)abstractNode;
                arrayList.addAll(abstractDataNode.getAttributes().getAttribute());
            }
            abstractDataNode = (MapTargetSourceType)this.srcData.get(n);
            MapTargetSourceType mapTargetSourceType = new MapTargetSourceType();
            UpdateTableColumnType updateTableColumnType = new UpdateTableColumnType();
            updateTableColumnType.setRequiredColumn(abstractDataNode.getKey().isRequiredColumn());
            AttributeTypeHelper.copyAttribute((AttributeType)updateTableColumnType, (AttributeType)abstractDataNode.getKey());
            mapTargetSourceType.setKey(updateTableColumnType);
            AttributeType attributeType = null;
            if (object != null) {
                for (AttributeType attributeType2 : arrayList) {
                    if (null == attributeType2.getName() || !attributeType2.getName().equals(object.toString()) || !attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    attributeType = new AttributeType();
                    AttributeTypeHelper.copyAttribute(attributeType, attributeType2);
                    break;
                }
            } else {
                attributeType = UpdateTableNode.getEmptyAttributeType();
                updateTableColumnType.setStatus(AttributeStatus.VALID);
            }
            if (attributeType == null) {
                return;
            }
            mapTargetSourceType.setValue(attributeType);
            ComplexProperty complexProperty = new ComplexProperty("updateWith", mapTargetSourceType);
            complexProperty.setOldData(abstractDataNode);
            UpdateTableNodeColumnsGroupPIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_ALIAS"), UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode, complexProperty, UpdateTableNodePropertyModel.UPDATE_WITH.index);
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            String string = null;
            if (this.srcData.isEmpty()) {
                return "";
            }
            MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)this.srcData.get(n);
            String string2 = null;
            String string3 = null;
            AttributeType attributeType = null;
            switch (n2) {
                case 1: {
                    string = mapTargetSourceType.getKey().getAlias() != null ? mapTargetSourceType.getKey().getAlias() : mapTargetSourceType.getKey().getName();
                    break;
                }
                case 2: {
                    string2 = mapTargetSourceType.getKey().getDataType();
                    string3 = mapTargetSourceType.getKey().getDataTypeQualifier();
                    if (DatabaseMetadataUtils.isACharacterOracleDataType(string2)) {
                        string = DatabaseMetadataUtils.getJSONDataType(string2, string3);
                        break;
                    }
                    string = string2;
                    break;
                }
                case 0: {
                    attributeType = mapTargetSourceType.getValue();
                    string = attributeType != null && attributeType.getName() != null ? attributeType.getName() : null;
                    break;
                }
                case 3: {
                    attributeType = mapTargetSourceType.getValue();
                    if (attributeType == null) break;
                    string2 = attributeType.getDataType();
                    string3 = attributeType.getDataTypeQualifier();
                    if (DatabaseMetadataUtils.isACharacterOracleDataType(string2)) {
                        string = DatabaseMetadataUtils.getJSONDataType(string2, string3);
                        break;
                    }
                    string = string2;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return string != null ? string : "";
        }

        @Override
        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            return super.getColumnClass(n);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                NodeType nodeType = UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode.getData();
                assert (nodeType instanceof UpdateTableNodeType);
                UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)nodeType;
                if (UpdateTableNode.isAutoSpec(updateTableNodeType)) {
                    return false;
                }
                return this._writable;
            }
            return false;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Icon icon = null;
            for (MapTargetSourceType mapTargetSourceType : UpdateTableNodeColumnsGroupPIComponentPanel.this._targetColumns) {
                if (n2 == 1) {
                    if (!mapTargetSourceType.getKey().getName().equals(object.toString())) continue;
                    icon = 0 == mapTargetSourceType.getKey().getStatus().compareTo((Enum)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
                    break;
                }
                if (n2 != 0 || null == mapTargetSourceType.getValue().getName() || mapTargetSourceType.getValue().getName().trim().isEmpty() || null == mapTargetSourceType.getValue().getStatus() || !mapTargetSourceType.getValue().getName().equals(object.toString())) continue;
                icon = 0 == mapTargetSourceType.getValue().getStatus().compareTo((Enum)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
                break;
            }
            if (icon != null) {
                this.setIcon(icon);
            } else {
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.getModel());
                int n3 = UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.convertRowIndexToModel(n);
                MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)generalAttributesTableModel.getSrcData().get(n3);
                UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
                if (updateTableColumnType.isRequiredColumn() && updateTableColumnType.getStatus().equals((Object)AttributeStatus.VALID)) {
                    this.setIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
                    ((JLabel)component).setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_REQUIRED"));
                } else if (object.toString().trim().isEmpty()) {
                    this.setIcon(null);
                } else {
                    this.setIcon(updateTableColumnType.getStatus().equals((Object)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png"));
                }
            }
            return component;
        }
    }

    private class CustomComboCellEditor
    extends DefaultCellEditor {
        public CustomComboCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object3;
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            List list = null;
            AbstractNode abstractNode = UpdateTableNodeColumnsGroupPIComponentPanel.this._targetNode.findParentNode();
            if (abstractNode != null) {
                assert (abstractNode instanceof AbstractDataNode);
                object3 = (AbstractDataNode)abstractNode;
                list = object3.getAttributes().getAttribute();
            }
            object3 = (GeneralAttributesTableModel)((Object)UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.getModel());
            int n3 = UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.convertRowIndexToModel(n);
            MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)((ODMrTableModel)((Object)object3)).getSrcData().get(n3);
            UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
            AttributeType attributeType = mapTargetSourceType.getValue();
            String string = updateTableColumnType.getDataType();
            ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
            arrayList.add(UpdateTableNode.getEmptyAttributeType());
            if (list != null) {
                for (AttributeType attributeType2 : list) {
                    if (attributeType2.getDataType().equals(string)) {
                        arrayList.add(attributeType2);
                        continue;
                    }
                    if (!DatabaseMetadataUtils.canDataBeImplicitlyConverted(attributeType2.getDataType(), string)) continue;
                    arrayList.add(attributeType2);
                }
            }
            Vector vector = new Vector(arrayList.size());
            boolean bl2 = true;
            for (AttributeType object22 : arrayList) {
                String string2 = object22.getName();
                vector.add(object22.getName());
                if ((attributeType.getName() == null || attributeType.getName().trim().isEmpty()) && (string2 == null || string2.trim().isEmpty())) {
                    bl2 = false;
                    continue;
                }
                if (attributeType.getName() == null || string2 == null || !string2.equals(attributeType.getName())) continue;
                bl2 = false;
            }
            if (bl2) {
                vector.add(attributeType.getName());
            }
            Collections.sort(vector);
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(vector));
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.setRenderer(new IconListRenderer());
            jComboBox.setModel(defaultComboBoxModel);
            jComboBox.setSelectedItem(attributeType.getName());
            return component;
        }
    }

    class IconListRenderer
    extends DefaultListCellRenderer {
        IconListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            int n2 = UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.getSelectedRow();
            if (-1 != n2) {
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.getModel());
                int n3 = UpdateTableNodeColumnsGroupPIComponentPanel.this._jAttributesTable.convertRowIndexToModel(n2);
                object2 = (MapTargetSourceType)generalAttributesTableModel.getSrcData().get(n3);
                UpdateTableColumnType updateTableColumnType = object2.getKey();
                bl5 = updateTableColumnType.isRequiredColumn();
            }
            for (MapTargetSourceType mapTargetSourceType : UpdateTableNodeColumnsGroupPIComponentPanel.this._targetColumns) {
                bl4 = true;
                if (object == null) {
                    bl3 = false;
                    break;
                }
                object2 = mapTargetSourceType.getValue().getName();
                if (object2 == null || ((String)object2).trim().isEmpty() || !object.toString().equals(mapTargetSourceType.getValue().getName()) || 0 == mapTargetSourceType.getValue().getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                bl4 = false;
                bl3 = true;
                break;
            }
            if (!bl3) {
                if (bl5) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
                    jLabel.setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_REQUIRED"));
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_NONE"));
                }
            } else {
                jLabel.setIcon(bl4 ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png"));
            }
            return jLabel;
        }
    }
}

