/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.regression;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CommentTextFieldEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.utils.comparator.BooleanComparator;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.inspect.AbstractButtonState;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Pair;

public class RegressionBuildPIComponentBuildPanel
extends GeneralBuildPIPanel
implements RegressionBuildPIComponentGUI {
    private static final Logger theLogger = Logger.getLogger(RegressionBuildPIComponentBuildPanel.class.getName());
    private static String _NOT_TESTED = BuildEditorLrb.get("BUILD_MODEL_NOT_TESTED");
    private List<RegressionResultType> _regResults;
    private JButton _viewModelBtn;
    private JButton _viewCompareBtn;
    private JButton _removeBtn;
    private JButton _addBtn;
    private static final String NOT_TESTED = "Not tested";
    private DataMinerTablePanel dataMinerTablePanel;

    public RegressionBuildPIComponentBuildPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._regResults = MetaDataHelper.getRegressionResultsCollection(abstractBuildNode);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return RegressionBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return RegressionBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public void updateCell(int n, int n2) {
        GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)this.getTable().getModel();
        genericBaseTableModel.fireTableCellUpdated(n, n2);
    }

    @Override
    protected int getModelNameIdFromPropertyModel() {
        return RegressionBuildNodePropertyModel.MODEL_NAME.index;
    }

    @Override
    protected int getModelsRerunIdFromPropertyModel() {
        return RegressionBuildNodePropertyModel.MODELS_RERUN.index;
    }

    @Override
    protected int getTestsRerunIdFromPropertyModel() {
        return RegressionBuildNodePropertyModel.TESTS_RERUN.index;
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 500, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.dataMinerTablePanel, -1, 201, Short.MAX_VALUE)));
    }

    public void initRes() {
    }

    @Override
    public void initUI(PropertyModel propertyModel) {
        super.initUI(propertyModel);
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        ModelsTableModel modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        modelsTableModel.setWritable(this.isWritable());
        this.dataMinerTablePanel.setup((TableModel)((Object)modelsTableModel), BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL"), new String[]{modelsTableModel.COLUMN_NAMES[0], modelsTableModel.COLUMN_NAMES[4]}, 0);
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XMLGregorianCalendar xMLGregorianCalendar;
                    boolean bl = false;
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)RegressionBuildPIComponentBuildPanel.this.getTable().getModel());
                    if (modelsTableModel.getDataVector().isEmpty()) {
                        return;
                    }
                    int[] nArray = RegressionBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                    ModelType modelType = (ModelType)modelsTableModel.getDataVector().get(nArray[0]);
                    if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                        bl = true;
                    } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                        bl = true;
                    }
                    if (bl) {
                        RegressionBuildPIComponentBuildPanel.this.viewModel();
                    }
                }
            }
        });
        this._viewModelBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this._viewModelBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._viewModelBtn.setDisabledIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_DIS));
        this._viewModelBtn.setEnabled(false);
        this._viewModelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegressionBuildPIComponentBuildPanel.this.viewModel();
            }
        });
        this._viewCompareBtn = new JButton(OracleIcons.getIcon((String)"showdifferences.png"));
        this._viewCompareBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_RESULTS_COMPARE"));
        this._viewCompareBtn.setEnabled(this.compareEnabled());
        this._viewCompareBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<RegressionResultType> arrayList = new ArrayList<RegressionResultType>();
                for (RegressionResultType regressionResultType : RegressionBuildPIComponentBuildPanel.this._regResults) {
                    XMLGregorianCalendar xMLGregorianCalendar = regressionResultType.getCreationDate();
                    if (xMLGregorianCalendar == null) continue;
                    arrayList.add(regressionResultType);
                }
                if (arrayList.isEmpty()) {
                    return;
                }
                RegressionBuildPIComponentBuildPanel.this.viewCompare(arrayList);
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)RegressionBuildPIComponentBuildPanel.this.getTable()));
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = RegressionBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)RegressionBuildPIComponentBuildPanel.this.getTable().getModel());
                ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                for (int i = 0; i < nArray.length; ++i) {
                    ModelType modelType = (ModelType)modelsTableModel.getDataVector().get(nArray[i]);
                    arrayList.add(modelType);
                }
                RegressionBuildPIComponentBuildPanel.this.setValue(arrayList, "modelRemoved", "modelAdded");
            }
        });
        this._removeBtn.setEnabled(false);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADD"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelType modelType;
                AbstractBuildNode abstractBuildNode = RegressionBuildPIComponentBuildPanel.this.getTargetNode((PropertyModel)RegressionBuildPIComponentBuildPanel.this._model);
                if (abstractBuildNode instanceof RegressionBuildNode && (modelType = NewModelPanel.addNewModel(RegressionBuildPIComponentBuildPanel.this, (BuildNodeType)abstractBuildNode.getData(), RegressionBuildPIComponentBuildPanel.this.getContext((PropertyModel)RegressionBuildPIComponentBuildPanel.this._model), abstractBuildNode)) != null) {
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    arrayList.add(modelType);
                    RegressionBuildPIComponentBuildPanel.this.setValue(arrayList, "modelAdded", "modelRemoved");
                }
            }
        });
        this._addBtn.setEnabled(this.isWritable());
        this.dataMinerTablePanel.addControlBarComponents(this._addBtn, this._removeBtn, this._duplicateBtn, this._viewModelBtn, this._viewCompareBtn);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RegressionBuildPIComponentBuildPanel.this.handleModelSelectionChanged();
            }
        });
        this.getTable().setFillsViewportHeight(true);
    }

    @Override
    public DataMinerTable getTable() {
        return this.dataMinerTablePanel.getTable();
    }

    public void reloadUI(PropertyModel propertyModel) {
        Vector vector;
        ModelsTableModel modelsTableModel;
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ArrayList<Vector> arrayList = null;
        if (nArray != null && nArray.length > 0) {
            modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
            arrayList = new ArrayList<Vector>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                vector = (ModelType)modelsTableModel.getDataVector().get(nArray[i]);
                arrayList.add(vector);
            }
        }
        modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        if (arrayList != null) {
            Object object;
            Vector<Integer> vector2 = new Vector<Integer>();
            vector = modelsTableModel.getDataVector();
            for (int i = 0; i < vector.size(); ++i) {
                object = (ModelType)vector.get(i);
                if (!arrayList.contains(object)) continue;
                vector2.add(i);
            }
            if (!vector2.isEmpty()) {
                Integer[] integerArray = vector2.toArray(new Integer[vector2.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = (ModelType)integerArray[i];
                }
                this.getTable().setSelectedRowsInModel((int[])object);
            }
        }
        this._viewCompareBtn.setEnabled(this.compareEnabled());
    }

    @Override
    protected ModelType getModelType(int n) {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = (ModelType)modelsTableModel.getDataVector().get(this.getTable().convertRowIndexToModel(n));
        return modelType;
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this.getTable().setModel((TableModel)((Object)modelsTableModel));
        this.getTable().setSorted(true);
        this.getTable().setUpdateSelectionOnSort(true);
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.getTable().sizeTableToContents();
        this.getTable().setAutoResizeMode(4);
        if (modelsTableModel.getRowCount() == 0) {
            return;
        }
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
                int n3 = jTable.convertRowIndexToModel(n);
                ModelType modelType = (ModelType)modelsTableModel.getDataVector().get(n3);
                return IconCellRenderer.getIconForPIStatus(modelType.getStatus());
            }
        });
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(iconCellRenderer);
        IconCellRenderer iconCellRenderer2 = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
                int n3 = jTable.convertRowIndexToModel(n);
                ModelType modelType = (ModelType)modelsTableModel.getDataVector().get(n3);
                RegressionResultType regressionResultType = null;
                for (RegressionResultType regressionResultType2 : RegressionBuildPIComponentBuildPanel.this._regResults) {
                    if (!regressionResultType2.getModelId().equals(modelType.getId())) continue;
                    regressionResultType = regressionResultType2;
                    break;
                }
                if (object.equals(RegressionBuildPIComponentBuildPanel.NOT_TESTED)) {
                    return OracleIcons.getIcon((String)"incompletestatus.png");
                }
                if (regressionResultType != null) {
                    return IconCellRenderer.getIconForPIStatus(regressionResultType.getStatus());
                }
                return OracleIcons.getIcon((String)"database_error.png");
            }
        });
        TableColumn tableColumn2 = this.getTable().getColumnModel().getColumn(3);
        tableColumn2.setCellRenderer(iconCellRenderer2);
        TableColumn tableColumn3 = this.getTable().getColumnModel().getColumn(1);
        tableColumn3.setCellEditor(new OutputCellEditor());
        tableColumn3.setCellRenderer(new OutputCellRenderer());
        TableColumn tableColumn4 = this.getTable().getColumnModel().getColumn(5);
        tableColumn4.setCellEditor(new CommentTextFieldEditor(this.getContext((PropertyModel)this._model)));
        tableColumn4.setMaxWidth(200);
        TableColumn tableColumn5 = this.getTable().getColumnModel().getColumn(0);
        tableColumn5.setMinWidth(100);
        tableColumn5.setCellEditor(new ModelNameCellEditor(this.getContext((PropertyModel)this._model), this.getWorkflowModel(), (BuildNodeType)this.getTargetNode((PropertyModel)this._model).getData()));
    }

    @Override
    public boolean isWritable() {
        return RegressionBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    private void setEnabled(AbstractButton[] abstractButtonArray, boolean[] blArray) {
        boolean bl = this.isWritable();
        AbstractButtonState abstractButtonState = new AbstractButtonState(abstractButtonArray, blArray);
        abstractButtonState.setState(bl);
    }

    private void setValue(ModelType modelType, Object object) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (object != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), (String)object);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.MODEL_ANNOTATION.index), null, new ComplexProperty("modelAnnotation", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(List<Pair> list) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.MODEL_USEFOROUTPUT.index), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), abstractBuildNode, arrayList);
        this.updateWorkFlow();
    }

    @Override
    protected void setValue(List<ModelType> list, String string, String string2) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADDED_REMOVED"), this.getTargetNode((PropertyModel)this._model), new ComplexProperty(string, string2, list), RegressionBuildNodePropertyModel.MODEL_ADDED_REMOVED.index);
            this.updateWorkFlow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RegressionBuildPIComponentBuildPanel.this.resetModelSettingsTable((PropertyModel)RegressionBuildPIComponentBuildPanel.this._model);
                }
            });
        }
    }

    protected void updateWorkFlow() {
        this.updateWorkFlowInternal();
    }

    private void handleModelSelectionChanged() {
        Object[] objectArray;
        AbstractButton[] abstractButtonArray;
        boolean bl;
        boolean bl2 = false;
        int n = this.getTable().getSelectedRowCount();
        boolean bl3 = bl = n == 1;
        if (n > 0) {
            XMLGregorianCalendar xMLGregorianCalendar;
            abstractButtonArray = (AbstractButton[])this.getTable().getModel();
            objectArray = this.getTable().getSelectedRowsInModel();
            if (objectArray.length == 0) {
                return;
            }
            ModelType modelType = (ModelType)abstractButtonArray.getDataVector().get(objectArray[0]);
            if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                bl2 = true;
            } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                bl2 = true;
            }
        }
        this._viewModelBtn.setEnabled(bl2 && bl);
        this._viewCompareBtn.setEnabled(this.compareEnabled());
        abstractButtonArray = new AbstractButton[]{this._viewCompareBtn, this._removeBtn, this._addBtn, this._duplicateBtn};
        objectArray = new boolean[]{bl2, n > 0, n != -1, true};
        this.setEnabled(abstractButtonArray, (boolean[])objectArray);
    }

    private boolean compareEnabled() {
        boolean bl = false;
        for (RegressionResultType regressionResultType : this._regResults) {
            XMLGregorianCalendar xMLGregorianCalendar = regressionResultType.getCreationDate();
            if (xMLGregorianCalendar == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void viewCompare(List<RegressionResultType> list) {
        Context context = this.getContext((PropertyModel)this._model);
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        try {
            Element[] elementArray = context.getSelection();
            WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
            NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
            if (nodeType instanceof RegressionBuildNodeType) {
                BuildNodeType buildNodeType = (BuildNodeType)nodeType;
                TestCompareNode testCompareNode = WorkflowEditor.createRegressTestCompareNode(context, workflowNode, buildNodeType, list);
                if (testCompareNode != null) {
                    EditorUtil.openDefaultEditorInFrame((Node)testCompareNode);
                } else {
                    MessageDialog.error((Component)this, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                }
            }
        }
        catch (DBException dBException) {
            theLogger.log(Level.SEVERE, dBException.getMessage(), dBException);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void viewModel() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = (ModelType)modelsTableModel.getDataVector().get(nArray[0]);
        if (modelType instanceof RSupportVectorMachineModelType) {
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(modelType);
            loadSVMModelViewer.execute();
        } else {
            Class<GLMRModelNode> clazz = null;
            if (modelType instanceof RGeneralizedLinearModelType) {
                clazz = GLMRModelNode.class;
            }
            Context context = this.getContext((PropertyModel)this._model);
            String string = modelType.getName();
            String string2 = this.getTargetNode((PropertyModel)this._model).getData().getName();
            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
            EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
        }
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._regResults.clear();
        this._regResults = MetaDataHelper.getRegressionResultsCollection(abstractBuildNode);
        this.reloadUI(propertyModel);
    }

    class ModelsTableModel
    extends SimpleBaseTableModel
    implements BuildNodeTableModel {
        private String[] COLUMN_NAMES = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_NAME"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_COMMENT")};
        private static final int MODEL_NAME = 0;
        private static final int OUTPUT = 1;
        private static final int BUILD = 2;
        private static final int TEST = 3;
        private static final int ALGORITHM = 4;
        private static final int COMMENT = 5;
        private Vector<ModelType> _srcData;
        private Map<String, ModelType> _srcMap;
        private boolean _writable = true;

        public ModelsTableModel(List<ModelType> list) {
            this._srcData = new Vector(list.size());
            this._srcData.addAll(list);
            this._srcMap = new HashMap<String, ModelType>();
            for (ModelType modelType : list) {
                this._srcMap.put(modelType.getName(), modelType);
            }
            this.setColumnIdentifiers(this.COLUMN_NAMES);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(this.COLUMN_NAMES.length);
        }

        @Override
        public List<ModelType> getDataList() {
            return new ArrayList<ModelType>(this._srcData);
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 1: {
                    return BooleanComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Vector getDataVector() {
            return this._srcData;
        }

        @Override
        public String getOriginalModelName(int n) {
            ModelType modelType = this._srcData.get(n);
            return modelType.getName();
        }

        public Pair<String, Boolean> getValueAtCheckBoxColumn(int n) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ModelType modelType = this._srcData.get(n);
            Pair pair = new Pair((Object)modelType.getName(), (Object)modelType.isUseForOutput());
            return pair;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return null;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this._srcData.get(n);
            Object object = null;
            block0 : switch (n2) {
                case 0: {
                    object = modelType.getName();
                    break;
                }
                case 4: {
                    object = MetaDataHelper.getAlgorithmName(modelType);
                    break;
                }
                case 3: {
                    object = _NOT_TESTED;
                    for (RegressionResultType regressionResultType : RegressionBuildPIComponentBuildPanel.this._regResults) {
                        if (!modelType.getId().equals(regressionResultType.getModelId())) continue;
                        XMLGregorianCalendar xMLGregorianCalendar = regressionResultType.getCreationDate();
                        if (xMLGregorianCalendar == null) break block0;
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break block0;
                    }
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = _NOT_BUILT;
                    break;
                }
                case 5: {
                    String string = modelType.getAnnotation();
                    object = string != null ? string : "";
                    break;
                }
                case 1: {
                    object = modelType.isUseForOutput();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 5 || n2 == 0 || n2 == 1) {
                return this._writable;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 5) {
                ModelType modelType = this._srcData.get(n);
                RegressionBuildPIComponentBuildPanel.this.setValue(modelType, object);
                this.fireTableCellUpdated(n, n2);
            } else if (n2 == 0) {
                RegressionBuildPIComponentBuildPanel.this.renameModel(this._srcData, object, n, n2);
            } else if (n2 == 1) {
                ModelType modelType = this._srcData.get(n);
                Boolean bl = (Boolean)object;
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                arrayList.add(new Pair((Object)modelType.getId(), (Object)bl));
                RegressionBuildPIComponentBuildPanel.this.setValue(arrayList);
            }
        }
    }

    private class LoadSVMModelViewer
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        ModelType _modelType;
        boolean _isLinear = false;

        public LoadSVMModelViewer(ModelType modelType) {
            this._modelType = modelType;
        }

        protected Object doInBackground() throws Exception {
            try {
                Context context = RegressionBuildPIComponentBuildPanel.this.getContext((PropertyModel)RegressionBuildPIComponentBuildPanel.this._model);
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                String string = connectionFolder.getUserAccountName();
                Model model = new Model(connectionFolder, string, this._modelType.getName());
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add("SVMS_KERNEL_FUNCTION");
                List<MiningModelSettings> list = model.getModelSetting(arrayList);
                MiningModelSettings miningModelSettings = list.get(0);
                this._isLinear = miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return this._isLinear;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                Context context = RegressionBuildPIComponentBuildPanel.this.getContext((PropertyModel)RegressionBuildPIComponentBuildPanel.this._model);
                BaseTreeNode baseTreeNode = null;
                String string = this._modelType.getName();
                if (string != null) {
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string2 = RegressionBuildPIComponentBuildPanel.this.getTargetNode((PropertyModel)RegressionBuildPIComponentBuildPanel.this._model).getData().getName();
                    baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                }
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
            }
        }
    }
}

