/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.clustering;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.Context;

public class ClusteringPartitionedBuildNodePropertyModel
extends AbstractNodePropertyModel {
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    public static final NodeProperty PROP_MODEL_ADDED_REMOVED;
    public static final NodeProperty PROP_ALGORITHM_SETTINGS;
    public static final NodeProperty PROP_CASE_IDS;
    public static final NodeProperty PROP_MODELS_RERUN;
    public static final NodeProperty PROP_MODEL_ANNOTATION;
    public static final NodeProperty PROP_MODEL_NAME;
    public static final NodeProperty PROP_MODEL_USEFOROUTPUT;
    public static final NodeProperty PROP_MINING_ATTRIBUTE_SETTINGS;
    public static final NodeProperty PROP_PARTITIONS_MAX_NUM;
    public static final NodeProperty PROP_PARTITIONS_EXPRESSION_EDIT;
    public static final NodeProperty PROP_ODMS_PARTITION_BUILD_TYPE;

    public ClusteringPartitionedBuildNodePropertyModel(Context context) {
        super(context);
    }

    @Override
    public String getHelpTopic() {
        return "clustering_node_pi";
    }

    @Override
    protected List<NodeProperty> getNodeProperties() {
        return properties;
    }

    private static void prepareStatusReady(List<Property> list, AbstractBuildNode abstractBuildNode) {
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType modelType : list2) {
            hashMap.put(modelType.getId(), ModelStatusType.READY);
        }
        if (!hashMap.isEmpty()) {
            list.add(new Property(String.valueOf(ClusteringPartitionedBuildNodePropertyModel.PROP_MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
        }
    }

    public static void updatePartitionBuildType(List<Property> list, AbstractBuildNode abstractBuildNode, String string, String string2) {
        ComplexProperty complexProperty = new ComplexProperty("ODMS_PARTITION_BUILD_TYPE", string);
        complexProperty.setOldData(string2);
        list.add(new Property(String.valueOf(ClusteringPartitionedBuildNodePropertyModel.PROP_ODMS_PARTITION_BUILD_TYPE.index), null, complexProperty, null, null));
        ClusteringPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updateMaxNumPartitions(List<Property> list, AbstractBuildNode abstractBuildNode, BigInteger bigInteger, BigInteger bigInteger2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_MAX_NUM", bigInteger);
        complexProperty.setOldData(bigInteger2);
        list.add(new Property(String.valueOf(ClusteringPartitionedBuildNodePropertyModel.PROP_PARTITIONS_MAX_NUM.index), null, complexProperty, null, null));
        ClusteringPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updatePartitionColumns(List<Property> list, AbstractBuildNode abstractBuildNode, PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSION_EDIT", partitionExpressions);
        complexProperty.setOldData(partitionExpressions2);
        list.add(new Property(String.valueOf(ClusteringPartitionedBuildNodePropertyModel.PROP_PARTITIONS_EXPRESSION_EDIT.index), null, complexProperty, null, null));
        ClusteringPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    static {
        properties.addAll(AbstractNodePropertyModel.properties);
        int n = properties.size();
        PROP_MODEL_ADDED_REMOVED = new NodeProperty("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_ADDED_REMOVED);
        PROP_ALGORITHM_SETTINGS = new NodeProperty("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_ALGORITHM_SETTINGS);
        PROP_CASE_IDS = new NodeProperty("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_CASE_IDS);
        PROP_MODELS_RERUN = new NodeProperty("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODELS_RERUN);
        PROP_MODEL_ANNOTATION = new NodeProperty("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_ANNOTATION);
        PROP_MODEL_NAME = new NodeProperty("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_NAME);
        PROP_MODEL_USEFOROUTPUT = new NodeProperty("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_USEFOROUTPUT);
        PROP_MINING_ATTRIBUTE_SETTINGS = new NodeProperty("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MINING_ATTRIBUTE_SETTINGS);
        PROP_PARTITIONS_MAX_NUM = new NodeProperty("PARTITIONS_MAX_NUM", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_PARTITIONS_MAX_NUM);
        PROP_PARTITIONS_EXPRESSION_EDIT = new NodeProperty("PARTITIONS_EXPRESSION_EDIT", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_PARTITIONS_EXPRESSION_EDIT);
        PROP_ODMS_PARTITION_BUILD_TYPE = new NodeProperty("ODMS_PARTITION_BUILD_TYPE", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_ODMS_PARTITION_BUILD_TYPE);
    }

    private static class Groups {
        private static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        private Groups() {
        }
    }
}

