/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.TestLiftProfitDialogPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;

public class ClassificationBuildPIComponentTestPanel
extends JPanel
implements ClassificationBuildPIComponentGUI {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildPIComponentTestPanel.class.getName());
    private List<ModelType> _models;
    private WorkflowNodePropertyProxyModel _model;
    private boolean _isAdjusting;
    private boolean _isPartitionModel;
    private boolean _clearSearchState = true;
    private ButtonGroup buttonGroupTest;
    private JCheckBox jAccuracyMetricsCheckBox;
    private JCheckBox jChkPerformTest;
    private JCheckBox jConfusionMatrixCheckBox;
    private JLabel jCreateSplitAsLabel;
    private JButton jEditTargetsButton;
    private JLabel jLblSplit;
    private JCheckBox jLiftProfitCheckBox;
    private JLabel jLiftProfitTargetSelectionLabel;
    private JPanel jPanelTestData;
    private JCheckBox jROCCheckBox;
    private JRadioButton jRadioAllData;
    private JRadioButton jRadioSplit;
    private JRadioButton jRadioTest;
    private JSpinner jSpinnerSplit;
    private JComboBox jSplitTableViewComboBox;
    private JLabel jTestDataLabel;
    private JLabel jTestResultsLabel;
    private JCheckBox jTuneCheckBox;
    private static double _SLIDER_INITIAL_VALUE = 40.0;
    private static double _SLIDER_MIN_VALUE = 5.0;
    private static double _SLIDER_MAX_VALUE = 100.0;
    private static double _SLIDER_STEP_VALUE = 1.0;

    public ClassificationBuildPIComponentTestPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._isPartitionModel = !abstractBuildNode.getPartitionAttributes(null).isEmpty();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this.buttonGroupTest = new ButtonGroup();
        this.jChkPerformTest = new JCheckBox();
        this.jPanelTestData = new JPanel();
        this.jTestResultsLabel = new JLabel();
        this.jAccuracyMetricsCheckBox = new JCheckBox();
        this.jConfusionMatrixCheckBox = new JCheckBox();
        this.jROCCheckBox = new JCheckBox();
        this.jLiftProfitCheckBox = new JCheckBox();
        this.jLiftProfitTargetSelectionLabel = new JLabel();
        this.jEditTargetsButton = new JButton();
        this.jTuneCheckBox = new JCheckBox();
        this.jTestDataLabel = new JLabel();
        this.jRadioAllData = new JRadioButton();
        this.jRadioSplit = new JRadioButton();
        this.jLblSplit = new JLabel();
        this.jSpinnerSplit = new JSpinner();
        this.jCreateSplitAsLabel = new JLabel();
        this.jSplitTableViewComboBox = new JComboBox();
        this.jRadioTest = new JRadioButton();
        this.jChkPerformTest.setText("Perform Test");
        this.jChkPerformTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkPerformTest.setMargin(new Insets(0, 0, 0, 0));
        this.jTestResultsLabel.setText("Test Results");
        this.jAccuracyMetricsCheckBox.setText("Accuracy Metrics");
        this.jAccuracyMetricsCheckBox.setOpaque(false);
        this.jConfusionMatrixCheckBox.setText("Confusion Matrix");
        this.jConfusionMatrixCheckBox.setOpaque(false);
        this.jROCCheckBox.setText("ROC Curve (Binary Class Only)");
        this.jROCCheckBox.setOpaque(false);
        this.jLiftProfitCheckBox.setText("Lift and Profit");
        this.jLiftProfitCheckBox.setOpaque(false);
        this.jLiftProfitTargetSelectionLabel.setText("Top 5 target class values by frequency");
        this.jEditTargetsButton.setText("Edit...");
        this.jTuneCheckBox.setText("Generate Selected Test Results for Model Tuning");
        this.jTuneCheckBox.setOpaque(false);
        this.jTestDataLabel.setText("Test Data");
        this.jRadioAllData.setText("Use All Mining Build Data for Testing");
        this.jRadioAllData.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAllData.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioSplit.setText("Use Split Build Data for Testing");
        this.jRadioSplit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioSplit.setMargin(new Insets(0, 0, 0, 0));
        this.jLblSplit.setLabelFor(this.jSpinnerSplit);
        this.jLblSplit.setText("Split for Test (%):");
        this.jCreateSplitAsLabel.setLabelFor(this.jSplitTableViewComboBox);
        this.jCreateSplitAsLabel.setText("Create Split as:");
        this.jSplitTableViewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Table", "View"}));
        this.jRadioTest.setText("Use Test Data Source for Testing");
        this.jRadioTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioTest.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout(this.jPanelTestData);
        this.jPanelTestData.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jConfusionMatrixCheckBox, -1, 381, Short.MAX_VALUE).addComponent(this.jAccuracyMetricsCheckBox, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jROCCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jLiftProfitCheckBox, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTuneCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLiftProfitTargetSelectionLabel, -2, 275, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditTargetsButton))).addGap(0, 0, Short.MAX_VALUE)))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTestResultsLabel, -2, 140, -2).addComponent(this.jTestDataLabel, -2, 146, -2).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioSplit, -2, 373, -2).addComponent(this.jRadioAllData, -2, 372, -2).addComponent(this.jRadioTest).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblSplit, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSpinnerSplit, -2, 47, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCreateSplitAsLabel, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitTableViewComboBox, -2, -1, -2))))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jLiftProfitCheckBox, this.jROCCheckBox, this.jRadioAllData);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTestResultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAccuracyMetricsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConfusionMatrixCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jROCCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLiftProfitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLiftProfitTargetSelectionLabel).addComponent(this.jEditTargetsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneCheckBox).addGap(18, 18, 18).addComponent(this.jTestDataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioAllData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioSplit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSplit).addComponent(this.jSpinnerSplit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCreateSplitAsLabel).addComponent(this.jSplitTableViewComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioTest).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelTestData, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jChkPerformTest, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jChkPerformTest).addGap(1, 1, 1).addComponent(this.jPanelTestData, -1, -1, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jChkPerformTest.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORM_TEST"));
        this.jChkPerformTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildPIComponentTestPanel.this.updateTestOption(ClassificationBuildPIComponentTestPanel.this.jChkPerformTest.isSelected());
            }
        });
        this.jChkPerformTest.setOpaque(false);
        this.jTestResultsLabel.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_TEST_RESULTS"));
        this.jAccuracyMetricsCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORMANCE_METRICS"));
        this.jConfusionMatrixCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORMANCE_MATRIX"));
        this.jROCCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ROC"));
        this.jLiftProfitCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_N_PROFIT"));
        this.jEditTargetsButton.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_EDIT"));
        this.jTuneCheckBox.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TUNING"));
        this.jTestDataLabel.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_TEST_DATA"));
        this.jSplitTableViewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SplitDataFormat.toHuman((String)"Table"), ServerConstants.SplitDataFormat.toHuman((String)"View")}));
        ResourceUtils.resSpinner((JLabel)this.jLblSplit, (JSpinner)this.jSpinnerSplit, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPLIT_LABEL"));
        this.jSpinnerSplit.setModel(new SpinnerNumberModel(_SLIDER_INITIAL_VALUE, _SLIDER_MIN_VALUE, _SLIDER_MAX_VALUE, _SLIDER_STEP_VALUE));
        this.jPanelTestData.setOpaque(false);
        this.jRadioAllData.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ALL_BUILD_DATA"));
        this.jRadioAllData.setOpaque(false);
        this.jRadioAllData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestDataSource testDataSource = new TestDataSource();
                testDataSource.setBuildData(new TestDataSource.BuildData());
                ClassificationBuildPIComponentTestPanel.this.setValue(testDataSource);
                ClassificationBuildPIComponentTestPanel.this.enableControls();
            }
        });
        this.jRadioSplit.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPLIT_BUILD_DATA"));
        this.jRadioSplit.setOpaque(false);
        this.jRadioSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestDataSource testDataSource = new TestDataSource();
                Double d = (Double)ClassificationBuildPIComponentTestPanel.this.jSpinnerSplit.getValue();
                TestDataSource.SplitData splitData = new TestDataSource.SplitData();
                splitData.setTestPercent(d.doubleValue());
                testDataSource.setSplitData(splitData);
                ClassificationBuildPIComponentTestPanel.this.setValue(testDataSource);
                ClassificationBuildPIComponentTestPanel.this.enableControls();
            }
        });
        this.jRadioTest.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TEST_DATA"));
        this.jRadioTest.setOpaque(false);
        this.jRadioTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractBuildNode abstractBuildNode = ClassificationBuildPIComponentTestPanel.this.getTargetNode((PropertyModel)ClassificationBuildPIComponentTestPanel.this._model);
                if (abstractBuildNode instanceof SupervisedBuildNode) {
                    WorkflowModel workflowModel = abstractBuildNode.getModel();
                    AbstractDataNode abstractDataNode = null;
                    List<AbstractNode> list = abstractBuildNode.findParentNodes();
                    AbstractDataNode abstractDataNode2 = abstractBuildNode.findBuildDataNode(workflowModel);
                    abstractDataNode = list.get(0).equals(abstractDataNode2) ? (AbstractDataNode)list.get(1) : (AbstractDataNode)list.get(0);
                    if (abstractDataNode != null) {
                        NodeType nodeType = abstractDataNode.getData();
                        TestDataSource testDataSource = new TestDataSource();
                        TestDataSource.TestData testData = new TestDataSource.TestData();
                        testData.setSourceId(nodeType.getId());
                        testDataSource.setTestData(testData);
                        ClassificationBuildPIComponentTestPanel.this.setValue(testDataSource);
                    }
                }
                ClassificationBuildPIComponentTestPanel.this.enableControls();
            }
        });
        this.buttonGroupTest.add(this.jRadioAllData);
        this.buttonGroupTest.add(this.jRadioSplit);
        this.buttonGroupTest.add(this.jRadioTest);
        this.jEditTargetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationTestSettingsType classificationTestSettingsType;
                TestLiftProfitDialogPanel testLiftProfitDialogPanel = new TestLiftProfitDialogPanel(ClassificationBuildPIComponentTestPanel.this.getContext((PropertyModel)ClassificationBuildPIComponentTestPanel.this._model), (PropertyModel)ClassificationBuildPIComponentTestPanel.this._model);
                if (testLiftProfitDialogPanel.showAsDialog(ClassificationBuildPIComponentTestPanel.this) && (classificationTestSettingsType = testLiftProfitDialogPanel.collectData()) != null) {
                    ClassificationBuildPIComponentTestPanel.this.setValue(classificationTestSettingsType);
                }
            }
        });
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        boolean bl = this.isPerformTest(this.getTestDataSettings());
        this.jChkPerformTest.setSelected(bl);
        this.initTestOption();
        this.jAccuracyMetricsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildNodeType.Results results = ClassificationBuildPIComponentTestPanel.this.getResults();
                boolean bl = ClassificationBuildPIComponentTestPanel.this.jAccuracyMetricsCheckBox.isSelected();
                Boolean bl2 = results.isGenAccuracyMetrics();
                if (bl2 == null || bl2 != bl) {
                    ClassificationBuildPIComponentTestPanel.this.setGenAccuracyMetrics(bl);
                }
            }
        });
        this.jConfusionMatrixCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildNodeType.Results results = ClassificationBuildPIComponentTestPanel.this.getResults();
                boolean bl = ClassificationBuildPIComponentTestPanel.this.jConfusionMatrixCheckBox.isSelected();
                Boolean bl2 = results.isGenConfusionMatrix();
                if (bl2 == null || bl2 != bl) {
                    ClassificationBuildPIComponentTestPanel.this.setGenConfusionMatrix(bl);
                }
            }
        });
        this.jROCCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildNodeType.Results results = ClassificationBuildPIComponentTestPanel.this.getResults();
                boolean bl = ClassificationBuildPIComponentTestPanel.this.jROCCheckBox.isSelected();
                Boolean bl2 = results.isGenROC();
                if (bl2 == null || bl2 != bl) {
                    ClassificationBuildPIComponentTestPanel.this.setGenROC(bl);
                }
            }
        });
        this.jLiftProfitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildNodeType.Results results = ClassificationBuildPIComponentTestPanel.this.getResults();
                boolean bl = ClassificationBuildPIComponentTestPanel.this.jLiftProfitCheckBox.isSelected();
                Boolean bl2 = results.isGenLift();
                if (bl2 == null || bl2 != bl) {
                    ClassificationBuildPIComponentTestPanel.this.setGenLiftAndProfit(bl);
                }
            }
        });
        this.jTuneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildNodeType.Results results = ClassificationBuildPIComponentTestPanel.this.getResults();
                boolean bl = ClassificationBuildPIComponentTestPanel.this.jTuneCheckBox.isSelected();
                Boolean bl2 = results.isGenTuning();
                if (bl2 == null || bl2 != bl) {
                    ClassificationBuildPIComponentTestPanel.this.setGenTuning(bl);
                }
            }
        });
        this.jSpinnerSplit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TestDataSource testDataSource = ClassificationBuildPIComponentTestPanel.this.getTestDataSettings();
                Double d = (Double)ClassificationBuildPIComponentTestPanel.this.jSpinnerSplit.getValue();
                double d2 = testDataSource.getSplitData().getTestPercent();
                if (d2 != d) {
                    ClassificationBuildPIComponentTestPanel.this.adjustSplitValue(d);
                }
            }
        });
        this.jSplitTableViewComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassificationBuildPIComponentTestPanel.this._isAdjusting) {
                    return;
                }
                TestDataSource testDataSource = ClassificationBuildPIComponentTestPanel.this.getTestDataSettings();
                String string = (String)ClassificationBuildPIComponentTestPanel.this.jSplitTableViewComboBox.getSelectedItem();
                String string2 = testDataSource.getSplitData().getDataFormat();
                if (string2 == null || !string2.equals(string)) {
                    ClassificationBuildPIComponentTestPanel.this.adjustSplitFormat(ServerConstants.SplitDataFormat.toSchema((String)string));
                }
            }
        });
    }

    private boolean isPerformTest(TestDataSource testDataSource) {
        return testDataSource != null && null == testDataSource.getNone();
    }

    private TestDataSource getTestDataSettings() {
        TestDataSource testDataSource = null;
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
            testDataSource = classificationBuildNodeType.getTestDataSource();
        }
        return testDataSource;
    }

    private ClassificationBuildNodeType.Results getResults() {
        ClassificationBuildNodeType.Results results = null;
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
            results = classificationBuildNodeType.getResults();
        }
        return results;
    }

    private ClassificationTestSettingsType getClassificationTestSettings() {
        ClassificationTestSettingsType classificationTestSettingsType = null;
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
            classificationTestSettingsType = classificationBuildNodeType.getTestSettings();
        }
        return classificationTestSettingsType;
    }

    private void initTestOption() {
        TestDataSource testDataSource;
        this._isAdjusting = true;
        ClassificationBuildNodeType.Results results = this.getResults();
        if (results != null) {
            this.jAccuracyMetricsCheckBox.setSelected(results.isGenAccuracyMetrics() == null || results.isGenAccuracyMetrics() != false);
            this.jConfusionMatrixCheckBox.setSelected(results.isGenConfusionMatrix() == null || results.isGenConfusionMatrix() != false);
            this.jROCCheckBox.setSelected(results.isGenROC() == null || results.isGenROC() != false);
            this.jLiftProfitCheckBox.setSelected(results.isGenLift() == null || results.isGenLift() != false);
            this.jTuneCheckBox.setSelected(!this._isPartitionModel && results.isGenTuning() != null && results.isGenTuning() != false);
            testDataSource = this.getClassificationTestSettings();
            if (testDataSource.getTopNTargets() != null) {
                String string = MessageFormat.format(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TOP_N_TARGETS"), testDataSource.getTopNTargets().getValue().intValue());
                this.jLiftProfitTargetSelectionLabel.setText(string);
            } else if (testDataSource.getBottomNTargets() != null) {
                String string = MessageFormat.format(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_BTN_N_TARGETS"), testDataSource.getBottomNTargets().getValue().intValue());
                this.jLiftProfitTargetSelectionLabel.setText(string);
            } else {
                this.jLiftProfitTargetSelectionLabel.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPECIFIC_TARGETS"));
            }
        }
        if ((testDataSource = this.getTestDataSettings()) != null) {
            if (null != testDataSource.getBuildData()) {
                this.jRadioAllData.setSelected(true);
            } else if (null != testDataSource.getTestData()) {
                this.jRadioTest.setSelected(true);
            } else if (null != testDataSource.getSplitData()) {
                this.jRadioSplit.setSelected(true);
                this.jSpinnerSplit.setValue(testDataSource.getSplitData().getTestPercent());
                if (testDataSource.getSplitData().getDataFormat() != null) {
                    this.jSplitTableViewComboBox.setSelectedItem(ServerConstants.SplitDataFormat.toHuman((String)testDataSource.getSplitData().getDataFormat()));
                } else {
                    this.jSplitTableViewComboBox.setSelectedItem(ServerConstants.SplitDataFormat.toHuman((String)"View"));
                }
            }
        }
        this.enableControls();
        this._isAdjusting = false;
    }

    private void enableControls() {
        boolean bl = this.isWritable();
        boolean bl2 = this.jChkPerformTest.isSelected();
        this.jChkPerformTest.setEnabled(bl);
        this.jAccuracyMetricsCheckBox.setEnabled(bl2 && bl);
        this.jConfusionMatrixCheckBox.setEnabled(bl2 && bl);
        this.jROCCheckBox.setEnabled(bl2 && bl);
        this.jLiftProfitCheckBox.setEnabled(bl2 && bl);
        this.jTuneCheckBox.setEnabled(!this._isPartitionModel && (this.jROCCheckBox.isSelected() || this.jLiftProfitCheckBox.isSelected()) && bl);
        boolean bl3 = this.jLiftProfitCheckBox.isSelected();
        this.jLiftProfitTargetSelectionLabel.setEnabled(bl2 && bl && bl3);
        this.jEditTargetsButton.setEnabled(bl2 && bl && bl3);
        this.jRadioAllData.setEnabled(bl2 && bl);
        this.jRadioSplit.setEnabled(bl2 && bl);
        boolean bl4 = false;
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode instanceof SupervisedBuildNode) {
            List<AbstractNode> list = abstractBuildNode.findParentNodes();
            bl4 = list != null && !list.isEmpty() && list.size() == 2;
        }
        this.jRadioTest.setEnabled(bl2 && bl4 && bl);
        boolean bl5 = this.jRadioSplit.isSelected();
        this.jSpinnerSplit.setEnabled(bl2 && bl && bl5);
        this.jSplitTableViewComboBox.setEnabled(bl2 && bl && bl5);
    }

    private void updateTestOption(boolean bl) {
        TestDataSource testDataSource = new TestDataSource();
        if (bl) {
            if (null != testDataSource.getBuildData()) {
                this.jRadioAllData.setSelected(true);
                testDataSource.setBuildData(new TestDataSource.BuildData());
            } else if (null != testDataSource.getTestData()) {
                this.jRadioTest.setSelected(true);
                testDataSource.setTestData(new TestDataSource.TestData());
            } else {
                this.jRadioSplit.setSelected(true);
                Preferences preferences = Preferences.getPreferences();
                ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
                Double d = classificationModelBuildPreferencesPanelSettings.getTestSplitPercent();
                TestDataSource.SplitData splitData = new TestDataSource.SplitData();
                splitData.setTestPercent(d.doubleValue());
                String string = classificationModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
                splitData.setDataFormat(string);
                testDataSource.setSplitData(splitData);
            }
        } else {
            testDataSource.setNone(new TestDataSource.None());
        }
        this.setValues(testDataSource, bl);
        this.enableControls();
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            Node node = workflowEditor.getSelectedDiagramNode();
            if (node != null) {
                workflowEditor.setSelected(workflowNode.getEngine(), node);
            }
        }
    }

    private void adjustSplitValue(double d) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.SPLIT_VALUE.index), null, new ComplexProperty("splitValueChanged", d), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("splitValueChanged", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void adjustSplitFormat(String string) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.SPLIT_DATA_FORMAT.index), null, new ComplexProperty("splitDataFormat", string), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("splitDataFormat", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenAccuracyMetrics(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ACCURACY_METRICS.index), null, new ComplexProperty("genAccuracyMetrics", bl), null, null));
            if (Boolean.FALSE.equals(bl)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_CONFUSION_MATRIX.index), null, new ComplexProperty("genConfusionMatrix", bl), null, null));
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ROC_CURVE.index), null, new ComplexProperty("genROC", bl), null, null));
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_LIFT_AND_PROFIT.index), null, new ComplexProperty("genLiftProfit", bl), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("genAccuracyMetrics", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenConfusionMatrix(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ACCURACY_METRICS.index), null, new ComplexProperty("genAccuracyMetrics", bl), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_CONFUSION_MATRIX.index), null, new ComplexProperty("genConfusionMatrix", bl), null, null));
            if (Boolean.FALSE.equals(bl)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ROC_CURVE.index), null, new ComplexProperty("genROC", bl), null, null));
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_LIFT_AND_PROFIT.index), null, new ComplexProperty("genLiftProfit", bl), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("genConfusionMatrix", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenROC(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ACCURACY_METRICS.index), null, new ComplexProperty("genAccuracyMetrics", bl), null, null));
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_CONFUSION_MATRIX.index), null, new ComplexProperty("genConfusionMatrix", bl), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ROC_CURVE.index), null, new ComplexProperty("genROC", bl), null, null));
            if (Boolean.FALSE.equals(bl) && !this.jLiftProfitCheckBox.isSelected()) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_FOR_TUNING.index), null, new ComplexProperty("genTuning", Boolean.FALSE), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("genROC", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenLiftAndProfit(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ACCURACY_METRICS.index), null, new ComplexProperty("genAccuracyMetrics", bl), null, null));
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_CONFUSION_MATRIX.index), null, new ComplexProperty("genConfusionMatrix", bl), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_LIFT_AND_PROFIT.index), null, new ComplexProperty("genLiftProfit", bl), null, null));
            if (Boolean.FALSE.equals(bl) && !this.jROCCheckBox.isSelected()) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_FOR_TUNING.index), null, new ComplexProperty("genTuning", Boolean.FALSE), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("genLiftProfit", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenTuning(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_FOR_TUNING.index), null, new ComplexProperty("genTuning", bl), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("genTuning", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(TestDataSource testDataSource) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TEST_OPTIONS_CHANGED.index), null, new ComplexProperty("testOptionsChanged", testDataSource), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            if (this.isPerformTest(testDataSource)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            } else {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_ADDED_REMOVED.index), null, new ComplexProperty("alltestsRemoved", "alltestsRestored", MetaDataHelper.getClassificationResultsCollection(abstractBuildNode)), null, null));
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_FOR_TUNING_ADDED_REMOVED.index), null, new ComplexProperty("alltestsForTuningRemoved", "alltestsForTuningRestored", MetaDataHelper.getClassResultsForTuningCollection(abstractBuildNode)), null, null));
            }
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(ClassificationTestSettingsType classificationTestSettingsType) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TEST_SETTINGS_CHANGED.index), null, new ComplexProperty("testSettingsChanged", classificationTestSettingsType), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValues(TestDataSource testDataSource, boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TEST_OPTIONS_CHANGED.index), null, new ComplexProperty("testOptionsChanged", testDataSource), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ACCURACY_METRICS.index), null, new ComplexProperty("genAccuracyMetrics", bl), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_CONFUSION_MATRIX.index), null, new ComplexProperty("genConfusionMatrix", bl), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_ROC_CURVE.index), null, new ComplexProperty("genROC", bl), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_LIFT_AND_PROFIT.index), null, new ComplexProperty("genLiftProfit", bl), null, null));
            if (!bl) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.GEN_FOR_TUNING.index), null, new ComplexProperty("genTuning", Boolean.FALSE), null, null));
            }
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            if (this.isPerformTest(testDataSource)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            } else {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.TESTS_ADDED_REMOVED.index), null, new ComplexProperty("alltestsRemoved", "alltestsRestored", MetaDataHelper.getClassificationResultsCollection(abstractBuildNode)), null, null));
            }
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    public void upadteUI(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._isPartitionModel = !abstractBuildNode.getPartitionAttributes(null).isEmpty();
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        TestDataSource testDataSource = this.getTestDataSettings();
        boolean bl = this.isPerformTest(testDataSource);
        this.jChkPerformTest.setSelected(bl);
        this.initTestOption();
        this.jChkPerformTest.setEnabled(this.isWritable());
    }

    @Override
    public boolean isWritable() {
        return ClassificationBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }
}

