/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inmemoryparallelquery;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.PerformanceOptionsCellRender;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.inmemoryparallelquery.InMemoryParallelPreferences;
import oracle.dmt.dataminer.workflow.inmemoryparallelquery.ViewDataPerformancePanel;
import oracle.dmt.dataminer.workflow.inmemoryparallelquery.ViewPerformanceDataProvider;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelTablePanel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InMemoryColumnarType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ParallelismType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ORAData;

public class InMemoryParallelTablePanel
extends ParallelTablePanel {
    private static String INMEMORY_ON_COLUMN = WorkflowEditorLrb.get("INMEMORY_TABLE_ENABLED");
    private static String INMEMORY_SETTINGS = WorkflowEditorLrb.get("INMEMORY_TABLE_SETTINGS");
    protected InMemoryParallelPreferences IMPQPreferences;
    private DropDownMenuButton menuInMemory;
    private DropDownMenuButton menuParallel;
    private static List<String> menuItems = new ArrayList<String>();
    private static int menuIndex;
    private static int _menu_enable_idx;
    private static int _menu_disable_idx;
    private static int _menu_all_idx;
    private static int _menu_none_idx;
    private static Map<String, String> excludedInMemory;

    @Override
    protected void createEditorColumns() {
        super.createEditorColumns();
        this.columnNamesEditor.add(INMEMORY_ON_COLUMN);
        this.columnNamesEditor.add(INMEMORY_SETTINGS);
    }

    @Override
    protected void createPreferncesColumns() {
        super.createPreferncesColumns();
        this.columnNamesPreferences.add(INMEMORY_ON_COLUMN);
        this.columnNamesPreferences.add(INMEMORY_SETTINGS);
    }

    private int get_in_mem_on_idx() {
        return this.getColumnIndex(INMEMORY_ON_COLUMN);
    }

    private int get_in_mem_settings_idx() {
        return this.getColumnIndex(INMEMORY_SETTINGS);
    }

    public InMemoryParallelTablePanel(Context context, List<AbstractNode> list) {
        super(context, list);
        this.setEditorPanelHelpId();
    }

    public InMemoryParallelTablePanel() {
    }

    @Override
    protected void setPreferencesPanelHelpId() {
        this.setHelpID("preferences_para");
    }

    @Override
    protected void setEditorPanelHelpId() {
        this.setHelpID("performance_settings");
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        this.initilizePreferences(traversableContext);
        this.initUI();
    }

    @Override
    public void initilizePreferences(TraversableContext traversableContext) {
        this.IMPQPreferences = InMemoryParallelPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    @Override
    public void initUI() {
        JLabel jLabel = new JLabel(" ");
        boolean bl = this.isPreferencePanel || !this.wfNode.isReadOnly();
        this.menuInMemory = new DropDownMenuButton();
        this.menuInMemory.setText(WorkflowEditorLrb.get("INMEMORY_TABLE_ALL_MENU"));
        this.menuParallel = new DropDownMenuButton();
        this.menuParallel.setText(WorkflowEditorLrb.get("PARALLEL_TABLE_ALL_MENU"));
        this.menuParallel.setEnabled(bl);
        final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
        dropDownMenuButton.setEnabled(bl);
        dropDownMenuButton.setIcon(OracleIcons.getIcon((String)"action.png"));
        dropDownMenuButton.setToolTipText(WorkflowEditorLrb.get("PERFORMANCE_NODE_PREFERENCES"));
        dropDownMenuButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    dropDownMenuButton.addPopupItem((Action)new AbstractAction(WorkflowEditorLrb.get("PARALLEL_PREFERENCE_LAUNCH")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String[] stringArray = new String[]{PreferencesLrb.get("DATA_MINER_PREFERENCES_KEY"), PreferencesLrb.get("NODE_SETTINGS_PREFERENCES_KEY"), PreferencesLrb.get("PERFORMANCE_QUERY_PREFERENCES_KEY")};
                            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                        }
                    });
                    dropDownMenuButton.addPopupItem((Action)new AbstractAction(WorkflowEditorLrb.get("PARALLEL_APPLY_DEFAULT_PREFERENCES")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            InMemoryParallelTablePanel.this.initNonPreferenceTableDefault();
                        }
                    });
                } else if (itemEvent.getStateChange() == 2) {
                    dropDownMenuButton.removeAllPopupItems();
                }
            }
        });
        final JButton jButton = new JButton();
        jButton.setEnabled(bl);
        jButton.setToolTipText(WorkflowEditorLrb.get("PERFORMANCE_SETTING"));
        jButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InMemoryParallelTablePanel.this.launchEdit();
            }
        });
        if (this.isPreferencePanel) {
            this.getInnerTable().addControlBarComponents(new Component[]{this.menuParallel, jLabel, this.menuInMemory, jButton});
        } else {
            this.getInnerTable().addControlBarComponents(new Component[]{jButton, dropDownMenuButton});
            this.getInnerTable().addControlBarComponents(new Component[]{this.menuParallel, jLabel, this.menuInMemory});
        }
        this.initTable(this.isPreferencePanel);
        if (this.getTable().getSelectedRowCount() < 1) {
            jButton.setEnabled(false);
        } else {
            jButton.setEnabled(true);
        }
        this.getTable().getColumnModel().getColumn(this.get_parallel_on_idx()).setMaxWidth(150);
        this.getTable().getColumnModel().getColumn(this.get_in_mem_on_idx()).setMaxWidth(150);
        this.getTable().setEnabled(bl);
        this.getTable().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("rowSorter".equals(propertyChangeEvent.getPropertyName())) {
                    int n = InMemoryParallelTablePanel.this.getTable().getRowCount();
                    if (n <= 0) {
                        InMemoryParallelTablePanel.this.menuInMemory.setEnabled(false);
                        InMemoryParallelTablePanel.this.menuParallel.setEnabled(false);
                        jButton.setEnabled(false);
                        dropDownMenuButton.setEnabled(false);
                    } else {
                        InMemoryParallelTablePanel.this.menuInMemory.setEnabled(true);
                        InMemoryParallelTablePanel.this.menuParallel.setEnabled(true);
                        dropDownMenuButton.setEnabled(true);
                        if (InMemoryParallelTablePanel.this.getTable().getSelectedRowCount() <= 0) {
                            jButton.setEnabled(false);
                        } else {
                            jButton.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (InMemoryParallelTablePanel.this.getTable().getSelectedRowCount() > 0) {
                    jButton.setEnabled(true);
                } else {
                    jButton.setEnabled(false);
                }
            }
        });
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    InMemoryParallelTablePanel.this.launchEdit();
                }
            }
        });
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(this.get_in_mem_on_idx());
        tableColumn.setCellRenderer(new PerformanceOptionsCellRender(bl));
        this.setupMenus(this.menuParallel);
        this.setupMenus(this.menuInMemory);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl = true;
                int[] nArray = InMemoryParallelTablePanel.this.getTable().getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    String string;
                    Object object = InMemoryParallelTablePanel.this.getTable().getValueAt(nArray[i], InMemoryParallelTablePanel.this.get_in_mem_on_idx());
                    if (!(object instanceof String) || !(string = object.toString()).isEmpty()) continue;
                    bl = false;
                    break;
                }
                InMemoryParallelTablePanel.this.menuInMemory.setEnabled(bl);
            }
        });
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this.getTable().getModel());
        this.getTable().setRowSorter(tableRowSorter);
        tableRowSorter.setComparator(this.get_in_mem_on_idx(), (Comparator<?>)ToStringComparator.getComparator());
        tableRowSorter.setComparator(this.get_parallel_on_idx(), (Comparator<?>)ToStringComparator.getComparator());
        this.menuInMemory.setEnabled(bl);
    }

    @Override
    protected void initPreferenceTable() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Map<String, String> map = MetaDataHelper.getNodeTypeNameMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string;
            Vector<Object> vector2 = new Vector<Object>();
            String string2 = string = entry.getKey();
            boolean bl = excludedNodesParallel.containsKey(string2);
            boolean bl2 = excludedInMemory.containsKey(string2);
            if (bl) {
                ++n2;
            }
            if (bl2) {
                ++n4;
            }
            if (bl && bl2) continue;
            String string3 = entry.getValue();
            vector2.add(string3);
            String string4 = this.IMPQPreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            if ("true".equals(string4) || "TRUE".equals(string4)) {
                ++n;
                vector2.add(true);
            } else {
                vector2.add(false);
            }
            String string5 = this.IMPQPreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string5 != null) {
                vector2.add(string5);
            } else {
                vector2.add("System Determined");
            }
            n3 += this.addInMemoryPreferenceRowValues(vector2, string, bl2);
            vector.add(vector2);
        }
        this.getInnerTable().setup((TableModel)new InMemoryParallelTableModel(vector, this.columnNamesPreferences, vector.size() - n2, n, vector.size() - n4, n3), null, new String[]{NODE_TYPE_COLUMN}, 0);
        this.getInnerTable().getTable().setSortColumn(0, true);
        this.updateToolBarTitle(n, vector.size(), n3, vector.size());
        this.updateSelection();
    }

    @Override
    protected void initNonPreferenceTableDefault() {
        int n = this.getTable().getRowCount();
        if (this.IMPQPreferences == null) {
            this.IMPQPreferences = InMemoryParallelPreferences.getInstance();
        }
        int n2 = this.initNonPreferenceTableDefault(n, this.IMPQPreferences);
        int n3 = this.initInMemoryNonPreferenceTableDefault(n, this.IMPQPreferences);
        this.updateToolBarTitle(n2, n, n3, n);
    }

    protected int initInMemoryNonPreferenceTableDefault(int n, InMemoryParallelPreferences inMemoryParallelPreferences) {
        int n2 = this.get_in_mem_on_idx();
        int n3 = 0;
        TableModel tableModel = this.getTable().getModel();
        Map<String, String> map = this.reverseMap(MetaDataHelper.getNodeTypeNameMap());
        for (int i = 0; i < n; ++i) {
            String string = (String)tableModel.getValueAt(i, this.get_type_idx());
            String string2 = map.get(string);
            String string3 = inMemoryParallelPreferences.getProperty(string2, InMemoryParallelPreferences.PROPERTY_INMEMORY.IS_IN_MEMORY);
            if (!string3.equals("")) {
                if (Boolean.parseBoolean(string3)) {
                    tableModel.setValueAt(Boolean.TRUE, i, n2);
                    ++n3;
                } else {
                    tableModel.setValueAt(Boolean.FALSE, i, n2);
                }
                String string4 = inMemoryParallelPreferences.getProperty(string2, InMemoryParallelPreferences.PROPERTY_INMEMORY.COMPRESSION);
                string4 = string4 != null && !string4.isEmpty() ? string4 : MetaDataHelper.defaultInMmemoryCompressionHuman();
                String string5 = inMemoryParallelPreferences.getProperty(string2, InMemoryParallelPreferences.PROPERTY_INMEMORY.PRIORITY);
                string5 = string5 != null && !string5.isEmpty() ? string5 : MetaDataHelper.defaultInMmemoryPriorityHuman();
                StringBuilder stringBuilder = new StringBuilder(string4);
                stringBuilder.append(", ");
                stringBuilder.append(string5);
                tableModel.setValueAt(stringBuilder.toString(), i, this.get_in_mem_settings_idx());
                continue;
            }
            tableModel.setValueAt("", i, n2);
            tableModel.setValueAt("", i, this.get_in_mem_settings_idx());
        }
        return n3;
    }

    @Override
    protected void initNonPreferenceTable() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        Enumeration enumeration = this.model.getObjects();
        this.metadata = new HashMap();
        Map<String, String> map = MetaDataHelper.getNodeTypeNameMap();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof GeneralLink) continue;
            AbstractNode abstractNode = (AbstractNode)e;
            NodeType nodeType = abstractNode.getData();
            Vector<Object> vector2 = new Vector<Object>();
            String string = nodeType.getClass().getName();
            boolean bl = excludedNodesParallel.containsKey(string);
            boolean bl2 = excludedInMemory.containsKey(string);
            if (bl) {
                ++n2;
            }
            if (bl2) {
                ++n4;
            }
            if (bl && bl2) continue;
            this.metadata.put(nodeType.getName(), abstractNode);
            n += this.addParallelRowValues(vector2, nodeType, map);
            n3 += this.addInMemoryRowValues(vector2, nodeType);
            vector.add(vector2);
        }
        this.getInnerTable().setup((TableModel)new InMemoryParallelTableModel(vector, this.columnNamesEditor, vector.size() - n2, n, vector.size() - n4, n3), null, new String[]{NAME_COLUMN, TYPE_COLUMN}, 0);
        this.getInnerTable().getTable().setSortColumn(0, true);
        this.updateToolBarTitle(n, vector.size() - n2, n3, vector.size() - n4);
        this.updateSelection();
    }

    protected int addInMemoryRowValues(Vector<Object> vector, NodeType nodeType) {
        if (null != excludedInMemory.get(nodeType.getClass().getName())) {
            vector.add("");
            vector.add("");
            return 0;
        }
        int n = 0;
        if (null == nodeType.getInMemoryColumnar()) {
            vector.add(false);
            StringBuilder stringBuilder = new StringBuilder(MetaDataHelper.defaultInMmemoryCompressionHuman());
            stringBuilder.append(", ");
            stringBuilder.append(MetaDataHelper.defaultInMmemoryPriorityHuman());
            vector.add(stringBuilder.toString());
        } else {
            if (nodeType.getInMemoryColumnar().isEnable()) {
                ++n;
                vector.add(true);
            } else {
                vector.add(false);
            }
            String string = null == nodeType.getInMemoryColumnar().getCompressionMethod() ? MetaDataHelper.defaultInMmemoryCompressionMachine() : nodeType.getInMemoryColumnar().getCompressionMethod();
            String string2 = null == nodeType.getInMemoryColumnar().getPriorityLevel() ? MetaDataHelper.defaultInMmemoryPriorityMachine() : nodeType.getInMemoryColumnar().getPriorityLevel();
            StringBuilder stringBuilder = new StringBuilder(MetaDataHelper.inMmemoryCompressionCovertToHuman(string));
            if (!string2.isEmpty()) {
                stringBuilder.append(", ");
                stringBuilder.append(MetaDataHelper.inMmemoryPriorityCovertToHuman(string2));
            }
            vector.add(stringBuilder.toString());
        }
        return n;
    }

    protected int addInMemoryPreferenceRowValues(Vector<Object> vector, String string, boolean bl) {
        if (bl) {
            vector.add("");
            vector.add("");
            return 0;
        }
        int n = 0;
        String string2 = this.IMPQPreferences.getProperty(string, InMemoryParallelPreferences.PROPERTY_INMEMORY.IS_IN_MEMORY);
        if (null == string2) {
            vector.add(false);
            StringBuilder stringBuilder = new StringBuilder(MetaDataHelper.defaultInMmemoryCompressionHuman());
            stringBuilder.append(", ");
            stringBuilder.append(MetaDataHelper.defaultInMmemoryPriorityHuman());
            vector.add(stringBuilder.toString());
        } else {
            if (0 == string2.compareToIgnoreCase("TRUE")) {
                ++n;
                vector.add(true);
            } else {
                vector.add(false);
            }
            String string3 = this.IMPQPreferences.getProperty(string, InMemoryParallelPreferences.PROPERTY_INMEMORY.COMPRESSION);
            String string4 = this.IMPQPreferences.getProperty(string, InMemoryParallelPreferences.PROPERTY_INMEMORY.PRIORITY);
            String string5 = null == string3 ? MetaDataHelper.defaultInMmemoryCompressionHuman() : string3;
            String string6 = null == string4 ? MetaDataHelper.defaultInMmemoryPriorityHuman() : string4;
            StringBuilder stringBuilder = new StringBuilder(string5);
            if (!string6.isEmpty()) {
                stringBuilder.append(", ");
                stringBuilder.append(string6);
            }
            vector.add(stringBuilder.toString());
        }
        return n;
    }

    public void updateToolBarTitle(int n, int n2, int n3, int n4) {
        this.getInnerTable().setTitle(MessageFormat.format(WorkflowEditorLrb.get("WORKFLOW_PERFORMANCE_TITLE_BAR"), n, n2, n3, n4));
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.savePreferences(this.IMPQPreferences);
    }

    @Override
    public void savePreferences(ParallelQueryPreferences parallelQueryPreferences) {
        super.savePreferences(parallelQueryPreferences);
        int n = this.getTable().getModel().getRowCount();
        Map<String, String> map = this.reverseMap(MetaDataHelper.getNodeTypeNameMap());
        for (int i = 0; i < n; ++i) {
            String string = this.getTable().getModel().getValueAt(i, this.get_node_type_idx()).toString();
            String string2 = String.valueOf(this.getTable().getModel().getValueAt(i, this.get_in_mem_on_idx()));
            String string3 = this.getTable().getModel().getValueAt(i, this.get_in_mem_settings_idx()).toString();
            String string4 = map.get(string);
            String[] stringArray = null;
            stringArray = string3 == null && string3.isEmpty() ? new String[]{MetaDataHelper.defaultInMmemoryCompressionMachine(), ""} : string3.split(",");
            String string5 = stringArray != null && stringArray[0] != null && !stringArray[0].isEmpty() ? stringArray[0] : MetaDataHelper.defaultInMmemoryCompressionHuman();
            String string6 = stringArray != null && stringArray.length > 1 ? stringArray[1].trim() : MetaDataHelper.defaultInMmemoryPriorityHuman();
            this.IMPQPreferences.setProperty(string4, InMemoryParallelPreferences.PROPERTY_INMEMORY.IS_IN_MEMORY, string2);
            this.IMPQPreferences.setProperty(string4, InMemoryParallelPreferences.PROPERTY_INMEMORY.COMPRESSION, string5);
            this.IMPQPreferences.setProperty(string4, InMemoryParallelPreferences.PROPERTY_INMEMORY.PRIORITY, string6);
        }
    }

    @Override
    protected void launchEdit() {
        Object object;
        Object object2;
        boolean bl = false;
        int[] nArray = this.getTable().getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            object2 = this.getTable().getValueAt(nArray[i], this.get_in_mem_on_idx());
            if (!(object2 instanceof String) || !((String)(object = object2.toString())).isEmpty()) continue;
            bl = true;
            break;
        }
        if (bl) {
            super.launchEdit();
            return;
        }
        String string = WorkflowEditorLrb.get("NODE_PERFORMANCE_DIALOG_TITLE");
        object2 = new ViewDataPerformancePanel(string);
        this.initPanel((ViewPerformanceDataProvider)object2);
        object = new DialogHelper((DialogDisplayable)object2);
        ((DialogHelper)object).setDialogOkExecutor(new DialogOkExecutor(){
            final /* synthetic */ ViewDataPerformancePanel val$viewPanel;
            {
                this.val$viewPanel = viewDataPerformancePanel;
            }

            @Override
            public void onOK() throws DialogExecutionException {
                InMemoryParallelTablePanel.this.setParallelEnable(this.val$viewPanel.isParallelEnable());
                if (this.val$viewPanel.isSystemDetermined()) {
                    InMemoryParallelTablePanel.this.setDegreeValue("System Determined");
                } else {
                    InMemoryParallelTablePanel.this.setDegreeValue(this.val$viewPanel.getDegreeValue());
                }
                InMemoryParallelTablePanel.this.setInMemoryValues(this.val$viewPanel.isInMemoryEnable());
                InMemoryParallelTablePanel.this.setInMemorySettings(this.val$viewPanel.getCompressionMethod(), this.val$viewPanel.getPriorityLevel());
            }
        });
        ((DialogHelper)object).showAsDialog((Component)((Object)this));
    }

    private void initPanel(ViewPerformanceDataProvider viewPerformanceDataProvider) {
        this.initParallelPanel(viewPerformanceDataProvider);
        int n = this.getTable().getSelectedRowCount();
        if (n == 1) {
            int n2 = this.getTable().getSelectedRow();
            String string = this.getTable().getValueAt(n2, this.get_in_mem_on_idx()).toString();
            viewPerformanceDataProvider.setInMemoryEnable(Boolean.parseBoolean(string));
            String string2 = this.getTable().getValueAt(n2, this.get_in_mem_settings_idx()).toString();
            String[] stringArray = null;
            stringArray = string2 == null && string2.isEmpty() ? new String[]{MetaDataHelper.defaultInMmemoryCompressionMachine(), ""} : string2.split(",");
            String string3 = stringArray != null && stringArray[0] != null && !stringArray[0].isEmpty() ? stringArray[0] : MetaDataHelper.defaultInMmemoryCompressionHuman();
            String string4 = stringArray != null && stringArray.length > 1 ? stringArray[1].trim() : MetaDataHelper.defaultInMmemoryPriorityHuman();
            viewPerformanceDataProvider.setInMemoryValues(string3, string4);
        } else {
            String string;
            String string5;
            boolean bl = true;
            int[] nArray = this.getTable().getSelectedRows();
            String string6 = null;
            String string7 = null;
            for (int i = 0; i < nArray.length; ++i) {
                string5 = this.getTable().getValueAt(nArray[i], this.get_in_mem_on_idx()).toString();
                string = this.getTable().getValueAt(nArray[i], this.get_in_mem_settings_idx()).toString();
                if (string6 == null && string7 == null) {
                    string6 = string5;
                    string7 = string;
                    continue;
                }
                if (string6.equals(string5) && string7.equals(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (Boolean.parseBoolean(string6)) {
                    viewPerformanceDataProvider.setInMemoryEnable(true);
                } else {
                    viewPerformanceDataProvider.setInMemoryEnable(false);
                }
                String[] stringArray = null;
                stringArray = StringUtils.isEmpty(string7) ? new String[]{MetaDataHelper.defaultInMmemoryCompressionMachine(), ""} : string7.split(",");
                string5 = stringArray != null && stringArray[0] != null && !stringArray[0].isEmpty() ? stringArray[0] : MetaDataHelper.defaultInMmemoryCompressionHuman();
                string = stringArray != null && stringArray.length > 1 ? stringArray[1].trim() : MetaDataHelper.defaultInMmemoryPriorityHuman();
                viewPerformanceDataProvider.setInMemoryValues(string5, string);
            } else {
                viewPerformanceDataProvider.setInMemoryEnable(true);
                viewPerformanceDataProvider.setInMemoryDefaults();
            }
        }
    }

    public void setInMemoryValues(boolean bl) {
        this.setInMemoryValues(bl, this.getTable().getSelectedRows());
    }

    public void setAllInMemoryValues(boolean bl) {
        this.setInMemoryValues(bl, null);
    }

    public void setInMemorySettings(String string, String string2) {
        this.setInMemorySettings(string, string2, this.getTable().getSelectedRows());
    }

    protected void setInMemorySettings(String string, String string2, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(", ");
        stringBuilder.append(string2);
        if (nArray == null) {
            int n = this.getTable().getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                this.getTable().setValueAt(stringBuilder.toString(), i, this.get_in_mem_settings_idx());
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(stringBuilder.toString(), nArray[i], this.get_in_mem_settings_idx());
            }
        }
    }

    protected void setInMemoryValues(boolean bl, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            int n = this.getTable().getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.getTable().getValueAt(i, this.get_in_mem_on_idx());
                if (!(object instanceof Boolean)) continue;
                this.getTable().setValueAt(bl, i, this.get_in_mem_on_idx());
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(bl, nArray[i], this.get_in_mem_on_idx());
            }
        }
    }

    protected void setParallelValues(boolean bl, int[] nArray) {
        if (nArray == null) {
            int n = this.getTable().getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                this.getTable().setValueAt(bl, i, this.get_parallel_on_idx());
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(bl, nArray[i], this.get_parallel_on_idx());
            }
        }
    }

    private void setupMenus(final DropDownMenuButton dropDownMenuButton) {
        dropDownMenuButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object;
                    int[] nArray = InMemoryParallelTablePanel.this.getTable().getSelectedRows();
                    Boolean bl = null;
                    Boolean bl2 = null;
                    Boolean bl3 = null;
                    Boolean bl4 = null;
                    if (nArray != null && nArray.length > 0) {
                        for (int i = 0; i < nArray.length; ++i) {
                            Boolean object2 = (Boolean)InMemoryParallelTablePanel.this.getTable().getValueAt(nArray[i], InMemoryParallelTablePanel.this.get_parallel_on_idx());
                            if (Boolean.FALSE.equals(object2)) {
                                bl = Boolean.TRUE;
                            }
                            if (Boolean.TRUE.equals(object2)) {
                                bl2 = Boolean.TRUE;
                            }
                            object = InMemoryParallelTablePanel.this.getTable().getValueAt(nArray[i], InMemoryParallelTablePanel.this.get_in_mem_on_idx());
                            Boolean bl5 = Boolean.FALSE;
                            if (object instanceof Boolean) {
                                bl5 = (Boolean)object;
                            } else {
                                String string = object.toString();
                                if (!string.isEmpty()) {
                                    bl5 = Boolean.parseBoolean(string);
                                }
                            }
                            if (Boolean.FALSE.equals(bl5)) {
                                bl3 = Boolean.TRUE;
                            }
                            if (Boolean.TRUE.equals(bl5)) {
                                bl4 = Boolean.TRUE;
                            }
                            if (bl != null && bl2 != null && bl3 != null && bl4 != null) break;
                        }
                    }
                    if (bl == null) {
                        bl = false;
                    }
                    if (bl2 == null) {
                        bl2 = false;
                    }
                    if (bl3 == null) {
                        bl3 = false;
                    }
                    if (bl4 == null) {
                        bl4 = false;
                    }
                    for (String string : menuItems) {
                        object = new CustomAbstractAction(dropDownMenuButton, string, nArray);
                        if (string.equals(menuItems.get(_menu_enable_idx))) {
                            if (dropDownMenuButton.equals(InMemoryParallelTablePanel.this.menuParallel)) {
                                ((AbstractAction)object).setEnabled(bl);
                            } else {
                                ((AbstractAction)object).setEnabled(bl3);
                            }
                        }
                        if (string.equals(menuItems.get(_menu_disable_idx))) {
                            if (dropDownMenuButton.equals(InMemoryParallelTablePanel.this.menuParallel)) {
                                ((AbstractAction)object).setEnabled(bl2);
                            } else {
                                ((AbstractAction)object).setEnabled(bl4);
                            }
                        }
                        dropDownMenuButton.addPopupItem((Action)object);
                    }
                } else if (itemEvent.getStateChange() == 2) {
                    dropDownMenuButton.removeAllPopupItems();
                }
            }
        });
    }

    protected boolean areEqual(InMemoryColumnarType inMemoryColumnarType, InMemoryColumnarType inMemoryColumnarType2) {
        if (ObjectUtils.areBothNull((Object)inMemoryColumnarType, (Object)inMemoryColumnarType2)) {
            return true;
        }
        if (ObjectUtils.isAnyNull((Object)inMemoryColumnarType, (Object)inMemoryColumnarType2)) {
            return false;
        }
        if (inMemoryColumnarType.isEnable() != inMemoryColumnarType2.isEnable()) {
            return false;
        }
        if (inMemoryColumnarType.isEnable()) {
            if (inMemoryColumnarType.getCompressionMethod() != null && inMemoryColumnarType2.getCompressionMethod() == null || inMemoryColumnarType2.getCompressionMethod() != null && inMemoryColumnarType.getCompressionMethod() == null) {
                return false;
            }
            if (inMemoryColumnarType.getCompressionMethod() != null && inMemoryColumnarType2.getCompressionMethod() != null) {
                if (!inMemoryColumnarType.getCompressionMethod().equals(inMemoryColumnarType2.getCompressionMethod())) {
                    return false;
                }
                if (null != inMemoryColumnarType.getPriorityLevel() && null != inMemoryColumnarType2.getPriorityLevel()) {
                    return inMemoryColumnarType.getPriorityLevel().equals(inMemoryColumnarType2.getPriorityLevel());
                }
                return null == inMemoryColumnarType.getPriorityLevel() && null == inMemoryColumnarType2.getPriorityLevel();
            }
        }
        return true;
    }

    @Override
    public boolean doWork() {
        try {
            if (this.metadata == null) {
                return false;
            }
            final ArrayList<String> arrayList = new ArrayList<String>();
            final ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = this.getTable().getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object;
                String string;
                String string2 = this.getTable().getValueAt(i, this.get_column_idx()).toString();
                ParallelismType parallelismType = new ParallelismType();
                Boolean bl = (Boolean)this.getTable().getValueAt(i, this.get_parallel_on_idx());
                String string3 = this.getTable().getValueAt(i, this.get_parallel_degree_idx()).toString();
                InMemoryColumnarType inMemoryColumnarType = new InMemoryColumnarType();
                Object object2 = this.getTable().getValueAt(i, this.get_in_mem_on_idx());
                boolean bl2 = false;
                if (object2 instanceof Boolean) {
                    bl2 = (Boolean)object2;
                } else {
                    string = object2.toString();
                    if (!string.isEmpty()) {
                        bl2 = Boolean.parseBoolean(string);
                    }
                }
                string = this.getTable().getValueAt(i, this.get_in_mem_settings_idx()).toString();
                AbstractNode abstractNode = (AbstractNode)this.metadata.get(string2);
                NodeType nodeType = abstractNode.getData();
                if (bl.equals(Boolean.TRUE)) {
                    parallelismType.setEnable(true);
                } else {
                    parallelismType.setEnable(false);
                }
                if (string3.equalsIgnoreCase("System Determined")) {
                    parallelismType.setSystemDetermined(new ParallelismType.SystemDetermined());
                } else {
                    object = new ParallelismType.Custom();
                    object.setDegree(Long.parseLong(string3));
                    parallelismType.setCustom(object);
                }
                object = null;
                String string4 = null;
                inMemoryColumnarType.setEnable(bl2);
                String[] stringArray = null;
                stringArray = string == null && string.isEmpty() ? new String[]{MetaDataHelper.defaultInMmemoryCompressionMachine(), ""} : string.split(",");
                object = stringArray != null && stringArray[0] != null && !stringArray[0].isEmpty() ? MetaDataHelper.inMmemoryCompressionCovertToMachine(stringArray[0]) : MetaDataHelper.defaultInMmemoryCompressionMachine();
                inMemoryColumnarType.setCompressionMethod((String)object);
                string4 = stringArray != null && stringArray.length > 1 ? MetaDataHelper.inMemoryPriorityCovertToMachine(stringArray[1].trim()) : "";
                inMemoryColumnarType.setPriorityLevel(string4);
                if ((nodeType instanceof CreateTableNodeType || nodeType instanceof GraphNodeType || nodeType instanceof SQLQueryNodeType || nodeType instanceof DataProfileNodeType) && nodeType.getStatus() == NodeStatusType.COMPLETE && this.hashChange(nodeType.getParallelism(), parallelismType)) {
                    arrayList.add(nodeType.getId());
                }
                if ((nodeType instanceof DataProfileNodeType || nodeType instanceof TransformationNodeType || nodeType instanceof BuildTextNodeRefType || nodeType instanceof CreateTableNodeType || nodeType instanceof UpdateTableNodeType) && nodeType.getStatus() == NodeStatusType.COMPLETE && !this.areEqual(nodeType.getInMemoryColumnar(), inMemoryColumnarType)) {
                    arrayList2.add(nodeType.getId());
                }
                nodeType.setParallelism(parallelismType);
                nodeType.setInMemoryColumnar(inMemoryColumnarType);
            }
            this.wfNode.markDirty(true);
            if (arrayList.size() > 0 || arrayList2.size() > 0) {
                MessageDialog.optionalInformation((String)(this.getClass().getName() + "displaySaveWFRequired"), (Component)((Object)this), (Object)WorkflowEditorLrb.get("SAVE_PERFORMACE_SETTINGS_WORKFLOW_MESSAGE"), (String)WorkflowEditorLrb.get("SAVE_PERFORMACE_SETTINGS_WORKFLOW_TITTLE"), null);
                this.wfNode.addNodeListener(new NodeListener(){

                    public void nodeSaved(NodeEvent nodeEvent) {
                        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                        String[] stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
                        if (stringArray.length > 0 || stringArray2.length > 0) {
                            UpdateParallelInMemorySetting updateParallelInMemorySetting = new UpdateParallelInMemorySetting(InMemoryParallelTablePanel.this.wfNode.getId(), stringArray, stringArray2);
                            updateParallelInMemorySetting.execute();
                            InMemoryParallelTablePanel.this.wfNode.removeNodeListener(this);
                        }
                    }
                });
                this.wfNode.save();
            }
            this.workflowEditor.updateParallelToolBarLink();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    static /* synthetic */ Logger access$400() {
        return theLogger;
    }

    static {
        menuItems.add(WorkflowEditorLrb.get("INMEMORY_PARALLEL_TABLE_MENU_ENABLE"));
        menuItems.add(WorkflowEditorLrb.get("INMEMORY_PARALLEL_TABLE_MENU_DISABLE"));
        menuItems.add(WorkflowEditorLrb.get("INMEMORY_PARALLEL_TABLE_MENU_ALL"));
        menuItems.add(WorkflowEditorLrb.get("INMEMORY_PARALLEL_TABLE_MENU_NONE"));
        menuIndex = 0;
        _menu_enable_idx = menuIndex++;
        _menu_disable_idx = menuIndex++;
        _menu_all_idx = menuIndex++;
        _menu_none_idx = menuIndex++;
        excludedInMemory = MetaDataHelper.getNodeTypeInMemoryExcluded();
    }

    class InMemoryParallelTableModel
    extends DefaultTableModel {
        private int totalParallelRows;
        private int activeParallel;
        private int totalInMemoryRows;
        private int activeInMemory;

        public InMemoryParallelTableModel(Vector vector, Vector<String> vector2, int n, int n2, int n3, int n4) {
            super(vector, vector2);
            this.totalParallelRows = 0;
            this.activeParallel = 0;
            this.totalInMemoryRows = 0;
            this.activeInMemory = 0;
            this.totalParallelRows = n;
            this.activeParallel = n2;
            this.totalInMemoryRows = n3;
            this.activeInMemory = n4;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == InMemoryParallelTablePanel.this.get_parallel_on_idx()) {
                return true;
            }
            if (n2 == InMemoryParallelTablePanel.this.get_in_mem_on_idx()) {
                Object object = this.getValueAt(n, n2);
                return !(object instanceof String);
            }
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == InMemoryParallelTablePanel.this.get_parallel_on_idx()) {
                return Boolean.class;
            }
            if (n == InMemoryParallelTablePanel.this.get_in_mem_on_idx()) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == InMemoryParallelTablePanel.this.get_parallel_on_idx()) {
                boolean bl;
                Object object2 = this.getValueAt(n, n2);
                boolean bl2 = bl = !object2.equals(object);
                if (bl) {
                    this.activeParallel = Boolean.TRUE.equals(object) ? ++this.activeParallel : --this.activeParallel;
                    InMemoryParallelTablePanel.this.updateToolBarTitle(this.activeParallel, this.totalParallelRows, this.activeInMemory, this.totalInMemoryRows);
                }
            } else if (n2 == InMemoryParallelTablePanel.this.get_in_mem_on_idx()) {
                boolean bl;
                Object object3 = this.getValueAt(n, n2);
                boolean bl3 = bl = !object3.equals(object);
                if (bl) {
                    this.activeInMemory = Boolean.TRUE.equals(object) ? ++this.activeInMemory : --this.activeInMemory;
                    InMemoryParallelTablePanel.this.updateToolBarTitle(this.activeParallel, this.totalParallelRows, this.activeInMemory, this.totalInMemoryRows);
                }
            }
            super.setValueAt(object, n, n2);
        }
    }

    class CustomAbstractAction
    extends AbstractAction {
        int[] selectedRows;
        String actionItem;
        DropDownMenuButton parentMenu;

        CustomAbstractAction(DropDownMenuButton dropDownMenuButton, String string, int[] nArray) {
            super(string);
            this.parentMenu = dropDownMenuButton;
            this.actionItem = string;
            this.selectedRows = nArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionItem.equals(menuItems.get(_menu_enable_idx))) {
                if (this.parentMenu.equals(InMemoryParallelTablePanel.this.menuParallel)) {
                    InMemoryParallelTablePanel.this.setParallelValues(true, this.selectedRows);
                } else {
                    InMemoryParallelTablePanel.this.setInMemoryValues(true, this.selectedRows);
                }
            } else if (this.actionItem.equals(menuItems.get(_menu_disable_idx))) {
                if (this.parentMenu.equals(InMemoryParallelTablePanel.this.menuParallel)) {
                    InMemoryParallelTablePanel.this.setParallelValues(false, this.selectedRows);
                } else {
                    InMemoryParallelTablePanel.this.setInMemoryValues(false, this.selectedRows);
                }
            } else if (this.actionItem.equals(menuItems.get(_menu_all_idx))) {
                if (this.parentMenu.equals(InMemoryParallelTablePanel.this.menuParallel)) {
                    InMemoryParallelTablePanel.this.setParallelValues(true);
                } else {
                    InMemoryParallelTablePanel.this.setAllInMemoryValues(true);
                }
            } else if (this.actionItem.equals(menuItems.get(_menu_none_idx))) {
                if (this.parentMenu.equals(InMemoryParallelTablePanel.this.menuParallel)) {
                    InMemoryParallelTablePanel.this.setParallelValues(false);
                } else {
                    InMemoryParallelTablePanel.this.setAllInMemoryValues(false);
                }
            }
        }
    }

    class UpdateParallelInMemorySetting
    extends ParallelTablePanel.UpdateObjects {
        private String[] inMemoryNodeIds;

        UpdateParallelInMemorySetting(BigDecimal bigDecimal, String[] stringArray, String[] stringArray2) {
            super(InMemoryParallelTablePanel.this, bigDecimal, stringArray);
            this.inMemoryNodeIds = stringArray2;
        }

        @Override
        protected Object doInBackground() {
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(InMemoryParallelTablePanel.this.context);
                this.updateTableViewObjects(sQLHelper, this.workflowId, this.parallelNodeIds);
                this.alterInMemoryTables(sQLHelper, this.workflowId, this.inMemoryNodeIds);
            }
            return null;
        }

        protected void alterInMemoryTables(SQLHelper sQLHelper, BigDecimal bigDecimal, String[] stringArray) {
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[]{new OdmrObjectNames(stringArray)};
            try {
                sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.ALTER_IN_MEMORY_TABLES(:1,:2)}");
                sQLHelper.cstmt.setBigDecimal(1, bigDecimal);
                sQLHelper.cstmt.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
                sQLHelper.cstmt.execute();
                sQLHelper.cstmt.close();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        }
    }
}

