/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.TransformationPreferencesSettings;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.transformations.ExtendedTransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.TIMESTAMPTZ;

public class TransformationStatisticsState
implements GraphModelProvider {
    private static final Logger theLogger = Logger.getLogger(TransformationStatisticsState.class.getName());
    public static final int _MAX_STR_LENGTH = 50;
    static String NULLS = "Nulls";
    static String EDGES = "EdgeValues";
    static int DEFAULT_BIN_COUNT = 10;
    private boolean _loaded;
    private Context _context;
    private TransformationNode _transformationNode;
    private TransformedAttributes _transformedAttributes;
    private Vector<TransformationSourceAttribute> _transformationSourceAttributes;
    private TransformationSettingsTableModel _tableModel;
    private TransformationPreferencesSettings transformSettings = TransformationPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    static String RANGE = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABELS_RANGE");
    static String SEQUENCE = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABELS_NUMBER");
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    static String _NONE_ATTRIBUTE = DataProfileStatisticsLrb.get("ATTRIBUTE_NONE");
    private static String ATTR = "ATTR";
    private static String DATA_TYPE = "DATA_TYPE";
    private static String NULL_PERCENT = "NULL_PERCENT";
    private static String DISTINCT_CNT = "DISTINCT_CNT";
    private static String DISTINCT_PERCENT = "DISTINCT_PERCENT";
    private static String MODE_VALUE = "MODE_VALUE";
    private static String AVG = "AVG";
    private static String AVG_DATE = "AVG_DATE";
    private static String AVG_TS_TZ = "AVG_TS_TZ";
    private static String MEDIAN_VAL = "MEDIAN_VAL";
    private static String MEDIAN_DATE = "MEDIAN_DATE";
    private static String MEDIAN_TS_TZ = "MEDIAN_TS_TZ";
    private static String MIN = "MIN";
    private static String MAX = "MAX";
    private static String STD = "STD";
    private static String VAR = "VAR";
    private static String SKEWNESS = "SKEWNESS";
    private static String KURTOSIS = "KURTOSIS";
    private static String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    private static String ATTRIBUTE_PERCENT = "ATTRIBUTE_PERCENT";
    private static String _comma = ", ";
    private static DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.getDefault());
    private static Character decimalSpearator = Character.valueOf(dfs.getDecimalSeparator());
    private static String _where_clause = "<where_clause>";
    private static String _where_clause_template = " where ATTR IN(";
    private static String _attr_list_token = "<attribute_list>";
    private static String _table_name_token = "<table_name>";
    private static String _QUERY = "SELECT <attribute_list> from <table_name>, table (HISTOGRAMS) <where_clause>";
    private static String _QUERY_NO_HISTOGRAM = "SELECT <attribute_list> from <table_name> <where_clause>";
    private HashMap<String, AttributeHistogramArray> _serverHistograms = new HashMap();
    private Map<String, Boolean> _mapModified = new HashMap<String, Boolean>();
    private HashMap<String, DataProfileStatisticsData> _refreshDataPoints;
    private HashMap<String, AttributeHistogramArray> _refreshHistograms = new HashMap();
    private String _refreshStatsTable;
    private String _refreshSingleColumnStatsTable;
    private HashMap<String, DataProfileStatisticsData> _serverDataPoints;
    private StatsSelection statsSlelection;
    static String LIST_OF_DISTINCT_VALUES = "LIST_OF_DISTINCT_VALUES";
    private Map<String, List<String>> distinctValues = new HashMap<String, List<String>>();
    private Map<String, List<Integer>> frequencies = new HashMap<String, List<Integer>>();
    private static String EQWIDTH = "EQWIDTH";
    private static String QTILE = "QTILE";
    private static String TOPN = "TOPN";
    static String UNBOUNDED = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_UNBOUNDED") + " ";
    static String UPPER_BOUND = " " + XformDialogsLrb.get("CUSTOM_BINNING_PANEL_UPPER_BOUND") + " ";
    static String NO_LOWER_BOUND = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_LOWER_BOUND");
    static String DASH = " - < ";
    private static final String ODMR_OBJECT_NAMES = "ODMR_OBJECT_NAMES";
    private static final String ODMR_OBJECT_IDS = "ODMR_OBJECT_IDS";
    private static final String ODMR_OBJECT_VALUES = "ODMR_OBJECT_VALUES";
    private static String xformToSql = "{? = call ODMR_UTIL.CLIENT_TRANSFORM(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    static String sql_distincts = "SELECT COUNT (<column_name>) frequency,  <column_name>  from (<table_name>) where <column_name> is not null group by <column_name>";
    private static String queryDateTemplate_no_with = "  <stacked_sql_view>,\n   ALL_DATA_VIEW AS (\n     SELECT * FROM(\n       SELECT \"Attribute Name\", \"Attribute Value\" \n       FROM(\n        SELECT \"Attribute Name\", \"Attribute Value\"  \n        FROM  (SELECT <column> FROM (<table_name>))  \n            UNPIVOT (\n              \"Attribute Value\" \n               FOR \"Attribute Name\" IN (<column>))\n         GROUP BY (\"Attribute Name\", \"Attribute Value\") ) ) ),\n   SUB_STATS_VIEW AS (\n     SELECT \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS DATE) max_value,  \n                               CAST(MIN(\"Attribute Value\") AS DATE) min_value  \n     FROM ALL_DATA_VIEW GROUP BY (\"Attribute Name\") ),\n   STATS_VIEW AS(\n    SELECT \"Attribute Name\", max_value, min_value, ((max_value - min_value) / <bin_count>) AS bin_value FROM SUB_STATS_VIEW),\n   BIN_IDS AS ( SELECT rownum AS bin_id FROM dual connect by rownum < <bin_count_plus_one> )\n   SELECT TO_CHAR((min_value + (bin_id-1) * bin_value), 'DD.MM.YYYY HH24:MI:SS') BIN_BOUND, bin_value from STATS_VIEW, BIN_IDS ORDER BY bin_id\n";
    private static String queryDateTemplate = "WITH  \n   ALL_DATA_VIEW AS (\n     SELECT * FROM(\n       SELECT \"Attribute Name\", \"Attribute Value\" \n       FROM(\n        SELECT \"Attribute Name\", \"Attribute Value\"  \n        FROM  (SELECT <column> FROM (<table_name>))  \n            UNPIVOT (\n              \"Attribute Value\" \n               FOR \"Attribute Name\" IN (<column>))\n         GROUP BY (\"Attribute Name\", \"Attribute Value\") ) ) ),\n   SUB_STATS_VIEW AS (\n     SELECT \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS DATE) max_value,  \n                               CAST(MIN(\"Attribute Value\") AS DATE) min_value  \n     FROM ALL_DATA_VIEW GROUP BY (\"Attribute Name\") ),\n   STATS_VIEW AS(\n    SELECT \"Attribute Name\", max_value, min_value, ((max_value - min_value) / <bin_count>) AS bin_value FROM SUB_STATS_VIEW),\n   BIN_IDS AS ( SELECT rownum AS bin_id FROM dual connect by rownum < <bin_count_plus_one> )\n   SELECT TO_CHAR((min_value + (bin_id-1) * bin_value), 'DD.MM.YYYY HH24:MI:SS') BIN_BOUND, bin_value from STATS_VIEW, BIN_IDS ORDER BY bin_id\n";
    private static String queryDateTemplate_no_with_tz = "  <stacked_sql_view>,\n   ALL_DATA_VIEW AS (\n     SELECT * FROM(\n       SELECT \"Attribute Name\", \"Attribute Value\" \n       FROM(\n        SELECT \"Attribute Name\", \"Attribute Value\"  \n        FROM  (SELECT <column> FROM (<table_name>))  \n            UNPIVOT (\n              \"Attribute Value\" \n               FOR \"Attribute Name\" IN (<column>))\n         GROUP BY (\"Attribute Name\", \"Attribute Value\") ) ) ),\n   SUB_STATS_VIEW AS (\n     SELECT \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS TIMESTAMP WITH TIME ZONE) max_value,  \n                               CAST(MIN(\"Attribute Value\") AS TIMESTAMP WITH TIME ZONE) min_value  \n     FROM ALL_DATA_VIEW GROUP BY (\"Attribute Name\") ),\n   STATS_VIEW AS(\n    SELECT \"Attribute Name\", max_value, min_value, ((max_value - min_value) / <bin_count>) AS bin_value FROM SUB_STATS_VIEW),\n   BIN_IDS AS ( SELECT rownum AS bin_id FROM dual connect by rownum < <bin_count_plus_one> )\n   SELECT TO_CHAR((min_value + (bin_id-1) * bin_value), 'DD.MM.YYYY HH24:MI:SS TZH:TZM') BIN_BOUND, \n   EXTRACT( DAY FROM bin_value ) * 86400\n     + EXTRACT( HOUR   FROM bin_value ) * 3600\n     + EXTRACT( MINUTE FROM bin_value ) * 60\n     + EXTRACT( SECOND FROM bin_value ) bin_value \nfrom STATS_VIEW, BIN_IDS ORDER BY bin_id\n";
    private static String queryDateTemplate_tz = "WITH  \n   ALL_DATA_VIEW AS (\n     SELECT * FROM(\n       SELECT \"Attribute Name\", \"Attribute Value\" \n       FROM(\n        SELECT \"Attribute Name\", \"Attribute Value\"  \n        FROM  (SELECT <column> FROM (<table_name>))  \n            UNPIVOT (\n              \"Attribute Value\" \n               FOR \"Attribute Name\" IN (<column>))\n         GROUP BY (\"Attribute Name\", \"Attribute Value\") ) ) ),\n   SUB_STATS_VIEW AS (\n     SELECT \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS TIMESTAMP WITH TIME ZONE) max_value,  \n                               CAST(MIN(\"Attribute Value\") AS TIMESTAMP WITH TIME ZONE) min_value  \n     FROM ALL_DATA_VIEW GROUP BY (\"Attribute Name\") ),\n   STATS_VIEW AS(\n    SELECT \"Attribute Name\", max_value, min_value, ((max_value - min_value) / <bin_count>) AS bin_value FROM SUB_STATS_VIEW),\n   BIN_IDS AS ( SELECT rownum AS bin_id FROM dual connect by rownum < <bin_count_plus_one> )\n   SELECT TO_CHAR((min_value + (bin_id-1) * bin_value), ''DD.MM.YYYY HH24:MI:SS TZH:TZM'') BIN_BOUND,    EXTRACT( DAY FROM bin_value ) * 86400\n     + EXTRACT( HOUR   FROM bin_value ) * 3600\n     + EXTRACT( MINUTE FROM bin_value ) * 60\n     + EXTRACT( SECOND FROM bin_value ) bin_value \nfrom STATS_VIEW, BIN_IDS ORDER BY bin_id\n";

    private static String getAttributeList(StatsSelection statsSelection) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ATTR);
        stringBuffer.append(_comma);
        stringBuffer.append(DATA_TYPE);
        if (statsSelection.isPercentnull()) {
            stringBuffer.append(_comma);
            stringBuffer.append(NULL_PERCENT);
        }
        if (statsSelection.isPercentdistinct()) {
            stringBuffer.append(_comma);
            stringBuffer.append(DISTINCT_CNT);
            stringBuffer.append(_comma);
            stringBuffer.append(DISTINCT_PERCENT);
        }
        if (statsSelection.isMode()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MODE_VALUE);
        }
        if (statsSelection.isAvg()) {
            stringBuffer.append(_comma);
            stringBuffer.append(AVG);
            stringBuffer.append(_comma);
            stringBuffer.append(AVG_DATE);
            stringBuffer.append(_comma);
            stringBuffer.append(AVG_TS_TZ);
        }
        if (statsSelection.isMedian()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MEDIAN_VAL);
            stringBuffer.append(_comma);
            stringBuffer.append(MEDIAN_DATE);
            stringBuffer.append(_comma);
            stringBuffer.append(MEDIAN_TS_TZ);
        }
        if (statsSelection.isMin()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MIN);
        }
        if (statsSelection.isMax()) {
            stringBuffer.append(_comma);
            stringBuffer.append(MAX);
        }
        if (statsSelection.isStd()) {
            stringBuffer.append(_comma);
            stringBuffer.append(STD);
        }
        if (statsSelection.isVar()) {
            stringBuffer.append(_comma);
            stringBuffer.append(VAR);
        }
        if (statsSelection.isSkewness()) {
            stringBuffer.append(_comma);
            stringBuffer.append(SKEWNESS);
        }
        if (statsSelection.isKurtosis()) {
            stringBuffer.append(_comma);
            stringBuffer.append(KURTOSIS);
        }
        if (statsSelection.isHistogram()) {
            stringBuffer.append(_comma);
            stringBuffer.append(ATTRIBUTE_VALUE);
            stringBuffer.append(_comma);
            stringBuffer.append(ATTRIBUTE_PERCENT);
        }
        return stringBuffer.toString();
    }

    boolean isUpToDate() {
        boolean bl = true;
        Collection<Boolean> collection = this._mapModified.values();
        for (Boolean bl2 : collection) {
            if (!bl2.booleanValue()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void addToModifiedList(MapTransformedSource mapTransformedSource) {
        if (null != mapTransformedSource.getKey()) {
            this._mapModified.put(mapTransformedSource.getKey().getName(), Boolean.TRUE);
        }
    }

    public boolean isModified(String string) {
        return null != this._mapModified.get(string);
    }

    public boolean needsRefresh(String string) {
        Boolean bl = this._mapModified.get(string);
        if (null == bl) {
            return false;
        }
        return bl;
    }

    private void resetModifiedList() {
        Set<String> set = this._mapModified.keySet();
        for (String string : set) {
            this._mapModified.put(string, Boolean.FALSE);
        }
    }

    private void resetModifiedState(String string) {
        this._mapModified.put(string, Boolean.FALSE);
    }

    public void setTransformationSourceAttributes(Vector<TransformationSourceAttribute> vector) {
        this._transformationSourceAttributes = vector;
    }

    public TransformationSourceAttribute findTransformationSourceColumn(String string) {
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            if (transformationSourceAttribute.getName().equals(string)) {
                return transformationSourceAttribute;
            }
            if (null == transformationSourceAttribute.getAlias() || !transformationSourceAttribute.getAlias().equals(string)) continue;
            return transformationSourceAttribute;
        }
        return null;
    }

    public TransformationOutputAttribute findTransformedColumn(String string) {
        List list = this._transformedAttributes.getMapTransformedSourceType();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (MapTransformedSource mapTransformedSource : list) {
            if (!mapTransformedSource.getKey().getName().equals(string)) continue;
            return mapTransformedSource.getKey();
        }
        return null;
    }

    public Context getContext() {
        return this._context;
    }

    public void setRefreshSingleColumnStatsTable(String string) {
        this._refreshSingleColumnStatsTable = string;
    }

    public String getRefreshSingleColumnStatsTable() {
        return this._refreshSingleColumnStatsTable;
    }

    public void setTransformationNode(TransformationNode transformationNode) {
        this._transformationNode = transformationNode;
    }

    public TransformationNode getTransformationNode() {
        return this._transformationNode;
    }

    public TransformedAttributes getTransformedAttributes() {
        return this._transformedAttributes;
    }

    public boolean isShowNulls() {
        return this.transformSettings.isShowNulls();
    }

    public static String getReducedName(String string) {
        String string2 = string.length() > 50 ? string.substring(0, 50) + "..." : string;
        return string2;
    }

    public TransformationStatisticsState(Context context, GraphicalPreferencesSettings graphicalPreferencesSettings, TransformationNode transformationNode, TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this.styleSelection = graphicalPreferencesSettings.getGraphStyle();
        this.depthRadius = graphicalPreferencesSettings.getRadiusDepthValue();
        this._transformationNode = transformationNode;
        this._transformedAttributes = transformedAttributes;
        this._transformationSourceAttributes = vector;
        TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
        this.statsSlelection = transformationNodeType.getStatsSelection();
        if (this.statsSlelection == null) {
            this.statsSlelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
    }

    GraphDataModel initGraphModel() {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        defaultGraphDataModel.setX1(DataProfileStatisticsLrb.get("HISTOGRAM_X_AXIS"), null);
        defaultGraphDataModel.setY1(DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS"), null);
        return defaultGraphDataModel;
    }

    public String getServerStatisticalTable() {
        ResultType resultType = ((TransformationNodeType)this._transformationNode.getData()).getInputStatisticTable();
        return resultType != null ? resultType.getName() : null;
    }

    public boolean hasInputStatisticTable() {
        ResultType resultType = ((TransformationNodeType)this._transformationNode.getData()).getInputStatisticTable();
        return resultType != null;
    }

    public static String getTransformationSourceAttributeDataType(TransformationNode transformationNode, String string) {
        String string2 = null;
        TransformationSourceAttributes transformationSourceAttributes = ((TransformationNodeType)transformationNode.getData()).getTransformationSourceAttributes();
        for (TransformationSourceAttribute transformationSourceAttribute : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!transformationSourceAttribute.getName().equals(string)) continue;
            string2 = transformationSourceAttribute.getDataType();
            break;
        }
        return string2;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void close() {
    }

    public StatsSelection getStatsSelection() {
        return this.statsSlelection;
    }

    public void setTableModel(TransformationSettingsTableModel transformationSettingsTableModel) {
        this._tableModel = transformationSettingsTableModel;
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void loadExtendedModel(String string, int n) throws Exception {
        String string2 = this.getServerStatisticalTable();
        if (string2 == null) {
            this._loaded = false;
            return;
        }
        this._tableModel = new ExtendedTransformationSettingsTableModel(this.statsSlelection, this._transformedAttributes, this._transformationSourceAttributes, this.loadAllStatistics(string2), string, n);
        this.createAllGraphDataModelsTotalPopulation();
        this._loaded = true;
    }

    public void loadBaseModel(String string, int n) throws Exception {
        String string2 = this.getServerStatisticalTable();
        if (string2 == null) {
            this._loaded = false;
            return;
        }
        this._tableModel = new TransformationSettingsTableModel(this.statsSlelection, this._transformedAttributes, this._transformationSourceAttributes, this.loadAllStatistics(string2), string, n);
        this.createAllGraphDataModelsTotalPopulation();
        this._loaded = true;
    }

    public List<DataProfileStatisticsData> loadAllStatistics(String string) throws Exception {
        List<DataProfileStatisticsData> list;
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        List<DataProfileStatisticsData> list2 = this.loadServerStatistics(string);
        if (list2 != null && !list2.isEmpty()) {
            arrayList.addAll(list2);
        }
        if (this._refreshStatsTable != null && (list = this.loadRefreshedStatistics(this._refreshStatsTable)) != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<DataProfileStatisticsData> loadRefreshedStatistics(String string) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this.resetModifiedList();
            return TransformationStatisticsState.loadStatistics(this._context, string, this.statsSlelection, null, this._refreshDataPoints, this._refreshHistograms, null);
        }
        return TransformationStatisticsState.getDataPoints(this._refreshDataPoints);
    }

    public int getNumberOfSelectedStats() {
        int n = 0;
        if (this.statsSlelection.isAvg()) {
            ++n;
        }
        if (this.statsSlelection.isHistogram()) {
            ++n;
        }
        if (this.statsSlelection.isKurtosis()) {
            ++n;
        }
        if (this.statsSlelection.isMax()) {
            ++n;
        }
        if (this.statsSlelection.isMin()) {
            ++n;
        }
        if (this.statsSlelection.isMedian()) {
            ++n;
        }
        if (this.statsSlelection.isPercentdistinct()) {
            ++n;
        }
        if (this.statsSlelection.isPercentnull()) {
            ++n;
        }
        if (this.statsSlelection.isSkewness()) {
            ++n;
        }
        if (this.statsSlelection.isStd()) {
            ++n;
        }
        if (this.statsSlelection.isVar()) {
            ++n;
        }
        if (this.statsSlelection.isPercentnull()) {
            ++n;
        }
        return n;
    }

    public List<DataProfileStatisticsData> loadColumnRefreshedStatistics(Map<String, DataProfileStatisticsData> map, Map<String, AttributeHistogramArray> map2, List<String> list) throws SQLException {
        return TransformationStatisticsState.loadStatistics(this._context, this._refreshSingleColumnStatsTable, this.statsSlelection, list, map, map2, null);
    }

    private List<DataProfileStatisticsData> loadServerStatistics(String string) throws SQLException {
        if (this._serverDataPoints == null) {
            this._serverDataPoints = new HashMap();
            return TransformationStatisticsState.loadStatistics(this._context, string, this.statsSlelection, null, this._serverDataPoints, this._serverHistograms, this._mapModified);
        }
        return TransformationStatisticsState.getDataPoints(this._serverDataPoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DataProfileStatisticsData> loadStatistics(Context context, String string, StatsSelection statsSelection, List<String> list, Map<String, DataProfileStatisticsData> map, Map<String, AttributeHistogramArray> map2, Map<String, Boolean> map3) throws SQLException {
        List<DataProfileStatisticsData> list2 = null;
        if (!(statsSelection.isPercentdistinct() || statsSelection.isPercentnull() || statsSelection.isMax() || statsSelection.isMin() || statsSelection.isAvg() || statsSelection.isStd() || statsSelection.isVar() || statsSelection.isKurtosis() || statsSelection.isMedian() || statsSelection.isSkewness() || statsSelection.isMode() || statsSelection.isHistogram())) {
            list2 = new ArrayList<DataProfileStatisticsData>();
            return list2;
        }
        String string2 = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            String string3;
            CharSequence charSequence;
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            string2 = StringUtils.getReplacedString(statsSelection.isHistogram() ? _QUERY : _QUERY_NO_HISTOGRAM, _attr_list_token, TransformationStatisticsState.getAttributeList(statsSelection));
            if (list == null || list.isEmpty()) {
                string2 = StringUtils.getReplacedString(string2, _where_clause, "");
            } else {
                charSequence = new StringBuilder();
                for (String string4 : list) {
                    if (charSequence.length() > 0) {
                        charSequence.append(",");
                    }
                    string3 = StringUtils.addSingleQuotes(TransformationStatisticsState.getQuotedName(StringUtils.escapeSingleQuotesForSQL(string4)));
                    charSequence.append(string3);
                }
                charSequence.append(")");
                object = new StringBuilder(_where_clause_template);
                ((StringBuilder)object).append(charSequence.toString());
                string2 = StringUtils.getReplacedString(string2, _where_clause, ((StringBuilder)object).toString());
            }
            string2 = StringUtils.getReplacedString(string2, _table_name_token, string);
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string2);
            sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
            while (sQLHelper.ors.next()) {
                Object object2;
                GregorianCalendar gregorianCalendar;
                Cloneable cloneable;
                Object object3;
                Object object4;
                Date date;
                byte[] byArray;
                String string4;
                charSequence = sQLHelper.ors.getString(ATTR);
                object = StringUtils.trimDoubleQuotes((String)charSequence);
                if (map3 != null && null != map3.get(object)) continue;
                string4 = sQLHelper.ors.getString(DATA_TYPE);
                string3 = statsSelection.isPercentnull() ? sQLHelper.ors.getObject(NULL_PERCENT) : null;
                Object object5 = statsSelection.isPercentdistinct() ? sQLHelper.ors.getObject(DISTINCT_CNT) : null;
                Object object6 = statsSelection.isPercentdistinct() ? sQLHelper.ors.getObject(DISTINCT_PERCENT) : null;
                String string5 = statsSelection.isMode() ? sQLHelper.ors.getString(MODE_VALUE) : null;
                Object object7 = statsSelection.isAvg() ? sQLHelper.ors.getObject(AVG) : null;
                java.sql.Date date2 = statsSelection.isAvg() ? sQLHelper.ors.getDate(AVG_DATE) : null;
                TIMESTAMPTZ tIMESTAMPTZ = statsSelection.isAvg() ? sQLHelper.ors.getTIMESTAMPTZ(AVG_TS_TZ) : null;
                Object object8 = statsSelection.isMedian() ? sQLHelper.ors.getObject(MEDIAN_VAL) : null;
                java.sql.Date date3 = statsSelection.isMedian() ? sQLHelper.ors.getDate(MEDIAN_DATE) : null;
                TIMESTAMPTZ tIMESTAMPTZ2 = statsSelection.isMedian() ? sQLHelper.ors.getTIMESTAMPTZ(MEDIAN_TS_TZ) : null;
                String string6 = statsSelection.isMin() ? sQLHelper.ors.getString(MIN) : null;
                String string7 = statsSelection.isMax() ? sQLHelper.ors.getString(MAX) : null;
                Object object9 = statsSelection.isStd() ? sQLHelper.ors.getObject(STD) : null;
                Object object10 = statsSelection.isVar() ? sQLHelper.ors.getObject(VAR) : null;
                Object object11 = statsSelection.isSkewness() ? sQLHelper.ors.getObject(SKEWNESS) : null;
                Object object12 = statsSelection.isKurtosis() ? sQLHelper.ors.getObject(KURTOSIS) : null;
                Object object13 = statsSelection.isHistogram() ? sQLHelper.ors.getObject(ATTRIBUTE_VALUE) : null;
                Double d = statsSelection.isHistogram() ? Double.valueOf(sQLHelper.ors.getDouble(ATTRIBUTE_PERCENT)) : null;
                Double d2 = string3 == null ? null : Double.valueOf(((BigDecimal)((Object)string3)).doubleValue());
                Integer n = object5 == null ? null : Integer.valueOf(((BigDecimal)object5).intValue());
                Double d3 = object6 == null ? null : Double.valueOf(((BigDecimal)object6).doubleValue());
                Double d4 = object7 == null ? null : Double.valueOf(((BigDecimal)object7).doubleValue());
                Date date4 = date2 == null ? null : new Date(date2.getTime());
                Object object14 = null;
                if (d4 != null) {
                    object14 = d4;
                } else if (date4 != null) {
                    object14 = date4;
                } else if (tIMESTAMPTZ != null) {
                    byArray = tIMESTAMPTZ.toBytes();
                    date = tIMESTAMPTZ.timestampValue(sQLHelper.conn);
                    object4 = new GregorianCalendar();
                    ((Calendar)object4).setTime(date);
                    object3 = TimeUtils.GMT + TimeUtils.getRegionName(byArray);
                    cloneable = TimeUtils.toTimeZoneFromZoneId((String)object3);
                    ((GregorianCalendar)object4).setTimeZone((TimeZone)cloneable);
                    object14 = object4;
                }
                byArray = object8 == null ? null : Double.valueOf(((BigDecimal)object8).doubleValue());
                date = date3 == null ? null : new Date(date3.getTime());
                object4 = null;
                if (byArray != null) {
                    object4 = byArray;
                } else if (date != null) {
                    object4 = date;
                } else if (tIMESTAMPTZ2 != null) {
                    object3 = tIMESTAMPTZ2.toBytes();
                    cloneable = tIMESTAMPTZ2.timestampValue(sQLHelper.conn);
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime((Date)cloneable);
                    object2 = TimeUtils.GMT + TimeUtils.getRegionName(object3);
                    TimeZone timeZone = TimeUtils.toTimeZoneFromZoneId((String)object2);
                    gregorianCalendar.setTimeZone(timeZone);
                    object4 = gregorianCalendar;
                }
                object3 = object9 == null ? null : Double.valueOf(((BigDecimal)object9).doubleValue());
                cloneable = object10 == null ? null : Double.valueOf(((BigDecimal)object10).doubleValue());
                gregorianCalendar = object11 == null ? null : Double.valueOf(((BigDecimal)object11).doubleValue());
                object2 = object12 == null ? null : Double.valueOf(((BigDecimal)object12).doubleValue());
                TransformationStatisticsState.addPoint(map, map2, (String)charSequence, string4, d2, n, d3, string5, object14, object4, string6, string7, (Double)object3, (Double)((Object)cloneable), (Double)((Object)gregorianCalendar), (Double)object2, object13, null, d, statsSelection.isHistogram());
            }
            list2 = TransformationStatisticsState.getDataPoints(map);
        }
        return list2;
    }

    public TransformationSettingsTableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        DataProfileStatisticsData dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(n);
        if (dataProfileStatisticsData == null) {
            return null;
        }
        GraphDataModel graphDataModel = dataProfileStatisticsData.getGraphDataModel();
        return graphDataModel;
    }

    public DataProfileStatisticsData getDataProfileStatisticsData(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getDataProfileStatisticsData(string);
    }

    public void setDataProfileStatisticsData(DataProfileStatisticsData dataProfileStatisticsData) {
        if (this._tableModel == null) {
            return;
        }
        this._tableModel.addDataItem(dataProfileStatisticsData);
        String string = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
        int n = this._tableModel.getRow(string);
        this._tableModel.fireTableRowsUpdated(n, n);
    }

    public void setDataProfileStatisticsData(List<DataProfileStatisticsData> list) {
        if (this._tableModel == null) {
            return;
        }
        for (DataProfileStatisticsData dataProfileStatisticsData : list) {
            this._tableModel.addDataItem(dataProfileStatisticsData);
            String string = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
            int n = this._tableModel.getRow(string);
            this._tableModel.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public String getStyleSelection() {
        return this.styleSelection;
    }

    public int getDepthRadius() {
        return this.depthRadius;
    }

    public GraphDataModel createDetailedGraphModel(String string) {
        GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulation(string);
        return graphDataModel;
    }

    private void createAllGraphDataModelsTotalPopulation() {
        Vector vector = this._tableModel.getDataVector();
        for (TransformationSourceAttribute transformationSourceAttribute : vector) {
            String string = transformationSourceAttribute.getName();
            GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulationGeneric(string);
            if (graphDataModel == null) {
                return;
            }
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(Integer.valueOf(0));
            graphDataModel.setLineDataLineDisplayed(false);
            DataProfileStatisticsData dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(string);
            if (dataProfileStatisticsData == null) continue;
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    GraphDataModel createGraphDataModelTotalPopulation(String string) {
        return this.createGraphDataModelTotalPopulationGeneric(string);
    }

    GraphDataModel createGraphDataModelTotalPopulationGeneric(String string) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? StringUtils.trimSingleQuotes(string2.toString()) : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(Integer.valueOf(this.depthRadius));
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    GraphDataModel createDetailedRefreshedGraphModel(String string, AttributeHistogramArray attributeHistogramArray) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? StringUtils.trimSingleQuotes(string2.toString()) : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(Integer.valueOf(this.depthRadius));
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    GraphDataModel createBriefRefreshedGraphModel(AttributeHistogramArray attributeHistogramArray) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        graphDataModel.setTitle(null);
        graphDataModel.setLegendVisible(false);
        graphDataModel.setDepthRadius(Integer.valueOf(0));
        graphDataModel.setLineDataLineDisplayed(false);
        return graphDataModel;
    }

    private void clearServerResults() {
        if (this._serverHistograms != null) {
            this._serverHistograms.clear();
        }
        if (this._serverDataPoints != null) {
            this._serverDataPoints.clear();
        }
    }

    private void clearRefreshedResults() {
        if (this._refreshHistograms != null) {
            this._refreshHistograms.clear();
            if (this._refreshDataPoints != null) {
                this._refreshDataPoints.clear();
                this._refreshDataPoints = null;
            }
        }
    }

    private static List<DataProfileStatisticsData> getDataPoints(Map<String, DataProfileStatisticsData> map) {
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        arrayList.addAll(map.values());
        return arrayList;
    }

    private static void addPoint(Map<String, DataProfileStatisticsData> map, Map<String, AttributeHistogramArray> map2, String string, String string2, Double d, Integer n, Double d2, String string3, Object object, Object object2, String string4, String string5, Double d3, Double d4, Double d5, Double d6, Object object3, String string6, Double d7, boolean bl) {
        AttributeHistogramArray attributeHistogramArray;
        if (null == map.get(string)) {
            map.put(string, new DataProfileStatisticsData(string, string2, d, n, d2, string3, object, object2, string4, string5, d3, d4, d5, d6));
        }
        if ((attributeHistogramArray = map2.get(string)) == null) {
            attributeHistogramArray = new AttributeHistogramArray();
            map2.put(string, attributeHistogramArray);
        }
        if (bl) {
            attributeHistogramArray.addPoint(object3, string6, d7);
        }
    }

    public void updateRefreshedData(String string, AttributeHistogramArray attributeHistogramArray, DataProfileStatisticsData dataProfileStatisticsData) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this._refreshStatsTable = this._refreshSingleColumnStatsTable;
            this._refreshSingleColumnStatsTable = null;
        }
        String string2 = TransformationStatisticsState.getQuotedName(string);
        this._refreshHistograms.put(string2, attributeHistogramArray);
        this._refreshDataPoints.put(string2, dataProfileStatisticsData);
        this.resetModifiedState(string);
    }

    public void updateRefreshedDataWiz(List<String> list, Map<String, AttributeHistogramArray> map, Map<String, DataProfileStatisticsData> map2) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this._refreshStatsTable = this._refreshSingleColumnStatsTable;
            this._refreshSingleColumnStatsTable = null;
        }
        for (String string : list) {
            String string2 = TransformationStatisticsState.getQuotedName(string);
            this._refreshHistograms.put(string2, map.get(string2));
            this._refreshDataPoints.put(string2, map2.get(string2));
        }
        for (String string : list) {
            this.resetModifiedState(string);
        }
    }

    private AttributeHistogramArray getHistogram(String string) {
        AttributeHistogramArray attributeHistogramArray = null;
        if (!this.isModified(string)) {
            if (this._serverHistograms != null) {
                attributeHistogramArray = this._serverHistograms.get(TransformationStatisticsState.getQuotedName(string));
            }
        } else if (!this.needsRefresh(string) && this._refreshHistograms != null) {
            attributeHistogramArray = this._refreshHistograms.get(TransformationStatisticsState.getQuotedName(string));
        }
        if (this.isShowNulls() || attributeHistogramArray == null) {
            return attributeHistogramArray;
        }
        return this.getNullsFilteredHistogram(attributeHistogramArray);
    }

    public AttributeHistogramArray getNullsFilteredHistogram(AttributeHistogramArray attributeHistogramArray) {
        AttributeHistogramArray attributeHistogramArray2 = new AttributeHistogramArray();
        ArrayList<NameValuePair> arrayList = attributeHistogramArray.getAttributeValuesBars();
        for (NameValuePair nameValuePair : arrayList) {
            if (nameValuePair.getName().equals(NULL_BINS)) continue;
            ArrayList<NameValuePair> arrayList2 = new ArrayList<NameValuePair>();
            List list = (List)nameValuePair.getValue();
            for (NameValuePair nameValuePair2 : list) {
                NameValuePair nameValuePair3 = new NameValuePair(nameValuePair2 != null ? nameValuePair2.getName() : null, nameValuePair2.getValue());
                arrayList2.add(nameValuePair3);
            }
            NameValuePair nameValuePair4 = new NameValuePair(nameValuePair.getName(), arrayList2);
            attributeHistogramArray2.addPoint(nameValuePair4);
        }
        return attributeHistogramArray2;
    }

    void removeAllData(String string) {
        if (this._serverHistograms != null) {
            this._serverHistograms.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._serverDataPoints != null) {
            this._serverDataPoints.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._refreshHistograms != null) {
            this._refreshHistograms.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._refreshDataPoints != null) {
            this._refreshDataPoints.remove(TransformationStatisticsState.getQuotedName(string));
        }
    }

    public static String getQuotedName(String string) {
        if (StringUtils.isDoubleQuotedString(string)) {
            return string;
        }
        return StringUtils.addDoubleQuotes(string);
    }

    public Object getMissingValuesDefaultReplacementValue(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMissingValuesReplacementValue(transformationSourceAttribute);
    }

    public Double getStd(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getStd(transformationSourceAttribute);
    }

    public Object getAvg(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getAvg(transformationSourceAttribute);
    }

    public Double getMin(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMin(string);
    }

    public Double getMax(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMax(string);
    }

    private static String getStackedSQL(TransformationNode transformationNode) {
        AbstractNode abstractNode = transformationNode.findParentNode();
        assert (abstractNode instanceof DataProvider);
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        return dataProvider.getInputSQL();
    }

    public void setDistinctValues(String string, List<String> list) {
        this.distinctValues.remove(string);
        this.distinctValues.put(string, new ArrayList<String>(list));
    }

    public void setDistinctValuesFrequencies(String string, List<NameValuePair> list) {
        this.distinctValues.remove(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (NameValuePair nameValuePair : list) {
            arrayList.add(nameValuePair.getName());
            arrayList2.add((Integer)nameValuePair.getValue());
        }
        this.distinctValues.put(string, new ArrayList(arrayList));
        this.frequencies.put(string, new ArrayList(arrayList2));
    }

    public List<String> getDistinctValues(String string) {
        if (this.distinctValues.isEmpty()) {
            this.getDistinctValuesAndFrequenciesFromDB(string);
        }
        return this.distinctValues.get(string);
    }

    public List<Integer> getFrequencies(String string) {
        if (this.frequencies.isEmpty()) {
            this.getDistinctValuesAndFrequenciesFromDB(string);
        }
        return this.frequencies.get(string);
    }

    Vector<NameValuePair> generateDefaultBinsXform(String string, String string2, TransformationType.Binning binning) throws SQLException {
        Vector<NameValuePair> vector = null;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        vector = string2.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string2) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string2) ? TransformationStatisticsState._generateDefaultDateBins1(connectionFolder, this._transformationNode, string, binning, false) : (DatabaseMetadataUtils.isTimestampWithTimeZone(string2) ? TransformationStatisticsState._generateDefaultDateBins1(connectionFolder, this._transformationNode, string, binning, true) : TransformationStatisticsState._generateDefaultBins1(connectionFolder, this._transformationNode, string, string2, binning));
        return vector;
    }

    public static Vector<NameValuePair> generateDefaultBins(ConnectionManager connectionManager, String string, String string2, String string3, TransformationType.Binning binning) throws SQLException {
        if (string3.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string3) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string3)) {
            return TransformationStatisticsState._generateDefaultDateBins2(connectionManager, string, string2, binning, false);
        }
        if (DatabaseMetadataUtils.isTimestampWithTimeZone(string3)) {
            return TransformationStatisticsState._generateDefaultDateBins2(connectionManager, string, string2, binning, true);
        }
        return TransformationStatisticsState._generateDefaultBins2(connectionManager, string, string2, string3, binning);
    }

    private static Vector<NameValuePair> _generateDefaultBins1(ConnectionManager connectionManager, TransformationNode transformationNode, String string, String string2, TransformationType.Binning binning) throws SQLException {
        String string3 = TransformationStatisticsState.getStackedSQL(transformationNode);
        if (binning.getTopN() != null) {
            return TransformationStatisticsState._generateDefaultBinsTopN(connectionManager, string3, string, binning);
        }
        return TransformationStatisticsState._generateDefaultBinsCommon(connectionManager, string3, string, string2, binning);
    }

    private static Vector<NameValuePair> _generateDefaultBins2(ConnectionManager connectionManager, String string, String string2, String string3, TransformationType.Binning binning) throws SQLException {
        return TransformationStatisticsState._generateDefaultBinsCommon(connectionManager, string, string2, string3, binning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultBinsCommon(ConnectionManager connectionManager, String string, String string2, String string3, TransformationType.Binning binning) throws SQLException {
        int n;
        String string4;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        int n2 = 0;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl = false;
        if (null != binning.getEqualWidth()) {
            string4 = EQWIDTH;
            n2 = null != binning.getEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getEqualWidth().getBinCount();
            binLabels = binning.getEqualWidth().getBinLabels();
        } else if (null != binning.getDateEqualWidth()) {
            string4 = EQWIDTH;
            n2 = null != binning.getDateEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getDateEqualWidth().getBinCount();
            binLabels = binning.getDateEqualWidth().getBinLabels();
        } else if (null != binning.getTimestampEqualWidth()) {
            string4 = EQWIDTH;
            n2 = null != binning.getTimestampEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getTimestampEqualWidth().getBinCount();
            binLabels = binning.getTimestampEqualWidth().getBinLabels();
        } else if (null != binning.getQuantile()) {
            string4 = QTILE;
            n2 = null != binning.getQuantile().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getQuantile().getBinCount();
            binLabels = binning.getQuantile().getBinLabels();
        } else {
            string4 = TOPN;
            bigInteger = BigInteger.valueOf(binning.getTopN().getBinCount().intValue() - 1);
        }
        int n3 = n = bigInteger != null ? bigInteger.intValue() : 0;
        if (binLabels != null) {
            bl = null != binLabels.getNumberSequence();
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string5;
            int n4;
            String[] stringArray;
            int n5;
            sQLHelper.conn = connectionManager.getConnection(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            Array array = oracleConnection.createOracleArray(ODMR_OBJECT_NAMES, (Object)new String[0]);
            Array array2 = oracleConnection.createOracleArray(ODMR_OBJECT_IDS, (Object)new String[0]);
            Array array3 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            Array array4 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            Array array5 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            String string6 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.GENERATE_DEFAULT_BINS(?,?,?,?,?,?,?,?,?,?,?)}");
            int n6 = 1;
            sQLHelper.cstmt.setCharacterStream(n6++, (Reader)new StringReader(string), string.length());
            sQLHelper.cstmt.setArray(n6++, array);
            sQLHelper.cstmt.setArray(n6++, array2);
            sQLHelper.cstmt.setArray(n6++, array3);
            sQLHelper.cstmt.setArray(n6++, array4);
            sQLHelper.cstmt.setArray(n6++, array5);
            sQLHelper.cstmt.setString(n6++, string6);
            sQLHelper.cstmt.setString(n6++, string3);
            sQLHelper.cstmt.setString(n6++, string4);
            sQLHelper.cstmt.setInt(n6++, n2);
            sQLHelper.cstmt.setInt(n6++, n);
            n6 = 2;
            sQLHelper.cstmt.registerOutParameter(n6++, 2003, ODMR_OBJECT_NAMES);
            sQLHelper.cstmt.registerOutParameter(n6++, 2003, ODMR_OBJECT_IDS);
            sQLHelper.cstmt.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.execute();
            n6 = 2;
            ARRAY aRRAY = sQLHelper.cstmt.getARRAY(n6++);
            ARRAY aRRAY2 = sQLHelper.cstmt.getARRAY(n6++);
            BigDecimal[] bigDecimalArray = (BigDecimal[])aRRAY2.getArray();
            Double[] doubleArray = new Double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                doubleArray[i] = bigDecimalArray[i].doubleValue();
            }
            ARRAY aRRAY3 = sQLHelper.cstmt.getARRAY(n6++);
            String[] stringArray2 = (String[])aRRAY3.getArray();
            ARRAY aRRAY4 = sQLHelper.cstmt.getARRAY(n6++);
            String[] stringArray3 = (String[])aRRAY4.getArray();
            ARRAY aRRAY5 = sQLHelper.cstmt.getARRAY(n6++);
            String[] stringArray4 = (String[])aRRAY5.getArray();
            if (stringArray3 != null && stringArray3.length > 0 && stringArray3[0] == null) {
                n5 = 0;
                stringArray = new String[stringArray3.length + 1];
                stringArray[n5] = "1";
                for (n4 = 1; n4 < stringArray3.length - 1; ++n4) {
                    ++n5;
                    try {
                        stringArray[n5] = String.valueOf(Integer.parseInt(stringArray3[n4]) + 1);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringArray[n5] = stringArray3[n4];
                    }
                }
                stringArray[n5 + 1] = String.valueOf(Integer.parseInt(stringArray[n5]) + 1);
            } else {
                stringArray = stringArray3;
            }
            if (string4.equals(TOPN)) {
                HashMap<Object, NameValuePair> hashMap = new HashMap<Object, NameValuePair>();
                for (n4 = 0; n4 < stringArray2.length; ++n4) {
                    string5 = stringArray2[n4];
                    var35_42 = stringArray2[n4];
                    if (var35_42 == null || null != hashMap.get(var35_42)) continue;
                    var36_43 = new ArrayList();
                    var36_43.add(string5);
                    var37_44 = new NameValuePair((String)var35_42, var36_43, n4);
                    vector.add((NameValuePair)var37_44);
                    hashMap.put(var35_42, (NameValuePair)var37_44);
                }
            } else {
                n5 = 0;
                for (n4 = 1; n4 < doubleArray.length - 2; ++n4) {
                    string5 = null;
                    var35_42 = doubleArray[n4];
                    var36_43 = var35_42 != null ? ((Double)var35_42).toString() : "0";
                    var36_43 = TransformationStatisticsState.findDecimalPart((Double)var35_42);
                    if (n4 == 1) {
                        string5 = !bl ? new NameValuePair(UNBOUNDED + (String)var36_43, (Object)NO_LOWER_BOUND, n5) : new NameValuePair(stringArray[n5], (Object)NO_LOWER_BOUND, n5);
                        string5.setRangeValue(string5.getName());
                        ++n5;
                        vector.add((NameValuePair)string5);
                    }
                    if (!bl) {
                        var37_44 = TransformationStatisticsState.findDecimalPart(doubleArray[n4]) + DASH + TransformationStatisticsState.findDecimalPart(doubleArray[n4 + 1]);
                        string5 = new NameValuePair((String)var37_44, (Object)TransformationStatisticsState.findDecimalPart(doubleArray[n4]), n5);
                    } else {
                        string5 = new NameValuePair(stringArray[n5], (Object)TransformationStatisticsState.findDecimalPart(doubleArray[n4]), n5);
                    }
                    string5.setRangeValue(string5.getName());
                    ++n5;
                    vector.add((NameValuePair)string5);
                }
                NameValuePair nameValuePair = null;
                string5 = TransformationStatisticsState.findDecimalPart(doubleArray[doubleArray.length - 2]);
                if (doubleArray != null && doubleArray.length > 0) {
                    if (doubleArray.length == 3) {
                        nameValuePair = !bl ? new NameValuePair(" " + UNBOUNDED + string5, (Object)NO_LOWER_BOUND, n5) : new NameValuePair(stringArray[n5], (Object)NO_LOWER_BOUND, n5);
                        nameValuePair.setRangeValue(nameValuePair.getName());
                        ++n5;
                        vector.add(nameValuePair);
                    }
                    if (!bl) {
                        nameValuePair = new NameValuePair(UPPER_BOUND + string5, (Object)string5, n5);
                        nameValuePair.setRangeValue(nameValuePair.getName());
                    } else {
                        nameValuePair = new NameValuePair(stringArray[n5], (Object)string5, n5);
                        nameValuePair.setRangeValue(nameValuePair.getName());
                    }
                    vector.add(nameValuePair);
                }
            }
            if (string4.equals(TOPN) && !vector.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray4.length; ++i) {
                    string5 = stringArray4[i];
                    if (string5 == null || string5.isEmpty()) continue;
                    string5 = stringArray4[i];
                    if (string5 == null || string5.isEmpty()) {
                        string5 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                    }
                    arrayList.add(string5);
                }
                vector.add(new NameValuePair(LIST_OF_DISTINCT_VALUES, arrayList));
            }
        }
        return vector;
    }

    private static String findDecimalPart(double d) {
        long l = (long)d;
        double d2 = d - (double)l;
        if (Math.abs(d) >= 1.0) {
            String string = String.valueOf(d);
            if (d2 == 0.0) {
                int n = string.lastIndexOf(decimalSpearator.charValue());
                if (-1 == n) {
                    return string;
                }
                string = string.substring(0, n);
                return string;
            }
            return string;
        }
        String string = String.valueOf(d2);
        if (!string.startsWith("0")) {
            return string;
        }
        return string.substring(1, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultBinsTopN(ConnectionManager connectionManager, String string, String string2, TransformationType.Binning binning) throws SQLException {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        BigInteger bigInteger = BigInteger.valueOf(binning.getTopN().getBinCount().intValue() - 1);
        int n = bigInteger != null ? bigInteger.intValue() : 0;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string3;
            int n2;
            sQLHelper.conn = connectionManager.getConnection(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            Array array = oracleConnection.createOracleArray(ODMR_OBJECT_NAMES, (Object)new String[0]);
            Array array2 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            Array array3 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            Array array4 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            Array array5 = oracleConnection.createOracleArray(ODMR_OBJECT_IDS, (Object)new Integer[0]);
            String string4 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.GENERATE_DEFAULT_BINS_TOPN(?,?,?,?,?,?,?,?)}");
            int n3 = 1;
            sQLHelper.cstmt.setCharacterStream(n3++, (Reader)new StringReader(string), string.length());
            sQLHelper.cstmt.setArray(n3++, array);
            sQLHelper.cstmt.setArray(n3++, array2);
            sQLHelper.cstmt.setArray(n3++, array3);
            sQLHelper.cstmt.setArray(n3++, array4);
            sQLHelper.cstmt.setArray(n3++, array5);
            sQLHelper.cstmt.setString(n3++, string4);
            sQLHelper.cstmt.setInt(n3++, n);
            n3 = 2;
            sQLHelper.cstmt.registerOutParameter(n3++, 2003, ODMR_OBJECT_NAMES);
            sQLHelper.cstmt.registerOutParameter(n3++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.registerOutParameter(n3++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.registerOutParameter(n3++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.registerOutParameter(n3++, 2003, ODMR_OBJECT_IDS);
            sQLHelper.cstmt.execute();
            n3 = 2;
            ARRAY aRRAY = sQLHelper.cstmt.getARRAY(n3++);
            ARRAY aRRAY2 = sQLHelper.cstmt.getARRAY(n3++);
            String[] stringArray = (String[])aRRAY2.getArray();
            ARRAY aRRAY3 = sQLHelper.cstmt.getARRAY(n3++);
            String[] stringArray2 = (String[])aRRAY3.getArray();
            ARRAY aRRAY4 = sQLHelper.cstmt.getARRAY(n3++);
            String[] stringArray3 = (String[])aRRAY4.getArray();
            ARRAY aRRAY5 = sQLHelper.cstmt.getARRAY(n3++);
            BigDecimal[] bigDecimalArray = (BigDecimal[])aRRAY5.getArray();
            if (stringArray2 != null && stringArray2.length > 0 && stringArray2[0] == null) {
                int n4 = 0;
                var25_28 = new String[stringArray2.length + 1];
                var25_28[n4] = "1";
                for (n2 = 1; n2 < stringArray2.length - 1; ++n2) {
                    ++n4;
                    try {
                        var25_28[n4] = String.valueOf(Integer.parseInt(stringArray2[n2]) + 1);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        var25_28[n4] = stringArray2[n2];
                    }
                }
                var25_28[n4 + 1] = String.valueOf(Integer.parseInt(var25_28[n4]) + 1);
            } else {
                var25_28 = stringArray2;
            }
            HashMap<String, NameValuePair> hashMap = new HashMap<String, NameValuePair>();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string5 = stringArray[n2];
                string3 = stringArray[n2];
                if (string3 == null || null != hashMap.get(string3)) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string5);
                NameValuePair nameValuePair = new NameValuePair(string3, arrayList, n2);
                vector.add(nameValuePair);
                hashMap.put(string3, nameValuePair);
            }
            if (!vector.isEmpty()) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                for (int i = 0; i < stringArray3.length; ++i) {
                    string3 = stringArray3[i];
                    if (string3 == null || string3.isEmpty()) continue;
                    int n5 = bigDecimalArray[i].intValue();
                    string3 = stringArray3[i];
                    if (string3 == null || string3.isEmpty()) {
                        string3 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                    }
                    arrayList.add(new NameValuePair(string3, (Object)n5));
                }
                vector.add(new NameValuePair(LIST_OF_DISTINCT_VALUES, arrayList));
            }
        }
        return vector;
    }

    private static String removeWithClause(String string, String string2, int n, boolean bl) {
        int n2 = string.indexOf("WITH");
        if (n2 == -1) {
            String string3 = bl ? queryDateTemplate_tz : queryDateTemplate;
            string3 = StringUtils.getReplacedString(string3, "<column>", string2);
            string3 = StringUtils.getReplacedString(string3, "<bin_count>", String.valueOf(n));
            string3 = StringUtils.getReplacedString(string3, "<bin_count_plus_one>", String.valueOf(n + 1));
            string3 = StringUtils.getReplacedString(string3, "<table_name>", string);
            return string3;
        }
        int n3 = string.indexOf("*/");
        int n4 = string.indexOf(" as ");
        if (n4 == -1) {
            n4 = string.indexOf(" AS ");
        }
        String string4 = string.substring(n3 + 2, n4);
        n4 = string.toLowerCase().indexOf("/* END OF SQL FOR NODE:".toLowerCase());
        String string5 = string.substring(0, n4);
        String string6 = bl ? queryDateTemplate_no_with_tz : queryDateTemplate_no_with;
        string6 = StringUtils.getReplacedString(string6, "<column>", string2);
        string6 = StringUtils.getReplacedString(string6, "<bin_count>", String.valueOf(n));
        string6 = StringUtils.getReplacedString(string6, "<bin_count_plus_one>", String.valueOf(n + 1));
        string6 = StringUtils.getReplacedString(string6, "<stacked_sql_view>", string5);
        string6 = StringUtils.getReplacedString(string6, "<table_name>", string4);
        return string6;
    }

    private static Vector<NameValuePair> _generateDefaultDateBins1(ConnectionManager connectionManager, TransformationNode transformationNode, String string, TransformationType.Binning binning, boolean bl) throws SQLException {
        String string2 = TransformationStatisticsState.getStackedSQL(transformationNode);
        return TransformationStatisticsState._generateDefaultDateBinsCommon(connectionManager, string2, string, binning, bl);
    }

    private static Vector<NameValuePair> _generateDefaultDateBins2(ConnectionManager connectionManager, String string, String string2, TransformationType.Binning binning, boolean bl) throws SQLException {
        return TransformationStatisticsState._generateDefaultDateBinsCommon(connectionManager, string, string2, binning, bl);
    }

    private static Vector<NameValuePair> _generateDefaultDateBinsCommon(ConnectionManager connectionManager, String string, String string2, TransformationType.Binning binning, boolean bl) throws SQLException {
        int n;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (string == null) {
            return vector;
        }
        if (!bl ? null == binning.getDateEqualWidth() : null == binning.getTimestampEqualWidth()) {
            return vector;
        }
        BigInteger bigInteger = bl ? binning.getTimestampEqualWidth().getBinCount() : binning.getDateEqualWidth().getBinCount();
        BinLabels binLabels = bl ? binning.getTimestampEqualWidth().getBinLabels() : binning.getDateEqualWidth().getBinLabels();
        boolean bl2 = false;
        int n2 = n = bigInteger != null ? bigInteger.intValue() : 0;
        if (binLabels != null) {
            bl2 = null != binLabels.getNumberSequence();
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string3 = StringUtils.isDoubleQuotedString(string2) ? string2 : StringUtils.addDoubleQuotes(string2);
            String string4 = TransformationStatisticsState.removeWithClause(string, string3, n, bl);
            sQLHelper.conn = connectionManager.getConnection(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.ors = (OracleResultSet)sQLHelper.opstmt.executeQuery();
            String string5 = NO_LOWER_BOUND;
            String string6 = null;
            Long l = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (sQLHelper.ors.next()) {
                l = sQLHelper.ors.getLong("bin_value");
                string6 = sQLHelper.ors.getString("BIN_BOUND");
                arrayList.add(string6);
                if (l.doubleValue() != 0.0) continue;
                arrayList.add(string6);
                break;
            }
            if (arrayList.isEmpty()) {
                Vector<NameValuePair> vector2 = vector;
                return vector2;
            }
            NameValuePair nameValuePair = null;
            Integer n3 = 1;
            String string7 = n3.toString();
            nameValuePair = !bl2 ? new NameValuePair(UNBOUNDED + (String)arrayList.get(1), (Object)NO_LOWER_BOUND, n3.intValue()) : new NameValuePair(string7, (Object)NO_LOWER_BOUND, n3.intValue());
            string5 = (String)arrayList.get(1);
            vector.add(nameValuePair);
            nameValuePair.setRangeValue(nameValuePair.getName());
            if (l.doubleValue() > 0.0) {
                for (int i = 2; i < arrayList.size(); ++i) {
                    Object object = n3;
                    n3 = n3 + 1;
                    string7 = n3.toString();
                    if (!bl2) {
                        object = string5 + DASH + (String)arrayList.get(i);
                        nameValuePair = new NameValuePair((String)object, (Object)string5, n3.intValue());
                    } else {
                        nameValuePair = new NameValuePair(string7, (Object)string5, n3.intValue());
                    }
                    string5 = (String)arrayList.get(i);
                    vector.add(nameValuePair);
                    nameValuePair.setRangeValue(nameValuePair.getName());
                }
            }
            if (!vector.isEmpty()) {
                if (!bl2) {
                    nameValuePair = new NameValuePair(UPPER_BOUND + string5, (Object)string5, vector.size() + 1);
                    vector.add(nameValuePair);
                    nameValuePair.setRangeValue(nameValuePair.getName());
                } else {
                    Integer n4 = n3;
                    n3 = n3 + 1;
                    string7 = n3.toString();
                    nameValuePair = new NameValuePair(string7, (Object)string5, n3.intValue());
                    vector.add(nameValuePair);
                    nameValuePair.setRangeValue(nameValuePair.getName());
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshAllStatistics() throws Exception {
        if (this.isUpToDate()) {
            return false;
        }
        try {
            ArrayList<String> arrayList = null;
            ArrayList<String> arrayList2 = null;
            for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
                DataProfileStatisticsData dataProfileStatisticsData;
                if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList2 = new ArrayList<String>();
                }
                arrayList.add(transformationSourceAttribute.getName());
                arrayList2.add(transformationSourceAttribute.getDataType());
            }
            this._refreshStatsTable = TransformationStatisticsState.refreshStatistics(this._context, arrayList, arrayList2, this._transformedAttributes, this._transformationNode, this._refreshStatsTable, this.getServerStatisticalTable());
            boolean bl = true;
            return bl;
        }
        finally {
            this.clearRefreshedResults();
        }
    }

    public void refreshSingleColumnStatistics(String string) throws Exception {
        Object object;
        Object object22;
        if (!this.isModified(string)) {
            return;
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list = transformedAttributes.getMapTransformedSourceType();
        if (null != this._transformedAttributes && !this._transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (Object object22 : this._transformedAttributes.getMapTransformedSourceType()) {
                object = object22.getKey();
                if (!object.getName().equals(string)) continue;
                list.add(object22);
                break;
            }
        }
        Object object3 = null;
        object22 = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            DataProfileStatisticsData dataProfileStatisticsData;
            if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || DatabaseMetadataUtils.isACustomDataType(this._context, transformationSourceAttribute.getDataType()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
            if (object3 == null) {
                object3 = new ArrayList();
                object22 = new ArrayList();
            }
            object3.add((String)transformationSourceAttribute.getName());
            object22.add(transformationSourceAttribute.getDataType());
        }
        object = this.getServerStatisticalTable();
        if (object != null) {
            this._refreshSingleColumnStatsTable = TransformationStatisticsState.refreshStatistics(this._context, object3, (List<String>)object22, transformedAttributes, this._transformationNode, this._refreshSingleColumnStatsTable, (String)object);
        }
    }

    public void refreshSelectedColumnsStatistics(List<String> list) throws Exception {
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object22 : list) {
            if (!this.isModified(object22)) continue;
            hashMap.put(object22, object22);
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list2 = transformedAttributes.getMapTransformedSourceType();
        if (null != this._transformedAttributes && !this._transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (Object object2 : this._transformedAttributes.getMapTransformedSourceType()) {
                TransformationOutputAttribute transformationOutputAttribute = object2.getKey();
                if (null == hashMap.get(transformationOutputAttribute.getName())) continue;
                list2.add(object2);
            }
        }
        Object object3 = null;
        object2 = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            DataProfileStatisticsData dataProfileStatisticsData;
            if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
            if (object3 == null) {
                object3 = new ArrayList();
                object2 = new ArrayList();
            }
            object3.add((String)transformationSourceAttribute.getName());
            object2.add(transformationSourceAttribute.getDataType());
        }
        this._refreshSingleColumnStatsTable = TransformationStatisticsState.refreshStatistics(this._context, object3, (List<String>)object2, transformedAttributes, this._transformationNode, this._refreshSingleColumnStatsTable, this.getServerStatisticalTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String refreshStatistics(Context context, List<String> list, List<String> list2, TransformedAttributes transformedAttributes, TransformationNode transformationNode, String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        StringBuilder stringBuilder;
        Object object10;
        StringCollection stringCollection;
        Object object11;
        Object object12;
        Object object132;
        Object object14;
        Object object15;
        ResultType resultType = ((TransformationNodeType)transformationNode.getData()).getSampleSettings().getOutputTable();
        Object object16 = resultType.getName();
        assert (object16 != null);
        if (list != null && !list.isEmpty() && !TransformationStatisticsState.areColumnsPresentInSampleTable(context, (String)object16, list) && (object15 = transformationNode.findParentNode()) != null && object15 instanceof DataProvider && null != (object14 = (DataProvider)object15).getInputSQL()) {
            object16 = "(" + object14.getInputSQL() + ")";
        }
        object15 = new ArrayList();
        object14 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        ArrayList<Double> arrayList10 = new ArrayList<Double>();
        ArrayList<String> arrayList11 = new ArrayList<String>();
        ArrayList<String> arrayList12 = new ArrayList<String>();
        ArrayList<Integer> arrayList13 = new ArrayList<Integer>();
        ArrayList<String> arrayList14 = new ArrayList<String>();
        ArrayList<String> arrayList15 = new ArrayList<String>();
        ArrayList<Integer> arrayList16 = new ArrayList<Integer>();
        ArrayList<String> arrayList17 = new ArrayList<String>();
        ArrayList<String> arrayList18 = new ArrayList<String>();
        ArrayList<String> arrayList19 = new ArrayList<String>();
        ArrayList<String> arrayList20 = new ArrayList<String>();
        ArrayList<Integer> arrayList21 = new ArrayList<Integer>();
        ArrayList<String> arrayList22 = new ArrayList<String>();
        ArrayList<String> arrayList23 = new ArrayList<String>();
        ArrayList<Integer> arrayList24 = new ArrayList<Integer>();
        ArrayList<String> arrayList25 = new ArrayList<String>();
        ArrayList<String> arrayList26 = new ArrayList<String>();
        ArrayList<String> arrayList27 = new ArrayList<String>();
        ArrayList<String> arrayList28 = new ArrayList<String>();
        ArrayList<Integer> arrayList29 = new ArrayList<Integer>();
        ArrayList<String> arrayList30 = new ArrayList<String>();
        ArrayList<String> arrayList31 = new ArrayList<String>();
        ArrayList<String> arrayList32 = new ArrayList<String>();
        ArrayList<Integer> arrayList33 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList34 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList35 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList36 = new ArrayList<Integer>();
        ArrayList<String> arrayList37 = new ArrayList<String>();
        ArrayList<String> arrayList38 = new ArrayList<String>();
        ArrayList<Integer> arrayList39 = new ArrayList<Integer>();
        ArrayList<String> arrayList40 = new ArrayList<String>();
        ArrayList<String> arrayList41 = new ArrayList<String>();
        ArrayList<String> arrayList42 = new ArrayList<String>();
        ArrayList<Integer> arrayList43 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList44 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList45 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList46 = new ArrayList<Integer>();
        ArrayList<String> arrayList47 = new ArrayList<String>();
        ArrayList<String> arrayList48 = new ArrayList<String>();
        ArrayList<Integer> arrayList49 = new ArrayList<Integer>();
        ArrayList<String> arrayList50 = new ArrayList<String>();
        ArrayList<String> arrayList51 = new ArrayList<String>();
        ArrayList<String> arrayList52 = new ArrayList<String>();
        ArrayList<Integer> arrayList53 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList54 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList55 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList56 = new ArrayList<Integer>();
        ArrayList<String> arrayList57 = new ArrayList<String>();
        ArrayList<String> arrayList58 = new ArrayList<String>();
        ArrayList<Integer> arrayList59 = new ArrayList<Integer>();
        ArrayList<String> arrayList60 = new ArrayList<String>();
        ArrayList<String> arrayList61 = new ArrayList<String>();
        ArrayList<String> arrayList62 = new ArrayList<String>();
        ArrayList<Integer> arrayList63 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList64 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList65 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList66 = new ArrayList<Integer>();
        ArrayList<String> arrayList67 = new ArrayList<String>();
        ArrayList<String> arrayList68 = new ArrayList<String>();
        ArrayList<Integer> arrayList69 = new ArrayList<Integer>();
        ArrayList<String> arrayList70 = new ArrayList<String>();
        ArrayList<String> arrayList71 = new ArrayList<String>();
        ArrayList<Integer> arrayList72 = new ArrayList<Integer>();
        ArrayList<String> arrayList73 = new ArrayList<String>();
        ArrayList<String> arrayList74 = new ArrayList<String>();
        ArrayList<String> arrayList75 = new ArrayList<String>();
        ArrayList<String> arrayList76 = new ArrayList<String>();
        ArrayList<String> arrayList77 = new ArrayList<String>();
        ArrayList<Integer> arrayList78 = new ArrayList<Integer>();
        ArrayList<String> arrayList79 = new ArrayList<String>();
        ArrayList<String> arrayList80 = new ArrayList<String>();
        ArrayList<String> arrayList81 = new ArrayList<String>();
        ArrayList<String> arrayList82 = new ArrayList<String>();
        ArrayList<String> arrayList83 = new ArrayList<String>();
        ArrayList<String> arrayList84 = new ArrayList<String>();
        ArrayList<String> arrayList85 = new ArrayList<String>();
        ArrayList<String> arrayList86 = new ArrayList<String>();
        ArrayList<String> arrayList87 = new ArrayList<String>();
        ArrayList<String> arrayList88 = new ArrayList<String>();
        ArrayList<String> arrayList89 = new ArrayList<String>();
        ArrayList<Double> arrayList90 = new ArrayList<Double>();
        ArrayList<String> arrayList91 = new ArrayList<String>();
        ArrayList<String> arrayList92 = new ArrayList<String>();
        ArrayList<String> arrayList93 = new ArrayList<String>();
        ArrayList<Object> arrayList94 = new ArrayList<Object>();
        ArrayList<String> arrayList95 = new ArrayList<String>();
        ArrayList<String> arrayList96 = new ArrayList<String>();
        ArrayList<String> arrayList97 = new ArrayList<String>();
        ArrayList<Object> arrayList98 = new ArrayList<Object>();
        ArrayList<String> arrayList99 = new ArrayList<String>();
        ArrayList<String> arrayList100 = new ArrayList<String>();
        ArrayList<String> arrayList101 = new ArrayList<String>();
        ArrayList<String> arrayList102 = new ArrayList<String>();
        ArrayList<Double> arrayList103 = new ArrayList<Double>();
        ArrayList<Double> arrayList104 = new ArrayList<Double>();
        ArrayList<Double> arrayList105 = new ArrayList<Double>();
        ArrayList<Double> arrayList106 = new ArrayList<Double>();
        ArrayList<Double> arrayList107 = new ArrayList<Double>();
        ArrayList<String> arrayList108 = new ArrayList<String>();
        ArrayList<String> arrayList109 = new ArrayList<String>();
        ArrayList<String> arrayList110 = new ArrayList<String>();
        ArrayList<Double> arrayList111 = new ArrayList<Double>();
        ArrayList<Double> arrayList112 = new ArrayList<Double>();
        ArrayList<String> arrayList113 = new ArrayList<String>();
        ArrayList<String> arrayList114 = new ArrayList<String>();
        ArrayList<String> arrayList115 = new ArrayList<String>();
        TransformationNodeType transformationNodeType = (TransformationNodeType)transformationNode.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object132 : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            hashMap.put(object132.getName(), object132);
        }
        List list3 = transformedAttributes.getMapTransformedSourceType();
        object132 = list3.iterator();
        while (object132.hasNext()) {
            Object object17;
            TransformationType.Binning.CustomCategorical customCategorical;
            String string32;
            object12 = (MapTransformedSource)object132.next();
            object11 = object12.getKey();
            stringCollection = object12.getStringCollectionNames();
            object10 = new StringBuilder();
            stringBuilder = new StringBuilder();
            for (String string32 : stringCollection.getValue()) {
                if (((StringBuilder)object10).length() > 0) {
                    ((StringBuilder)object10).append(", ");
                    stringBuilder.append(", ");
                }
                ((StringBuilder)object10).append(string32);
                stringBuilder.append(((TransformationSourceAttribute)hashMap.get(string32)).getDataType());
            }
            if (!object11.isModified()) continue;
            TransformationType transformationType = object11.getTransformationElementType();
            string32 = transformationType.getBinning();
            if (null != string32) {
                if (null != string32.getCustomCategorical()) {
                    customCategorical = string32.getCustomCategorical();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList4.add(object17.getLabel());
                    arrayList5.add(object17.isIncludeNulls() ? "true" : "false");
                    object9 = customCategorical.getCategoricalBin();
                    object8 = object9.iterator();
                    while (object8.hasNext()) {
                        object7 = (CategoricalBin)object8.next();
                        object6 = object7.getStringCollectionValues().getValue();
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            object4 = (String)object5.next();
                            object15.add(object11.getName());
                            object14.add(((StringBuilder)object10).toString());
                            arrayList.add(object7.getName());
                            arrayList2.add(object7.isIsOther() ? 1 : 0);
                            arrayList3.add((String)object4);
                        }
                    }
                    continue;
                }
                if (null != string32.getCustomDate()) {
                    customCategorical = string32.getCustomDate();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList19.add(object17.getLabel());
                    arrayList20.add(object17.isIncludeNulls() ? "true" : "false");
                    arrayList21.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    object9 = customCategorical.getBinLabels();
                    object8 = customCategorical.getDateBin();
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (DateBin)object7.next();
                        arrayList14.add(object11.getName());
                        arrayList15.add(((StringBuilder)object10).toString());
                        arrayList16.add(null != object9.getNumberSequence() ? 1 : 0);
                        arrayList17.add(object6.getName());
                        object5 = TimeUtils.getShortSimpleDateFormatZoneRFC2();
                        object4 = new StringBuffer();
                        if (null != object6.getLowerBound().getValue()) {
                            object3 = object6.getLowerBound().getValue().toGregorianCalendar().getTime();
                            object2 = ((SimpleDateFormat)object5).format((Date)object3, (StringBuffer)object4, new FieldPosition(0));
                            arrayList18.add(((StringBuffer)object2).toString());
                            continue;
                        }
                        arrayList18.add(null);
                    }
                    continue;
                }
                if (null != string32.getCustomTimestamp()) {
                    customCategorical = string32.getCustomTimestamp();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList27.add(object17.getLabel());
                    arrayList28.add(object17.isIncludeNulls() ? "true" : "false");
                    arrayList29.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    object9 = customCategorical.getBinLabels();
                    object8 = customCategorical.getTimestampTimezoneBin();
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (TimestampTimezoneBin)object7.next();
                        arrayList22.add(object11.getName());
                        arrayList23.add(((StringBuilder)object10).toString());
                        arrayList24.add(null != object9.getNumberSequence() ? 1 : 0);
                        arrayList25.add(object6.getName());
                        object5 = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
                        object4 = new StringBuffer();
                        if (null != object6.getLowerBound().getValue()) {
                            object3 = object6.getLowerBound().getValue().toGregorianCalendar();
                            ((DateFormat)object5).setTimeZone(((GregorianCalendar)object3).getTimeZone());
                            object2 = object6.getLowerBound().getValue().toGregorianCalendar().getTime();
                            object = ((SimpleDateFormat)object5).format((Date)object2, (StringBuffer)object4, new FieldPosition(0));
                            arrayList26.add(TimeUtils.removeGMT(((StringBuffer)object).toString()));
                            continue;
                        }
                        arrayList26.add(null);
                    }
                    continue;
                }
                if (null != string32.getCustomNumeric()) {
                    customCategorical = string32.getCustomNumeric();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    object9 = customCategorical.getBinLabels();
                    arrayList11.add(object17.getLabel());
                    arrayList12.add(object17.isIncludeNulls() ? "true" : "false");
                    arrayList13.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    object8 = customCategorical.getNumericBin();
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (NumericBin)object7.next();
                        arrayList6.add(object11.getName());
                        arrayList7.add(((StringBuilder)object10).toString());
                        arrayList8.add(null != object9.getNumberSequence() ? 1 : 0);
                        arrayList9.add(object6.getBinName());
                        arrayList10.add(object6.getLowerBound());
                    }
                    continue;
                }
                if (null != string32.getEqualWidth()) {
                    customCategorical = string32.getEqualWidth();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList30.add(object11.getName());
                    arrayList31.add(((StringBuilder)object10).toString());
                    arrayList32.add(stringBuilder.toString());
                    arrayList33.add(customCategorical.getBinCount().intValue());
                    object9 = customCategorical.getBinGeneration();
                    arrayList34.add(null != object9.getAuto() ? 1 : 0);
                    arrayList35.add(null != object9.getManual() ? 1 : 0);
                    object8 = customCategorical.getBinLabels();
                    arrayList36.add(null != object8.getNumberSequence() ? 1 : 0);
                    arrayList37.add(object17.getLabel());
                    arrayList39.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    arrayList40.add(object17.getNullBinsSelection() != null ? object17.getNullBinsSelection() : "Auto");
                    arrayList38.add(object17.isIncludeNulls() ? "true" : "false");
                    continue;
                }
                if (null != string32.getDateEqualWidth()) {
                    customCategorical = string32.getDateEqualWidth();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList49.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    object9 = customCategorical.getBinGeneration();
                    object8 = customCategorical.getBinLabels();
                    object7 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, ((StringBuilder)object10).toString());
                    if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object7)) {
                        arrayList41.add(object11.getName());
                        arrayList42.add(((StringBuilder)object10).toString());
                        arrayList43.add(customCategorical.getBinCount().intValue());
                        arrayList44.add(null != object9.getAuto() ? 1 : 0);
                        arrayList45.add(null != object9.getManual() ? 1 : 0);
                        arrayList46.add(null != object8.getNumberSequence() ? 1 : 0);
                        arrayList47.add(object17.getLabel());
                        arrayList50.add(object17.getNullBinsSelection() != null ? object17.getNullBinsSelection() : "Auto");
                        arrayList48.add(object17.isIncludeNulls() ? "true" : "false");
                        continue;
                    }
                    arrayList51.add(object11.getName());
                    arrayList52.add(((StringBuilder)object10).toString());
                    arrayList53.add(customCategorical.getBinCount().intValue());
                    arrayList54.add(null != object9.getAuto() ? 1 : 0);
                    arrayList55.add(null != object9.getManual() ? 1 : 0);
                    arrayList56.add(null != object8.getNumberSequence() ? 1 : 0);
                    arrayList57.add(object17.getLabel());
                    arrayList60.add(object17.getNullBinsSelection() != null ? object17.getNullBinsSelection() : "Auto");
                    arrayList58.add(object17.isIncludeNulls() ? "true" : "false");
                    continue;
                }
                if (null != string32.getTimestampEqualWidth()) {
                    customCategorical = string32.getTimestampEqualWidth();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList59.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    object9 = customCategorical.getBinGeneration();
                    object8 = customCategorical.getBinLabels();
                    object7 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, ((StringBuilder)object10).toString());
                    if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object7)) continue;
                    arrayList51.add(object11.getName());
                    arrayList52.add(((StringBuilder)object10).toString());
                    arrayList53.add(customCategorical.getBinCount().intValue());
                    arrayList54.add(null != object9.getAuto() ? 1 : 0);
                    arrayList55.add(null != object9.getManual() ? 1 : 0);
                    arrayList56.add(null != object8.getNumberSequence() ? 1 : 0);
                    arrayList57.add(object17.getLabel());
                    arrayList60.add(object17.getNullBinsSelection() != null ? object17.getNullBinsSelection() : "Auto");
                    arrayList58.add(object17.isIncludeNulls() ? "true" : "false");
                    continue;
                }
                if (null != string32.getQuantile()) {
                    customCategorical = string32.getQuantile();
                    object17 = AttributeTypeHelper.cloneTransformNulls(customCategorical.getTransformNulls());
                    arrayList61.add(object11.getName());
                    arrayList62.add(((StringBuilder)object10).toString());
                    arrayList63.add(customCategorical.getBinCount().intValue());
                    object9 = customCategorical.getBinGeneration();
                    arrayList64.add(null != object9.getAuto() ? 1 : 0);
                    arrayList65.add(null != object9.getManual() ? 1 : 0);
                    object8 = customCategorical.getBinLabels();
                    arrayList66.add(null != object8.getNumberSequence() ? 1 : 0);
                    arrayList67.add(object17.getLabel());
                    arrayList68.add(object17.isIncludeNulls() ? "true" : "false");
                    arrayList69.add(object17.getNullBinId() != null ? Integer.valueOf(object17.getNullBinId().intValue()) : null);
                    continue;
                }
                if (null == string32.getTopN()) continue;
                customCategorical = string32.getTopN();
                object17 = stringBuilder.toString();
                object9 = AttributeTypeHelper.cloneTransformNulls(string32.getTopN().getTransformNulls());
                if (((String)object17).equals("NVARCHAR2") || ((String)object17).equals("NCHAR")) {
                    arrayList76.add(object11.getName());
                    arrayList77.add(((StringBuilder)object10).toString());
                    arrayList78.add(customCategorical.getBinCount().intValue());
                    arrayList79.add(customCategorical.getOther());
                    arrayList80.add(object9.getLabel());
                    arrayList81.add(object9.isIncludeNulls() ? "true" : "false");
                    continue;
                }
                arrayList70.add(object11.getName());
                arrayList71.add(((StringBuilder)object10).toString());
                arrayList72.add(customCategorical.getBinCount().intValue());
                arrayList73.add(customCategorical.getOther());
                arrayList74.add(object9.getLabel());
                arrayList75.add(object9.isIncludeNulls() ? "true" : "false");
                continue;
            }
            if (null != transformationType.getMissingValuesCategorical()) {
                customCategorical = transformationType.getMissingValuesCategorical();
                arrayList82.add(object11.getName());
                arrayList83.add(((StringBuilder)object10).toString());
                arrayList84.add(stringBuilder.toString());
                object17 = customCategorical.getCategoricalStatistic();
                object9 = customCategorical.getValue();
                if (object17 != null) {
                    arrayList85.add(object17.getReplaceNullsWith());
                    arrayList86.add("");
                    continue;
                }
                if (object9 == null) continue;
                arrayList85.add("");
                arrayList86.add(object9.getReplaceNullsWith());
                continue;
            }
            if (null != transformationType.getMissingValuesNumeric()) {
                customCategorical = transformationType.getMissingValuesNumeric();
                arrayList87.add(object11.getName());
                arrayList88.add(((StringBuilder)object10).toString());
                object17 = customCategorical.getNumericStatistic();
                object9 = customCategorical.getValue();
                if (object17 != null) {
                    arrayList89.add(object17.getReplaceNullsWith());
                    arrayList90.add(0.0);
                    continue;
                }
                if (object9 == null) continue;
                arrayList89.add("");
                arrayList90.add(object9.getReplaceNullsWith());
                continue;
            }
            if (null != transformationType.getMissingValuesDate()) {
                customCategorical = transformationType.getMissingValuesDate();
                object17 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, ((StringBuilder)object10).toString());
                if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object17)) {
                    arrayList91.add(object11.getName());
                    arrayList92.add(((StringBuilder)object10).toString());
                    object9 = customCategorical.getDateStatistic();
                    object8 = customCategorical.getValue();
                    if (object9 != null) {
                        arrayList93.add(object9.getReplaceNullsWith());
                        arrayList94.add("");
                        continue;
                    }
                    if (object8 == null) continue;
                    arrayList93.add("");
                    object7 = TransformationStatisticsState.createReplaceMentValue((TransformationType.MissingValuesDate.Value)object8, false);
                    arrayList94.add(object7);
                    continue;
                }
                arrayList95.add(object11.getName());
                arrayList96.add(((StringBuilder)object10).toString());
                object9 = customCategorical.getDateStatistic();
                object8 = customCategorical.getValue();
                if (object9 != null) {
                    arrayList97.add(object9.getReplaceNullsWith());
                    arrayList98.add("");
                    continue;
                }
                if (object8 == null) continue;
                arrayList97.add("");
                object7 = TransformationStatisticsState.createReplaceMentValue((TransformationType.MissingValuesDate.Value)object8, true);
                arrayList98.add(object7);
                continue;
            }
            if (null != transformationType.getNormalization()) {
                customCategorical = transformationType.getNormalization();
                arrayList108.add(object11.getName());
                arrayList109.add(((StringBuilder)object10).toString());
                if (null != customCategorical.getMinMax()) {
                    arrayList110.add("MinMax");
                    arrayList111.add(null);
                    arrayList112.add(null);
                    continue;
                }
                if (null != customCategorical.getZScore()) {
                    arrayList110.add("ZScore");
                    arrayList111.add(null);
                    arrayList112.add(null);
                    continue;
                }
                if (null != customCategorical.getLinearScale()) {
                    arrayList110.add("LinearScale");
                    arrayList111.add(null);
                    arrayList112.add(null);
                    continue;
                }
                arrayList110.add("Manual");
                arrayList111.add(customCategorical.getManual().getShift());
                arrayList112.add(customCategorical.getManual().getScale());
                continue;
            }
            if (null != transformationType.getOutlier()) {
                customCategorical = transformationType.getOutlier();
                arrayList99.add(object11.getName());
                arrayList100.add(((StringBuilder)object10).toString());
                if (NULLS.equals(customCategorical.getReplaceWith())) {
                    arrayList102.add(NULLS);
                } else {
                    arrayList102.add(EDGES);
                }
                if (null != customCategorical.getStandardDeviation()) {
                    arrayList101.add("StandardDeviation");
                    arrayList103.add(customCategorical.getStandardDeviation().getMultiplesSigma());
                    arrayList104.add(null);
                    arrayList105.add(null);
                    arrayList106.add(null);
                    arrayList107.add(null);
                    continue;
                }
                if (null != customCategorical.getValue()) {
                    arrayList101.add("Value");
                    arrayList103.add(null);
                    arrayList104.add(customCategorical.getValue().getLowerValue());
                    arrayList105.add(customCategorical.getValue().getUpperValue());
                    arrayList106.add(null);
                    arrayList107.add(null);
                    continue;
                }
                arrayList101.add("Percent");
                arrayList103.add(null);
                arrayList104.add(null);
                arrayList105.add(null);
                arrayList106.add(customCategorical.getPercent().getLowerPercent());
                arrayList107.add(customCategorical.getPercent().getUpperPercent());
                continue;
            }
            if (null != transformationType.getCustomTransformationEx()) {
                arrayList113.add(object11.getName());
                arrayList114.add(((StringBuilder)object10).toString());
                arrayList115.add(transformationType.getCustomTransformationEx());
                continue;
            }
            if (null == transformationType.getCustomTransformation()) continue;
            customCategorical = transformationType.getCustomTransformation();
            arrayList113.add(object11.getName());
            arrayList114.add(((StringBuilder)object10).toString());
            arrayList115.add(customCategorical.getValue());
        }
        object132 = transformationNode.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, true);
        object12 = transformationNode.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        object11 = transformationNode.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_INSERT, true);
        stringCollection = ((TransformationNodeType)transformationNode.getData()).getStatsSelection();
        if (stringCollection == null) {
            stringCollection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        object10 = new SQLHelper();
        try {
            Array array;
            Array array2;
            Array array3;
            ((SQLHelper)object10).conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            stringBuilder = (OracleConnection)((SQLHelper)object10).conn;
            ((SQLHelper)object10).cstmt = (OracleCallableStatement)((SQLHelper)object10).conn.prepareCall(xformToSql);
            int n = 1;
            ((SQLHelper)object10).cstmt.registerOutParameter(n++, 12);
            ((SQLHelper)object10).cstmt.setString(n++, (String)object16);
            if (string != null) {
                ((SQLHelper)object10).cstmt.setString(n++, string);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 12);
            }
            int n2 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getNumericalBins();
            int n3 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getCategoricalBins();
            int n4 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getDateBins();
            object9 = ((TransformationNodeType)transformationNode.getData()).getNullsLabel();
            if (object9 == null) {
                object9 = GraphModelProvider.NULL_BINS;
            }
            if ((object8 = ((TransformationNodeType)transformationNode.getData()).getOtherLabel()) == null) {
                object8 = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER_DEFAULT");
            }
            ((SQLHelper)object10).cstmt.setInt(n++, n3);
            ((SQLHelper)object10).cstmt.setInt(n++, n2);
            ((SQLHelper)object10).cstmt.setInt(n++, n4);
            ((SQLHelper)object10).cstmt.setString(n++, (String)object9);
            ((SQLHelper)object10).cstmt.setString(n++, (String)object8);
            if (list != null && !list.isEmpty()) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, list.toArray(new String[list.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, list2.toArray(new String[list2.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList70.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList70.toArray(new String[arrayList70.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList71.toArray(new String[arrayList71.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList72.toArray(new Integer[arrayList72.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList73.toArray(new String[arrayList73.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList74.toArray(new String[arrayList74.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList75.toArray(new String[arrayList75.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList76.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList76.toArray(new String[arrayList76.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList77.toArray(new String[arrayList77.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList78.toArray(new Integer[arrayList78.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList79.toArray(new String[arrayList79.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList80.toArray(new String[arrayList80.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList81.toArray(new String[arrayList81.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList30.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList30.toArray(new String[arrayList30.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList31.toArray(new String[arrayList31.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList32.toArray(new String[arrayList32.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList33.toArray(new Integer[arrayList33.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList34.toArray(new Integer[arrayList34.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList35.toArray(new Integer[arrayList35.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList36.toArray(new Integer[arrayList36.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList37.toArray(new String[arrayList37.size()]));
                array2 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList38.toArray(new String[arrayList38.size()]));
                array = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList39.toArray(new Integer[arrayList39.size()]));
                Array array4 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList40.toArray(new String[arrayList40.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
                ((SQLHelper)object10).cstmt.setArray(n++, array2);
                ((SQLHelper)object10).cstmt.setArray(n++, array);
                ((SQLHelper)object10).cstmt.setArray(n++, array4);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList41.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList41.toArray(new String[arrayList41.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList42.toArray(new String[arrayList42.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList43.toArray(new Integer[arrayList43.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList44.toArray(new Integer[arrayList44.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList45.toArray(new Integer[arrayList45.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList46.toArray(new Integer[arrayList46.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList47.toArray(new String[arrayList47.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList48.toArray(new String[arrayList48.size()]));
                array2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList49.toArray(new Integer[arrayList49.size()]));
                array = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList50.toArray(new String[arrayList50.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
                ((SQLHelper)object10).cstmt.setArray(n++, array2);
                ((SQLHelper)object10).cstmt.setArray(n++, array);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList51.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList51.toArray(new String[arrayList51.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList52.toArray(new String[arrayList52.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList53.toArray(new Integer[arrayList53.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList54.toArray(new Integer[arrayList54.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList55.toArray(new Integer[arrayList55.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList56.toArray(new Integer[arrayList56.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList57.toArray(new String[arrayList57.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList58.toArray(new String[arrayList58.size()]));
                array2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList59.toArray(new Integer[arrayList59.size()]));
                array = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList60.toArray(new String[arrayList60.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
                ((SQLHelper)object10).cstmt.setArray(n++, array2);
                ((SQLHelper)object10).cstmt.setArray(n++, array);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList61.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList61.toArray(new String[arrayList61.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList62.toArray(new String[arrayList62.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList63.toArray(new Integer[arrayList63.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList64.toArray(new Integer[arrayList64.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList65.toArray(new Integer[arrayList65.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList66.toArray(new Integer[arrayList66.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList67.toArray(new String[arrayList67.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList68.toArray(new String[arrayList68.size()]));
                array2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList69.toArray(new Integer[arrayList69.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
                ((SQLHelper)object10).cstmt.setArray(n++, array2);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList14.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList14.toArray(new String[arrayList14.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList15.toArray(new String[arrayList15.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList16.toArray(new Integer[arrayList16.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList17.toArray(new String[arrayList17.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList18.toArray(new String[arrayList18.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList19.toArray(new String[arrayList19.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList20.toArray(new String[arrayList20.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList21.toArray(new Integer[arrayList21.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList22.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList22.toArray(new String[arrayList22.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList23.toArray(new String[arrayList23.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList24.toArray(new Integer[arrayList24.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList25.toArray(new String[arrayList25.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList26.toArray(new String[arrayList26.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList27.toArray(new String[arrayList27.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList28.toArray(new String[arrayList27.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList29.toArray(new Integer[arrayList29.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList6.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList6.toArray(new String[arrayList6.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList7.toArray(new String[arrayList7.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList8.toArray(new Integer[arrayList8.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList9.toArray(new String[arrayList9.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList10.toArray(new Double[arrayList10.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList11.toArray(new String[arrayList11.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList12.toArray(new String[arrayList12.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList13.toArray(new Integer[arrayList13.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (object15.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, object15.toArray(new String[object15.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, object14.toArray(new String[object14.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList.toArray(new String[arrayList.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList2.toArray(new Integer[arrayList2.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList3.toArray(new String[arrayList3.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList4.toArray(new String[arrayList4.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList5.toArray(new String[arrayList5.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList82.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList82.toArray(new String[arrayList82.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList83.toArray(new String[arrayList83.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList84.toArray(new String[arrayList84.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList85.toArray(new String[arrayList85.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList86.toArray(new String[arrayList86.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList87.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList87.toArray(new String[arrayList87.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList88.toArray(new String[arrayList88.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList89.toArray(new String[arrayList89.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList90.toArray(new Double[arrayList90.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList91.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList91.toArray(new String[arrayList91.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList92.toArray(new String[arrayList92.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList93.toArray(new String[arrayList93.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList94.toArray(new String[arrayList94.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList95.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList95.toArray(new String[arrayList95.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList96.toArray(new String[arrayList96.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList97.toArray(new String[arrayList97.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList98.toArray(new String[arrayList98.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList99.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList99.toArray(new String[arrayList99.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList100.toArray(new String[arrayList100.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList101.toArray(new String[arrayList101.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList102.toArray(new String[arrayList102.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList103.toArray(new Double[arrayList103.size()]));
                object2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList104.toArray(new Double[arrayList104.size()]));
                object = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList105.toArray(new Double[arrayList105.size()]));
                array3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList106.toArray(new Double[arrayList106.size()]));
                array2 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList107.toArray(new Double[arrayList107.size()]));
                if (string2 != null) {
                    ((SQLHelper)object10).cstmt.setString(n++, string2);
                } else {
                    ((SQLHelper)object10).cstmt.setNull(n++, 12);
                }
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object2);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object);
                ((SQLHelper)object10).cstmt.setArray(n++, array3);
                ((SQLHelper)object10).cstmt.setArray(n++, array2);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 12);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList108.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList108.toArray(new String[arrayList108.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList109.toArray(new String[arrayList109.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList110.toArray(new String[arrayList110.size()]));
                object4 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList111.toArray(new Double[arrayList111.size()]));
                object3 = stringBuilder.createOracleArray(ODMR_OBJECT_IDS, arrayList112.toArray(new Double[arrayList112.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object4);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object3);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList113.size() > 0) {
                object7 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList113.toArray(new String[arrayList113.size()]));
                object6 = stringBuilder.createOracleArray(ODMR_OBJECT_NAMES, arrayList114.toArray(new String[arrayList114.size()]));
                object5 = stringBuilder.createOracleArray(ODMR_OBJECT_VALUES, arrayList115.toArray(new String[arrayList115.size()]));
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object7);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object6);
                ((SQLHelper)object10).cstmt.setArray(n++, (Array)object5);
            } else {
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                ((SQLHelper)object10).cstmt.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            ((SQLHelper)object10).cstmt.setString(n++, (String)object12);
            ((SQLHelper)object10).cstmt.setString(n++, (String)object11);
            ((SQLHelper)object10).cstmt.setString(n++, (String)object132);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isPercentdistinct() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isPercentnull() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isMax() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isMin() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isAvg() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isStd() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isVar() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isKurtosis() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isMedian() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isSkewness() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isMode() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isModeall() ? 1 : 0);
            ((SQLHelper)object10).cstmt.setInt(n++, stringCollection.isHistogram() ? 1 : 0);
            ((SQLHelper)object10).cstmt.executeQuery();
            object6 = object7 = ((SQLHelper)object10).cstmt.getString(1);
            return object6;
        }
        finally {
            ((SQLHelper)object10).close();
        }
    }

    private static String createReplaceMentValue(TransformationType.MissingValuesDate.Value value, boolean bl) {
        XMLGregorianCalendar xMLGregorianCalendar = TimeUtils.SimpleDate2XMLDate(value.getReplaceNullsWith().toGregorianCalendar(), bl);
        String string = xMLGregorianCalendar.toString();
        string = string.replace("T", " ");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDistinctValuesAndFrequenciesFromDB(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        String string2 = TransformationStatisticsState.getStackedSQL(this._transformationNode);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._context, ConnectionProperties.ALTER_SESSION_FIXES);
            String string3 = StringUtils.getReplacedString(sql_distincts, "<column_name>", string);
            string3 = StringUtils.getReplacedString(string3, "<table_name>", string2);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt(1);
                String string4 = sQLHelper.rs.getString(2);
                arrayList2.add(n);
                arrayList.add(string4);
            }
        }
        this.distinctValues.put(string, arrayList);
        this.frequencies.put(string, arrayList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areColumnsPresentInSampleTable(Context context, String string, List<String> list) {
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            int n = 0;
            for (String string2 : list) {
                if (++n > 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string2);
            }
            Object object = ConnectionFolder.getUserAccountName(context);
            object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
            stringBuffer.append(" from " + (String)object + "." + string + " where ROWNUM < 2");
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuffer.toString());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() {
        if (this._refreshStatsTable == null && this._refreshSingleColumnStatsTable == null) {
            return;
        }
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            String string = ConnectionFolder.getUserAccountName(this._context);
            String string2 = string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            if (null != this._refreshSingleColumnStatsTable) {
                try {
                    DatabaseMetadataUtils.dropTable(connectionFolder, string, this._refreshSingleColumnStatsTable);
                    this._refreshSingleColumnStatsTable = null;
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            if (null != this._refreshStatsTable) {
                DatabaseMetadataUtils.dropTable(connectionFolder, string, this._refreshStatsTable);
                this._refreshStatsTable = null;
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        finally {
            this.clearRefreshedResults();
            this.clearServerResults();
        }
    }

    public static Map<String, List<NameValuePair>> generateGraphBins(ConnectionManager connectionManager, String string, List<String> list, List<String> list2, List<Integer> list3, String string2, String string3) throws SQLException {
        HashMap<String, List<NameValuePair>> hashMap = new HashMap<String, List<NameValuePair>>();
        if (string == null) {
            return hashMap;
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            sQLHelper.conn = connectionManager.getConnection();
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            String[] stringArray = new String[list.size()];
            String[] stringArray2 = new String[list.size()];
            Integer[] integerArray = new Integer[list.size()];
            int n = 0;
            for (String object22 : list) {
                object = StringUtils.isDoubleQuotedString(object22) ? object22 : StringUtils.addDoubleQuotes(object22);
                stringArray[n] = object;
                stringArray2[n] = list2.get(n);
                integerArray[n] = list3.get(n);
                ++n;
            }
            Array array = oracleConnection.createOracleArray(ODMR_OBJECT_NAMES, (Object)stringArray);
            Array array2 = oracleConnection.createOracleArray(ODMR_OBJECT_NAMES, (Object)stringArray2);
            object = oracleConnection.createOracleArray(ODMR_OBJECT_IDS, (Object)integerArray);
            Array array3 = oracleConnection.createOracleArray(ODMR_OBJECT_NAMES, (Object)new String[0]);
            Array array4 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            Array array5 = oracleConnection.createOracleArray(ODMR_OBJECT_VALUES, (Object)new String[0]);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_ENGINE.BIN_MULTIPLE_COLUMNS(?,?,?,?,?,?,?,?,?)}");
            int n2 = 1;
            sQLHelper.cstmt.setCharacterStream(n2++, (Reader)new StringReader(string), string.length());
            sQLHelper.cstmt.setArray(n2++, array);
            sQLHelper.cstmt.setArray(n2++, array2);
            sQLHelper.cstmt.setArray(n2++, (Array)object);
            sQLHelper.cstmt.setArray(n2++, array3);
            sQLHelper.cstmt.setArray(n2++, array4);
            sQLHelper.cstmt.setArray(n2++, array5);
            sQLHelper.cstmt.setString(n2++, string2);
            sQLHelper.cstmt.setString(n2++, string3);
            n2 = 5;
            sQLHelper.cstmt.registerOutParameter(n2++, 2003, ODMR_OBJECT_NAMES);
            sQLHelper.cstmt.registerOutParameter(n2++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.registerOutParameter(n2++, 2003, ODMR_OBJECT_VALUES);
            sQLHelper.cstmt.execute();
            n2 = 5;
            ARRAY aRRAY = sQLHelper.cstmt.getARRAY(n2++);
            String[] stringArray3 = (String[])aRRAY.getArray();
            ARRAY aRRAY2 = sQLHelper.cstmt.getARRAY(n2++);
            String[] stringArray4 = (String[])aRRAY2.getArray();
            ARRAY aRRAY3 = sQLHelper.cstmt.getARRAY(n2++);
            String[] stringArray5 = (String[])aRRAY3.getArray();
            for (int i = 0; i < stringArray3.length; ++i) {
                ArrayList<NameValuePair> arrayList = (ArrayList<NameValuePair>)hashMap.get(stringArray3[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList<NameValuePair>();
                    hashMap.put(stringArray3[i], arrayList);
                }
                NameValuePair nameValuePair = new NameValuePair(stringArray4[i], (Object)stringArray5[i]);
                arrayList.add(nameValuePair);
            }
        }
        return hashMap;
    }

    public int getRowCount() {
        return this.statsSlelection.getRowcount().intValue();
    }

    public boolean isSampledData() {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this._transformationNode.getData();
        SampleSettings sampleSettings = transformationNodeType.getSampleSettings();
        return !sampleSettings.isUseFullData();
    }

    public TransformNulls getTransformNulls(String string) {
        TransformationType.Binning binning;
        TransformNulls transformNulls = null;
        TransformationOutputAttribute transformationOutputAttribute = this.findTransformedColumn(string);
        if (null != transformationOutputAttribute && null != (binning = transformationOutputAttribute.getTransformationElementType().getBinning())) {
            if (null != binning.getEqualWidth()) {
                TransformationType.Binning.EqualWidth equalWidth = binning.getEqualWidth();
                transformNulls = equalWidth.getTransformNulls();
            } else if (null != binning.getDateEqualWidth()) {
                TransformationType.Binning.DateEqualWidth dateEqualWidth = binning.getDateEqualWidth();
                transformNulls = dateEqualWidth.getTransformNulls();
            } else if (null != binning.getTimestampEqualWidth()) {
                TransformationType.Binning.TimestampEqualWidth timestampEqualWidth = binning.getTimestampEqualWidth();
                transformNulls = timestampEqualWidth.getTransformNulls();
            } else if (null != binning.getQuantile()) {
                TransformationType.Binning.Quantile quantile = binning.getQuantile();
                transformNulls = quantile.getTransformNulls();
            } else if (null != binning.getTopN()) {
                TransformationType.Binning.TopN topN = binning.getTopN();
                transformNulls = topN.getTransformNulls();
            } else if (null != binning.getCustomCategorical()) {
                TransformationType.Binning.CustomCategorical customCategorical = binning.getCustomCategorical();
                transformNulls = customCategorical.getTransformNulls();
            } else if (null != binning.getCustomDate()) {
                TransformationType.Binning.CustomDate customDate = binning.getCustomDate();
                transformNulls = customDate.getTransformNulls();
            } else if (null != binning.getCustomTimestamp()) {
                TransformationType.Binning.CustomTimestamp customTimestamp = binning.getCustomTimestamp();
                transformNulls = customTimestamp.getTransformNulls();
            } else if (null != binning.getCustomNumeric()) {
                TransformationType.Binning.CustomNumeric customNumeric = binning.getCustomNumeric();
                transformNulls = customNumeric.getTransformNulls();
            }
        }
        if (transformNulls == null) {
            transformNulls = AttributeTypeHelper.cloneTransformNulls(null);
        }
        return transformNulls;
    }

    public static class AttributeHistogramArray {
        ArrayList<NameValuePair> attributeValuesBars = new ArrayList();

        boolean isEmpty() {
            return this.attributeValuesBars.isEmpty();
        }

        ArrayList<String> getBarTitles() {
            ArrayList<String> arrayList = new ArrayList<String>(this.attributeValuesBars.size());
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                arrayList.add(nameValuePair.getName());
            }
            return arrayList;
        }

        ArrayList<NameValuePair> getBarArray(String string) {
            ArrayList<NameValuePair> arrayList = null;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!string.equals(nameValuePair.getName())) continue;
                arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
            }
            return arrayList;
        }

        void addPoint(NameValuePair nameValuePair) {
            this.attributeValuesBars.add(nameValuePair);
        }

        void addPoint(Object object, String string, Double d) {
            boolean bl = false;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!object.toString().equals(nameValuePair.getName())) continue;
                ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
                arrayList.add(new NameValuePair(string, (Object)d));
                bl = true;
            }
            if (!bl) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                arrayList.add(new NameValuePair(string, (Object)d));
                this.attributeValuesBars.add(new NameValuePair(object.toString(), arrayList));
            }
        }

        public ArrayList<NameValuePair> getAttributeValuesBars() {
            return this.attributeValuesBars;
        }
    }
}

