/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigInteger;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningDetailsNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.NullBinsSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.BinGeneration;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.ide.util.ResourceUtils;

public class BinningPanelSimpleNumeric
extends JPanel
implements BinningDetailsNumeric {
    private Integer bincount;
    private String binningType;
    private BinGeneration binGeneration;
    private BinLabels binLabels;
    private TransformNulls transformNulls;
    private boolean showTransformNULLsCheckBox = false;
    private static final String _EDIT_FIELD = "_EDIT_FIELD";
    private static final String _EXPLANATION_LABEL = "_EXPLANATION_LABEL";
    private JTextField jTxtNullValue;
    private NullBinsSelectionPanel jLabelExplanation;
    private JComboBox jComboBoxRange;
    private JPanel jHostPanel;
    private JLabel jLabelCount;
    private JLabel jLabelRange;
    private JTextField jTextFieldBinCount;
    private JCheckBox jchkBoxXformNulls;

    public BinningPanelSimpleNumeric(String string, Integer n, BinGeneration binGeneration, BinLabels binLabels, TransformNulls transformNulls, boolean bl) {
        this.binningType = string;
        this.bincount = n;
        this.binGeneration = binGeneration;
        this.binLabels = binLabels;
        this.transformNulls = transformNulls;
        this.showTransformNULLsCheckBox = bl;
        this.initComponents();
        if (bl) {
            this.jLabelExplanation = new NullBinsSelectionPanel(this);
            this.jTxtNullValue = new JTextField();
        }
        this.initRes();
        this.initUI();
        this.initElements();
    }

    private void initComponents() {
        this.jLabelCount = new JLabel();
        this.jTextFieldBinCount = new NumberTextField();
        this.jLabelRange = new JLabel();
        this.jComboBoxRange = new JComboBox();
        this.jchkBoxXformNulls = new JCheckBox();
        this.jHostPanel = new JPanel();
        this.jLabelCount.setText("Bin Count:");
        this.jLabelRange.setText("Bin Labels:");
        this.jComboBoxRange.setModel(new DefaultComboBoxModel<String>(new String[]{"Range", "Number", " "}));
        this.jchkBoxXformNulls.setText("Transform NULL's");
        this.jHostPanel.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelCount, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelRange, -1, -1, Short.MAX_VALUE).addComponent(this.jchkBoxXformNulls, -1, 149, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxRange, 0, 282, Short.MAX_VALUE).addComponent(this.jTextFieldBinCount, -2, 64, -2).addComponent(this.jHostPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCount).addComponent(this.jTextFieldBinCount, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(44, 44, 44).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRange).addComponent(this.jComboBoxRange, -2, -1, -2)))).addGap(28, 28, 28).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jchkBoxXformNulls).addComponent(this.jHostPanel, -2, -1, -2)).addContainerGap(103, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jHostPanel, this.jchkBoxXformNulls);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelCount, (Component)this.jTextFieldBinCount, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_COUNT"));
        ResourceUtils.resLabel((JLabel)this.jLabelRange, (Component)this.jComboBoxRange, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABLES"));
        this.jTextFieldBinCount.setToolTipText(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_COUNT_TOOLTIP"));
        this.jComboBoxRange.setToolTipText(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABLES_TOOLTIP"));
    }

    protected void initElements() {
        if (this.showTransformNULLsCheckBox) {
            boolean bl = this.jchkBoxXformNulls.isSelected();
            this.jLabelExplanation.enableControls(bl);
            this.jchkBoxXformNulls.setText(_TRANSFORM_NULLS);
            String string = StringUtils.trimSingleQuotes(this.transformNulls.getLabel());
            string = StringUtils.getReplacedString(string, "''", "'");
            this.jTxtNullValue.setText(string);
        }
    }

    @Override
    public TransformNulls getSrcTransformNulls() {
        return this.transformNulls;
    }

    public void initUI() {
        ((NumberTextField)this.jTextFieldBinCount).setDataType(Integer.class);
        ((NumberTextField)this.jTextFieldBinCount).setSigned(false);
        this.jTextFieldBinCount.setLocale(Locale.getDefault());
        ((NumberTextField)this.jTextFieldBinCount).setNumber((Number)this.bincount);
        this.jComboBoxRange.setModel(new DefaultComboBoxModel<String>(new String[]{TransformationStatisticsState.RANGE, TransformationStatisticsState.SEQUENCE}));
        if (this.showTransformNULLsCheckBox) {
            this.jLabelExplanation.setNullBinPlacementSelection(this.transformNulls);
            if (this.transformNulls == null || this.transformNulls.getNullBinId() == null || this.transformNulls.getNullBinsSelection().equals("Auto")) {
                this.jLabelExplanation.setBinIdAuto(this.bincount + 1);
            } else {
                this.jLabelExplanation.setBinIdAuto(this.transformNulls.getNullBinId().intValue());
            }
            this.jHostPanel.add(_EDIT_FIELD, this.jTxtNullValue);
            this.jHostPanel.add(_EXPLANATION_LABEL, this.jLabelExplanation);
        }
        this.jComboBoxRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BinningPanelSimpleNumeric.this.showTransformNULLsCheckBox) {
                    String string = (String)BinningPanelSimpleNumeric.this.jComboBoxRange.getSelectedItem();
                    boolean bl = !string.equals(TransformationStatisticsState.SEQUENCE);
                    BinningPanelSimpleNumeric.this.showEditControl(bl);
                    BinningPanelSimpleNumeric.this.updateUI();
                }
            }
        });
        if (this.showTransformNULLsCheckBox) {
            boolean bl;
            boolean bl2 = bl = null != this.binLabels.getRange();
            if (bl) {
                this.jComboBoxRange.setSelectedItem(TransformationStatisticsState.RANGE);
            } else {
                this.jComboBoxRange.setSelectedItem(TransformationStatisticsState.SEQUENCE);
            }
            this.showEditControl(bl);
        } else {
            this.jchkBoxXformNulls.setVisible(false);
            this.showEditControl(false);
        }
        if (this.showTransformNULLsCheckBox) {
            this.jchkBoxXformNulls.setSelected(this.transformNulls.isIncludeNulls());
            this.jTxtNullValue.setEnabled(this.transformNulls.isIncludeNulls());
            this.jchkBoxXformNulls.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = BinningPanelSimpleNumeric.this.jchkBoxXformNulls.isSelected();
                    BinningPanelSimpleNumeric.this.transformNulls.setIncludeNulls(bl);
                    BinningPanelSimpleNumeric.this.jTxtNullValue.setEnabled(bl);
                    BinningPanelSimpleNumeric.this.jLabelExplanation.enableControls(bl);
                    if (bl) {
                        Number number = ((NumberTextField)BinningPanelSimpleNumeric.this.jTextFieldBinCount).getNumber();
                        if (!BinningPanelSimpleNumeric.this.jLabelExplanation.isCustomNullValuePlacementSelection()) {
                            BinningPanelSimpleNumeric.this.jLabelExplanation.setBinIdAuto(number.intValue() + 1);
                        }
                    }
                }
            });
        }
        this.jTextFieldBinCount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = BinningPanelSimpleNumeric.this.jchkBoxXformNulls.isSelected();
                if (!bl) {
                    return;
                }
                NumberTextField numberTextField = (NumberTextField)keyEvent.getSource();
                Number number = numberTextField.getNumber();
                if (number != null && !BinningPanelSimpleNumeric.this.jLabelExplanation.isCustomNullValuePlacementSelection()) {
                    BinningPanelSimpleNumeric.this.jLabelExplanation.setBinIdAuto(number.intValue() + 1);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
    }

    private void showEditControl(boolean bl) {
        CardLayout cardLayout = (CardLayout)this.jHostPanel.getLayout();
        if (bl) {
            cardLayout.show(this.jHostPanel, _EDIT_FIELD);
        } else {
            cardLayout.show(this.jHostPanel, _EXPLANATION_LABEL);
        }
    }

    @Override
    public Integer getBinCount() {
        Number number = ((NumberTextField)this.jTextFieldBinCount).getNumber();
        Integer n = (Integer)number;
        return n;
    }

    @Override
    public void setBinCount(Integer n) {
        ((NumberTextField)this.jTextFieldBinCount).setNumber((Number)n);
    }

    @Override
    public String getSelectedBinngType() {
        return this.binningType;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public void setAuto(boolean bl) {
    }

    @Override
    public void activateDlg() {
    }

    @Override
    public boolean isLabels() {
        Object object = this.jComboBoxRange.getSelectedItem();
        return object.toString().equals(TransformationStatisticsState.RANGE);
    }

    @Override
    public void setLabels(boolean bl) {
        if (bl) {
            this.jComboBoxRange.setSelectedItem(TransformationStatisticsState.RANGE);
        } else {
            this.jComboBoxRange.setSelectedItem(TransformationStatisticsState.SEQUENCE);
        }
    }

    @Override
    public TransformNulls getResultTransformNulls() {
        String string;
        if (!this.jLabelExplanation.isValidBinValue()) {
            return null;
        }
        TransformNulls transformNulls = AttributeTypeHelper.cloneTransformNulls(this.transformNulls);
        if (null != this.jTxtNullValue.getText()) {
            boolean bl;
            string = StringUtils.trimSingleQuotes(this.jTxtNullValue.getText());
            string = StringUtils.escapeSingleQuotesForSQL(string);
            boolean bl2 = bl = null != this.binLabels.getNumberSequence();
            if (bl) {
                transformNulls.setLabel(GraphModelProvider.NULL_BINS);
            } else {
                transformNulls.setLabel(StringUtils.addSingleQuotes(string));
            }
        }
        string = this.jLabelExplanation.getNullValuePlacementSelection();
        transformNulls.setNullBinsSelection(string);
        transformNulls.setNullBinId(BigInteger.valueOf(this.jLabelExplanation.geMaxBinId()));
        return transformNulls;
    }
}

